/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AESKey;
import com.rsa.jsafe.JA_AESTables;
import com.rsa.jsafe.JA_AlgaeBlockCipher;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JA_SymmetricPaddingScheme;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

class JA_AES
extends JSAFE_Object
implements JA_AlgaeBlockCipher,
Cloneable,
Serializable {
    private byte[] keyTable = new byte[240];
    protected int fixedRounds;
    private int rounds;
    private transient ObfuscatorItem tableOI;
    private int obfuscateFlag = 0;
    private static final int NOT_OBFUSCATED = 0;
    private static final int OBFUSCATED = 1;
    private static final int OBFUSCATE_OFF = 2;
    private static final int DEOBFUSCATED = 4;
    private static final int AES_BLOCK_SIZE = 16;

    JA_AES() {
    }

    JA_AES(int[] nArray) throws JSAFE_InvalidParameterException {
        this.setInstantiationParameters(nArray);
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray == null) {
            return;
        }
        if (nArray.length == 0) {
            return;
        }
        throw new JSAFE_InvalidParameterException("Incorrect number of AES algorithm parameters: expected none.");
    }

    public int[] getInstantiationParameters() {
        int[] nArray = new int[]{};
        return nArray;
    }

    public void setAlgorithmBER(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        jA_FeedbackMode.setAlgorithmBER(byArray, n, n2);
    }

    public byte[] getDERAlgorithmID(JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme) throws JSAFE_UnimplementedException {
        throw new JSAFE_UnimplementedException("Not yet implemented.");
    }

    public byte[] getParamsDER(byte[] byArray) {
        return byArray;
    }

    public String getAlgorithm() {
        if (this.rounds == 10) {
            return "AES128";
        }
        if (this.rounds == 12) {
            return "AES192";
        }
        if (this.rounds == 14) {
            return "AES256";
        }
        return "AES";
    }

    public int getBlockSize() {
        return 16;
    }

    public boolean canWrapKey(boolean bl) {
        return false;
    }

    public void pbeKeySize(int n) {
    }

    public void encryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        this.aesInit(jSAFE_SecretKey, true);
    }

    public void decryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        this.aesInit(jSAFE_SecretKey, false);
    }

    private void aesInit(JSAFE_SecretKey jSAFE_SecretKey, boolean bl) throws JSAFE_InvalidKeyException {
        int n;
        int n2;
        byte[] byArray = null;
        try {
            byArray = ((JA_AESKey)jSAFE_SecretKey).getSecretKeyData("Clear");
        }
        catch (ClassCastException classCastException) {
            throw new JSAFE_InvalidKeyException("Invalid key type");
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_InvalidKeyException("Invalid key type");
        }
        if (byArray == null) {
            throw new JSAFE_InvalidKeyException("Invalid AES key length");
        }
        byte[] byArray2 = new byte[]{1, 2, 4, 8, 16, 32, 64, -128, 27, 54, 108, -40, -85, 77, -102, 47, 94, -68, 99, -58, -105, 53, 106, -44, -77, 125, -6, -17, -59, -111};
        if (this.tableOI != null) {
            this.tableOI.overwrite();
        }
        int n3 = byArray.length;
        this.rounds = n3 / 4 + 6;
        if (this.fixedRounds != 0 && this.rounds != this.fixedRounds) {
            int n4 = (this.fixedRounds - 6) * 32;
            int n5 = (this.rounds - 6) * 32;
            throw new JSAFE_InvalidKeyException("AES" + n4 + " instantiated, key size is " + n5);
        }
        int n6 = 11;
        if (n3 == 24) {
            n6 = 9;
        }
        if (n3 == 32) {
            n6 = 8;
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, 0, byArray3, 0, n3);
        int n7 = n3 - 4;
        int n8 = 0;
        int n9 = 0;
        int n10 = 1;
        while (n10 <= n6) {
            if (n10 != 1) {
                int n11 = byArray3[n7 + 1] & 0xFF;
                byArray3[0] = (byte)(byArray3[0] ^ JA_AESTables.S[n11]);
                n11 = byArray3[n7 + 2] & 0xFF;
                byArray3[1] = (byte)(byArray3[1] ^ JA_AESTables.S[n11]);
                n11 = byArray3[n7 + 3] & 0xFF;
                byArray3[2] = (byte)(byArray3[2] ^ JA_AESTables.S[n11]);
                n11 = byArray3[n7] & 0xFF;
                byArray3[3] = (byte)(byArray3[3] ^ JA_AESTables.S[n11]);
                byArray3[0] = (byte)(byArray3[0] ^ byArray2[n9++]);
                if (n3 != 32) {
                    n2 = 4;
                    while (n2 < n3) {
                        int n12 = n2;
                        byArray3[n12] = (byte)(byArray3[n12] ^ byArray3[n2 - 4]);
                        ++n2;
                    }
                } else {
                    n2 = 4;
                    while (n2 < 16) {
                        int n13 = n2;
                        byArray3[n13] = (byte)(byArray3[n13] ^ byArray3[n2 - 4]);
                        ++n2;
                    }
                    n11 = byArray3[12] & 0xFF;
                    byArray3[16] = (byte)(byArray3[16] ^ JA_AESTables.S[n11]);
                    n11 = byArray3[13] & 0xFF;
                    byArray3[17] = (byte)(byArray3[17] ^ JA_AESTables.S[n11]);
                    n11 = byArray3[14] & 0xFF;
                    byArray3[18] = (byte)(byArray3[18] ^ JA_AESTables.S[n11]);
                    n11 = byArray3[15] & 0xFF;
                    byArray3[19] = (byte)(byArray3[19] ^ JA_AESTables.S[n11]);
                    n = 20;
                    while (n < 32) {
                        int n14 = n;
                        byArray3[n14] = (byte)(byArray3[n14] ^ byArray3[n - 4]);
                        ++n;
                    }
                }
            }
            if (n10 == n6) {
                System.arraycopy(byArray3, 0, this.keyTable, n8, 16);
            } else {
                System.arraycopy(byArray3, 0, this.keyTable, n8, n3);
            }
            ++n10;
            n8 += n3;
        }
        if (!bl) {
            n8 = 16;
            n2 = 1;
            while (n2 < this.rounds) {
                n = 0;
                while (n < 4) {
                    int n15 = this.keyTable[n8] & 0xFF;
                    int n16 = this.keyTable[n8 + 1] & 0xFF;
                    int n17 = this.keyTable[n8 + 2] & 0xFF;
                    int n18 = this.keyTable[n8 + 3] & 0xFF;
                    int n19 = JA_AESTables.U1[n15] ^ JA_AESTables.U2[n16] ^ JA_AESTables.U3[n17] ^ JA_AESTables.U4[n18];
                    this.keyTable[n8 + 3] = (byte)n19;
                    this.keyTable[n8 + 2] = (byte)(n19 >> 8);
                    this.keyTable[n8 + 1] = (byte)(n19 >> 16);
                    this.keyTable[n8] = (byte)(n19 >> 24);
                    ++n;
                    n8 += 4;
                }
                ++n2;
            }
        }
        this.obfuscate();
        this.overwrite(byArray);
    }

    public int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray = new int[16];
        int[] nArray2 = new int[4];
        int n7 = 0;
        while (n7 < 16) {
            nArray[n7] = (byArray[n] ^ this.keyTable[n7]) & 0xFF;
            ++n7;
            ++n;
        }
        nArray2[0] = JA_AESTables.T1[nArray[0]] ^ JA_AESTables.T2[nArray[5]] ^ JA_AESTables.T3[nArray[10]] ^ JA_AESTables.T4[nArray[15]];
        nArray2[1] = JA_AESTables.T1[nArray[4]] ^ JA_AESTables.T2[nArray[9]] ^ JA_AESTables.T3[nArray[14]] ^ JA_AESTables.T4[nArray[3]];
        nArray2[2] = JA_AESTables.T1[nArray[8]] ^ JA_AESTables.T2[nArray[13]] ^ JA_AESTables.T3[nArray[2]] ^ JA_AESTables.T4[nArray[7]];
        nArray2[3] = JA_AESTables.T1[nArray[12]] ^ JA_AESTables.T2[nArray[1]] ^ JA_AESTables.T3[nArray[6]] ^ JA_AESTables.T4[nArray[11]];
        int n8 = 16;
        int n9 = 1;
        while (n9 < this.rounds - 1) {
            n6 = 0;
            n5 = 0;
            while (n5 < 4) {
                n4 = 24;
                n3 = 0;
                while (n3 < 4) {
                    nArray[n6++] = (nArray2[n5] >> n4 ^ this.keyTable[n8++]) & 0xFF;
                    ++n3;
                    n4 -= 8;
                }
                ++n5;
            }
            nArray2[0] = JA_AESTables.T1[nArray[0]] ^ JA_AESTables.T2[nArray[5]] ^ JA_AESTables.T3[nArray[10]] ^ JA_AESTables.T4[nArray[15]];
            nArray2[1] = JA_AESTables.T1[nArray[4]] ^ JA_AESTables.T2[nArray[9]] ^ JA_AESTables.T3[nArray[14]] ^ JA_AESTables.T4[nArray[3]];
            nArray2[2] = JA_AESTables.T1[nArray[8]] ^ JA_AESTables.T2[nArray[13]] ^ JA_AESTables.T3[nArray[2]] ^ JA_AESTables.T4[nArray[7]];
            nArray2[3] = JA_AESTables.T1[nArray[12]] ^ JA_AESTables.T2[nArray[1]] ^ JA_AESTables.T3[nArray[6]] ^ JA_AESTables.T4[nArray[11]];
            ++n9;
        }
        n6 = 0;
        n5 = 0;
        while (n5 < 4) {
            n4 = 24;
            n3 = 0;
            while (n3 < 4) {
                nArray[n6++] = (nArray2[n5] >> n4 ^ this.keyTable[n8++]) & 0xFF;
                ++n3;
                n4 -= 8;
            }
            ++n5;
        }
        n4 = n2;
        byArray2[n4++] = (byte)(JA_AESTables.T1[nArray[0]] >> 16);
        byArray2[n4++] = (byte)(JA_AESTables.T1[nArray[5]] >> 16);
        byArray2[n4++] = (byte)(JA_AESTables.T1[nArray[10]] >> 16);
        byArray2[n4++] = (byte)(JA_AESTables.T1[nArray[15]] >> 16);
        byArray2[n4++] = (byte)(JA_AESTables.T1[nArray[4]] >> 16);
        byArray2[n4++] = (byte)(JA_AESTables.T1[nArray[9]] >> 16);
        byArray2[n4++] = (byte)(JA_AESTables.T1[nArray[14]] >> 16);
        byArray2[n4++] = (byte)(JA_AESTables.T1[nArray[3]] >> 16);
        byArray2[n4++] = (byte)(JA_AESTables.T1[nArray[8]] >> 16);
        byArray2[n4++] = (byte)(JA_AESTables.T1[nArray[13]] >> 16);
        byArray2[n4++] = (byte)(JA_AESTables.T1[nArray[2]] >> 16);
        byArray2[n4++] = (byte)(JA_AESTables.T1[nArray[7]] >> 16);
        byArray2[n4++] = (byte)(JA_AESTables.T1[nArray[12]] >> 16);
        byArray2[n4++] = (byte)(JA_AESTables.T1[nArray[1]] >> 16);
        byArray2[n4++] = (byte)(JA_AESTables.T1[nArray[6]] >> 16);
        byArray2[n4++] = (byte)(JA_AESTables.T1[nArray[11]] >> 16);
        n3 = 0;
        while (n3 < 16) {
            int n10 = n2++;
            byArray2[n10] = (byte)(byArray2[n10] ^ this.keyTable[n8++]);
            ++n3;
        }
        return 16;
    }

    public int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray = new int[16];
        int[] nArray2 = new int[4];
        int n7 = this.rounds * 16;
        int n8 = 0;
        while (n8 < 16) {
            nArray[n8] = (byArray[n] ^ this.keyTable[n7]) & 0xFF;
            ++n8;
            ++n;
            ++n7;
        }
        n7 -= 32;
        nArray2[0] = JA_AESTables.T5[nArray[0]] ^ JA_AESTables.T6[nArray[13]] ^ JA_AESTables.T7[nArray[10]] ^ JA_AESTables.T8[nArray[7]];
        nArray2[1] = JA_AESTables.T5[nArray[4]] ^ JA_AESTables.T6[nArray[1]] ^ JA_AESTables.T7[nArray[14]] ^ JA_AESTables.T8[nArray[11]];
        nArray2[2] = JA_AESTables.T5[nArray[8]] ^ JA_AESTables.T6[nArray[5]] ^ JA_AESTables.T7[nArray[2]] ^ JA_AESTables.T8[nArray[15]];
        nArray2[3] = JA_AESTables.T5[nArray[12]] ^ JA_AESTables.T6[nArray[9]] ^ JA_AESTables.T7[nArray[6]] ^ JA_AESTables.T8[nArray[3]];
        int n9 = 1;
        while (n9 < this.rounds - 1) {
            n6 = 0;
            n5 = 0;
            while (n5 < 4) {
                n4 = 24;
                n3 = 0;
                while (n3 < 4) {
                    nArray[n6++] = (nArray2[n5] >> n4 ^ this.keyTable[n7++]) & 0xFF;
                    ++n3;
                    n4 -= 8;
                }
                ++n5;
            }
            n7 -= 32;
            nArray2[0] = JA_AESTables.T5[nArray[0]] ^ JA_AESTables.T6[nArray[13]] ^ JA_AESTables.T7[nArray[10]] ^ JA_AESTables.T8[nArray[7]];
            nArray2[1] = JA_AESTables.T5[nArray[4]] ^ JA_AESTables.T6[nArray[1]] ^ JA_AESTables.T7[nArray[14]] ^ JA_AESTables.T8[nArray[11]];
            nArray2[2] = JA_AESTables.T5[nArray[8]] ^ JA_AESTables.T6[nArray[5]] ^ JA_AESTables.T7[nArray[2]] ^ JA_AESTables.T8[nArray[15]];
            nArray2[3] = JA_AESTables.T5[nArray[12]] ^ JA_AESTables.T6[nArray[9]] ^ JA_AESTables.T7[nArray[6]] ^ JA_AESTables.T8[nArray[3]];
            ++n9;
        }
        n6 = 0;
        n5 = 0;
        while (n5 < 4) {
            n4 = 24;
            n3 = 0;
            while (n3 < 4) {
                nArray[n6++] = (nArray2[n5] >> n4 ^ this.keyTable[n7++]) & 0xFF;
                ++n3;
                n4 -= 8;
            }
            ++n5;
        }
        n4 = n2;
        byArray2[n4++] = JA_AESTables.S5[nArray[0]];
        byArray2[n4++] = JA_AESTables.S5[nArray[13]];
        byArray2[n4++] = JA_AESTables.S5[nArray[10]];
        byArray2[n4++] = JA_AESTables.S5[nArray[7]];
        byArray2[n4++] = JA_AESTables.S5[nArray[4]];
        byArray2[n4++] = JA_AESTables.S5[nArray[1]];
        byArray2[n4++] = JA_AESTables.S5[nArray[14]];
        byArray2[n4++] = JA_AESTables.S5[nArray[11]];
        byArray2[n4++] = JA_AESTables.S5[nArray[8]];
        byArray2[n4++] = JA_AESTables.S5[nArray[5]];
        byArray2[n4++] = JA_AESTables.S5[nArray[2]];
        byArray2[n4++] = JA_AESTables.S5[nArray[15]];
        byArray2[n4++] = JA_AESTables.S5[nArray[12]];
        byArray2[n4++] = JA_AESTables.S5[nArray[9]];
        byArray2[n4++] = JA_AESTables.S5[nArray[6]];
        byArray2[n4++] = JA_AESTables.S5[nArray[3]];
        n3 = 0;
        while (n3 < 16) {
            int n10 = n2++;
            byArray2[n10] = (byte)(byArray2[n10] ^ this.keyTable[n3]);
            ++n3;
        }
        return 16;
    }

    public byte[] wrapKey(JSAFE_Key jSAFE_Key, boolean bl, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot wrap key.");
    }

    public JSAFE_PrivateKey unwrapPrivateKey(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    public JSAFE_PublicKey unwrapPublicKey(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    public JSAFE_SecretKey unwrapSecretKey(byte[] byArray, int n, int n2, boolean bl, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    public void obfuscate() {
        if ((this.obfuscateFlag & 2) != 0) {
            return;
        }
        if (this.tableOI == null) {
            this.tableOI = JSAFE_Obfuscator.register(this.keyTable);
            if (!this.tableOI.getPower()) {
                this.obfuscateFlag = 2;
                return;
            }
            this.obfuscateFlag = 1;
        } else {
            this.tableOI.obfuscate();
            this.obfuscateFlag = 1;
        }
    }

    public void deobfuscate() {
        if ((this.obfuscateFlag & 1) != 0) {
            this.tableOI.deobfuscate();
            this.obfuscateFlag = 4;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JA_AES jA_AES = new JA_AES();
        this.copyContents(jA_AES);
        return jA_AES;
    }

    protected void copyContents(JA_AES jA_AES) throws CloneNotSupportedException {
        int n = this.obfuscateFlag;
        this.deobfuscate();
        if (this.keyTable != null) {
            System.arraycopy(this.keyTable, 0, jA_AES.keyTable, 0, this.keyTable.length);
        }
        if ((n & 1) != 0) {
            this.obfuscate();
            jA_AES.obfuscate();
        }
        jA_AES.fixedRounds = this.fixedRounds;
        jA_AES.rounds = this.rounds;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private void prepareSerialization() {
        if ((this.obfuscateFlag & 1) == 0) {
            return;
        }
        this.deobfuscate();
        this.obfuscateFlag = 1;
    }

    private void restoreAfterSerialization() {
        if (this.obfuscateFlag == 1) {
            this.obfuscateFlag = 4;
            this.obfuscate();
        }
    }

    private void restoreAfterDeserialization() {
        if (this.obfuscateFlag == 1) {
            this.obfuscateFlag = 0;
            this.obfuscate();
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        JSAFE_Obfuscator.deregisterOrOverwrite(this.keyTable, this.tableOI);
        this.tableOI = null;
        this.obfuscateFlag = 0;
        this.rounds = 0;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

