/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_UnimplementedException;

class JA_AsymmetricAlgID
extends JSAFE_Object {
    String transformation;
    byte[] paramsP;
    int paramsPOffset;
    int paramsPLen;
    private static final String[] oaepTransformations = new String[]{"RSA/PKCS1V2OAEPPad"};

    JA_AsymmetricAlgID() {
    }

    void decodeAlgID(byte[] byArray, int n) throws JSAFE_UnimplementedException {
        this.paramsP = null;
        EncodedContainer encodedContainer = new EncodedContainer(130816);
        try {
            this.transformation = AlgorithmID.berDecodeAlgID(byArray, n, 2, encodedContainer);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not read BER data. (" + aSN_Exception.getMessage() + ")");
        }
        if (this.transformation == null) {
            return;
        }
        int n2 = 0;
        while (n2 < oaepTransformations.length) {
            if (this.transformation.compareTo(oaepTransformations[n2]) == 0) break;
            ++n2;
        }
        if (n2 >= oaepTransformations.length) {
            return;
        }
        this.readOAEPAlgIDParams(n2, encodedContainer.data, encodedContainer.dataOffset);
    }

    private void readOAEPAlgIDParams(int n, byte[] byArray, int n2) throws JSAFE_UnimplementedException {
        try {
            ASN1Container[] aSN1ContainerArray = JA_AsymmetricAlgID.getOAEPContainerArray(null, null, null, null, null);
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            this.transformation = aSN1ContainerArray[1].dataPresent ? this.transformation.concat("/" + ((OIDContainer)aSN1ContainerArray[2]).transformation) : this.transformation.concat("/SHA1");
            if (aSN1ContainerArray[5].dataPresent) {
                this.transformation = this.transformation.concat("/" + ((OIDContainer)aSN1ContainerArray[6]).transformation);
                this.transformation = this.transformation.concat("/" + ((OIDContainer)aSN1ContainerArray[8]).transformation);
            } else {
                this.transformation = this.transformation.concat("/MGF1/SHA1");
            }
            if (aSN1ContainerArray[12].dataPresent) {
                this.transformation = this.transformation.concat("/" + ((OIDContainer)aSN1ContainerArray[13]).transformation);
                this.paramsP = aSN1ContainerArray[14].data;
                this.paramsPOffset = aSN1ContainerArray[14].dataOffset;
                this.paramsPLen = aSN1ContainerArray[14].dataLen;
            } else {
                this.transformation = this.transformation.concat("/SpecifiedParams");
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Invalid RSA OAEP parameter BER encoding. (" + aSN_Exception.getMessage() + ")");
        }
    }

    static byte[] getOAEPAlgIDParams(String string, String string2, String string3, String string4, byte[] byArray) throws JSAFE_UnimplementedException {
        try {
            ASN1Container[] aSN1ContainerArray = JA_AsymmetricAlgID.getOAEPContainerArray(string, string2, string3, string4, byArray);
            return ASN1.derEncode(aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not DER encode the OAEP AlgID parameters. " + aSN_Exception.getMessage());
        }
    }

    private static ASN1Container[] getOAEPContainerArray(String string, String string2, String string3, String string4, byte[] byArray) throws ASN_Exception {
        EndContainer endContainer = new EndContainer();
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        boolean bl = false;
        if (string != null && string.compareTo("SHA1") != 0) {
            bl = true;
        }
        SequenceContainer sequenceContainer2 = new SequenceContainer(0xA20000, bl, 0);
        OIDContainer oIDContainer = new OIDContainer(0, true, 0, string, 10);
        EncodedContainer encodedContainer = new EncodedContainer(130816, true, 5, null, 0, 0);
        bl = false;
        if (string2 != null && string2.compareTo("MGF1") != 0 && string3 != null && string3.compareTo("SHA1") != 0) {
            bl = true;
        }
        SequenceContainer sequenceContainer3 = new SequenceContainer(10616833, bl, 0);
        OIDContainer oIDContainer2 = new OIDContainer(0, true, 0, string2, 12);
        SequenceContainer sequenceContainer4 = new SequenceContainer(0, true, 0);
        OIDContainer oIDContainer3 = new OIDContainer(0, true, 0, string3, 11);
        EncodedContainer encodedContainer2 = new EncodedContainer(130816, true, 5, null, 0, 0);
        bl = false;
        if (string4 != null && string4.compareTo("SpecifiedParams") != 0) {
            bl = true;
        }
        int n = 0;
        if (byArray != null && byArray.length != 0) {
            bl = true;
            n = byArray.length;
        }
        SequenceContainer sequenceContainer5 = new SequenceContainer(0xA20002, bl, 0);
        OIDContainer oIDContainer4 = new OIDContainer(0, true, 0, string4, 13);
        OctetStringContainer octetStringContainer = new OctetStringContainer(0, true, 0, byArray, 0, n);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, sequenceContainer2, oIDContainer, encodedContainer, endContainer, sequenceContainer3, oIDContainer2, sequenceContainer4, oIDContainer3, encodedContainer2, endContainer, endContainer, sequenceContainer5, oIDContainer4, octetStringContainer, endContainer, endContainer};
        return aSN1ContainerArray;
    }
}

