/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeRecode;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;

final class JA_Base64
implements JA_AlgaeRecode {
    public static final int PAD_CHAR = 64;
    public static final int IGNORE_CHAR = 65;
    public static final int DEFAULT_OUTPUT_LINE_SIZE = 76;
    public static final int UNRESTRICTED_OUTPUT_LINE_SIZE = 0;
    private static final byte[] BASE64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".getBytes();
    private int count;
    private static final int RECODE_BUFFER_SIZE = 4;
    private byte[] buffer = new byte[4];
    private int outputLineSize;
    private int inputCharsProcessed;

    JA_Base64() {
    }

    private void commonInit() {
        this.count = 0;
        this.inputCharsProcessed = 0;
    }

    JA_Base64(int[] nArray) throws JSAFE_InvalidParameterException {
        this.setInstantiationParameters(nArray);
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        this.outputLineSize = 76;
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (nArray.length != 1) {
            throw new JSAFE_InvalidParameterException("Incorrect number of parameters: expected 1");
        }
        if (nArray[0] < 0 || nArray[0] > 76) {
            throw new JSAFE_InvalidParameterException("Parameter out of range");
        }
        if (nArray[0] % 4 != 0) {
            throw new JSAFE_InvalidParameterException("Parameter must be a multiple of 4");
        }
        this.outputLineSize = nArray[0];
    }

    public int[] getInstantiationParameters() {
        int[] nArray = new int[]{this.outputLineSize};
        return nArray;
    }

    public String getAlgorithm() {
        return "Base64";
    }

    public int getOutputBufferSize(int n, boolean bl) {
        int n2 = 0;
        if (bl) {
            if (n == 0) {
                return this.outputLineSize > 0 ? 6 : 4;
            }
            if (n % 3 != 0) {
                int n3 = n2 = this.outputLineSize > 0 ? 6 : 4;
            }
            if (n / 3 > 0) {
                int n4 = 4 * n / 3;
                n2 += n4;
                if (this.outputLineSize > 0) {
                    n2 += 2 * (n4 / this.outputLineSize);
                }
            }
        } else {
            n2 = this.decodeFinalCount();
            if (n == 0) {
                return n2;
            }
            n2 += 3 * (n / 4);
        }
        return n2;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_Base64 jA_Base64 = new JA_Base64();
        jA_Base64.count = this.count;
        if (this.buffer != null) {
            jA_Base64.buffer = (byte[])this.buffer.clone();
        }
        jA_Base64.outputLineSize = this.outputLineSize;
        jA_Base64.inputCharsProcessed = jA_Base64.inputCharsProcessed;
        return jA_Base64;
    }

    public void encodeInit() {
        this.commonInit();
    }

    public int encodeUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n2 <= 0) {
            return 0;
        }
        int n4 = n3;
        while (n2-- > 0) {
            this.buffer[this.count++] = byArray[n++];
            ++this.inputCharsProcessed;
            if (this.count != 3) continue;
            this.count = 0;
            byArray2[n3++] = BASE64[this.buffer[0] >> 2 & 0x3F];
            byArray2[n3++] = BASE64[this.buffer[0] << 4 & 0x30 | this.buffer[1] >> 4 & 0xF];
            byArray2[n3++] = BASE64[this.buffer[1] << 2 & 0x3C | this.buffer[2] >> 6 & 3];
            byArray2[n3++] = BASE64[this.buffer[2] & 0x3F];
            if (this.outputLineSize <= 0 || 4 * (this.inputCharsProcessed / 3) != this.outputLineSize) continue;
            this.inputCharsProcessed = 0;
            byArray2[n3++] = 13;
            byArray2[n3++] = 10;
        }
        return n3 - n4;
    }

    public int encodeFinal(byte[] byArray, int n) {
        if (this.count == 0) {
            return 0;
        }
        int n2 = n;
        byArray[n++] = BASE64[this.buffer[0] >> 2 & 0x3F];
        if (this.count == 1) {
            byArray[n++] = BASE64[this.buffer[0] << 4 & 0x30];
            byArray[n++] = BASE64[64];
        } else if (this.count == 2) {
            byArray[n++] = BASE64[this.buffer[0] << 4 & 0x30 | this.buffer[1] >> 4 & 0xF];
            byArray[n++] = BASE64[this.buffer[1] << 2 & 0x3C];
        }
        byArray[n++] = BASE64[64];
        this.count = 0;
        return n - n2;
    }

    public void decodeInit() {
        this.commonInit();
    }

    public int decodeUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws JSAFE_InputException {
        if (n2 <= 0) {
            return 0;
        }
        int n4 = n3;
        while (n2-- > 0) {
            int n5;
            if ((n5 = this.lookupChar(byArray[n++])) < 0) {
                throw new JSAFE_InputException("invalid character");
            }
            if (n5 != 65) {
                this.buffer[this.count++] = (byte)n5;
            }
            if (this.count != 4) continue;
            int n6 = 0;
            while (n6 < 4) {
                if (this.buffer[n6] == 64) {
                    return n3 - n4;
                }
                ++n6;
            }
            byArray2[n3++] = (byte)(this.buffer[0] << 2 & 0xFC | this.buffer[1] >> 4 & 3);
            byArray2[n3++] = (byte)(this.buffer[1] << 4 & 0xF0 | this.buffer[2] >> 2 & 0xF);
            byArray2[n3++] = (byte)(this.buffer[2] << 6 & 0xC0 | this.buffer[3] & 0x3F);
            this.count = 0;
        }
        return n3 - n4;
    }

    private int decodeFinalCount() {
        if (this.count == 0) {
            return 3;
        }
        if (this.buffer[2] == 64) {
            return 1;
        }
        if (this.buffer[3] == 64) {
            return 2;
        }
        return 3;
    }

    public int decodeFinal(byte[] byArray, int n) throws JSAFE_InputException {
        if (this.count == 0) {
            return 0;
        }
        if (this.count != 4) {
            throw new JSAFE_InputException("Unexpected padding chars");
        }
        if (this.buffer[0] == 64 || this.buffer[1] == 64) {
            throw new JSAFE_InputException("Unexpected padding chars");
        }
        this.count = 0;
        byArray[n++] = (byte)(this.buffer[0] << 2 & 0xFC | this.buffer[1] >> 4 & 3);
        if (this.buffer[2] == 64) {
            return 1;
        }
        byArray[n++] = (byte)(this.buffer[1] << 4 & 0xF0 | this.buffer[2] >> 2 & 0xF);
        if (this.buffer[3] == 64) {
            return 2;
        }
        byArray[n] = (byte)(this.buffer[2] << 6 & 0xC0 | this.buffer[3] & 0x3F);
        return 3;
    }

    private int lookupChar(int n) {
        if (n == 13 || n == 10 || n == 32 || n == 9) {
            return 65;
        }
        int n2 = 64;
        while (n2 >= 0) {
            if ((byte)n == BASE64[n2]) break;
            --n2;
        }
        return n2;
    }

    public void obfuscate() {
    }

    public void deobfuscate() {
    }

    public void clearSensitiveData() {
        int n = 0;
        while (n < this.buffer.length) {
            this.buffer[n] = 0;
            ++n;
        }
        this.count = 0;
        this.inputCharsProcessed = 0;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

