/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.jsafe.JA_AlgaeBlockCipher;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.security.SecureRandom;

final class JA_CBC
extends JA_FeedbackMode
implements Cloneable,
Serializable {
    private byte[] initializationVector;
    private byte[] xorVector;
    private byte[] cipherVector;
    private byte[] availableVector;
    private byte[] otherVector;
    private boolean cipherAvailable = true;
    private int ivLength;

    JA_CBC() {
    }

    JA_CBC(int[] nArray) throws JSAFE_InvalidParameterException {
        this.setInstantiationParameters(nArray);
    }

    JA_CBC(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3] = byArray3[n3] = byArray[n];
            ++n3;
            ++n;
        }
        this.initializationVector = byArray2;
        this.xorVector = byArray3;
        this.cipherVector = byArray4;
        this.ivLength = n2;
    }

    public int getBlockSize() {
        return -1;
    }

    public String getFeedbackMode() {
        return "CBC";
    }

    public int getIVSize(int n) {
        return n;
    }

    public void setAlgorithmBER(byte[] byArray, int n, int n2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        try {
            OctetStringContainer octetStringContainer = new OctetStringContainer(0);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{octetStringContainer};
            ASN1.berDecode(byArray, n, aSN1ContainerArray);
            this.setIV(octetStringContainer.data, octetStringContainer.dataOffset, octetStringContainer.dataLen);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Invalid BER encoding. (" + aSN_Exception.getMessage() + ")");
        }
    }

    byte[] getParamsDER() throws JSAFE_UnimplementedException {
        if (this.initializationVector == null) {
            throw new JSAFE_UnimplementedException("Cannot DER encode CBC, IV not set.");
        }
        byte[] byArray = new byte[this.initializationVector.length + 2];
        byArray[0] = 4;
        byArray[1] = (byte)this.initializationVector.length;
        System.arraycopy(this.initializationVector, 0, byArray, 2, this.initializationVector.length);
        return byArray;
    }

    public void setIV(byte[] byArray, int n, int n2) throws JSAFE_IVException {
        if (this.ivLength != 0 && n2 != this.ivLength) {
            throw new JSAFE_IVException("Incorrect IV Length. Should be " + this.ivLength + ".");
        }
        this.cipherAvailable = true;
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3] = byArray3[n3] = byArray[n];
            ++n3;
            ++n;
        }
        this.initializationVector = byArray2;
        this.xorVector = byArray3;
        this.cipherVector = byArray4;
        this.ivLength = n2;
    }

    public int getIVLength() {
        return this.ivLength;
    }

    public byte[] getIV() {
        if (this.ivLength == 0) {
            return null;
        }
        byte[] byArray = new byte[this.ivLength];
        int n = 0;
        while (n < this.ivLength) {
            byArray[n] = this.initializationVector[n];
            ++n;
        }
        return byArray;
    }

    void encryptInit(JA_AlgaeBlockCipher jA_AlgaeBlockCipher, JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        jA_AlgaeBlockCipher.encryptInit(jSAFE_SecretKey, secureRandom);
    }

    void decryptInit(JA_AlgaeBlockCipher jA_AlgaeBlockCipher, JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        jA_AlgaeBlockCipher.decryptInit(jSAFE_SecretKey, secureRandom);
    }

    public Object clone() throws CloneNotSupportedException {
        JA_CBC jA_CBC = new JA_CBC();
        if (this.initializationVector != null) {
            jA_CBC.initializationVector = (byte[])this.initializationVector.clone();
        }
        if (this.xorVector != null) {
            jA_CBC.xorVector = (byte[])this.xorVector.clone();
        }
        if (this.cipherVector != null) {
            jA_CBC.cipherVector = (byte[])this.cipherVector.clone();
        }
        if (this.availableVector != null) {
            jA_CBC.availableVector = (byte[])this.availableVector.clone();
        }
        if (this.otherVector != null) {
            jA_CBC.otherVector = (byte[])this.otherVector.clone();
        }
        jA_CBC.cipherAvailable = this.cipherAvailable;
        jA_CBC.ivLength = this.ivLength;
        return jA_CBC;
    }

    int encryptBlock(JA_AlgaeBlockCipher jA_AlgaeBlockCipher, byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = 0;
        while (n3 < this.ivLength) {
            int n4 = n3;
            this.xorVector[n4] = (byte)(this.xorVector[n4] ^ byArray[n3 + n]);
            ++n3;
        }
        int n5 = jA_AlgaeBlockCipher.encryptBlock(this.xorVector, 0, byArray2, n2);
        n3 = 0;
        while (n3 < this.ivLength) {
            this.xorVector[n3] = byArray2[n3 + n2];
            ++n3;
        }
        return n5;
    }

    int decryptBlock(JA_AlgaeBlockCipher jA_AlgaeBlockCipher, byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.cipherAvailable) {
            this.availableVector = this.cipherVector;
            this.otherVector = this.xorVector;
        } else {
            this.availableVector = this.xorVector;
            this.otherVector = this.cipherVector;
        }
        this.cipherAvailable = !this.cipherAvailable;
        int n3 = 0;
        while (n3 < this.ivLength) {
            this.availableVector[n3] = byArray[n3 + n];
            ++n3;
        }
        int n4 = jA_AlgaeBlockCipher.decryptBlock(byArray, n, byArray2, n2);
        n3 = 0;
        while (n3 < this.ivLength) {
            int n5 = n3 + n2;
            byArray2[n5] = (byte)(byArray2[n5] ^ this.otherVector[n3]);
            ++n3;
        }
        return n4;
    }

    public void clearSensitiveData() {
        JSAFE_Obfuscator.overwrite(this.initializationVector);
        JSAFE_Obfuscator.overwrite(this.xorVector);
        JSAFE_Obfuscator.overwrite(this.cipherVector);
        this.ivLength = 0;
        this.cipherAvailable = true;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

