/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeBlockCipher;
import com.rsa.jsafe.JA_DESKey;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JA_SymmetricPaddingScheme;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

final class JA_DES
extends JSAFE_Object
implements JA_AlgaeBlockCipher,
Cloneable,
Serializable {
    private byte[] keyTable = new byte[128];
    private transient ObfuscatorItem tableOI;
    private static final int DES_BLOCK_SIZE = 8;
    private static final int[] sBox0 = new int[]{0x808200, 0, 32768, 0x808202, 0x808002, 33282, 2, 32768, 512, 0x808200, 0x808202, 512, 0x800202, 0x808002, 0x800000, 2, 514, 0x800200, 0x800200, 33280, 33280, 0x808000, 0x808000, 0x800202, 32770, 0x800002, 0x800002, 32770, 0, 514, 33282, 0x800000, 32768, 0x808202, 2, 0x808000, 0x808200, 0x800000, 0x800000, 512, 0x808002, 32768, 33280, 0x800002, 512, 2, 0x800202, 33282, 0x808202, 32770, 0x808000, 0x800202, 0x800002, 514, 33282, 0x808200, 514, 0x800200, 0x800200, 0, 32770, 33280, 0, 0x808002};
    private static final int[] sBox1 = new int[]{1074282512, 0x40004000, 16384, 540688, 524288, 16, 1074266128, 0x40004010, 0x40000010, 1074282512, 0x40084000, 0x40000000, 0x40004000, 524288, 16, 1074266128, 540672, 524304, 0x40004010, 0, 0x40000000, 16384, 540688, 0x40080000, 524304, 0x40000010, 0, 540672, 16400, 0x40084000, 0x40080000, 16400, 0, 540688, 1074266128, 524288, 0x40004010, 0x40080000, 0x40084000, 16384, 0x40080000, 0x40004000, 16, 1074282512, 540688, 16, 16384, 0x40000000, 16400, 0x40084000, 524288, 0x40000010, 524304, 0x40004010, 0x40000010, 524304, 540672, 0, 0x40004000, 16400, 0x40000000, 1074266128, 1074282512, 540672};
    private static final int[] sBox2 = new int[]{260, 0x4010100, 0, 0x4010004, 0x4000100, 0, 65796, 0x4000100, 65540, 0x4000004, 0x4000004, 65536, 0x4010104, 65540, 0x4010000, 260, 0x4000000, 4, 0x4010100, 256, 65792, 0x4010000, 0x4010004, 65796, 0x4000104, 65792, 65536, 0x4000104, 4, 0x4010104, 256, 0x4000000, 0x4010100, 0x4000000, 65540, 260, 65536, 0x4010100, 0x4000100, 0, 256, 65540, 0x4010104, 0x4000100, 0x4000004, 256, 0, 0x4010004, 0x4000104, 65536, 0x4000000, 0x4010104, 4, 65796, 65792, 0x4000004, 0x4010000, 0x4000104, 260, 0x4010000, 65796, 4, 0x4010004, 65792};
    private static final int[] sBox3 = new int[]{-2143285248, -2147479488, -2147479488, 64, 0x401040, -2143289280, -2143289344, -2147479552, 0, 0x401000, 0x401000, -2143285184, -2147483584, 0, 0x400040, -2143289344, Integer.MIN_VALUE, 4096, 0x400000, -2143285248, 64, 0x400000, -2147479552, 4160, -2143289280, Integer.MIN_VALUE, 4160, 0x400040, 4096, 0x401040, -2143285184, -2147483584, 0x400040, -2143289344, 0x401000, -2143285184, -2147483584, 0, 0, 0x401000, 4160, 0x400040, -2143289280, Integer.MIN_VALUE, -2143285248, -2147479488, -2147479488, 64, -2143285184, -2147483584, Integer.MIN_VALUE, 4096, -2143289344, -2147479552, 0x401040, -2143289280, -2147479552, 4160, 0x400000, -2143285248, 64, 0x400000, 4096, 0x401040};
    private static final int[] sBox4 = new int[]{128, 17039488, 0x1040000, 553648256, 262144, 128, 0x20000000, 0x1040000, 537133184, 262144, 0x1000080, 537133184, 553648256, 553910272, 262272, 0x20000000, 0x1000000, 0x20040000, 0x20040000, 0, 0x20000080, 553910400, 553910400, 0x1000080, 553910272, 0x20000080, 0, 0x21000000, 17039488, 0x1000000, 0x21000000, 262272, 262144, 553648256, 128, 0x1000000, 0x20000000, 0x1040000, 553648256, 537133184, 0x1000080, 0x20000000, 553910272, 17039488, 537133184, 128, 0x1000000, 553910272, 553910400, 262272, 0x21000000, 553910400, 0x1040000, 0, 0x20040000, 0x21000000, 262272, 0x1000080, 0x20000080, 262144, 0, 0x20040000, 17039488, 0x20000080};
    private static final int[] sBox5 = new int[]{0x10000008, 0x10200000, 8192, 270540808, 0x10200000, 8, 270540808, 0x200000, 0x10002000, 0x202008, 0x200000, 0x10000008, 0x200008, 0x10002000, 0x10000000, 8200, 0, 0x200008, 268443656, 8192, 0x202000, 268443656, 8, 270532616, 270532616, 0, 0x202008, 0x10202000, 8200, 0x202000, 0x10202000, 0x10000000, 0x10002000, 8, 270532616, 0x202000, 270540808, 0x200000, 8200, 0x10000008, 0x200000, 0x10002000, 0x10000000, 8200, 0x10000008, 270540808, 0x202000, 0x10200000, 0x202008, 0x10202000, 0, 270532616, 8, 8192, 0x10200000, 0x202008, 8192, 0x200008, 268443656, 0, 0x10202000, 0x10000000, 0x200008, 268443656};
    private static final int[] sBox6 = new int[]{0x100000, 0x2100001, 33555457, 0, 1024, 33555457, 0x100401, 34604032, 34604033, 0x100000, 0, 0x2000001, 1, 0x2000000, 0x2100001, 1025, 0x2000400, 0x100401, 0x100001, 0x2000400, 0x2000001, 0x2100000, 34604032, 0x100001, 0x2100000, 1024, 1025, 34604033, 0x100400, 1, 0x2000000, 0x100400, 0x2000000, 0x100400, 0x100000, 33555457, 33555457, 0x2100001, 0x2100001, 1, 0x100001, 0x2000000, 0x2000400, 0x100000, 34604032, 1025, 0x100401, 34604032, 1025, 0x2000001, 34604033, 0x2100000, 0x100400, 0, 1, 34604033, 0, 0x100401, 0x2100000, 1024, 0x2000001, 0x2000400, 1024, 0x100001};
    private static final int[] sBox7 = new int[]{0x8000820, 2048, 131072, 0x8020820, 0x8000000, 0x8000820, 32, 0x8000000, 131104, 0x8020000, 0x8020820, 133120, 0x8020800, 133152, 2048, 32, 0x8020000, 0x8000020, 0x8000800, 2080, 133120, 131104, 0x8020020, 0x8020800, 2080, 0, 0, 0x8020020, 0x8000020, 0x8000800, 133152, 131072, 133152, 131072, 0x8020800, 2048, 32, 0x8020020, 2048, 133152, 0x8000800, 32, 0x8000020, 0x8020000, 0x8020020, 0x8000000, 131072, 0x8000820, 0, 0x8020820, 131104, 0x8000020, 0x8020000, 0x8000800, 0x8000820, 0, 0x8020820, 133120, 133120, 2080, 2080, 131104, 0x8000000, 0x8020800};

    JA_DES() {
    }

    JA_DES(int[] nArray) throws JSAFE_InvalidParameterException {
        this();
        this.setInstantiationParameters(nArray);
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Expected no algorithm parameters");
        }
    }

    public int[] getInstantiationParameters() {
        return new int[0];
    }

    public void setAlgorithmBER(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        jA_FeedbackMode.setAlgorithmBER(byArray, n, n2);
    }

    public byte[] getParamsDER(byte[] byArray) {
        return byArray;
    }

    public String getAlgorithm() {
        return "DES";
    }

    public int getBlockSize() {
        return 8;
    }

    public boolean canWrapKey(boolean bl) {
        return false;
    }

    public void pbeKeySize(int n) {
    }

    public byte[] wrapKey(JSAFE_Key jSAFE_Key, boolean bl, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot wrap key.");
    }

    public JSAFE_PrivateKey unwrapPrivateKey(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    public JSAFE_PublicKey unwrapPublicKey(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    public JSAFE_SecretKey unwrapSecretKey(byte[] byArray, int n, int n2, boolean bl, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private void prepareSerialization() {
        if (this.tableOI != null) {
            this.tableOI.deobfuscate();
        }
    }

    private void restoreAfterSerialization() {
        if (this.tableOI != null) {
            this.tableOI.obfuscate();
        }
    }

    private void restoreAfterDeserialization() {
        if (this.keyTable == null) {
            return;
        }
        this.tableOI = JSAFE_Obfuscator.register(this.keyTable);
        this.tableOI.obfuscate();
    }

    public Object clone() throws CloneNotSupportedException {
        JA_DES jA_DES = new JA_DES();
        jA_DES.keyTable = (byte[])JSAFE_Obfuscator.copy(this.keyTable, this.tableOI);
        jA_DES.tableOI = JSAFE_Obfuscator.getObfuscatorItem(jA_DES.keyTable);
        return jA_DES;
    }

    private static void schedule(byte[] byArray, byte[] byArray2, boolean bl) {
        int n = 16;
        int[] nArray = new int[]{1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1};
        int n2 = (byArray2[0] & 0xFF) + ((byArray2[1] & 0xFF) << 8) + ((byArray2[2] & 0xFF) << 16) + ((byArray2[3] & 0xFF) << 24);
        int n3 = (byArray2[4] & 0xFF) + ((byArray2[5] & 0xFF) << 8) + ((byArray2[6] & 0xFF) << 16) + ((byArray2[7] & 0xFF) << 24);
        int n4 = (n3 & 0xF0F0F0F) + ((n2 & 0xF0F0F0F) << 4);
        n2 = (n2 & 0xF0F0F0F0) + (n3 >>> 4 & 0xF0F0F0F);
        n3 = (n4 >>> 24) + (n4 >>> 8 & 0xFF00) + ((n4 & 0xFF00) << 8) + (n4 << 24);
        int n5 = (n2 ^ n2 >>> 9) & 0x550055;
        n2 ^= n5 + (n5 << 9);
        n4 = (n3 ^ n3 >>> 7) & 0xAA00AA;
        n3 ^= n4 + (n4 << 7);
        n5 = (n2 ^ n2 >>> 18) & 0x3333;
        n4 = (n3 ^ n3 >>> 14) & 0xCCCC;
        n3 ^= n4 + (n4 << 14);
        n4 = (n3 >>> 8) + ((n2 ^= n5 + (n5 << 18)) >>> 4 & 0xF000000);
        n5 = n2 & 0xFFFFFFF;
        while (n-- > 0) {
            int n6 = nArray[n];
            int n7 = 28 - n6;
            int n8 = (bl ? n : 15 - n) << 3;
            byArray[n8] = (byte)((n5 >>> 8 & 0x20 | n5 >>> 12 & 0x10 | n5 >>> 7 & 8 | n5 >>> 21 & 4 | n5 << 1 & 2 | n5 >>> 4 & 1) & 0xFF);
            byArray[n8 + 1] = (byte)((n5 << 3 & 0x20 | n5 >>> 23 & 0x10 | n5 >>> 11 & 8 | n5 >>> 3 & 4 | n5 >>> 19 & 2 | n5 >>> 9 & 1) & 0xFF);
            byArray[n8 + 2] = (byte)((n5 >>> 17 & 0x20 | n5 >>> 14 & 0x10 | n5 >>> 8 & 8 | n5 >>> 1 & 4 | n5 >>> 24 & 2 | n5 >>> 7 & 1) & 0xFF);
            byArray[n8 + 3] = (byte)((n5 >>> 10 & 0x20 | n5 >>> 2 & 0x10 | n5 >>> 23 & 8 | n5 >>> 17 & 4 | n5 >>> 11 & 2 | n5 >>> 1 & 1) & 0xFF);
            byArray[n8 + 4] = (byte)((n4 >>> 7 & 0x20 | n4 >>> 19 & 0x10 | n4 << 1 & 8 | n4 >>> 6 & 4 | n4 >>> 17 & 2 | n4 >>> 26 & 1) & 0xFF);
            byArray[n8 + 5] = (byte)((n4 << 4 & 0x20 | n4 >>> 7 & 0x10 | n4 >>> 19 & 8 | n4 >>> 14 & 4 | n4 >>> 3 & 2 | n4 >>> 19 & 1) & 0xFF);
            byArray[n8 + 6] = (byte)((n4 >>> 10 & 0x20 | n4 >>> 16 & 0x10 | n4 >>> 7 & 8 | n4 >>> 25 & 4 | n4 >>> 4 & 2 | n4 >>> 24 & 1) & 0xFF);
            byArray[n8 + 7] = (byte)((n4 >>> 12 & 0x20 | n4 >>> 9 & 0x10 | n4 >>> 18 & 8 | n4 >>> 5 & 4 | n4 << 1 & 2 | n4 >>> 3 & 1) & 0xFF);
            n5 = n5 << n6 | n5 >>> n7;
            n4 = n4 << n6 | n4 >>> n7;
        }
    }

    public void encryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        byte[] byArray = null;
        try {
            byArray = ((JA_DESKey)jSAFE_SecretKey).getSecretKeyData("Clear");
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_InvalidKeyException("Invalid key type");
        }
        if (this.tableOI != null) {
            this.tableOI.overwrite();
        }
        JA_DES.schedule(this.keyTable, byArray, true);
        if (this.tableOI == null) {
            this.tableOI = JSAFE_Obfuscator.register(this.keyTable);
        }
        this.tableOI.obfuscate();
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = 0;
            ++n;
        }
    }

    public void decryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        byte[] byArray = null;
        try {
            byArray = ((JA_DESKey)jSAFE_SecretKey).getSecretKeyData("Clear");
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_InvalidKeyException("Invalid key type");
        }
        if (this.tableOI != null) {
            this.tableOI.overwrite();
        }
        JA_DES.schedule(this.keyTable, byArray, false);
        if (this.tableOI == null) {
            this.tableOI = JSAFE_Obfuscator.register(this.keyTable);
        }
        this.tableOI.obfuscate();
        JSAFE_Obfuscator.overwrite(byArray);
    }

    private void cryptoBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3;
        int n4 = n + 7;
        int n5 = (byArray[n4--] & 0xFF) + ((byArray[n4--] & 0xFF) << 8) + ((byArray[n4--] & 0xFF) << 16) + ((byArray[n4--] & 0xFF) << 24);
        n4 = n3 = (byArray[n4--] & 0xFF) + ((byArray[n4--] & 0xFF) << 8) + ((byArray[n4--] & 0xFF) << 16) + ((byArray[n4--] & 0xFF) << 24);
        n3 = n5;
        n5 = n4;
        n4 = (n3 ^ n5 >>> 1) & 0x55555555;
        n3 ^= n4;
        n5 ^= n4 << 1;
        n4 = (n3 ^ n3 >>> 12) & 0xF0F0;
        n3 ^= n4 + (n4 << 12);
        n4 = (n5 ^ n5 >>> 12) & 0xF0F0;
        n5 ^= n4 + (n4 << 12);
        n4 = (n3 ^ n3 >>> 6) & 0xCC00CC;
        n3 ^= n4 + (n4 << 6);
        n4 = (n5 ^ n5 >>> 6) & 0xCC00CC;
        n5 ^= n4 + (n4 << 6);
        n4 = (n3 ^ n3 >>> 3) & 0xA0A0A0A;
        n3 ^= n4 + (n4 << 3);
        n4 = (n5 ^ n5 >>> 3) & 0xA0A0A0A;
        n5 ^= n4 + (n4 << 3);
        n4 = (n3 ^ n3 >>> 3) & 0x11111111;
        n3 ^= n4 + (n4 << 3);
        n4 = (n5 ^ n5 >>> 3) & 0x11111111;
        n5 ^= n4 + (n4 << 3);
        n4 = n3;
        n3 = n5;
        n5 = n4;
        int n6 = 0;
        while (n6 <= 112) {
            int n7 = sBox0[(n5 >>> 27 | n5 << 5) & 0x3F ^ this.keyTable[n6] & 0xFF];
            n7 |= sBox1[n5 >>> 23 & 0x3F ^ this.keyTable[++n6] & 0xFF];
            n7 |= sBox2[n5 >>> 19 & 0x3F ^ this.keyTable[++n6] & 0xFF];
            n7 |= sBox3[n5 >>> 15 & 0x3F ^ this.keyTable[++n6] & 0xFF];
            n7 |= sBox4[n5 >>> 11 & 0x3F ^ this.keyTable[++n6] & 0xFF];
            n7 |= sBox5[n5 >>> 7 & 0x3F ^ this.keyTable[++n6] & 0xFF];
            n7 |= sBox6[n5 >>> 3 & 0x3F ^ this.keyTable[++n6] & 0xFF];
            n7 |= sBox7[(n5 << 1 | n5 >>> 31) & 0x3F ^ this.keyTable[++n6] & 0xFF];
            n3 ^= n7;
            n7 = sBox0[(n3 >>> 27 | n3 << 5) & 0x3F ^ this.keyTable[++n6] & 0xFF];
            n7 |= sBox1[n3 >>> 23 & 0x3F ^ this.keyTable[++n6] & 0xFF];
            n7 |= sBox2[n3 >>> 19 & 0x3F ^ this.keyTable[++n6] & 0xFF];
            n7 |= sBox3[n3 >>> 15 & 0x3F ^ this.keyTable[++n6] & 0xFF];
            n7 |= sBox4[n3 >>> 11 & 0x3F ^ this.keyTable[++n6] & 0xFF];
            n7 |= sBox5[n3 >>> 7 & 0x3F ^ this.keyTable[++n6] & 0xFF];
            n7 |= sBox6[n3 >>> 3 & 0x3F ^ this.keyTable[++n6] & 0xFF];
            n5 ^= (n7 |= sBox7[(n3 << 1 | n3 >>> 31) & 0x3F ^ this.keyTable[++n6] & 0xFF]);
            ++n6;
        }
        n4 = (n3 ^ n5 >>> 4) & 0xF0F0F0F;
        n3 ^= n4;
        n5 ^= n4 << 4;
        n4 = (n3 ^ n3 >>> 18) & 0x3333;
        n3 ^= n4 + (n4 << 18);
        n4 = (n5 ^ n5 >>> 18) & 0x3333;
        n5 ^= n4 + (n4 << 18);
        n4 = (n3 ^ n3 >>> 9) & 0x550055;
        n3 ^= n4 + (n4 << 9);
        n4 = (n5 ^ n5 >>> 9) & 0x550055;
        n5 ^= n4 + (n4 << 9);
        n4 = (n3 ^ n3 >>> 6) & 0x3030303;
        n3 ^= n4 + (n4 << 6);
        n4 = (n5 ^ n5 >>> 6) & 0x3030303;
        n5 ^= n4 + (n4 << 6);
        n4 = (n3 ^ n3 >>> 3) & 0x11111111;
        n3 ^= n4 + (n4 << 3);
        n4 = (n5 ^ n5 >>> 3) & 0x11111111;
        n5 ^= n4 + (n4 << 3);
        int n8 = n2 + 7;
        byArray2[n8] = (byte)n3;
        byArray2[--n8] = (byte)(n3 >>> 8);
        byArray2[--n8] = (byte)(n3 >>> 16);
        byArray2[--n8] = (byte)(n3 >>> 24);
        byArray2[--n8] = (byte)n5;
        byArray2[--n8] = (byte)(n5 >>> 8);
        byArray2[--n8] = (byte)(n5 >>> 16);
        byArray2[--n8] = (byte)(n5 >>> 24);
    }

    public int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.cryptoBlock(byArray, n, byArray2, n2);
        return 8;
    }

    public int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.cryptoBlock(byArray, n, byArray2, n2);
        return 8;
    }

    public void obfuscate() {
        if (this.tableOI != null) {
            this.tableOI.obfuscate();
        }
    }

    public void deobfuscate() {
        if (this.tableOI != null) {
            this.tableOI.deobfuscate();
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        JSAFE_Obfuscator.deregister(this.keyTable, this.tableOI);
        this.tableOI = null;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

