/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_SecretKey;
import java.io.Serializable;
import java.security.SecureRandom;

public class JA_DESKey
extends JSAFE_SecretKey
implements Cloneable,
Serializable {
    protected static final byte[][] weakKeys = new byte[][]{{1, 1, 1, 1, 1, 1, 1, 1}, {-2, -2, -2, -2, -2, -2, -2, -2}, {31, 31, 31, 31, 31, 31, 31, 31}, {-32, -32, -32, -32, -32, -32, -32, -32}, {1, -2, 1, -2, 1, -2, 1, -2}, {31, -32, 31, -32, 14, -15, 14, -15}, {1, -32, 1, -32, 1, -15, 1, -15}, {31, -2, 31, -2, 14, -2, 14, -2}, {1, 31, 1, 31, 1, 14, 1, 14}, {-32, -2, -32, -2, -15, -2, -15, -2}, {-2, 1, -2, 1, -2, 1, -2, 1}, {-32, 31, -32, 31, -15, 14, -15, 14}, {-32, 1, -32, 1, -15, 1, -15, 1}, {-2, 31, -2, 31, -2, 14, -2, 14}, {31, 1, 31, 1, 14, 1, 14, 1}, {-2, -32, -2, -32, -2, -15, -2, -15}};
    private static final int MIN_KEY_BITS = 64;
    private static final int MAX_KEY_BITS = 64;

    public JA_DESKey() {
        super("DES", 64, 64);
    }

    public void setSecretKeyData(byte[] byArray, int n, int n2) throws JSAFE_InvalidKeyException {
        if (this.keyData != null) {
            JSAFE_Obfuscator.deregisterOrOverwrite(this.keyData, this.keyOI);
            this.keyOI = null;
            this.keyData = null;
        }
        if (n2 != 8) {
            throw new JSAFE_InvalidKeyException("Invalid key data length. Should be 8 bytes long.");
        }
        this.keyData = new byte[n2];
        System.arraycopy(byArray, n, this.keyData, 0, n2);
        int n3 = 0;
        while (n3 < 8) {
            byte by = this.keyData[n3];
            byte by2 = 1;
            int n4 = 0;
            while (n4 < 7) {
                by = (byte)(by >>> 1);
                by2 = (byte)(by2 ^ by);
                ++n4;
            }
            by2 = (byte)(by2 & 1);
            int n5 = n3;
            this.keyData[n5] = (byte)(this.keyData[n5] & 0xFFFFFFFE);
            int n6 = n3++;
            this.keyData[n6] = (byte)(this.keyData[n6] | by2);
        }
        this.keyOI = JSAFE_Obfuscator.register(this.keyData);
        this.keyOI.obfuscate();
    }

    public void generateInit(int[] nArray, SecureRandom secureRandom) throws JSAFE_InvalidParameterException, JSAFE_InvalidUseException {
        int[] nArray2 = new int[]{64};
        if (nArray != null) {
            if (nArray.length > 1) {
                throw new JSAFE_InvalidParameterException("Wrong number of parameters: Expected 1 for DES key generation - KeyLenInBits");
            }
            if (nArray[0] != 56 && nArray[0] != 64) {
                throw new JSAFE_InvalidParameterException("Incorrect DES key length. 56 or 64 bits are acceptable.");
            }
        }
        super.generateInit(nArray2, secureRandom);
    }

    int getKeyBitLength(int n) {
        if (n == -1 || n == 56 || n == 64) {
            return 64;
        }
        return -1;
    }
}

