/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeBlockCipher;
import com.rsa.jsafe.JA_DES;
import com.rsa.jsafe.JA_DESKey;
import com.rsa.jsafe.JA_DESXKey;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JA_SymmetricPaddingScheme;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

final class JA_DESX
extends JSAFE_Object
implements JA_AlgaeBlockCipher,
Cloneable,
Serializable {
    private byte[] xorBuffer;
    private transient ObfuscatorItem bufferOI;
    private static final int DESX_BLOCK_SIZE = 8;
    private JA_DES desObject = new JA_DES();

    JA_DESX() {
    }

    JA_DESX(int[] nArray) throws JSAFE_InvalidParameterException {
        this();
        this.setInstantiationParameters(nArray);
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Expected no algorithm parameters");
        }
    }

    public int[] getInstantiationParameters() {
        return new int[0];
    }

    public void setAlgorithmBER(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        jA_FeedbackMode.setAlgorithmBER(byArray, n, n2);
    }

    public byte[] getParamsDER(byte[] byArray) {
        return byArray;
    }

    public String getAlgorithm() {
        return "DESX";
    }

    public int getBlockSize() {
        return 8;
    }

    public boolean canWrapKey(boolean bl) {
        return false;
    }

    public void pbeKeySize(int n) {
    }

    public byte[] wrapKey(JSAFE_Key jSAFE_Key, boolean bl, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot wrap key.");
    }

    public JSAFE_PrivateKey unwrapPrivateKey(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    public JSAFE_PublicKey unwrapPublicKey(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    public JSAFE_SecretKey unwrapSecretKey(byte[] byArray, int n, int n2, boolean bl, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private void prepareSerialization() {
        this.deobfuscate();
    }

    private void restoreAfterSerialization() {
        this.obfuscate();
    }

    private void restoreAfterDeserialization() {
        if (this.xorBuffer == null) {
            return;
        }
        this.bufferOI = JSAFE_Obfuscator.register(this.xorBuffer);
        this.bufferOI.obfuscate();
        this.desObject.obfuscate();
    }

    public Object clone() throws CloneNotSupportedException {
        JA_DESX jA_DESX = new JA_DESX();
        jA_DESX.desObject = (JA_DES)this.desObject.clone();
        if (this.xorBuffer != null) {
            jA_DESX.xorBuffer = (byte[])JSAFE_Obfuscator.copy(this.xorBuffer, this.bufferOI);
            jA_DESX.bufferOI = JSAFE_Obfuscator.getObfuscatorItem(jA_DESX.xorBuffer);
        }
        return jA_DESX;
    }

    public void encryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        if (this.bufferOI != null) {
            this.bufferOI.overwrite();
            this.bufferOI = null;
            this.xorBuffer = null;
        }
        JA_DESKey jA_DESKey = null;
        try {
            this.xorBuffer = ((JA_DESXKey)jSAFE_SecretKey).getSecretKeyData("Clear");
            jA_DESKey = ((JA_DESXKey)jSAFE_SecretKey).getDESKey();
        }
        catch (ClassCastException classCastException) {
            throw new JSAFE_InvalidKeyException("Invalid key type");
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_InvalidKeyException("Invalid key type");
        }
        this.desObject.encryptInit(jA_DESKey, secureRandom);
        this.bufferOI = JSAFE_Obfuscator.register(this.xorBuffer);
        this.bufferOI.obfuscate();
    }

    public void decryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        if (this.bufferOI != null) {
            this.bufferOI.overwrite();
            this.bufferOI = null;
            this.xorBuffer = null;
        }
        JA_DESKey jA_DESKey = null;
        try {
            this.xorBuffer = ((JA_DESXKey)jSAFE_SecretKey).getSecretKeyData("Clear");
            jA_DESKey = ((JA_DESXKey)jSAFE_SecretKey).getDESKey();
        }
        catch (ClassCastException classCastException) {
            throw new JSAFE_InvalidKeyException("Invalid key type");
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_InvalidKeyException("Invalid key type");
        }
        this.desObject.decryptInit(jA_DESKey, secureRandom);
        this.bufferOI = JSAFE_Obfuscator.register(this.xorBuffer);
        this.bufferOI.obfuscate();
    }

    public int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = 0;
        while (n3 < 8) {
            this.xorBuffer[n3] = (byte)(this.xorBuffer[n3 + 8] ^ byArray[n]);
            ++n3;
            ++n;
        }
        this.desObject.encryptBlock(this.xorBuffer, 0, byArray2, n2);
        int n4 = 16;
        while (n4 < 24) {
            int n5 = n2++;
            byArray2[n5] = (byte)(byArray2[n5] ^ this.xorBuffer[n4]);
            ++n4;
        }
        return 8;
    }

    public int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = 0;
        while (n3 < 8) {
            this.xorBuffer[n3] = (byte)(this.xorBuffer[n3 + 16] ^ byArray[n]);
            ++n3;
            ++n;
        }
        this.desObject.encryptBlock(this.xorBuffer, 0, byArray2, n2);
        int n4 = 8;
        while (n4 < 16) {
            int n5 = n2++;
            byArray2[n5] = (byte)(byArray2[n5] ^ this.xorBuffer[n4]);
            ++n4;
        }
        return 8;
    }

    public void obfuscate() {
        if (this.bufferOI != null) {
            this.bufferOI.obfuscate();
        }
        this.desObject.obfuscate();
    }

    public void deobfuscate() {
        if (this.bufferOI != null) {
            this.bufferOI.deobfuscate();
        }
        this.desObject.deobfuscate();
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.desObject.clearSensitiveData();
        JSAFE_Obfuscator.deregister(this.xorBuffer, this.bufferOI);
        this.bufferOI = null;
        this.xorBuffer = null;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

