/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_DESKey;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_SecretKey;
import java.io.Serializable;
import java.security.SecureRandom;

public class JA_DESXKey
extends JSAFE_SecretKey
implements Cloneable,
Serializable {
    private static final int MIN_KEY_BITS = 192;
    private static final int MAX_KEY_BITS = 192;
    private JA_DESKey desKey;

    public JA_DESXKey() {
        super("DESX", 192, 192);
    }

    public void setSecretKeyData(byte[] byArray, int n, int n2) throws JSAFE_InvalidKeyException {
        if (this.keyData != null) {
            JSAFE_Obfuscator.deregisterOrOverwrite(this.keyData, this.keyOI);
            this.keyOI = null;
            this.keyData = null;
        }
        if (this.desKey != null) {
            this.desKey.clearSensitiveData();
        } else {
            this.desKey = new JA_DESKey();
        }
        if (n2 != 24) {
            throw new JSAFE_InvalidKeyException("Invalid key data length. Should be 24.");
        }
        this.keyData = new byte[n2];
        System.arraycopy(byArray, n, this.keyData, 0, n2);
        this.desKey.setSecretKeyData(this.keyData, 0, 8);
        this.keyOI = JSAFE_Obfuscator.register(this.keyData);
        this.keyOI.obfuscate();
    }

    public void generateInit(int[] nArray, SecureRandom secureRandom) throws JSAFE_InvalidParameterException, JSAFE_InvalidUseException {
        int[] nArray2 = new int[]{192};
        if (nArray != null) {
            if (nArray.length > 1) {
                throw new JSAFE_InvalidParameterException("Wrong number of parameters: Expected 1 for DESX key generation. Key length in bits.");
            }
            if (nArray[0] != 120 && nArray[0] != 192) {
                throw new JSAFE_InvalidParameterException("Incorrect DESX key length. Expected 120 or 192 (bits).");
            }
        }
        super.generateInit(nArray2, secureRandom);
    }

    int getKeyBitLength(int n) {
        if (n == -1 || n == 120 || n == 192) {
            return 192;
        }
        return -1;
    }

    JA_DESKey getDESKey() {
        return this.desKey;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_DESXKey jA_DESXKey = (JA_DESXKey)super.clone();
        if (this.desKey != null) {
            jA_DESXKey.desKey = (JA_DESKey)this.desKey.clone();
        }
        return jA_DESXKey;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        if (this.desKey != null) {
            this.desKey.clearSensitiveData();
        }
        this.desKey = null;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

