/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeKeyAgree;
import com.rsa.jsafe.JA_AlternateArithmetic;
import com.rsa.jsafe.JA_DHBER;
import com.rsa.jsafe.JA_KeyData;
import com.rsa.jsafe.JCMPArithmeticClass;
import com.rsa.jsafe.JCMPInteger;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidArithmeticException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_Parameters;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

final class JA_DH
extends JSAFE_Object
implements JA_AlgaeKeyAgree,
JA_AlternateArithmetic,
Cloneable,
Serializable {
    private int outputBufferSize;
    private Class arithmeticClass;
    private SecureRandom random;
    private byte[] randomSerialize;
    private String randomAlgorithm;
    private JCMPInteger primeP;
    private JCMPInteger baseG;
    private int maxExponentLen;
    private JCMPInteger myPublicValue;
    private JCMPInteger myPrivateValue;
    private JCMPInteger correspondentPublicValue;

    JA_DH() {
    }

    JA_DH(int[] nArray) throws JSAFE_InvalidParameterException {
        this();
        this.setInstantiationParameters(nArray);
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Invalid instantiation parameters. Expected no parameters.");
        }
    }

    public String getAlgorithm() {
        return "DH";
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public int[] getInstantiationParameters() {
        return new int[0];
    }

    public boolean setAlgorithmBER(byte[] byArray, int n) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        try {
            return JA_DHBER.setAlgorithmBER(this, byArray, n);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_UnimplementedException(jSAFE_Exception.getMessage());
        }
    }

    public byte[] getDERAlgorithmID() throws JSAFE_UnimplementedException {
        return JA_DHBER.getDERAlgorithmID(this.primeP, this.baseG, this.maxExponentLen);
    }

    private void initializeArithmetic() {
        if (this.arithmeticClass == null) {
            this.arithmeticClass = JCMPArithmeticClass.getDefaultClass();
        }
    }

    public void setArithmetic(Class clazz) throws JSAFE_InvalidArithmeticException {
        try {
            JCMPInteger jCMPInteger = (JCMPInteger)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        this.arithmeticClass = clazz;
    }

    void loadSystemParameters(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5, boolean bl, byte[] byArray3, int n6, int n7) throws JSAFE_InvalidParameterException {
        this.clearParameters();
        try {
            this.initializeArithmetic();
            this.primeP = (JCMPInteger)this.arithmeticClass.newInstance();
            this.baseG = (JCMPInteger)this.arithmeticClass.newInstance();
            this.primeP.setValue(byArray, n, n2);
            this.baseG.setValue(byArray2, n3, n4);
            int n8 = this.primeP.getBitLength();
            if (n8 < 256 || n8 > 2048) {
                throw new JSAFE_InvalidParameterException("Invalid DH prime size. Should be between 256 and 2048 bits.");
            }
            if (this.baseG.compareTo(this.primeP) >= 0) {
                throw new JSAFE_InvalidParameterException("Invalid DH base size.");
            }
            this.maxExponentLen = n8 - 1;
            if (n5 != -1) {
                this.maxExponentLen = n5;
            } else if (bl) {
                this.maxExponentLen = 0;
                int n9 = 0;
                int n10 = 0;
                while (n9 < n7) {
                    this.maxExponentLen <<= n10;
                    this.maxExponentLen |= byArray3[n9 + n6] & 0xFF;
                    ++n9;
                    n10 += 8;
                }
            }
            if (this.maxExponentLen >= n8 || this.maxExponentLen < 160) {
                throw new JSAFE_InvalidParameterException("Invalid DH max exponent length. Should be no less than 160 but less than " + n8);
            }
        }
        catch (JSAFE_InputException jSAFE_InputException) {
            throw new JSAFE_InvalidParameterException("Bad arithmetic class.");
        }
        catch (InstantiationException instantiationException) {
            throw new JSAFE_InvalidParameterException("Bad arithmetic class.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSAFE_InvalidParameterException("Bad arithmetic class.");
        }
        this.setOutputBufferSize();
    }

    public void keyAgreeInitRandom(SecureRandom secureRandom) {
        if (secureRandom != null) {
            this.random = secureRandom;
        }
    }

    public void keyAgreeInitParameters(JSAFE_Parameters jSAFE_Parameters) throws JSAFE_InvalidParameterException {
        try {
            byte[][] byArray = jSAFE_Parameters.getParameterData("DHParameters");
            if (byArray == null || byArray.length != 3) {
                throw new JSAFE_InvalidParameterException("Invalid DH parameters.");
            }
            this.loadSystemParameters(byArray[0], 0, byArray[0].length, byArray[1], 0, byArray[1].length, -1, true, byArray[2], 0, byArray[2].length);
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new JSAFE_InvalidParameterException("Invalid DH parameters.");
        }
    }

    public boolean keyAgreeInitPublicKey(JSAFE_PublicKey jSAFE_PublicKey) {
        byte[][] byArray = JA_KeyData.getKeyData(jSAFE_PublicKey, "DHPublicKey");
        if (byArray == null || byArray.length != 4) {
            return false;
        }
        try {
            this.loadSystemParameters(byArray[0], 0, byArray[0].length, byArray[1], 0, byArray[1].length, -1, true, byArray[2], 0, byArray[2].length);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return false;
        }
        return true;
    }

    public boolean keyAgreeInitPrivateKey(JSAFE_PrivateKey jSAFE_PrivateKey) {
        byte[][] byArray = JA_KeyData.getKeyData(jSAFE_PrivateKey, "DHPrivateKey");
        if (byArray == null || byArray.length != 4) {
            return false;
        }
        try {
            this.loadSystemParameters(byArray[0], 0, byArray[0].length, byArray[1], 0, byArray[1].length, -1, true, byArray[2], 0, byArray[2].length);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return false;
        }
        return true;
    }

    private void setOutputBufferSize() {
        if (this.primeP == null) {
            return;
        }
        int n = this.primeP.getBitLength();
        this.outputBufferSize = (n + 7) / 8;
    }

    public byte[][] getSharedParameters() {
        if (this.primeP == null || this.baseG == null) {
            return new byte[0][];
        }
        int n = 4;
        if (this.maxExponentLen <= 0xFFFFFF) {
            --n;
            if (this.maxExponentLen <= 65535) {
                --n;
                if (this.maxExponentLen <= 255) {
                    --n;
                }
            }
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        try {
            byArray = this.primeP.toOctetString();
            byArray2 = this.baseG.toOctetString();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            byArray = null;
            byArray2 = null;
        }
        byte[] byArray3 = new byte[n];
        int n2 = n - 1;
        int n3 = 0;
        while (n2 >= 0) {
            byArray3[n2] = (byte)(this.maxExponentLen >>> n3 & 0xFF);
            --n2;
            n3 += 8;
        }
        byte[][] byArrayArray = new byte[][]{byArray, byArray2, byArray3};
        return byArrayArray;
    }

    public void setCorrespondentPublicValue(byte[] byArray, int n, int n2) {
        try {
            this.correspondentPublicValue = (JCMPInteger)this.arithmeticClass.newInstance();
            this.correspondentPublicValue.setValue(byArray, n, n2);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            this.correspondentPublicValue = null;
        }
        catch (InstantiationException instantiationException) {
            this.correspondentPublicValue = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.correspondentPublicValue = null;
        }
    }

    public void setCorrespondentPublicValue(JSAFE_PublicKey jSAFE_PublicKey) throws JSAFE_InvalidKeyException {
        byte[][] byArray = JA_KeyData.getKeyData(jSAFE_PublicKey, "DHPublicValue");
        if (byArray == null || byArray.length != 1) {
            throw new JSAFE_InvalidKeyException("Invalid DH public key.");
        }
        this.setCorrespondentPublicValue(byArray[0], 0, byArray[0].length);
    }

    public void setMyPrivateValue(byte[] byArray, int n, int n2) {
        if (this.myPrivateValue != null) {
            this.myPrivateValue.clearSensitiveData();
        }
        try {
            this.myPrivateValue = (JCMPInteger)this.arithmeticClass.newInstance();
            this.myPrivateValue.setValue(byArray, n, n2);
            this.myPrivateValue.obfuscate();
        }
        catch (InstantiationException instantiationException) {
            this.myPrivateValue = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.myPrivateValue = null;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            this.myPrivateValue = null;
        }
    }

    public void setMyPrivateValue(JSAFE_PrivateKey jSAFE_PrivateKey) throws JSAFE_InvalidKeyException {
        byte[][] byArray = JA_KeyData.getKeyData(jSAFE_PrivateKey, "DHPrivateValue");
        if (byArray == null || byArray.length != 1) {
            throw new JSAFE_InvalidKeyException("Invalid DH private key.");
        }
        this.setMyPrivateValue(byArray[0], 0, byArray[0].length);
        this.overwrite(byArray[0]);
    }

    public void generateMyPrivateValue() {
        int n = this.maxExponentLen;
        if (n < 160) {
            n = this.primeP.getBitLength() - 1;
        }
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        this.random.nextBytes(byArray);
        int n3 = n2 * 8 - n;
        int n4 = -1;
        int n5 = 0;
        while (n5 < n3) {
            n4 = (byte)((n4 & 0xFF) >>> 1);
            byArray[0] = (byte)(byArray[0] & n4);
            ++n5;
        }
        this.setMyPrivateValue(byArray, 0, byArray.length);
        this.overwrite(byArray);
    }

    public int getMyPrivateValue(byte[] byArray, int n) {
        if (this.myPrivateValue == null) {
            return 0;
        }
        byte[] byArray2 = null;
        try {
            try {
                byArray2 = this.myPrivateValue.toOctetString();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                int n2 = byArray2.length;
                Object var7_6 = null;
                if (byArray2 != null) {
                    this.overwrite(byArray2);
                }
                return n2;
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                int n3 = 0;
                Object var7_7 = null;
                if (byArray2 != null) {
                    this.overwrite(byArray2);
                }
                return n3;
            }
        }
        catch (Throwable throwable) {
            block7: {
                Object var7_8 = null;
                if (byArray2 == null) break block7;
                this.overwrite(byArray2);
            }
            throw throwable;
        }
    }

    public void generateMyPublicValue() {
        try {
            this.myPublicValue = (JCMPInteger)this.arithmeticClass.newInstance();
            this.baseG.modExp(this.myPrivateValue, this.primeP, this.myPublicValue);
        }
        catch (InstantiationException instantiationException) {
            this.myPrivateValue = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.myPrivateValue = null;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            this.myPublicValue = null;
        }
    }

    public int getMyPublicValue(byte[] byArray, int n) {
        if (this.myPublicValue == null) {
            return 0;
        }
        int n2 = this.primeP.getBitLength();
        n2 = (n2 + 7) / 8;
        try {
            byte[] byArray2 = this.myPublicValue.toFixedLenOctetString(n2);
            int n3 = 0;
            while (n3 < byArray2.length) {
                byArray[n] = byArray2[n3];
                ++n3;
                ++n;
            }
            return byArray2.length;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return 0;
        }
    }

    public int generateSharedSecret(byte[] byArray, int n) {
        JCMPInteger jCMPInteger = null;
        byte[] byArray2 = null;
        try {
            try {
                jCMPInteger = (JCMPInteger)this.arithmeticClass.newInstance();
                this.correspondentPublicValue.modExp(this.myPrivateValue, this.primeP, jCMPInteger);
                int n2 = this.primeP.getBitLength();
                n2 = (n2 + 7) / 8;
                byArray2 = jCMPInteger.toFixedLenOctetString(n2);
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                int n3 = byArray2.length;
                Object var10_10 = null;
                if (byArray2 != null) {
                    this.overwrite(byArray2);
                }
                if (jCMPInteger != null) {
                    jCMPInteger.clearSensitiveData();
                }
                return n3;
            }
            catch (InstantiationException instantiationException) {
                int n4 = 0;
                Object var10_11 = null;
                if (byArray2 != null) {
                    this.overwrite(byArray2);
                }
                if (jCMPInteger != null) {
                    jCMPInteger.clearSensitiveData();
                }
                return n4;
            }
            catch (IllegalAccessException illegalAccessException) {
                int n5 = 0;
                Object var10_12 = null;
                if (byArray2 != null) {
                    this.overwrite(byArray2);
                }
                if (jCMPInteger != null) {
                    jCMPInteger.clearSensitiveData();
                }
                return n5;
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                int n6 = 0;
                Object var10_13 = null;
                if (byArray2 != null) {
                    this.overwrite(byArray2);
                }
                if (jCMPInteger != null) {
                    jCMPInteger.clearSensitiveData();
                }
                return n6;
            }
        }
        catch (Throwable throwable) {
            block15: {
                Object var10_14 = null;
                if (byArray2 != null) {
                    this.overwrite(byArray2);
                }
                if (jCMPInteger == null) break block15;
                jCMPInteger.clearSensitiveData();
            }
            throw throwable;
        }
    }

    public void obfuscate() {
    }

    public void deobfuscate() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JSAFE_SecureRandom jSAFE_SecureRandom = this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization(jSAFE_SecureRandom);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private JSAFE_SecureRandom prepareSerialization() {
        if (this.myPrivateValue != null) {
            this.myPrivateValue.deobfuscate();
        }
        if (this.random == null) {
            return null;
        }
        if (!(this.random instanceof JSAFE_SecureRandom)) {
            return null;
        }
        JSAFE_SecureRandom jSAFE_SecureRandom = (JSAFE_SecureRandom)this.random;
        if (jSAFE_SecureRandom.getDevice().compareTo("Java") != 0) {
            return null;
        }
        this.randomAlgorithm = jSAFE_SecureRandom.getAlgorithm();
        this.randomSerialize = jSAFE_SecureRandom.serializeRandom();
        JSAFE_SecureRandom jSAFE_SecureRandom2 = (JSAFE_SecureRandom)this.random;
        this.random = null;
        return jSAFE_SecureRandom2;
    }

    private void restoreAfterSerialization(JSAFE_SecureRandom jSAFE_SecureRandom) {
        if (this.myPrivateValue != null) {
            this.myPrivateValue.obfuscate();
        }
        if (this.randomSerialize == null) {
            return;
        }
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
        this.random = jSAFE_SecureRandom;
    }

    private void restoreAfterDeserialization() {
        if (this.myPrivateValue != null) {
            this.myPrivateValue.obfuscate();
        }
        if (this.randomSerialize == null) {
            return;
        }
        this.random = JSAFE_SecureRandom.deserializeRandom(this.randomAlgorithm, this.randomSerialize);
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_DH jA_DH = new JA_DH();
        jA_DH.arithmeticClass = this.arithmeticClass;
        jA_DH.random = this.random;
        jA_DH.outputBufferSize = this.outputBufferSize;
        if (this.primeP != null) {
            jA_DH.primeP = (JCMPInteger)this.primeP.clone();
        }
        if (this.baseG != null) {
            jA_DH.baseG = (JCMPInteger)this.baseG.clone();
        }
        jA_DH.maxExponentLen = this.maxExponentLen;
        if (this.myPublicValue != null) {
            jA_DH.myPublicValue = (JCMPInteger)this.myPublicValue.clone();
        }
        if (this.myPrivateValue != null) {
            jA_DH.myPrivateValue = (JCMPInteger)this.myPrivateValue.clone();
        }
        if (this.correspondentPublicValue != null) {
            jA_DH.correspondentPublicValue = (JCMPInteger)this.correspondentPublicValue.clone();
        }
        return jA_DH;
    }

    private void clearParameters() {
        if (this.primeP != null) {
            this.primeP.clearSensitiveData();
        }
        if (this.baseG != null) {
            this.baseG.clearSensitiveData();
        }
        this.maxExponentLen = 0;
        this.baseG = null;
        this.primeP = null;
    }

    private void clearKeys() {
        if (this.myPublicValue != null) {
            this.myPublicValue.clearSensitiveData();
        }
        if (this.myPrivateValue != null) {
            this.myPrivateValue.clearSensitiveData();
        }
        if (this.correspondentPublicValue != null) {
            this.correspondentPublicValue.clearSensitiveData();
        }
        this.correspondentPublicValue = null;
        this.myPrivateValue = null;
        this.myPublicValue = null;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.clearParameters();
        this.clearKeys();
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

