/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlternateArithmetic;
import com.rsa.jsafe.JA_DH;
import com.rsa.jsafe.JA_DHParameters;
import com.rsa.jsafe.JA_DHPrivateKey;
import com.rsa.jsafe.JA_DHPublicKey;
import com.rsa.jsafe.JCMPArithmeticClass;
import com.rsa.jsafe.JCMPInteger;
import com.rsa.jsafe.JG_KeyAgree;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidArithmeticException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_KeyPair;
import com.rsa.jsafe.JSAFE_Parameters;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Session;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public final class JA_DHKeyPair
extends JSAFE_KeyPair
implements JA_AlternateArithmetic,
Cloneable,
Serializable {
    private Class arithmeticClass;
    private SecureRandom random;
    private byte[] randomSerialize;
    private String randomAlgorithm;
    private JSAFE_Parameters jsafeParameters;
    private byte[][] sharedParams;
    private int objectState = 1;
    private static final int NOT_INITIALIZED = 1;
    private static final int INITIALIZED = 2;

    JA_DHKeyPair() {
    }

    public String getAlgorithm() {
        return "DH";
    }

    private void initializeArithmetic() {
        if (this.arithmeticClass == null) {
            this.arithmeticClass = JCMPArithmeticClass.getDefaultClass();
        }
    }

    public void setArithmetic(Class clazz) throws JSAFE_InvalidArithmeticException {
        try {
            JCMPInteger jCMPInteger = (JCMPInteger)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        this.arithmeticClass = clazz;
    }

    protected boolean setKeyPair(JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) {
        if (!(jSAFE_PublicKey instanceof JA_DHPublicKey) || !(jSAFE_PrivateKey instanceof JA_DHPrivateKey)) {
            return false;
        }
        return super.setKeyPair(jSAFE_PublicKey, jSAFE_PrivateKey);
    }

    protected boolean genInit(JSAFE_Parameters jSAFE_Parameters, int[] nArray, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray) {
        this.clearKeys();
        this.clearParameters();
        if (secureRandom != null) {
            this.random = secureRandom;
        }
        if (jSAFE_Parameters == null) {
            return false;
        }
        if (!(jSAFE_Parameters instanceof JA_DHParameters)) {
            return false;
        }
        if (nArray != null && nArray.length != 0) {
            return false;
        }
        if (this.random == null) {
            return false;
        }
        try {
            this.jsafeParameters = (JSAFE_Parameters)jSAFE_Parameters.clone();
            this.sharedParams = jSAFE_Parameters.getParameterData("DHParameters");
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return false;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return false;
        }
        this.objectState = 2;
        return true;
    }

    protected void genReInit() throws JSAFE_InvalidUseException {
        this.clearKeys();
        if (this.objectState != 2) {
            throw new JSAFE_InvalidUseException("Cannot reInit, object not initialized.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateKeyPair() throws JSAFE_InvalidUseException {
        Throwable throwable2;
        JG_KeyAgree jG_KeyAgree;
        JA_DH jA_DH;
        JSAFE_PrivateKey jSAFE_PrivateKey;
        JSAFE_PublicKey jSAFE_PublicKey;
        block14: {
            int n;
            if (this.objectState != 2) {
                throw new JSAFE_InvalidUseException("Object not initialized.");
            }
            this.initializeArithmetic();
            jSAFE_PublicKey = null;
            jSAFE_PrivateKey = null;
            jA_DH = null;
            jG_KeyAgree = null;
            byte[] byArray = null;
            try {
                try {
                    jSAFE_PublicKey = JSAFE_PublicKey.getInstance("DH", this.getDevice());
                    jSAFE_PrivateKey = JSAFE_PrivateKey.getInstance("DH", this.getDevice());
                    jA_DH = new JA_DH();
                    jA_DH.setArithmetic(this.arithmeticClass);
                    jG_KeyAgree = new JG_KeyAgree(jA_DH);
                    jG_KeyAgree.keyAgreeInit(this.jsafeParameters, this.random);
                    byte[] byArray2 = jG_KeyAgree.keyAgreePhase1();
                    byArray = jG_KeyAgree.getPrivateValue();
                    byte[][] byArrayArray = new byte[][]{this.sharedParams[0], this.sharedParams[1], this.sharedParams[2], byArray};
                    jSAFE_PrivateKey.setKeyData("DHPrivateKey", byArrayArray);
                    byte[][] byArrayArray2 = new byte[][]{this.sharedParams[0], this.sharedParams[1], this.sharedParams[2], byArray2};
                    jSAFE_PublicKey.setKeyData("DHPublicKey", byArrayArray2);
                    this.setKeys(jSAFE_PublicKey, jSAFE_PrivateKey);
                }
                catch (JSAFE_Exception jSAFE_Exception) {
                    throw new JSAFE_InvalidUseException("A necessary object is missing.");
                }
                Object var10_10 = null;
                if (byArray != null) {
                    int n2 = 0;
                    while (n2 < byArray.length) {
                        byArray[n2] = 0;
                        ++n2;
                    }
                }
                if (jSAFE_PrivateKey != null) {
                    jSAFE_PrivateKey.clearSensitiveData();
                }
                if (jSAFE_PublicKey != null) {
                    jSAFE_PublicKey.clearSensitiveData();
                }
                if (jA_DH != null) {
                    jA_DH.clearSensitiveData();
                }
                if (jG_KeyAgree == null) return;
                jG_KeyAgree.clearSensitiveData();
                return;
            }
            catch (Throwable throwable2) {
                Object var10_11 = null;
                if (byArray == null) break block14;
                n = 0;
            }
            while (n < byArray.length) {
                byArray[n] = false;
                ++n;
            }
        }
        if (jSAFE_PrivateKey != null) {
            jSAFE_PrivateKey.clearSensitiveData();
        }
        if (jSAFE_PublicKey != null) {
            jSAFE_PublicKey.clearSensitiveData();
        }
        if (jA_DH != null) {
            jA_DH.clearSensitiveData();
        }
        if (jG_KeyAgree == null) throw throwable2;
        jG_KeyAgree.clearSensitiveData();
        throw throwable2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JSAFE_SecureRandom jSAFE_SecureRandom = this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization(jSAFE_SecureRandom);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private JSAFE_SecureRandom prepareSerialization() {
        if (this.random == null) {
            return null;
        }
        if (!(this.random instanceof JSAFE_SecureRandom)) {
            return null;
        }
        JSAFE_SecureRandom jSAFE_SecureRandom = (JSAFE_SecureRandom)this.random;
        if (jSAFE_SecureRandom.getDevice().compareTo("Java") != 0) {
            return null;
        }
        this.randomAlgorithm = jSAFE_SecureRandom.getAlgorithm();
        this.randomSerialize = jSAFE_SecureRandom.serializeRandom();
        JSAFE_SecureRandom jSAFE_SecureRandom2 = (JSAFE_SecureRandom)this.random;
        this.random = null;
        return jSAFE_SecureRandom2;
    }

    private void restoreAfterSerialization(JSAFE_SecureRandom jSAFE_SecureRandom) {
        if (this.randomSerialize == null) {
            return;
        }
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
        this.random = jSAFE_SecureRandom;
    }

    private void restoreAfterDeserialization() {
        if (this.randomSerialize == null) {
            return;
        }
        this.random = JSAFE_SecureRandom.deserializeRandom(this.randomAlgorithm, this.randomSerialize);
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
    }

    protected JSAFE_KeyPair createClone() throws CloneNotSupportedException {
        JA_DHKeyPair jA_DHKeyPair = new JA_DHKeyPair();
        jA_DHKeyPair.objectState = this.objectState;
        jA_DHKeyPair.random = this.random;
        jA_DHKeyPair.arithmeticClass = this.arithmeticClass;
        if (this.jsafeParameters != null) {
            jA_DHKeyPair.jsafeParameters = (JSAFE_Parameters)this.jsafeParameters.clone();
        }
        if (this.sharedParams != null) {
            byte[][] byArrayArray = new byte[this.sharedParams.length][];
            int n = 0;
            while (n < this.sharedParams.length) {
                if (this.sharedParams[n] != null) {
                    byArrayArray[n] = (byte[])this.sharedParams[n].clone();
                }
                ++n;
            }
            jA_DHKeyPair.sharedParams = byArrayArray;
        }
        jA_DHKeyPair.setJSAFELevelValues(this);
        return jA_DHKeyPair;
    }

    protected void clearKeys() {
        super.clearKeys();
    }

    protected void clearParameters() {
        if (this.jsafeParameters != null) {
            this.jsafeParameters.clearSensitiveData();
        }
        this.jsafeParameters = null;
        this.sharedParams = null;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
    }

    public void doClearSensitiveData() {
        this.clearKeys();
        this.clearParameters();
        this.objectState = 1;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

