/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlternateArithmetic;
import com.rsa.jsafe.JA_DHParametersBER;
import com.rsa.jsafe.JA_PQGGen;
import com.rsa.jsafe.JCMPArithmeticClass;
import com.rsa.jsafe.JCMPInteger;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidArithmeticException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Parameters;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public final class JA_DHParameters
extends JSAFE_Parameters
implements JA_AlternateArithmetic,
Cloneable,
Serializable {
    private int primeLen;
    private int maxExponentLen;
    private byte[] primeP;
    private byte[] baseG;
    private SecureRandom random;
    private byte[] randomSerialize;
    private String randomAlgorithm;
    private Class arithmeticClass;
    private int objectState = 1;
    private static final int NOT_INITIALIZED = 1;
    private static final int INITIALIZED = 2;

    JA_DHParameters() {
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String[] getSupportedSetFormats() {
        String[] stringArray = new String[]{"DHParameters", "DHParametersBER"};
        return stringArray;
    }

    public String[] getSupportedGetFormats() {
        if (this.primeP == null || this.baseG == null) {
            return new String[0];
        }
        String[] stringArray = new String[]{"DHParameters", "DHParametersBER"};
        return stringArray;
    }

    void setAlgorithmBER(byte[] byArray, int n) throws JSAFE_UnimplementedException {
        JA_DHParametersBER.setAlgorithmBER(this, byArray, n);
    }

    public byte[] getDERAlgorithmID(String string) throws JSAFE_UnimplementedException {
        if (this.primeP == null || this.baseG == null) {
            throw new JSAFE_UnimplementedException("Cannot build the DER of the parameters, object not set.");
        }
        return JA_DHParametersBER.getDERAlgorithmID(this.primeP, this.baseG, this.maxExponentLen);
    }

    private void initializeArithmetic() {
        if (this.arithmeticClass == null) {
            this.arithmeticClass = JCMPArithmeticClass.getDefaultClass();
        }
    }

    public void setArithmetic(Class clazz) throws JSAFE_InvalidArithmeticException {
        try {
            JCMPInteger jCMPInteger = (JCMPInteger)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        this.arithmeticClass = clazz;
    }

    public void setParameterData(String string, byte[][] byArray) throws JSAFE_InputException, JSAFE_UnimplementedException {
        this.clearSensitiveData();
        if (string.compareTo("DHParametersBER") == 0) {
            if (byArray.length != 1) {
                throw new JSAFE_InputException("Invalid BER DH parameter data.");
            }
            this.setAlgorithmBER(byArray[0], 0);
            return;
        }
        if (string.compareTo("DHParameters") == 0) {
            this.setParameterData(byArray);
            return;
        }
        throw new JSAFE_UnimplementedException("Unimplemented DH parameter format.");
    }

    public void setParameterData(byte[][] byArray) throws JSAFE_InputException {
        if (byArray == null || byArray.length != 3) {
            throw new JSAFE_InputException("Invalid DH parameters.");
        }
        this.loadSystemParameters(byArray[0], 0, byArray[0].length, byArray[1], 0, byArray[1].length, -1, true, byArray[2], 0, byArray[2].length);
    }

    /*
     * Unable to fully structure code
     */
    void loadSystemParameters(byte[] var1_1, int var2_2, int var3_3, byte[] var4_4, int var5_5, int var6_6, int var7_7, boolean var8_8, byte[] var9_9, int var10_10, int var11_11) throws JSAFE_InputException {
        this.clearSensitiveData();
        while (var1_1[var2_2] == 0) {
            --var3_3;
            ++var2_2;
        }
        this.primeP = new byte[var3_3];
        System.arraycopy(var1_1, var2_2, this.primeP, 0, var3_3);
        this.primeLen = this.primeP.length * 8;
        var12_12 = this.primeP[0] & 255;
        var13_13 = var12_12 & 128;
        while (var13_13 == 0) {
            --this.primeLen;
            var13_13 = (var12_12 <<= 1) & 128;
        }
        if (this.primeLen >= 256 && this.primeLen <= 2048) ** GOTO lbl19
        throw new JSAFE_InputException("Invalid DH prime size. Should be between 256 and 2048 bits.");
lbl-1000:
        // 1 sources

        {
            --var6_6;
            ++var5_5;
lbl19:
            // 2 sources

            ** while (var4_4[var5_5] == 0)
        }
lbl20:
        // 1 sources

        this.baseG = new byte[var6_6];
        System.arraycopy(var4_4, var5_5, this.baseG, 0, var6_6);
        if (this.baseG.length > this.primeP.length) {
            throw new JSAFE_InputException("Invalid DH base size.");
        }
        if (this.baseG.length == this.primeP.length) {
            var14_14 = 0;
            while (var14_14 < this.baseG.length) {
                if ((this.baseG[var14_14] & 255) < (this.primeP[var14_14] & 255)) break;
                if ((this.baseG[var14_14] & 255) > (this.primeP[var14_14] & 255)) {
                    throw new JSAFE_InputException("Invalid DH base size.");
                }
                ++var14_14;
            }
            if (var14_14 >= this.baseG.length) {
                throw new JSAFE_InputException("Invalid DH base size.");
            }
        }
        this.maxExponentLen = this.primeLen - 1;
        if (var7_7 != -1) {
            this.maxExponentLen = var7_7;
        } else if (var8_8) {
            this.maxExponentLen = 0;
            var14_14 = 0;
            while (var14_14 < var11_11) {
                this.maxExponentLen <<= 8;
                this.maxExponentLen |= var9_9[var14_14 + var10_10] & 255;
                ++var14_14;
            }
        }
        if (this.maxExponentLen >= this.primeLen || this.maxExponentLen < 160) {
            throw new JSAFE_InputException("Invalid DH max exponent length.");
        }
    }

    public byte[][] getParameterData(String string) throws JSAFE_UnimplementedException {
        if (this.primeP == null || this.baseG == null) {
            return new byte[0][];
        }
        if (string.compareTo("DHParametersBER") == 0) {
            byte[] byArray = this.getDERAlgorithmID();
            byte[][] byArrayArray = new byte[][]{byArray};
            return byArrayArray;
        }
        if (string.compareTo("DHParameters") == 0) {
            return this.getParameterData();
        }
        throw new JSAFE_UnimplementedException("Unimplemented DH parameter format.");
    }

    public byte[][] getParameterData() {
        if (this.primeP == null || this.baseG == null) {
            return new byte[0][];
        }
        int n = 4;
        if (this.maxExponentLen <= 0xFFFFFF) {
            --n;
            if (this.maxExponentLen <= 65535) {
                --n;
                if (this.maxExponentLen <= 255) {
                    --n;
                }
            }
        }
        byte[] byArray = new byte[this.primeP.length];
        System.arraycopy(this.primeP, 0, byArray, 0, this.primeP.length);
        byte[] byArray2 = new byte[this.baseG.length];
        System.arraycopy(this.baseG, 0, byArray2, 0, this.baseG.length);
        byte[] byArray3 = new byte[n];
        int n2 = n - 1;
        int n3 = 0;
        while (n2 >= 0) {
            byArray3[n2] = (byte)(this.maxExponentLen >>> n3 & 0xFF);
            --n2;
            n3 += 8;
        }
        byte[][] byArrayArray = new byte[][]{byArray, byArray2, byArray3};
        return byArrayArray;
    }

    public void generateInit(int[] nArray, SecureRandom secureRandom) throws JSAFE_InvalidParameterException {
        this.generateInit(nArray, secureRandom, null);
    }

    public void generateInit(int[] nArray, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray) throws JSAFE_InvalidParameterException {
        this.clearSensitiveData();
        if (secureRandom != null) {
            this.random = secureRandom;
        }
        if (nArray == null || nArray.length != 2) {
            throw new JSAFE_InvalidParameterException("Incorrect number of DH param gen parameters: expected 2 (primeSize, exponentSize) (in bits).");
        }
        if (this.random == null) {
            throw new JSAFE_InvalidParameterException("DH parameter generation needs a random number generating object.");
        }
        int n = nArray[0];
        int n2 = nArray[1];
        if (n < 256 || n > 2048) {
            throw new JSAFE_InvalidParameterException("Invalid DH prime size. Should be between 256 and 2048 bits.");
        }
        if (n2 < 160 || n2 >= n) {
            throw new JSAFE_InvalidParameterException("Invalid DH exponent size.Should be between 160 and " + n + " (the Prime size) bits.");
        }
        this.primeLen = n;
        this.maxExponentLen = n2;
        this.objectState = 2;
    }

    public void generateReInit() throws JSAFE_InvalidUseException {
        if (this.objectState != 2) {
            throw new JSAFE_InvalidUseException("Cannot reinitialize, object not initialized.");
        }
        this.primeP = null;
        this.baseG = null;
    }

    public void generate() throws JSAFE_InvalidUseException {
        if (this.objectState != 2) {
            throw new JSAFE_InvalidUseException("Object not initialized.");
        }
        this.initializeArithmetic();
        int n = (this.primeLen + 7) / 8;
        int n2 = (this.maxExponentLen + 7) / 8;
        this.primeP = new byte[n];
        byte[] byArray = new byte[n2];
        this.baseG = new byte[n];
        JA_PQGGen.generatePQG(this.primeP, this.primeLen, byArray, this.maxExponentLen, this.baseG, this.random, this.arithmeticClass);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JSAFE_SecureRandom jSAFE_SecureRandom = this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization(jSAFE_SecureRandom);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private JSAFE_SecureRandom prepareSerialization() {
        if (this.random == null) {
            return null;
        }
        if (!(this.random instanceof JSAFE_SecureRandom)) {
            return null;
        }
        JSAFE_SecureRandom jSAFE_SecureRandom = (JSAFE_SecureRandom)this.random;
        if (jSAFE_SecureRandom.getDevice().compareTo("Java") != 0) {
            return null;
        }
        this.randomAlgorithm = jSAFE_SecureRandom.getAlgorithm();
        this.randomSerialize = jSAFE_SecureRandom.serializeRandom();
        JSAFE_SecureRandom jSAFE_SecureRandom2 = (JSAFE_SecureRandom)this.random;
        this.random = null;
        return jSAFE_SecureRandom2;
    }

    private void restoreAfterSerialization(JSAFE_SecureRandom jSAFE_SecureRandom) {
        if (this.randomSerialize == null) {
            return;
        }
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
        this.random = jSAFE_SecureRandom;
    }

    private void restoreAfterDeserialization() {
        if (this.randomSerialize == null) {
            return;
        }
        this.random = JSAFE_SecureRandom.deserializeRandom(this.randomAlgorithm, this.randomSerialize);
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_DHParameters jA_DHParameters = new JA_DHParameters();
        if (this.primeP != null) {
            jA_DHParameters.primeP = (byte[])this.primeP.clone();
        }
        if (this.baseG != null) {
            jA_DHParameters.baseG = (byte[])this.baseG.clone();
        }
        jA_DHParameters.maxExponentLen = this.maxExponentLen;
        jA_DHParameters.arithmeticClass = this.arithmeticClass;
        jA_DHParameters.objectState = this.objectState;
        jA_DHParameters.primeLen = this.primeLen;
        jA_DHParameters.maxExponentLen = this.maxExponentLen;
        jA_DHParameters.random = this.random;
        jA_DHParameters.setJSAFELevelValues(this);
        return jA_DHParameters;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.maxExponentLen = 0;
        this.primeLen = 0;
        this.baseG = null;
        this.primeP = null;
        this.objectState = 1;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

