/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_DHPrivateKeyBER;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class JA_DHPrivateKey
extends JSAFE_PrivateKey
implements JSAFE_Key,
Cloneable,
Serializable {
    private byte[] primeP;
    private byte[] baseG;
    private int maxExponentLen;
    private transient ObfuscatorItem privateOI;
    private byte[] privateValue;

    public String getAlgorithm() {
        return "DH";
    }

    public String[] getSupportedSetFormats() {
        String[] stringArray = new String[]{"DHPrivateKey", "DHPrivateValue", "DHPrivateKeyBER"};
        return stringArray;
    }

    public String[] getSupportedGetFormats() {
        if (this.privateValue == null) {
            return new String[0];
        }
        if (this.primeP == null || this.baseG == null) {
            String[] stringArray = new String[]{"DHPrivateValue", "DHPrivateKeyBER"};
            return stringArray;
        }
        String[] stringArray = new String[]{"DHPrivateKey", "DHPrivateValue", "DHPrivateKeyBER"};
        return stringArray;
    }

    public void setKeyData(String string, byte[][] byArray) throws JSAFE_UnimplementedException, JSAFE_InvalidKeyException {
        if (string.compareTo("DHPrivateKey") == 0) {
            this.setKeyData(byArray);
            return;
        }
        if (string.compareTo("DHPrivateKeyBER") == 0) {
            if (byArray == null || byArray.length != 1) {
                this.clearKeys();
                throw new JSAFE_InvalidKeyException("Invalid BER DH private key data.");
            }
            this.setKeyDataBER(byArray[0], 0);
            return;
        }
        if (string.compareTo("DHPrivateValue") == 0) {
            this.setKeyDataPrivateValue(byArray);
            return;
        }
        this.clearKeys();
        throw new JSAFE_UnimplementedException("Unknown DH key data format.");
    }

    public void setKeyData(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.clearKeys();
        this.clearParameters();
        if (byArray == null || byArray.length != 4) {
            throw new JSAFE_InvalidKeyException("Invalid input for DH key. Expected prime, base, maxExponentLen, publicValue");
        }
        try {
            this.loadSystemParameters(byArray[0], 0, byArray[0].length, byArray[1], 0, byArray[1].length, -1, true, byArray[2], 0, byArray[2].length);
            this.loadPrivateValue(byArray[3], 0, byArray[3].length);
        }
        catch (NullPointerException nullPointerException) {
            throw new JSAFE_InvalidKeyException("Invalid input for DH key.");
        }
    }

    public void setKeyDataPrivateValue(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.clearKeys();
        if (byArray == null || byArray.length != 1) {
            throw new JSAFE_InvalidKeyException("Invalid input for DH key.");
        }
        if (byArray[0] == null) {
            throw new JSAFE_InvalidKeyException("Invalid input for DH key.");
        }
        this.loadPrivateValue(byArray[0], 0, byArray[0].length);
    }

    void setKeyDataBER(byte[] byArray, int n) throws JSAFE_InvalidKeyException {
        this.clearKeys();
        this.clearParameters();
        JA_DHPrivateKeyBER.setKeyDataBER(this, byArray, n);
    }

    /*
     * Unable to fully structure code
     */
    void loadSystemParameters(byte[] var1_1, int var2_2, int var3_3, byte[] var4_4, int var5_5, int var6_6, int var7_7, boolean var8_8, byte[] var9_9, int var10_10, int var11_11) throws JSAFE_InvalidKeyException {
        this.clearParameters();
        while (var1_1[var2_2] == 0) {
            --var3_3;
            ++var2_2;
        }
        this.primeP = new byte[var3_3];
        System.arraycopy(var1_1, var2_2, this.primeP, 0, var3_3);
        var12_12 = this.primeP.length * 8;
        var13_13 = this.primeP[0] & 255;
        var14_14 = var13_13 & 128;
        while (var14_14 == 0) {
            --var12_12;
            var14_14 = (var13_13 <<= 1) & 128;
        }
        if (var12_12 >= 256 && var12_12 <= 2048) ** GOTO lbl19
        throw new JSAFE_InvalidKeyException("Invalid DH prime size.");
lbl-1000:
        // 1 sources

        {
            --var6_6;
            ++var5_5;
lbl19:
            // 2 sources

            ** while (var4_4[var5_5] == 0)
        }
lbl20:
        // 1 sources

        this.baseG = new byte[var6_6];
        System.arraycopy(var4_4, var5_5, this.baseG, 0, var6_6);
        if (this.baseG.length > this.primeP.length) {
            throw new JSAFE_InvalidKeyException("Invalid DH base size.");
        }
        if (this.baseG.length == this.primeP.length) {
            var15_15 = 0;
            while (var15_15 < this.baseG.length) {
                if ((this.baseG[var15_15] & 255) < (this.primeP[var15_15] & 255)) break;
                if ((this.baseG[var15_15] & 255) > (this.primeP[var15_15] & 255)) {
                    throw new JSAFE_InvalidKeyException("Invalid DH base size.");
                }
                ++var15_15;
            }
            if (var15_15 >= this.baseG.length) {
                throw new JSAFE_InvalidKeyException("Invalid DH base size.");
            }
        }
        this.maxExponentLen = var12_12 - 1;
        if (var7_7 != -1) {
            this.maxExponentLen = var7_7;
        } else if (var8_8) {
            this.maxExponentLen = 0;
            var15_15 = 0;
            while (var15_15 < var11_11) {
                this.maxExponentLen <<= 8;
                this.maxExponentLen |= var9_9[var15_15 + var10_10] & 255;
                ++var15_15;
            }
        }
        if (this.maxExponentLen >= var12_12 || this.maxExponentLen < 160) {
            throw new JSAFE_InvalidKeyException("Invalid DH max exponent length.");
        }
    }

    void loadPrivateValue(byte[] byArray, int n, int n2) throws JSAFE_InvalidKeyException {
        this.clearKeys();
        while (byArray[n] == 0) {
            --n2;
            ++n;
        }
        this.privateValue = new byte[n2];
        System.arraycopy(byArray, n, this.privateValue, 0, n2);
        if (this.maxExponentLen == 0) {
            this.privateOI = JSAFE_Obfuscator.register(this.privateValue);
            this.privateOI.obfuscate();
            return;
        }
        int n3 = this.privateValue.length * 8;
        int n4 = this.privateValue[0] & 0xFF;
        int n5 = n4 & 0x80;
        while (n5 == 0) {
            --n3;
            n5 = (n4 <<= 1) & 0x80;
        }
        if (n3 > this.maxExponentLen) {
            throw new JSAFE_InvalidKeyException("Invalid DH private exponent size.");
        }
        this.privateOI = JSAFE_Obfuscator.register(this.privateValue);
        this.privateOI.obfuscate();
    }

    public int getMaximumKeyLength() {
        return 2048;
    }

    public int getMinimumKeyLength() {
        return 256;
    }

    public byte[][] getKeyData(String string) throws JSAFE_UnimplementedException {
        if (string.compareTo("DHPrivateKeyBER") == 0) {
            return this.getKeyDataBER();
        }
        if (string.compareTo("DHPrivateValue") == 0) {
            return this.getKeyDataPrivateValue();
        }
        if (string.compareTo("DHPrivateKey") != 0) {
            throw new JSAFE_UnimplementedException("Unknown DH key data format.");
        }
        return this.getKeyData();
    }

    public byte[][] getKeyData() {
        if (this.primeP == null || this.baseG == null || this.privateValue == null) {
            return new byte[0][];
        }
        int n = 4;
        if (this.maxExponentLen <= 0xFFFFFF) {
            --n;
            if (this.maxExponentLen <= 65535) {
                --n;
                if (this.maxExponentLen <= 255) {
                    --n;
                }
            }
        }
        byte[] byArray = new byte[n];
        int n2 = n - 1;
        int n3 = 0;
        while (n2 >= 0) {
            byArray[n2] = (byte)(this.maxExponentLen >>> n3 & 0xFF);
            --n2;
            n3 += 8;
        }
        byte[] byArray2 = new byte[this.primeP.length];
        System.arraycopy(this.primeP, 0, byArray2, 0, this.primeP.length);
        byte[] byArray3 = new byte[this.baseG.length];
        System.arraycopy(this.baseG, 0, byArray3, 0, this.baseG.length);
        byte[] byArray4 = new byte[this.privateValue.length];
        this.privateOI.deobfuscate();
        System.arraycopy(this.privateValue, 0, byArray4, 0, this.privateValue.length);
        this.privateOI.obfuscate();
        byte[][] byArrayArray = new byte[][]{byArray2, byArray3, byArray, byArray4};
        return byArrayArray;
    }

    private byte[][] getKeyDataPrivateValue() {
        if (this.privateValue == null) {
            return new byte[0][];
        }
        byte[] byArray = new byte[this.privateValue.length];
        this.privateOI.deobfuscate();
        System.arraycopy(this.privateValue, 0, byArray, 0, this.privateValue.length);
        this.privateOI.obfuscate();
        byte[][] byArrayArray = new byte[][]{byArray};
        return byArrayArray;
    }

    private byte[][] getKeyDataBER() {
        if (this.primeP == null || this.baseG == null || this.privateValue == null) {
            return new byte[0][];
        }
        this.privateOI.deobfuscate();
        try {
            try {
                byte[][] byArrayArray;
                byte[] byArray = JA_DHPrivateKeyBER.getKeyDataBER(this.primeP, this.baseG, this.privateValue, this.maxExponentLen);
                byte[][] byArrayArray2 = byArrayArray = new byte[][]{byArray};
                Object var5_6 = null;
                this.privateOI.obfuscate();
                return byArrayArray2;
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                byte[][] byArrayArray = new byte[][]{};
                Object var5_7 = null;
                this.privateOI.obfuscate();
                return byArrayArray;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.privateOI.obfuscate();
            throw throwable;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private void prepareSerialization() {
        if (this.privateOI != null) {
            this.privateOI.deobfuscate();
        }
    }

    private void restoreAfterSerialization() {
        if (this.privateOI != null) {
            this.privateOI.obfuscate();
        }
    }

    private void restoreAfterDeserialization() {
        if (this.privateValue != null) {
            this.privateOI = JSAFE_Obfuscator.register(this.privateValue);
            this.privateOI.obfuscate();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof JA_DHPrivateKey)) {
            return false;
        }
        return this.dataEquals(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean dataEquals(Object object) {
        byte[][] byArray;
        block30: {
            int n;
            block31: {
                boolean bl;
                block29: {
                    block28: {
                        boolean bl2;
                        block27: {
                            boolean bl3;
                            block26: {
                                boolean bl4;
                                block25: {
                                    byArray = null;
                                    try {
                                        try {
                                            JSAFE_PrivateKey jSAFE_PrivateKey = (JSAFE_PrivateKey)object;
                                            if (this.privateValue == null) {
                                                if (jSAFE_PrivateKey.getAlgorithm().compareTo("DH") != 0) {
                                                    bl4 = false;
                                                    Object var9_9 = null;
                                                    if (byArray == null) return bl4;
                                                    break block25;
                                                }
                                                String[] stringArray = jSAFE_PrivateKey.getSupportedGetFormats();
                                                if (stringArray.length == 0) {
                                                    bl3 = true;
                                                    break block26;
                                                }
                                                bl2 = false;
                                                break block27;
                                            }
                                            if (this.primeP == null || this.baseG == null) {
                                                String[] stringArray = jSAFE_PrivateKey.getSupportedGetFormats();
                                                n = 0;
                                                while (n < stringArray.length && stringArray[n].compareTo("DHPrivateValue") == 0) {
                                                    n += 1;
                                                }
                                                if (n != stringArray.length) {
                                                    boolean bl5 = false;
                                                    Object var9_12 = null;
                                                    if (byArray == null) return bl5;
                                                    if (byArray.length == 1) {
                                                        this.overwrite(byArray[0]);
                                                        return bl5;
                                                    }
                                                    this.overwrite(byArray[2]);
                                                    return bl5;
                                                }
                                                byArray = jSAFE_PrivateKey.getKeyData("DHPrivateValue");
                                            } else {
                                                byArray = jSAFE_PrivateKey.getKeyData("DHPrivateKey");
                                            }
                                            int n2 = 0;
                                            if (byArray.length > 1) {
                                                if (!this.compareKeyArrays(this.primeP, null, byArray[0], null)) {
                                                    n = 0;
                                                    break block28;
                                                }
                                                if (!this.compareKeyArrays(this.baseG, null, byArray[1], null)) {
                                                    bl = false;
                                                    break block29;
                                                }
                                                n2 = 2;
                                            }
                                            if (this.compareKeyArrays(this.privateValue, this.privateOI, byArray[n2], null)) break block30;
                                            n = 0;
                                            break block31;
                                        }
                                        catch (Exception exception) {
                                            boolean bl6 = false;
                                            Object var9_17 = null;
                                            if (byArray == null) return bl6;
                                            if (byArray.length == 1) {
                                                this.overwrite(byArray[0]);
                                                return bl6;
                                            }
                                            this.overwrite(byArray[2]);
                                            return bl6;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var9_18 = null;
                                        if (byArray == null) throw throwable;
                                        if (byArray.length == 1) {
                                            this.overwrite((byte[])byArray[0]);
                                            throw throwable;
                                        }
                                        this.overwrite((byte[])byArray[2]);
                                        throw throwable;
                                    }
                                }
                                if (byArray.length == 1) {
                                    this.overwrite(byArray[0]);
                                    return bl4;
                                }
                                this.overwrite(byArray[2]);
                                return bl4;
                            }
                            Object var9_10 = null;
                            if (byArray == null) return bl3;
                            if (byArray.length == 1) {
                                this.overwrite(byArray[0]);
                                return bl3;
                            }
                            this.overwrite(byArray[2]);
                            return bl3;
                        }
                        Object var9_11 = null;
                        if (byArray == null) return bl2;
                        if (byArray.length == 1) {
                            this.overwrite(byArray[0]);
                            return bl2;
                        }
                        this.overwrite(byArray[2]);
                        return bl2;
                    }
                    Object var9_13 = null;
                    if (byArray == null) return n;
                    if (byArray.length == 1) {
                        this.overwrite(byArray[0]);
                        return n;
                    }
                    this.overwrite(byArray[2]);
                    return n;
                }
                Object var9_14 = null;
                if (byArray == null) return bl;
                if (byArray.length == 1) {
                    this.overwrite(byArray[0]);
                    return bl;
                }
                this.overwrite(byArray[2]);
                return bl;
            }
            Object var9_15 = null;
            if (byArray == null) return n;
            if (byArray.length == 1) {
                this.overwrite(byArray[0]);
                return n;
            }
            this.overwrite(byArray[2]);
            return n;
        }
        Object var9_16 = null;
        if (byArray == null) return true;
        if (byArray.length == 1) {
            this.overwrite(byArray[0]);
            return true;
        }
        this.overwrite(byArray[2]);
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_DHPrivateKey jA_DHPrivateKey = new JA_DHPrivateKey();
        if (this.primeP != null) {
            jA_DHPrivateKey.primeP = (byte[])this.primeP.clone();
        }
        if (this.baseG != null) {
            jA_DHPrivateKey.baseG = (byte[])this.baseG.clone();
        }
        jA_DHPrivateKey.maxExponentLen = this.maxExponentLen;
        if (this.privateValue != null) {
            jA_DHPrivateKey.privateValue = (byte[])JSAFE_Obfuscator.copy(this.privateValue, this.privateOI);
            jA_DHPrivateKey.privateOI = JSAFE_Obfuscator.getObfuscatorItem(jA_DHPrivateKey.privateValue);
        }
        jA_DHPrivateKey.setJSAFELevelValues(this);
        return jA_DHPrivateKey;
    }

    private void clearKeys() {
        if (this.privateValue == null) {
            return;
        }
        JSAFE_Obfuscator.deregister(this.privateValue, this.privateOI);
        this.privateValue = null;
        this.privateOI = null;
    }

    private void clearParameters() {
        this.maxExponentLen = 0;
        this.baseG = null;
        this.primeP = null;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.clearKeys();
        this.clearParameters();
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

