/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.jsafe.JA_DHPrivateKey;
import com.rsa.jsafe.JA_PrivateKeyBER;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;

final class JA_DHPrivateKeyBER
extends JSAFE_Object {
    JA_DHPrivateKeyBER() {
    }

    static void setKeyDataBER(JA_DHPrivateKey jA_DHPrivateKey, byte[] byArray, int n) throws JSAFE_InvalidKeyException {
        OIDContainer oIDContainer = new OIDContainer(0, 3);
        EncodedContainer encodedContainer = new EncodedContainer(77824);
        OctetStringContainer octetStringContainer = new OctetStringContainer(0);
        JA_PrivateKeyBER.berDecodePrivateKeyInfo(byArray, n, oIDContainer, encodedContainer, octetStringContainer);
        if (oIDContainer.transformation.compareTo("DH") != 0) {
            throw new JSAFE_InvalidKeyException("Invalid DH private key BER encoding.");
        }
        IntegerContainer integerContainer = new IntegerContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{integerContainer};
        try {
            ASN1.berDecode(octetStringContainer.data, octetStringContainer.dataOffset, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_InvalidKeyException("Could not decode DH key from BER. (" + aSN_Exception.getMessage() + ")");
        }
        if (encodedContainer.dataPresent) {
            OfContainer ofContainer = null;
            try {
                ofContainer = new OfContainer(0, 12288, new IntegerContainer(0));
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{ofContainer};
                ASN1.berDecode(encodedContainer.data, encodedContainer.dataOffset, aSN1ContainerArray2);
            }
            catch (ASN_Exception aSN_Exception) {
                throw new JSAFE_InvalidKeyException("Could not decode DH key from BER. (" + aSN_Exception.getMessage() + ")");
            }
            int n2 = ofContainer.getContainerCount();
            if (n2 != 3 && n2 != 2) {
                throw new JSAFE_InvalidKeyException("Could not read the DH parameters BER.");
            }
            IntegerContainer[] integerContainerArray = new IntegerContainer[n2];
            int n3 = -1;
            try {
                int n4 = 0;
                while (n4 < n2) {
                    integerContainerArray[n4] = (IntegerContainer)ofContainer.containerAt(n4);
                    ++n4;
                }
                if (n2 == 3) {
                    n3 = integerContainerArray[2].getValueAsInt();
                }
            }
            catch (ASN_Exception aSN_Exception) {
                throw new JSAFE_InvalidKeyException("Could not read the DSA parameters BER. (" + aSN_Exception.getMessage() + ")");
            }
            jA_DHPrivateKey.loadSystemParameters(integerContainerArray[0].data, integerContainerArray[0].dataOffset, integerContainerArray[0].dataLen, integerContainerArray[1].data, integerContainerArray[1].dataOffset, integerContainerArray[1].dataLen, n3, false, null, 0, 0);
        }
        jA_DHPrivateKey.loadPrivateValue(integerContainer.data, integerContainer.dataOffset, integerContainer.dataLen);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static byte[] getKeyDataBER(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws JSAFE_InvalidKeyException {
        Object object;
        Object object2;
        byte[] byArray4 = null;
        if (byArray != null && byArray2 != null) {
            try {
                ASN1Container[] aSN1ContainerArray;
                object2 = new OfContainer(65536, true, 0, 12288, new IntegerContainer(0));
                object = new IntegerContainer(0, true, 0, byArray, 0, byArray.length, true);
                IntegerContainer integerContainer = new IntegerContainer(0, true, 0, byArray2, 0, byArray2.length, true);
                ((OfContainer)object2).addContainer((ASN1Container)object);
                ((OfContainer)object2).addContainer(integerContainer);
                if (n > 0) {
                    aSN1ContainerArray = new IntegerContainer(0, true, 0, n);
                    ((OfContainer)object2).addContainer((ASN1Container)aSN1ContainerArray);
                }
                aSN1ContainerArray = new ASN1Container[]{object2};
                byArray4 = ASN1.derEncode(aSN1ContainerArray);
            }
            catch (ASN_Exception aSN_Exception) {
                throw new JSAFE_InvalidKeyException("Could not compute the DH parameters BER. (" + aSN_Exception.getMessage() + ")");
            }
        }
        object2 = null;
        try {
            object = new IntegerContainer(0, true, 0, byArray3, 0, byArray3.length, true);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{object};
            object2 = ASN1.derEncode(aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            if (object2 == null) throw new JSAFE_InvalidKeyException("Could not compute DH private key BER. (" + aSN_Exception.getMessage() + ")");
            JSAFE_Obfuscator.overwrite(object2);
            throw new JSAFE_InvalidKeyException("Could not compute DH private key BER. (" + aSN_Exception.getMessage() + ")");
        }
        try {
            object = JA_PrivateKeyBER.derEncodePrivateKeyInfo("DH", byArray4, (byte[])object2);
            Object var10_12 = null;
            if (object2 == null) return object;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (object2 == null) throw throwable;
            JSAFE_Obfuscator.overwrite(object2);
            throw throwable;
        }
        JSAFE_Obfuscator.overwrite(object2);
        return object;
    }
}

