/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_DHPublicKeyBER;
import com.rsa.jsafe.JA_DSAPublicKey;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;

public class JA_DHPublicKey
extends JSAFE_PublicKey
implements JSAFE_Key,
Cloneable,
Serializable {
    private byte[] primeP;
    private byte[] baseG;
    private int maxExponentLen;
    private byte[] publicValue;

    public String getAlgorithm() {
        return "DH";
    }

    public String[] getSupportedSetFormats() {
        String[] stringArray = new String[]{"DHPublicKey", "DHPublicValue", "DHPublicKeyBER"};
        return stringArray;
    }

    public String[] getSupportedGetFormats() {
        if (this.publicValue == null) {
            return new String[0];
        }
        if (this.primeP == null) {
            String[] stringArray = new String[]{"DHPublicValue", "DHPublicKeyBER"};
            return stringArray;
        }
        String[] stringArray = new String[]{"DHPublicKey", "DHPublicValue", "DHPublicKeyBER"};
        return stringArray;
    }

    public void setKeyData(String string, byte[][] byArray) throws JSAFE_UnimplementedException, JSAFE_InvalidKeyException {
        if (string.compareTo("DHPublicKey") == 0) {
            this.setKeyData(byArray);
            return;
        }
        if (string.compareTo("DHPublicKeyBER") == 0) {
            if (byArray == null || byArray.length != 1) {
                this.clearKeys();
                throw new JSAFE_UnimplementedException("Invalid BER DH public key data.");
            }
            this.setKeyDataBER(byArray[0], 0);
            return;
        }
        if (string.compareTo("DHPublicValue") == 0) {
            this.setKeyDataPublicValue(byArray);
            return;
        }
        this.clearKeys();
        throw new JSAFE_UnimplementedException("Unknown DH key data format.");
    }

    public void setKeyData(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.clearKeys();
        if (byArray == null || byArray.length != 4) {
            throw new JSAFE_InvalidKeyException("Invalid input for DH key. Expected prime, base, maxExponentLen, publicValue");
        }
        try {
            this.loadSystemParameters(byArray[0], 0, byArray[0].length, byArray[1], 0, byArray[1].length, -1, true, byArray[2], 0, byArray[2].length);
            this.loadPublicValue(byArray[3], 0, byArray[3].length);
        }
        catch (NullPointerException nullPointerException) {
            throw new JSAFE_InvalidKeyException("Invalid input for DH key.");
        }
    }

    private void setKeyDataPublicValue(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.clearKeys();
        if (byArray == null || byArray.length != 1) {
            throw new JSAFE_InvalidKeyException("Invalid input for DH key.");
        }
        this.loadPublicValue(byArray[0], 0, byArray[0].length);
    }

    void setKeyDataBER(byte[] byArray, int n) throws JSAFE_InvalidKeyException {
        this.clearKeys();
        JA_DHPublicKeyBER.setKeyDataBER(this, byArray, n);
    }

    /*
     * Unable to fully structure code
     */
    void loadSystemParameters(byte[] var1_1, int var2_2, int var3_3, byte[] var4_4, int var5_5, int var6_6, int var7_7, boolean var8_8, byte[] var9_9, int var10_10, int var11_11) throws JSAFE_InvalidKeyException {
        this.clearParameters();
        while (var1_1[var2_2] == 0) {
            --var3_3;
            ++var2_2;
        }
        this.primeP = new byte[var3_3];
        System.arraycopy(var1_1, var2_2, this.primeP, 0, var3_3);
        var12_12 = this.primeP.length * 8;
        var13_13 = this.primeP[0] & 255;
        var14_14 = var13_13 & 128;
        while (var14_14 == 0) {
            --var12_12;
            var14_14 = (var13_13 <<= 1) & 128;
        }
        if (var12_12 >= 256 && var12_12 <= 2048) ** GOTO lbl19
        throw new JSAFE_InvalidKeyException("Invalid DH prime size.");
lbl-1000:
        // 1 sources

        {
            --var6_6;
            ++var5_5;
lbl19:
            // 2 sources

            ** while (var4_4[var5_5] == 0)
        }
lbl20:
        // 1 sources

        this.baseG = new byte[var6_6];
        System.arraycopy(var4_4, var5_5, this.baseG, 0, var6_6);
        if (this.baseG.length > this.primeP.length) {
            throw new JSAFE_InvalidKeyException("Invalid DH base size.");
        }
        if (this.baseG.length == this.primeP.length) {
            var15_15 = 0;
            while (var15_15 < this.baseG.length) {
                if ((this.baseG[var15_15] & 255) < (this.primeP[var15_15] & 255)) break;
                if ((this.baseG[var15_15] & 255) > (this.primeP[var15_15] & 255)) {
                    throw new JSAFE_InvalidKeyException("Invalid DH base size.");
                }
                ++var15_15;
            }
            if (var15_15 >= this.baseG.length) {
                throw new JSAFE_InvalidKeyException("Invalid DH base size.");
            }
        }
        this.maxExponentLen = var12_12 - 1;
        if (var7_7 != -1) {
            this.maxExponentLen = var7_7;
        } else if (var8_8) {
            this.maxExponentLen = 0;
            var15_15 = 0;
            while (var15_15 < var11_11) {
                this.maxExponentLen <<= 8;
                this.maxExponentLen |= var9_9[var15_15 + var10_10] & 255;
                ++var15_15;
            }
        }
        if (this.maxExponentLen >= var12_12 || this.maxExponentLen < 160) {
            throw new JSAFE_InvalidKeyException("Invalid DH max exponent length.");
        }
    }

    void loadPublicValue(byte[] byArray, int n, int n2) throws JSAFE_InvalidKeyException {
        this.clearKeys();
        while (byArray[n] == 0) {
            --n2;
            ++n;
        }
        this.publicValue = new byte[n2];
        System.arraycopy(byArray, n, this.publicValue, 0, n2);
    }

    public int getMaximumKeyLength() {
        return 2048;
    }

    public int getMinimumKeyLength() {
        return 256;
    }

    public byte[][] getKeyData(String string) throws JSAFE_UnimplementedException {
        if (string.compareTo("DHPublicKeyBER") == 0) {
            return this.getKeyDataBER();
        }
        if (string.compareTo("DHPublicValue") == 0) {
            return this.getKeyDataPublicValue();
        }
        if (string.compareTo("DHPublicKey") != 0) {
            throw new JSAFE_UnimplementedException("Unknown DH key data format.");
        }
        return this.getKeyData();
    }

    public byte[][] getKeyData() {
        if (this.primeP == null || this.baseG == null) {
            return new byte[0][];
        }
        int n = 4;
        if (this.maxExponentLen <= 0xFFFFFF) {
            --n;
            if (this.maxExponentLen <= 65535) {
                --n;
                if (this.maxExponentLen <= 255) {
                    --n;
                }
            }
        }
        byte[] byArray = new byte[n];
        int n2 = n - 1;
        int n3 = 0;
        while (n2 >= 0) {
            byArray[n2] = (byte)(this.maxExponentLen >>> n3 & 0xFF);
            --n2;
            n3 += 8;
        }
        byte[] byArray2 = new byte[this.primeP.length];
        System.arraycopy(this.primeP, 0, byArray2, 0, this.primeP.length);
        byte[] byArray3 = new byte[this.baseG.length];
        System.arraycopy(this.baseG, 0, byArray3, 0, this.baseG.length);
        byte[] byArray4 = new byte[this.publicValue.length];
        System.arraycopy(this.publicValue, 0, byArray4, 0, this.publicValue.length);
        byte[][] byArrayArray = new byte[][]{byArray2, byArray3, byArray, byArray4};
        return byArrayArray;
    }

    private byte[][] getKeyDataPublicValue() {
        if (this.publicValue == null) {
            return new byte[0][];
        }
        byte[] byArray = new byte[this.publicValue.length];
        System.arraycopy(this.publicValue, 0, byArray, 0, this.publicValue.length);
        byte[][] byArrayArray = new byte[][]{byArray};
        return byArrayArray;
    }

    private byte[][] getKeyDataBER() {
        if (this.primeP == null || this.baseG == null || this.publicValue == null) {
            return new byte[0][];
        }
        try {
            byte[] byArray = JA_DHPublicKeyBER.getKeyDataBER(this.primeP, this.baseG, this.publicValue, this.maxExponentLen);
            byte[][] byArrayArray = new byte[][]{byArray};
            return byArrayArray;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return new byte[0][];
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof JA_DSAPublicKey)) {
            return false;
        }
        return this.dataEquals(object);
    }

    public boolean dataEquals(Object object) {
        try {
            byte[][] byArray;
            JSAFE_PublicKey jSAFE_PublicKey = (JSAFE_PublicKey)object;
            if (this.publicValue == null) {
                if (jSAFE_PublicKey.getAlgorithm().compareTo("DH") != 0) {
                    return false;
                }
                String[] stringArray = jSAFE_PublicKey.getSupportedGetFormats();
                return stringArray.length == 0;
            }
            if (this.primeP == null || this.baseG == null) {
                String[] stringArray = jSAFE_PublicKey.getSupportedGetFormats();
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].compareTo("DHPublicValue") != 0) break;
                    ++n;
                }
                if (n != stringArray.length) {
                    return false;
                }
                byArray = jSAFE_PublicKey.getKeyData("DHPublicValue");
            } else {
                byArray = jSAFE_PublicKey.getKeyData("DHPublicKey");
            }
            int n = 0;
            if (byArray.length > 1) {
                if (!this.compareKeyArrays(this.primeP, null, byArray[0], null)) {
                    return false;
                }
                if (!this.compareKeyArrays(this.baseG, null, byArray[2], null)) {
                    return false;
                }
                n = 3;
            }
            if (!this.compareKeyArrays(this.publicValue, null, byArray[n], null)) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_DHPublicKey jA_DHPublicKey = new JA_DHPublicKey();
        if (this.primeP != null) {
            jA_DHPublicKey.primeP = (byte[])this.primeP.clone();
        }
        if (this.baseG != null) {
            jA_DHPublicKey.baseG = (byte[])this.baseG.clone();
        }
        jA_DHPublicKey.maxExponentLen = this.maxExponentLen;
        if (this.publicValue != null) {
            jA_DHPublicKey.publicValue = (byte[])this.publicValue.clone();
        }
        jA_DHPublicKey.setJSAFELevelValues(this);
        return jA_DHPublicKey;
    }

    private void clearKeys() {
        this.publicValue = null;
    }

    private void clearParameters() {
        this.baseG = null;
        this.primeP = null;
        this.maxExponentLen = 0;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.clearKeys();
        this.clearParameters();
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

