/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.jsafe.JA_DHPublicKey;
import com.rsa.jsafe.JA_PublicKeyBER;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_Object;

final class JA_DHPublicKeyBER
extends JSAFE_Object {
    JA_DHPublicKeyBER() {
    }

    static void setKeyDataBER(JA_DHPublicKey jA_DHPublicKey, byte[] byArray, int n) throws JSAFE_InvalidKeyException {
        OIDContainer oIDContainer = new OIDContainer(0, 3);
        EncodedContainer encodedContainer = new EncodedContainer(77824);
        BitStringContainer bitStringContainer = new BitStringContainer(0);
        JA_PublicKeyBER.berDecodePublicKeyInfo(byArray, n, oIDContainer, encodedContainer, bitStringContainer);
        if (oIDContainer.transformation.compareTo("DH") != 0) {
            throw new JSAFE_InvalidKeyException("Invalid DH public key BER encoding.");
        }
        IntegerContainer integerContainer = new IntegerContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{integerContainer};
        try {
            ASN1.berDecode(bitStringContainer.data, bitStringContainer.dataOffset, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_InvalidKeyException("Could not decode DH key from BER: " + aSN_Exception.getMessage());
        }
        if (encodedContainer.dataPresent) {
            OfContainer ofContainer = null;
            try {
                ofContainer = new OfContainer(0, 12288, new IntegerContainer(0));
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{ofContainer};
                ASN1.berDecode(encodedContainer.data, encodedContainer.dataOffset, aSN1ContainerArray2);
            }
            catch (ASN_Exception aSN_Exception) {
                throw new JSAFE_InvalidKeyException("Could not decode DH key from BER: (" + aSN_Exception.getMessage() + ")");
            }
            int n2 = ofContainer.getContainerCount();
            if (n2 != 3 && n2 != 2) {
                throw new JSAFE_InvalidKeyException("Could not read the DH parameters BER.");
            }
            IntegerContainer[] integerContainerArray = new IntegerContainer[n2];
            int n3 = -1;
            try {
                int n4 = 0;
                while (n4 < n2) {
                    integerContainerArray[n4] = (IntegerContainer)ofContainer.containerAt(n4);
                    ++n4;
                }
                if (n2 == 3) {
                    n3 = integerContainerArray[2].getValueAsInt();
                }
            }
            catch (ASN_Exception aSN_Exception) {
                throw new JSAFE_InvalidKeyException("Could not read the DSA parameters BER: (" + aSN_Exception.getMessage() + ")");
            }
            jA_DHPublicKey.loadSystemParameters(integerContainerArray[0].data, integerContainerArray[0].dataOffset, integerContainerArray[0].dataLen, integerContainerArray[1].data, integerContainerArray[1].dataOffset, integerContainerArray[1].dataLen, n3, false, null, 0, 0);
        }
        jA_DHPublicKey.loadPublicValue(integerContainer.data, integerContainer.dataOffset, integerContainer.dataLen);
    }

    static byte[] getKeyDataBER(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws JSAFE_InvalidKeyException {
        Object object;
        IntegerContainer integerContainer;
        Object object2;
        byte[] byArray4 = null;
        if (byArray != null && byArray2 != null) {
            try {
                ASN1Container[] aSN1ContainerArray;
                object2 = new OfContainer(65536, true, 0, 12288, new IntegerContainer(0));
                integerContainer = new IntegerContainer(0, true, 0, byArray, 0, byArray.length, true);
                object = new IntegerContainer(0, true, 0, byArray2, 0, byArray2.length, true);
                ((OfContainer)object2).addContainer(integerContainer);
                ((OfContainer)object2).addContainer((ASN1Container)object);
                if (n > 0) {
                    aSN1ContainerArray = new IntegerContainer(0, true, 0, n);
                    ((OfContainer)object2).addContainer((ASN1Container)aSN1ContainerArray);
                }
                aSN1ContainerArray = new ASN1Container[]{object2};
                byArray4 = ASN1.derEncode(aSN1ContainerArray);
            }
            catch (ASN_Exception aSN_Exception) {
                throw new JSAFE_InvalidKeyException("Could not compute the DH parameters BER: " + aSN_Exception.getMessage());
            }
        }
        object2 = null;
        try {
            integerContainer = new IntegerContainer(0, true, 0, byArray3, 0, byArray3.length, true);
            object = new ASN1Container[]{integerContainer};
            object2 = ASN1.derEncode(object);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_InvalidKeyException("Could not compute DH public key BER: " + aSN_Exception.getMessage());
        }
        return JA_PublicKeyBER.derEncodePublicKeyInfo("DH", byArray4, (byte[])object2);
    }
}

