/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_AlgaeSignature;
import com.rsa.jsafe.JA_AlternateArithmetic;
import com.rsa.jsafe.JA_DSABER;
import com.rsa.jsafe.JA_FIPS186DSASigGenPRNG;
import com.rsa.jsafe.JA_SignaturePaddingScheme;
import com.rsa.jsafe.JCMPArithmeticClass;
import com.rsa.jsafe.JCMPInt;
import com.rsa.jsafe.JCMPInteger;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidArithmeticException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_Parameters;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public class JA_DSA
extends JSAFE_Object
implements JA_AlgaeSignature,
JA_AlternateArithmetic,
Cloneable,
Serializable {
    protected Class arithmeticClass;
    protected JA_FIPS186DSASigGenPRNG fipsRand;
    private byte[] randomSerialize;
    private String randomAlgorithm;
    protected int blockSize = -1;
    protected int maxInputLen = 0;
    protected static final int DSA_BLOCK_SIZE = 20;
    protected int signatureSize = 0;
    protected static final int SIGNATURE_WITHOUT_DIGEST_SIZE = 40;
    protected static final int SIGNATURE_WITH_DIGEST_SIZE = 48;
    protected JCMPInteger primeP;
    protected JCMPInteger subPrimeQ;
    protected JCMPInteger baseG;
    protected JCMPInteger publicValueY;
    protected JCMPInteger privateValueX;

    protected JA_DSA() {
    }

    protected JA_DSA(int[] nArray) throws JSAFE_InvalidParameterException {
        this();
        this.setInstantiationParameters(nArray);
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Incorrect number of instantiation parameters: expected none.");
        }
    }

    public int[] getInstantiationParameters() {
        return new int[0];
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public String getDefaultSignaturePaddingName() {
        return "NoPad";
    }

    public int getInputBlockSize() {
        return this.blockSize;
    }

    public int getMaxInputLen() {
        return this.maxInputLen;
    }

    public boolean doesSignUpdate() {
        return false;
    }

    public int getSignatureBlockSize() {
        return this.signatureSize;
    }

    public boolean isValidDigestAlgorithm(JA_AlgaeDigest jA_AlgaeDigest) {
        String string = jA_AlgaeDigest.getAlgorithm();
        if (string.compareTo("SHA1") == 0) {
            return true;
        }
        return string.compareTo("NoDigest") == 0;
    }

    public boolean isValidPaddingScheme(JA_SignaturePaddingScheme jA_SignaturePaddingScheme) {
        String string = jA_SignaturePaddingScheme.getPaddingScheme();
        return string.compareTo("NoPad") == 0;
    }

    protected void initializeArithmetic() {
        if (this.arithmeticClass == null) {
            this.arithmeticClass = JCMPArithmeticClass.getDefaultClass();
        }
    }

    public void setArithmetic(Class clazz) throws JSAFE_InvalidArithmeticException {
        try {
            JCMPInteger jCMPInteger = (JCMPInteger)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        this.arithmeticClass = clazz;
    }

    public void setAlgorithmBER(byte[] byArray, int n) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        JA_DSABER.setAlgorithmBER(this, byArray, n);
    }

    public byte[] getDERAlgorithmID(JA_AlgaeDigest jA_AlgaeDigest, JA_SignaturePaddingScheme jA_SignaturePaddingScheme, String string, boolean bl) throws JSAFE_UnimplementedException {
        return JA_DSABER.getDERAlgorithmID(jA_AlgaeDigest, jA_SignaturePaddingScheme, string, bl, this.primeP, this.subPrimeQ, this.baseG);
    }

    void loadSystemParameters(int n, byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5, byte[] byArray3, int n6, int n7) throws JSAFE_InvalidParameterException {
        this.clearParameters();
        this.initializeArithmetic();
        try {
            this.primeP = (JCMPInteger)this.arithmeticClass.newInstance();
            this.subPrimeQ = (JCMPInteger)this.arithmeticClass.newInstance();
            this.baseG = (JCMPInteger)this.arithmeticClass.newInstance();
            this.primeP.setValue(byArray, n2, n3);
            this.subPrimeQ.setValue(byArray2, n4, n5);
            this.baseG.setValue(byArray3, n6, n7);
            int n8 = this.primeP.getBitLength();
            if (n != -1 && n8 > n) {
                throw new JSAFE_InvalidParameterException("DSA prime size mismatch.");
            }
            if (n8 < 256 || n8 > 2048) {
                throw new JSAFE_InvalidParameterException("Invalid DSA prime size.");
            }
            int n9 = this.subPrimeQ.getBitLength();
            if (n9 < 160 || n9 > 160) {
                throw new JSAFE_InvalidParameterException("Invalid DSA subprime size.");
            }
            if (this.baseG.compareTo(this.primeP) >= 0) {
                throw new JSAFE_InvalidParameterException("Invalid DSA base size.");
            }
        }
        catch (JSAFE_InputException jSAFE_InputException) {
            throw new JSAFE_InvalidParameterException("Bad arithmetic class.");
        }
        catch (InstantiationException instantiationException) {
            throw new JSAFE_InvalidParameterException("Bad arithmetic class.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSAFE_InvalidParameterException("Bad arithmetic class.");
        }
    }

    public boolean needRandom() {
        return this.fipsRand == null;
    }

    public String setSignatureParameters(JSAFE_Parameters jSAFE_Parameters) {
        if (jSAFE_Parameters == null) {
            return null;
        }
        this.initializeArithmetic();
        try {
            byte[][] byArray = jSAFE_Parameters.getParameterData("DSAParameters");
            this.primeP = (JCMPInteger)this.arithmeticClass.newInstance();
            this.subPrimeQ = (JCMPInteger)this.arithmeticClass.newInstance();
            this.baseG = (JCMPInteger)this.arithmeticClass.newInstance();
            this.primeP.setValue(byArray[0], 0, byArray[0].length);
            this.subPrimeQ.setValue(byArray[1], 0, byArray[1].length);
            this.baseG.setValue(byArray[2], 0, byArray[2].length);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return "Invalid DSA system parameters.";
        }
        catch (InstantiationException instantiationException) {
            return "Bad arithmetic class.";
        }
        catch (IllegalAccessException illegalAccessException) {
            return "Bad arithmetic class.";
        }
        return null;
    }

    private String initFipsRandom(SecureRandom secureRandom) {
        byte[] byArray = new byte[20];
        secureRandom.nextBytes(byArray);
        try {
            this.fipsRand = new JA_FIPS186DSASigGenPRNG(byArray);
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            return "Invalid random object.";
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String signInit(JSAFE_PrivateKey jSAFE_PrivateKey, JA_AlgaeDigest jA_AlgaeDigest, JA_SignaturePaddingScheme jA_SignaturePaddingScheme, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray) {
        Object object;
        this.clearKeys();
        if (secureRandom != null && (object = this.initFipsRandom(secureRandom)) != null) {
            return object;
        }
        object = jSAFE_PrivateKey.getSupportedGetFormats();
        int n = 0;
        while (n < ((String[])object).length && object[n].compareTo("DSAPrivateKey") != 0) {
            ++n;
        }
        if (n < ((String[])object).length) {
            return this.signInitWithParameters(jSAFE_PrivateKey, jA_AlgaeDigest, jA_SignaturePaddingScheme);
        }
        if (this.primeP == null) return "Cannot initialize for DSA without the system parameters.";
        if (this.subPrimeQ == null) return "Cannot initialize for DSA without the system parameters.";
        if (this.baseG == null) {
            return "Cannot initialize for DSA without the system parameters.";
        }
        byte[][] byArray = null;
        try {
            try {
                byArray = jSAFE_PrivateKey.getKeyData("DSAPrivateValue");
                this.privateValueX = (JCMPInteger)this.arithmeticClass.newInstance();
                this.privateValueX.setValue(byArray[0], 0, byArray[0].length);
                this.privateValueX.obfuscate();
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                String string = "Could not initialize for DSA with the given key.";
                Object var14_10 = null;
                if (byArray == null) return string;
                if (byArray.length < 1) return string;
                this.overwrite(byArray[0]);
                return string;
            }
            catch (InstantiationException instantiationException) {
                String string = "Bad arithmetic class.";
                Object var14_11 = null;
                if (byArray == null) return string;
                if (byArray.length < 1) return string;
                this.overwrite(byArray[0]);
                return string;
            }
            catch (IllegalAccessException illegalAccessException) {
                String string = "Bad arithmetic class.";
                Object var14_12 = null;
                if (byArray == null) return string;
                if (byArray.length < 1) return string;
                this.overwrite(byArray[0]);
                return string;
            }
            Object var14_9 = null;
            if (byArray == null) return this.initSizes(jA_AlgaeDigest, jA_SignaturePaddingScheme);
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            if (byArray == null) throw throwable;
            if (byArray.length < 1) throw throwable;
            this.overwrite(byArray[0]);
            throw throwable;
        }
        if (byArray.length < 1) return this.initSizes(jA_AlgaeDigest, jA_SignaturePaddingScheme);
        this.overwrite(byArray[0]);
        return this.initSizes(jA_AlgaeDigest, jA_SignaturePaddingScheme);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String signInitWithParameters(JSAFE_PrivateKey jSAFE_PrivateKey, JA_AlgaeDigest jA_AlgaeDigest, JA_SignaturePaddingScheme jA_SignaturePaddingScheme) {
        int n;
        Throwable throwable2;
        byte[][] byArray;
        block13: {
            this.clearParameters();
            this.initializeArithmetic();
            byArray = null;
            try {
                block12: {
                    int n2;
                    String string;
                    int n3;
                    String string2;
                    int n4;
                    String string3;
                    try {
                        byArray = jSAFE_PrivateKey.getKeyData("DSAPrivateKey");
                        this.primeP = (JCMPInteger)this.arithmeticClass.newInstance();
                        this.subPrimeQ = (JCMPInteger)this.arithmeticClass.newInstance();
                        this.baseG = (JCMPInteger)this.arithmeticClass.newInstance();
                        this.privateValueX = (JCMPInteger)this.arithmeticClass.newInstance();
                        this.primeP.setValue(byArray[0], 0, byArray[0].length);
                        this.subPrimeQ.setValue(byArray[1], 0, byArray[1].length);
                        this.baseG.setValue(byArray[2], 0, byArray[2].length);
                        this.privateValueX.setValue(byArray[3], 0, byArray[3].length);
                        this.privateValueX.obfuscate();
                        break block12;
                    }
                    catch (JSAFE_Exception jSAFE_Exception) {
                        string3 = "Could not initialize for DSA with the given key.";
                        Object var10_6 = null;
                        if (byArray == null) return string3;
                        if (byArray.length < 4) return string3;
                        n4 = 0;
                    }
                    while (n4 < byArray[3].length) {
                        byArray[3][n4] = 0;
                        ++n4;
                    }
                    return string3;
                    catch (InstantiationException instantiationException) {
                        string2 = "Bad arithmetic class.";
                        Object var10_7 = null;
                        if (byArray == null) return string2;
                        if (byArray.length < 4) return string2;
                        n3 = 0;
                    }
                    while (n3 < byArray[3].length) {
                        byArray[3][n3] = 0;
                        ++n3;
                    }
                    return string2;
                    catch (IllegalAccessException illegalAccessException) {
                        string = "Bad arithmetic class.";
                        Object var10_8 = null;
                        if (byArray == null) return string;
                        if (byArray.length < 4) return string;
                        n2 = 0;
                    }
                    while (n2 < byArray[3].length) {
                        byArray[3][n2] = 0;
                        ++n2;
                    }
                    return string;
                }
                Object var10_5 = null;
                if (byArray == null) return this.initSizes(jA_AlgaeDigest, jA_SignaturePaddingScheme);
            }
            catch (Throwable throwable2) {
                Object var10_9 = null;
                if (byArray == null) throw throwable2;
                if (byArray.length < 4) throw throwable2;
                n = 0;
                break block13;
            }
            if (byArray.length < 4) return this.initSizes(jA_AlgaeDigest, jA_SignaturePaddingScheme);
            int n5 = 0;
            while (n5 < byArray[3].length) {
                byArray[3][n5] = 0;
                ++n5;
            }
            return this.initSizes(jA_AlgaeDigest, jA_SignaturePaddingScheme);
        }
        while (true) {
            if (n >= byArray[3].length) {
                throw throwable2;
            }
            byArray[3][n] = 0;
            ++n;
        }
    }

    public void signReInit() throws JSAFE_InvalidUseException {
    }

    public String verifyInit(JSAFE_PublicKey jSAFE_PublicKey, JA_AlgaeDigest jA_AlgaeDigest, JA_SignaturePaddingScheme jA_SignaturePaddingScheme, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray) {
        Object object;
        this.clearKeys();
        if (secureRandom != null && (object = this.initFipsRandom(secureRandom)) != null) {
            return object;
        }
        object = jSAFE_PublicKey.getSupportedGetFormats();
        int n = 0;
        while (n < ((String[])object).length) {
            if (object[n].compareTo("DSAPublicKey") == 0) break;
            ++n;
        }
        if (n < ((String[])object).length) {
            return this.verifyInitWithParameters(jSAFE_PublicKey, jA_AlgaeDigest, jA_SignaturePaddingScheme);
        }
        if (this.primeP == null || this.subPrimeQ == null || this.baseG == null) {
            return "Cannot initialize for DSA without the system parameters.";
        }
        try {
            byte[][] byArray = jSAFE_PublicKey.getKeyData("DSAPublicValue");
            this.publicValueY = (JCMPInteger)this.arithmeticClass.newInstance();
            this.publicValueY.setValue(byArray[0], 0, byArray[0].length);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return "Could not initialize for DSA with the given key.";
        }
        catch (InstantiationException instantiationException) {
            return "Bad arithmetic class.";
        }
        catch (IllegalAccessException illegalAccessException) {
            return "Bad arithmetic class.";
        }
        return this.initSizes(jA_AlgaeDigest, jA_SignaturePaddingScheme);
    }

    private String verifyInitWithParameters(JSAFE_PublicKey jSAFE_PublicKey, JA_AlgaeDigest jA_AlgaeDigest, JA_SignaturePaddingScheme jA_SignaturePaddingScheme) {
        this.clearParameters();
        this.initializeArithmetic();
        byte[][] byArray = null;
        try {
            byArray = jSAFE_PublicKey.getKeyData("DSAPublicKey");
            this.primeP = (JCMPInteger)this.arithmeticClass.newInstance();
            this.subPrimeQ = (JCMPInteger)this.arithmeticClass.newInstance();
            this.baseG = (JCMPInteger)this.arithmeticClass.newInstance();
            this.publicValueY = (JCMPInteger)this.arithmeticClass.newInstance();
            this.primeP.setValue(byArray[0], 0, byArray[0].length);
            this.subPrimeQ.setValue(byArray[1], 0, byArray[1].length);
            this.baseG.setValue(byArray[2], 0, byArray[2].length);
            this.publicValueY.setValue(byArray[3], 0, byArray[3].length);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return "Could not initialize for DSA with the given key.";
        }
        catch (InstantiationException instantiationException) {
            return "Bad arithmetic class.";
        }
        catch (IllegalAccessException illegalAccessException) {
            return "Bad arithmetic class.";
        }
        return this.initSizes(jA_AlgaeDigest, jA_SignaturePaddingScheme);
    }

    public void verifyReInit() throws JSAFE_InvalidUseException {
    }

    protected String initSizes(JA_AlgaeDigest jA_AlgaeDigest, JA_SignaturePaddingScheme jA_SignaturePaddingScheme) {
        String string = jA_AlgaeDigest.getAlgorithm();
        this.blockSize = 20;
        if (string.compareTo("NoDigest") != 0) {
            this.maxInputLen = -1;
            this.signatureSize = 48;
            return null;
        }
        this.maxInputLen = 20;
        this.signatureSize = 40;
        return null;
    }

    public void signUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException, JSAFE_InputException {
        throw new JSAFE_InvalidUseException("Improper call to signUpdate.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sign(byte[] byArray, int n, int n2, JA_AlgaeDigest jA_AlgaeDigest, JA_SignaturePaddingScheme jA_SignaturePaddingScheme, byte[] byArray2, int n3) {
        int n4;
        byte[] byArray3 = new byte[20];
        JCMPInteger jCMPInteger = null;
        JCMPInteger jCMPInteger2 = null;
        JCMPInteger jCMPInteger3 = null;
        JCMPInteger jCMPInteger4 = null;
        JCMPInteger jCMPInteger5 = null;
        JCMPInteger jCMPInteger6 = null;
        JCMPInteger jCMPInteger7 = null;
        try {
            try {
                this.initializeArithmetic();
                jCMPInteger = (JCMPInteger)this.arithmeticClass.newInstance();
                jCMPInteger2 = (JCMPInteger)this.arithmeticClass.newInstance();
                jCMPInteger3 = (JCMPInteger)this.arithmeticClass.newInstance();
                jCMPInteger4 = (JCMPInteger)this.arithmeticClass.newInstance();
                jCMPInteger5 = (JCMPInteger)this.arithmeticClass.newInstance();
                jCMPInteger6 = (JCMPInteger)this.arithmeticClass.newInstance();
                jCMPInteger7 = (JCMPInteger)this.arithmeticClass.newInstance();
                while (true) {
                    this.fipsRand.generateRandomBytes(byArray3, 0, byArray3.length);
                    jCMPInteger.setValue(byArray3, 0, byArray3.length);
                    jCMPInteger.modReduce(this.subPrimeQ, jCMPInteger2);
                    if (!jCMPInteger2.modInvert(this.subPrimeQ, jCMPInteger3)) continue;
                    this.baseG.modExp(jCMPInteger2, this.primeP, jCMPInteger);
                    jCMPInteger.modReduce(this.subPrimeQ, jCMPInteger4);
                    this.privateValueX.modMultiply(jCMPInteger4, this.subPrimeQ, jCMPInteger5);
                    jCMPInteger6.setValue(byArray, n, n2);
                    jCMPInteger6.add(jCMPInteger5, jCMPInteger);
                    jCMPInteger3.modMultiply(jCMPInteger, this.subPrimeQ, jCMPInteger7);
                    if (jCMPInteger7.getBitLength() > 1) break;
                }
                byte[] byArray4 = jCMPInteger4.toFixedLenOctetString(20);
                byte[] byArray5 = jCMPInteger7.toFixedLenOctetString(20);
                if (jA_AlgaeDigest.getAlgorithm().compareTo("NoDigest") == 0) {
                    int n5;
                    int n6 = 0;
                    while (true) {
                        if (n6 >= 20) {
                            n5 = 40;
                            Object var26_29 = null;
                            if (jCMPInteger2 != null) {
                                jCMPInteger2.clearSensitiveData();
                            }
                            if (jCMPInteger3 != null) {
                                jCMPInteger3.clearSensitiveData();
                            }
                            if (jCMPInteger4 != null) {
                                jCMPInteger4.clearSensitiveData();
                            }
                            if (jCMPInteger5 != null) {
                                jCMPInteger5.clearSensitiveData();
                            }
                            if (jCMPInteger6 != null) {
                                jCMPInteger6.clearSensitiveData();
                            }
                            if (jCMPInteger7 != null) {
                                jCMPInteger7.clearSensitiveData();
                            }
                            if (jCMPInteger == null) break;
                            jCMPInteger.clearSensitiveData();
                            break;
                        }
                        byArray2[n3] = byArray4[n6];
                        byArray2[n3 + 20] = byArray5[n6];
                        ++n6;
                        ++n3;
                    }
                    JSAFE_Obfuscator.overwrite(byArray3);
                    return n5;
                }
                SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
                EndContainer endContainer = new EndContainer();
                IntegerContainer integerContainer = new IntegerContainer(0, true, 0, byArray4, 0, byArray4.length, true);
                IntegerContainer integerContainer2 = new IntegerContainer(0, true, 0, byArray5, 0, byArray5.length, true);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, integerContainer2, endContainer};
                ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
                aSN1Template.derEncodeInit();
                n4 = aSN1Template.derEncode(byArray2, n3);
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                int n7 = 0;
                Object var26_31 = null;
                if (jCMPInteger2 != null) {
                    jCMPInteger2.clearSensitiveData();
                }
                if (jCMPInteger3 != null) {
                    jCMPInteger3.clearSensitiveData();
                }
                if (jCMPInteger4 != null) {
                    jCMPInteger4.clearSensitiveData();
                }
                if (jCMPInteger5 != null) {
                    jCMPInteger5.clearSensitiveData();
                }
                if (jCMPInteger6 != null) {
                    jCMPInteger6.clearSensitiveData();
                }
                if (jCMPInteger7 != null) {
                    jCMPInteger7.clearSensitiveData();
                }
                if (jCMPInteger != null) {
                    jCMPInteger.clearSensitiveData();
                }
                JSAFE_Obfuscator.overwrite(byArray3);
                return n7;
            }
            catch (ASN_Exception aSN_Exception) {
                int n8 = 0;
                Object var26_32 = null;
                if (jCMPInteger2 != null) {
                    jCMPInteger2.clearSensitiveData();
                }
                if (jCMPInteger3 != null) {
                    jCMPInteger3.clearSensitiveData();
                }
                if (jCMPInteger4 != null) {
                    jCMPInteger4.clearSensitiveData();
                }
                if (jCMPInteger5 != null) {
                    jCMPInteger5.clearSensitiveData();
                }
                if (jCMPInteger6 != null) {
                    jCMPInteger6.clearSensitiveData();
                }
                if (jCMPInteger7 != null) {
                    jCMPInteger7.clearSensitiveData();
                }
                if (jCMPInteger != null) {
                    jCMPInteger.clearSensitiveData();
                }
                JSAFE_Obfuscator.overwrite(byArray3);
                return n8;
            }
            catch (InstantiationException instantiationException) {
                int n9 = 0;
                Object var26_33 = null;
                if (jCMPInteger2 != null) {
                    jCMPInteger2.clearSensitiveData();
                }
                if (jCMPInteger3 != null) {
                    jCMPInteger3.clearSensitiveData();
                }
                if (jCMPInteger4 != null) {
                    jCMPInteger4.clearSensitiveData();
                }
                if (jCMPInteger5 != null) {
                    jCMPInteger5.clearSensitiveData();
                }
                if (jCMPInteger6 != null) {
                    jCMPInteger6.clearSensitiveData();
                }
                if (jCMPInteger7 != null) {
                    jCMPInteger7.clearSensitiveData();
                }
                if (jCMPInteger != null) {
                    jCMPInteger.clearSensitiveData();
                }
                JSAFE_Obfuscator.overwrite(byArray3);
                return n9;
            }
            catch (IllegalAccessException illegalAccessException) {
                int n10 = 0;
                Object var26_34 = null;
                if (jCMPInteger2 != null) {
                    jCMPInteger2.clearSensitiveData();
                }
                if (jCMPInteger3 != null) {
                    jCMPInteger3.clearSensitiveData();
                }
                if (jCMPInteger4 != null) {
                    jCMPInteger4.clearSensitiveData();
                }
                if (jCMPInteger5 != null) {
                    jCMPInteger5.clearSensitiveData();
                }
                if (jCMPInteger6 != null) {
                    jCMPInteger6.clearSensitiveData();
                }
                if (jCMPInteger7 != null) {
                    jCMPInteger7.clearSensitiveData();
                }
                if (jCMPInteger != null) {
                    jCMPInteger.clearSensitiveData();
                }
                JSAFE_Obfuscator.overwrite(byArray3);
                return n10;
            }
        }
        catch (Throwable throwable) {
            Object var26_35 = null;
            if (jCMPInteger2 != null) {
                jCMPInteger2.clearSensitiveData();
            }
            if (jCMPInteger3 != null) {
                jCMPInteger3.clearSensitiveData();
            }
            if (jCMPInteger4 != null) {
                jCMPInteger4.clearSensitiveData();
            }
            if (jCMPInteger5 != null) {
                jCMPInteger5.clearSensitiveData();
            }
            if (jCMPInteger6 != null) {
                jCMPInteger6.clearSensitiveData();
            }
            if (jCMPInteger7 != null) {
                jCMPInteger7.clearSensitiveData();
            }
            if (jCMPInteger != null) {
                jCMPInteger.clearSensitiveData();
            }
            JSAFE_Obfuscator.overwrite(byArray3);
            throw throwable;
        }
        Object var26_30 = null;
        if (jCMPInteger2 != null) {
            jCMPInteger2.clearSensitiveData();
        }
        if (jCMPInteger3 != null) {
            jCMPInteger3.clearSensitiveData();
        }
        if (jCMPInteger4 != null) {
            jCMPInteger4.clearSensitiveData();
        }
        if (jCMPInteger5 != null) {
            jCMPInteger5.clearSensitiveData();
        }
        if (jCMPInteger6 != null) {
            jCMPInteger6.clearSensitiveData();
        }
        if (jCMPInteger7 != null) {
            jCMPInteger7.clearSensitiveData();
        }
        if (jCMPInteger != null) {
            jCMPInteger.clearSensitiveData();
        }
        JSAFE_Obfuscator.overwrite(byArray3);
        return n4;
    }

    public void verifyUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException, JSAFE_InputException {
        throw new JSAFE_InvalidUseException("Improper call to verifyUpdate.");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verify(byte[] var1_1, int var2_2, int var3_3, JA_AlgaeDigest var4_4, JA_SignaturePaddingScheme var5_5, byte[] var6_6, int var7_7, int var8_8) {
        block79: {
            var9_9 = null;
            var10_10 = null;
            var11_11 = null;
            var12_12 = null;
            var13_13 = null;
            var14_14 = null;
            var15_15 = null;
            var16_16 = null;
            var17_17 = null;
            var18_18 = null;
            var19_19 = new byte[20];
            var20_20 = new byte[20];
            try {
                try {
                    block77: {
                        this.initializeArithmetic();
                        var9_9 = (JCMPInteger)this.arithmeticClass.newInstance();
                        var11_11 = (JCMPInteger)this.arithmeticClass.newInstance();
                        var10_10 = (JCMPInteger)this.arithmeticClass.newInstance();
                        var12_12 = (JCMPInteger)this.arithmeticClass.newInstance();
                        var13_13 = (JCMPInteger)this.arithmeticClass.newInstance();
                        var14_14 = (JCMPInteger)this.arithmeticClass.newInstance();
                        var15_15 = (JCMPInteger)this.arithmeticClass.newInstance();
                        var16_16 = (JCMPInteger)this.arithmeticClass.newInstance();
                        var17_17 = (JCMPInteger)this.arithmeticClass.newInstance();
                        var18_18 = (JCMPInteger)this.arithmeticClass.newInstance();
                        if (var4_4.getAlgorithm().compareTo("NoDigest") != 0) break block77;
                        var21_21 = 0;
                        if (true) ** GOTO lbl179
                    }
                    var21_22 = new SequenceContainer(0);
                    var22_25 = new EndContainer();
                    var23_29 = new IntegerContainer(0);
                    var24_33 = new IntegerContainer(0);
                    var25_37 = new ASN1Container[]{var21_22, var23_29, var24_33, var22_25};
                    ASN1.berDecode(var6_6, var7_7, var25_37);
                    var26_39 = var23_29.dataOffset + var23_29.dataLen - 1;
                    var27_40 = 19;
                    while (true) {
                        block78: {
                            if (var27_40 >= 0) break block78;
                            var28_41 = var24_33.dataOffset + var24_33.dataLen - 1;
                            var29_42 = 19;
                            if (true) ** GOTO lbl186
                        }
                        if (var26_39 >= var23_29.dataOffset) {
                            var19_19[var27_40] = var23_29.data[var26_39];
                        }
                        --var27_40;
                        --var26_39;
                    }
                }
                catch (JSAFE_Exception var21_24) {
                    var22_27 = false;
                    var31_45 = null;
                    if (var11_11 != null) {
                        var11_11.clearSensitiveData();
                    }
                    if (var10_10 != null) {
                        var10_10.clearSensitiveData();
                    }
                    if (var12_12 != null) {
                        var12_12.clearSensitiveData();
                    }
                    if (var13_13 != null) {
                        var13_13.clearSensitiveData();
                    }
                    if (var14_14 != null) {
                        var14_14.clearSensitiveData();
                    }
                    if (var15_15 != null) {
                        var15_15.clearSensitiveData();
                    }
                    if (var16_16 != null) {
                        var16_16.clearSensitiveData();
                    }
                    if (var17_17 != null) {
                        var17_17.clearSensitiveData();
                    }
                    if (var18_18 != null) {
                        var18_18.clearSensitiveData();
                    }
                    if (var9_9 == null) return var22_27;
                    var9_9.clearSensitiveData();
                    return var22_27;
                }
                catch (ASN_Exception var22_28) {
                    var23_31 = false;
                    var31_46 = null;
                    if (var11_11 != null) {
                        var11_11.clearSensitiveData();
                    }
                    if (var10_10 != null) {
                        var10_10.clearSensitiveData();
                    }
                    if (var12_12 != null) {
                        var12_12.clearSensitiveData();
                    }
                    if (var13_13 != null) {
                        var13_13.clearSensitiveData();
                    }
                    if (var14_14 != null) {
                        var14_14.clearSensitiveData();
                    }
                    if (var15_15 != null) {
                        var15_15.clearSensitiveData();
                    }
                    if (var16_16 != null) {
                        var16_16.clearSensitiveData();
                    }
                    if (var17_17 != null) {
                        var17_17.clearSensitiveData();
                    }
                    if (var18_18 != null) {
                        var18_18.clearSensitiveData();
                    }
                    if (var9_9 == null) return var23_31;
                    var9_9.clearSensitiveData();
                    return var23_31;
                }
                catch (InstantiationException var23_32) {
                    var24_35 = false;
                    var31_47 = null;
                    if (var11_11 != null) {
                        var11_11.clearSensitiveData();
                    }
                    if (var10_10 != null) {
                        var10_10.clearSensitiveData();
                    }
                    if (var12_12 != null) {
                        var12_12.clearSensitiveData();
                    }
                    if (var13_13 != null) {
                        var13_13.clearSensitiveData();
                    }
                    if (var14_14 != null) {
                        var14_14.clearSensitiveData();
                    }
                    if (var15_15 != null) {
                        var15_15.clearSensitiveData();
                    }
                    if (var16_16 != null) {
                        var16_16.clearSensitiveData();
                    }
                    if (var17_17 != null) {
                        var17_17.clearSensitiveData();
                    }
                    if (var18_18 != null) {
                        var18_18.clearSensitiveData();
                    }
                    if (var9_9 == null) return var24_35;
                    var9_9.clearSensitiveData();
                    return var24_35;
                }
                catch (IllegalAccessException var24_36) {
                    var25_38 = false;
                    var31_48 = null;
                    if (var11_11 != null) {
                        var11_11.clearSensitiveData();
                    }
                    if (var10_10 != null) {
                        var10_10.clearSensitiveData();
                    }
                    if (var12_12 != null) {
                        var12_12.clearSensitiveData();
                    }
                    if (var13_13 != null) {
                        var13_13.clearSensitiveData();
                    }
                    if (var14_14 != null) {
                        var14_14.clearSensitiveData();
                    }
                    if (var15_15 != null) {
                        var15_15.clearSensitiveData();
                    }
                    if (var16_16 != null) {
                        var16_16.clearSensitiveData();
                    }
                    if (var17_17 != null) {
                        var17_17.clearSensitiveData();
                    }
                    if (var18_18 != null) {
                        var18_18.clearSensitiveData();
                    }
                    if (var9_9 == null) return var25_38;
                    var9_9.clearSensitiveData();
                    return var25_38;
                }
            }
            catch (Throwable var30_50) {
                var31_49 = null;
                if (var11_11 != null) {
                    var11_11.clearSensitiveData();
                }
                if (var10_10 != null) {
                    var10_10.clearSensitiveData();
                }
                if (var12_12 != null) {
                    var12_12.clearSensitiveData();
                }
                if (var13_13 != null) {
                    var13_13.clearSensitiveData();
                }
                if (var14_14 != null) {
                    var14_14.clearSensitiveData();
                }
                if (var15_15 != null) {
                    var15_15.clearSensitiveData();
                }
                if (var16_16 != null) {
                    var16_16.clearSensitiveData();
                }
                if (var17_17 != null) {
                    var17_17.clearSensitiveData();
                }
                if (var18_18 != null) {
                    var18_18.clearSensitiveData();
                }
                if (var9_9 == null) throw var30_50;
                var9_9.clearSensitiveData();
                throw var30_50;
            }
            do {
                var19_19[var21_21] = var6_6[var7_7];
                var20_20[var21_21] = var6_6[var7_7 + 20];
                ++var21_21;
                ++var7_7;
lbl179:
                // 2 sources

            } while (var21_21 < 20);
            break block79;
            do {
                if (var28_41 >= var24_33.dataOffset) {
                    var20_20[var29_42] = var24_33.data[var28_41];
                }
                --var29_42;
                --var28_41;
lbl186:
                // 2 sources

            } while (var29_42 >= 0);
        }
        var11_11.setValue(var19_19, 0, 20);
        var10_10.setValue(var20_20, 0, 20);
        var10_10.modInvert(this.subPrimeQ, var12_12);
        var13_13.setValue(var1_1, var2_2, var3_3);
        var13_13.modMultiply(var12_12, this.subPrimeQ, var14_14);
        var11_11.modMultiply(var12_12, this.subPrimeQ, var15_15);
        this.baseG.modExp(var14_14, this.primeP, var16_16);
        this.publicValueY.modExp(var15_15, this.primeP, var17_17);
        var16_16.modMultiply(var17_17, this.primeP, var9_9);
        var9_9.modReduce(this.subPrimeQ, var18_18);
        var21_23 = var18_18.toFixedLenOctetString(20);
        var22_26 = 0;
        while (var22_26 < 20) {
            if (var21_23[var22_26] != var19_19[var22_26]) break;
            ++var22_26;
        }
        if (var22_26 < 20) {
            var23_30 = false;
            var31_43 = null;
            if (var11_11 != null) {
                var11_11.clearSensitiveData();
            }
            if (var10_10 != null) {
                var10_10.clearSensitiveData();
            }
            if (var12_12 != null) {
                var12_12.clearSensitiveData();
            }
            if (var13_13 != null) {
                var13_13.clearSensitiveData();
            }
            if (var14_14 != null) {
                var14_14.clearSensitiveData();
            }
            if (var15_15 != null) {
                var15_15.clearSensitiveData();
            }
            if (var16_16 != null) {
                var16_16.clearSensitiveData();
            }
            if (var17_17 != null) {
                var17_17.clearSensitiveData();
            }
            if (var18_18 != null) {
                var18_18.clearSensitiveData();
            }
            if (var9_9 == null) return var23_30;
            var9_9.clearSensitiveData();
            return var23_30;
        }
        var24_34 = true;
        var31_44 = null;
        if (var11_11 != null) {
            var11_11.clearSensitiveData();
        }
        if (var10_10 != null) {
            var10_10.clearSensitiveData();
        }
        if (var12_12 != null) {
            var12_12.clearSensitiveData();
        }
        if (var13_13 != null) {
            var13_13.clearSensitiveData();
        }
        if (var14_14 != null) {
            var14_14.clearSensitiveData();
        }
        if (var15_15 != null) {
            var15_15.clearSensitiveData();
        }
        if (var16_16 != null) {
            var16_16.clearSensitiveData();
        }
        if (var17_17 != null) {
            var17_17.clearSensitiveData();
        }
        if (var18_18 != null) {
            var18_18.clearSensitiveData();
        }
        if (var9_9 == null) return var24_34;
        var9_9.clearSensitiveData();
        return var24_34;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_DSA jA_DSA = new JA_DSA();
        jA_DSA.arithmeticClass = this.arithmeticClass;
        jA_DSA.fipsRand = this.fipsRand;
        jA_DSA.blockSize = this.blockSize;
        jA_DSA.maxInputLen = this.maxInputLen;
        jA_DSA.signatureSize = this.signatureSize;
        if (this.primeP != null) {
            jA_DSA.primeP = (JCMPInt)this.primeP.clone();
        }
        if (this.subPrimeQ != null) {
            jA_DSA.subPrimeQ = (JCMPInt)this.subPrimeQ.clone();
        }
        if (this.baseG != null) {
            jA_DSA.baseG = (JCMPInt)this.baseG.clone();
        }
        if (this.publicValueY != null) {
            jA_DSA.publicValueY = (JCMPInt)this.publicValueY.clone();
        }
        if (this.privateValueX != null) {
            jA_DSA.privateValueX = (JCMPInt)this.privateValueX.clone();
        }
        return jA_DSA;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.deobfuscate();
        objectOutputStream.defaultWriteObject();
        this.obfuscate();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private void restoreAfterDeserialization() {
        this.obfuscate();
    }

    public void obfuscate() {
        if (this.privateValueX != null) {
            this.privateValueX.obfuscate();
        }
    }

    public void deobfuscate() {
        if (this.privateValueX != null) {
            this.privateValueX.deobfuscate();
        }
    }

    protected void clearKeys() {
        if (this.publicValueY != null) {
            this.publicValueY.clearSensitiveData();
        }
        if (this.privateValueX != null) {
            this.privateValueX.clearSensitiveData();
        }
        this.privateValueX = null;
        this.publicValueY = null;
    }

    private void clearParameters() {
        if (this.primeP != null) {
            this.primeP.clearSensitiveData();
        }
        if (this.subPrimeQ != null) {
            this.subPrimeQ.clearSensitiveData();
        }
        if (this.baseG != null) {
            this.baseG.clearSensitiveData();
        }
        this.baseG = null;
        this.subPrimeQ = null;
        this.primeP = null;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.clearKeys();
        this.clearParameters();
        this.blockSize = -1;
        this.maxInputLen = 0;
        this.signatureSize = 0;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

