/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.CryptoJ;
import com.rsa.jsafe.JA_AlternateArithmetic;
import com.rsa.jsafe.JA_DSAParameters;
import com.rsa.jsafe.JA_DSAPrivateKey;
import com.rsa.jsafe.JA_DSAPublicKey;
import com.rsa.jsafe.JA_FIPS186DSAKeyGenPRNG;
import com.rsa.jsafe.JCMPArithmeticClass;
import com.rsa.jsafe.JCMPInteger;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidArithmeticException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_KeyPair;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_Parameters;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.KATDSASignVerify;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public class JA_DSAKeyPair
extends JSAFE_KeyPair
implements JA_AlternateArithmetic,
Cloneable,
Serializable {
    protected Class arithmeticClass;
    protected int primeLen;
    protected byte[][] sharedParams;
    protected SecureRandom random;
    protected byte[] randomSerialize;
    protected String randomAlgorithm;
    protected int objectStateGen;
    protected static final int NOT_INITIALIZED = 1;
    protected static final int INITIALIZED = 2;

    public JA_DSAKeyPair() {
        this.objectStateGen = 1;
    }

    public JA_DSAKeyPair(JA_DSAPublicKey jA_DSAPublicKey, JA_DSAPrivateKey jA_DSAPrivateKey) throws JSAFE_InvalidKeyException {
        this.setKeys(jA_DSAPublicKey, jA_DSAPrivateKey);
        this.objectStateGen = 1;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    protected void initializeArithmetic() {
        if (this.arithmeticClass == null) {
            this.arithmeticClass = JCMPArithmeticClass.getDefaultClass();
        }
    }

    public void setArithmetic(Class clazz) throws JSAFE_InvalidArithmeticException {
        try {
            JCMPInteger jCMPInteger = (JCMPInteger)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        this.arithmeticClass = clazz;
    }

    protected boolean setKeyPair(JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) {
        if (!(jSAFE_PublicKey instanceof JA_DSAPublicKey) || !(jSAFE_PrivateKey instanceof JA_DSAPrivateKey)) {
            return false;
        }
        return super.setKeyPair(jSAFE_PublicKey, jSAFE_PrivateKey);
    }

    protected boolean genInit(JSAFE_Parameters jSAFE_Parameters, int[] nArray, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray) {
        JSAFE_Object.checkIntegrity();
        this.clearKeys();
        this.clearParameters();
        if (secureRandom != null) {
            this.random = secureRandom;
        }
        if (jSAFE_Parameters == null) {
            return false;
        }
        if (!(jSAFE_Parameters instanceof JA_DSAParameters)) {
            return false;
        }
        if (nArray != null && nArray.length != 0) {
            return false;
        }
        if (this.random == null) {
            return false;
        }
        try {
            this.sharedParams = jSAFE_Parameters.getParameterData("DSAParameters");
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return false;
        }
        this.objectStateGen = 2;
        return true;
    }

    protected void genReInit() throws JSAFE_InvalidUseException {
        JSAFE_Object.checkIntegrity();
        this.clearKeys();
        if (this.objectStateGen != 2) {
            throw new JSAFE_InvalidUseException("Cannot reInit, object not initialized.");
        }
    }

    void pairwiseConsistencyCheck() {
        if (!JSAFE_Object.fipsIsRequired()) {
            return;
        }
        JSAFE_PublicKey jSAFE_PublicKey = null;
        JSAFE_PrivateKey jSAFE_PrivateKey = null;
        try {
            jSAFE_PublicKey = this.getPublicKey();
            jSAFE_PrivateKey = this.getPrivateKey();
            KATDSASignVerify kATDSASignVerify = new KATDSASignVerify();
            if (!kATDSASignVerify.testKeyPair(jSAFE_PublicKey, jSAFE_PrivateKey)) {
                CryptoJ.verified = 2;
                this.clearSensitiveData();
                this.objectStateGen = 1;
                throw new RuntimeException("Crypto-J has entered a failed state and is inoperable.An internal pairwise consistency check failed");
            }
            Object var5_4 = null;
            if (jSAFE_PublicKey != null) {
                jSAFE_PublicKey.clearSensitiveData();
            }
            if (jSAFE_PrivateKey != null) {
                jSAFE_PrivateKey.clearSensitiveData();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (jSAFE_PublicKey != null) {
                jSAFE_PublicKey.clearSensitiveData();
            }
            if (jSAFE_PrivateKey != null) {
                jSAFE_PrivateKey.clearSensitiveData();
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateKeyPair() throws JSAFE_InvalidUseException {
        Throwable throwable2;
        JSAFE_PrivateKey jSAFE_PrivateKey;
        JSAFE_PublicKey jSAFE_PublicKey;
        byte[] byArray;
        JCMPInteger jCMPInteger;
        JCMPInteger jCMPInteger2;
        JCMPInteger jCMPInteger3;
        JCMPInteger jCMPInteger4;
        JCMPInteger jCMPInteger5;
        block28: {
            int n;
            if (this.objectStateGen != 2) {
                throw new JSAFE_InvalidUseException("Cannot generate, object not initialized.");
            }
            this.initializeArithmetic();
            JA_FIPS186DSAKeyGenPRNG jA_FIPS186DSAKeyGenPRNG = null;
            jCMPInteger5 = null;
            jCMPInteger4 = null;
            jCMPInteger3 = null;
            jCMPInteger2 = null;
            jCMPInteger = null;
            byte[] byArray2 = null;
            byArray = null;
            jSAFE_PublicKey = null;
            jSAFE_PrivateKey = null;
            try {
                try {
                    jCMPInteger5 = (JCMPInteger)this.arithmeticClass.newInstance();
                    jCMPInteger5.setValue(this.sharedParams[0], 0, this.sharedParams[0].length);
                    this.primeLen = jCMPInteger5.getBitLength();
                    jCMPInteger4 = (JCMPInteger)this.arithmeticClass.newInstance();
                    jCMPInteger4.setValue(this.sharedParams[1], 0, this.sharedParams[1].length);
                    jCMPInteger3 = (JCMPInteger)this.arithmeticClass.newInstance();
                    jCMPInteger3.setValue(this.sharedParams[2], 0, this.sharedParams[2].length);
                    byte[] byArray3 = new byte[20];
                    this.random.nextBytes(byArray3);
                    jA_FIPS186DSAKeyGenPRNG = new JA_FIPS186DSAKeyGenPRNG(byArray3);
                    byArray2 = new byte[this.sharedParams[1].length];
                    jA_FIPS186DSAKeyGenPRNG.generateRandomBytes(byArray2, 0, byArray2.length);
                    jCMPInteger2 = (JCMPInteger)this.arithmeticClass.newInstance();
                    jCMPInteger = (JCMPInteger)this.arithmeticClass.newInstance();
                    jCMPInteger.setPowerOfTwo(this.primeLen);
                    jCMPInteger.setValue(byArray2, 0, byArray2.length);
                    jCMPInteger.modReduce(jCMPInteger4, jCMPInteger2);
                    jCMPInteger3.modExp(jCMPInteger2, jCMPInteger5, jCMPInteger);
                    byArray = jCMPInteger2.toOctetString();
                    byte[] byArray4 = jCMPInteger.toOctetString();
                    jSAFE_PublicKey = JSAFE_PublicKey.getInstance("DSA", this.getDevice());
                    jSAFE_PrivateKey = JSAFE_PrivateKey.getInstance("DSA", this.getDevice());
                    byte[][] byArrayArray = new byte[][]{this.sharedParams[0], this.sharedParams[1], this.sharedParams[2], byArray4};
                    jSAFE_PublicKey.setKeyData("DSAPublicKey", byArrayArray);
                    byte[][] byArrayArray2 = new byte[][]{this.sharedParams[0], this.sharedParams[1], this.sharedParams[2], byArray};
                    jSAFE_PrivateKey.setKeyData("DSAPrivateKey", byArrayArray2);
                    this.setKeys(jSAFE_PublicKey, jSAFE_PrivateKey);
                    this.pairwiseConsistencyCheck();
                }
                catch (InstantiationException instantiationException) {
                    throw new JSAFE_InvalidUseException("Bad arithmetic class.");
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new JSAFE_InvalidUseException("Bad arithmetic class.");
                }
                catch (JSAFE_Exception jSAFE_Exception) {
                    throw new JSAFE_InvalidUseException("Could not generate the key pair at this time.");
                }
                Object var16_18 = null;
                if (jA_FIPS186DSAKeyGenPRNG != null) {
                    jA_FIPS186DSAKeyGenPRNG.clearSensitiveData();
                }
                if (byArray2 != null) {
                    int n2 = 0;
                    while (n2 < byArray2.length) {
                        byArray2[n2] = 0;
                        ++n2;
                    }
                }
                if (byArray != null) {
                    int n3 = 0;
                    while (n3 < byArray.length) {
                        byArray[n3] = 0;
                        ++n3;
                    }
                }
                if (jCMPInteger2 != null) {
                    jCMPInteger2.clearSensitiveData();
                }
                if (jCMPInteger != null) {
                    jCMPInteger.clearSensitiveData();
                }
                if (jCMPInteger5 != null) {
                    jCMPInteger5.clearSensitiveData();
                }
                if (jCMPInteger4 != null) {
                    jCMPInteger4.clearSensitiveData();
                }
                if (jCMPInteger3 != null) {
                    jCMPInteger3.clearSensitiveData();
                }
                if (jSAFE_PublicKey != null) {
                    jSAFE_PublicKey.clearSensitiveData();
                }
                if (jSAFE_PrivateKey == null) return;
                jSAFE_PrivateKey.clearSensitiveData();
                return;
            }
            catch (Throwable throwable2) {
                Object var16_19 = null;
                if (jA_FIPS186DSAKeyGenPRNG != null) {
                    jA_FIPS186DSAKeyGenPRNG.clearSensitiveData();
                }
                if (byArray2 == null) break block28;
                n = 0;
            }
            while (n < byArray2.length) {
                byArray2[n] = false;
                ++n;
            }
        }
        if (byArray != null) {
            int n = 0;
            while (n < byArray.length) {
                byArray[n] = false;
                ++n;
            }
        }
        if (jCMPInteger2 != null) {
            jCMPInteger2.clearSensitiveData();
        }
        if (jCMPInteger != null) {
            jCMPInteger.clearSensitiveData();
        }
        if (jCMPInteger5 != null) {
            jCMPInteger5.clearSensitiveData();
        }
        if (jCMPInteger4 != null) {
            jCMPInteger4.clearSensitiveData();
        }
        if (jCMPInteger3 != null) {
            jCMPInteger3.clearSensitiveData();
        }
        if (jSAFE_PublicKey != null) {
            jSAFE_PublicKey.clearSensitiveData();
        }
        if (jSAFE_PrivateKey == null) throw throwable2;
        jSAFE_PrivateKey.clearSensitiveData();
        throw throwable2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JSAFE_SecureRandom jSAFE_SecureRandom = this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization(jSAFE_SecureRandom);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private JSAFE_SecureRandom prepareSerialization() {
        if (this.random == null) {
            return null;
        }
        if (!(this.random instanceof JSAFE_SecureRandom)) {
            return null;
        }
        JSAFE_SecureRandom jSAFE_SecureRandom = (JSAFE_SecureRandom)this.random;
        if (jSAFE_SecureRandom.getDevice().compareTo("Java") != 0) {
            return null;
        }
        this.randomAlgorithm = jSAFE_SecureRandom.getAlgorithm();
        this.randomSerialize = jSAFE_SecureRandom.serializeRandom();
        JSAFE_SecureRandom jSAFE_SecureRandom2 = (JSAFE_SecureRandom)this.random;
        this.random = null;
        return jSAFE_SecureRandom2;
    }

    private void restoreAfterSerialization(JSAFE_SecureRandom jSAFE_SecureRandom) {
        if (this.randomSerialize == null) {
            return;
        }
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
        this.random = jSAFE_SecureRandom;
    }

    private void restoreAfterDeserialization() {
        if (this.randomSerialize == null) {
            return;
        }
        this.random = JSAFE_SecureRandom.deserializeRandom(this.randomAlgorithm, this.randomSerialize);
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
    }

    protected JSAFE_KeyPair createClone() throws CloneNotSupportedException {
        JA_DSAKeyPair jA_DSAKeyPair = new JA_DSAKeyPair();
        jA_DSAKeyPair.arithmeticClass = this.arithmeticClass;
        jA_DSAKeyPair.primeLen = this.primeLen;
        if (this.sharedParams != null) {
            byte[][] byArrayArray = new byte[this.sharedParams.length][];
            int n = 0;
            while (n < this.sharedParams.length) {
                if (this.sharedParams[n] != null) {
                    byArrayArray[n] = (byte[])this.sharedParams[n].clone();
                }
                ++n;
            }
            jA_DSAKeyPair.sharedParams = byArrayArray;
        }
        jA_DSAKeyPair.random = this.random;
        jA_DSAKeyPair.objectStateGen = this.objectStateGen;
        jA_DSAKeyPair.setJSAFELevelValues(this);
        return jA_DSAKeyPair;
    }

    protected void clearKeys() {
        super.clearKeys();
    }

    protected void clearParameters() {
        this.sharedParams = null;
        this.primeLen = 0;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
    }

    protected void doClearSensitiveData() {
        this.clearKeys();
        this.clearParameters();
        this.objectStateGen = 1;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

