/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlternateArithmetic;
import com.rsa.jsafe.JA_DSAParametersBER;
import com.rsa.jsafe.JA_PQGGen;
import com.rsa.jsafe.JCMPArithmeticClass;
import com.rsa.jsafe.JCMPInteger;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidArithmeticException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Parameters;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public class JA_DSAParameters
extends JSAFE_Parameters
implements JA_AlternateArithmetic,
Cloneable,
Serializable {
    protected int primeLen;
    protected int subPrimeLen;
    protected byte[] primeP;
    protected byte[] subPrimeQ;
    protected byte[] baseG;
    protected SecureRandom random;
    protected byte[] randomSerialize;
    protected String randomAlgorithm;
    protected Class arithmeticClass;
    protected int objectState = 1;
    protected static final int NOT_INITIALIZED = 1;
    protected static final int INITIALIZED = 2;
    protected boolean isFIPSCompliant = false;

    protected JA_DSAParameters() {
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public String[] getSupportedSetFormats() {
        String[] stringArray = new String[]{"DSAParameters", "DSAParametersBER", "DSAParametersX957BER"};
        return stringArray;
    }

    public String[] getSupportedGetFormats() {
        if (this.primeP == null || this.subPrimeQ == null || this.baseG == null) {
            return new String[0];
        }
        String[] stringArray = new String[]{"DSAParameters", "DSAParametersBER", "DSAParametersX957BER"};
        return stringArray;
    }

    public void setAlgorithmBER(byte[] byArray, int n) throws JSAFE_UnimplementedException {
        JA_DSAParametersBER.setAlgorithmBER(this, byArray, n);
    }

    public byte[] getDERAlgorithmID(String string) throws JSAFE_UnimplementedException {
        if (this.primeP == null || this.subPrimeQ == null || this.baseG == null) {
            throw new JSAFE_UnimplementedException("Cannot build the DER of the parameters, object not set.");
        }
        if (string != null) {
            if (string.compareTo("DSAParametersX957BER") == 0) {
                string = "DSAX957";
            } else if (string.compareTo("DSAParametersBER") == 0) {
                string = null;
            }
        }
        return JA_DSAParametersBER.getDERAlgorithmID(string, this.primeP, this.subPrimeQ, this.baseG);
    }

    protected void initializeArithmetic() {
        if (this.arithmeticClass == null) {
            this.arithmeticClass = JCMPArithmeticClass.getDefaultClass();
        }
    }

    public void setArithmetic(Class clazz) throws JSAFE_InvalidArithmeticException {
        try {
            JCMPInteger jCMPInteger = (JCMPInteger)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        this.arithmeticClass = clazz;
    }

    public void setParameterData(String string, byte[][] byArray) throws JSAFE_InputException, JSAFE_UnimplementedException {
        this.clearSensitiveData();
        if (string.compareTo("DSAParametersBER") == 0 || string.compareTo("DSAParametersX957BER") == 0) {
            if (byArray.length != 1) {
                throw new JSAFE_InputException("Invalid BER DSA parameter data.");
            }
            this.setAlgorithmBER(byArray[0], 0);
            if (this.primeP == null || this.subPrimeQ == null || this.baseG == null) {
                throw new JSAFE_InputException("Invalid BER DSA parameter data.");
            }
            return;
        }
        if (string.compareTo("DSAParameters") == 0) {
            this.setParameterData(byArray);
            return;
        }
        throw new JSAFE_UnimplementedException("Unimplemented DSA parameter format.");
    }

    public void setParameterData(byte[][] byArray) throws JSAFE_InputException {
        if (byArray == null || byArray.length != 3) {
            throw new JSAFE_InputException("Invalid DSA parameters.");
        }
        this.loadSystemParameters(-1, byArray[0], 0, byArray[0].length, byArray[1], 0, byArray[1].length, byArray[2], 0, byArray[2].length);
    }

    /*
     * Unable to fully structure code
     */
    void loadSystemParameters(int var1_1, byte[] var2_2, int var3_3, int var4_4, byte[] var5_5, int var6_6, int var7_7, byte[] var8_8, int var9_9, int var10_10) throws JSAFE_InputException {
        this.clearSensitiveData();
        while (var2_2[var3_3] == 0) {
            --var4_4;
            ++var3_3;
        }
        this.primeP = new byte[var4_4];
        System.arraycopy(var2_2, var3_3, this.primeP, 0, var4_4);
        this.primeLen = this.primeP.length * 8;
        var11_11 = this.primeP[0] & 255;
        var12_12 = var11_11 & 128;
        while (var12_12 == 0) {
            --this.primeLen;
            var12_12 = (var11_11 <<= 1) & 128;
        }
        if (var1_1 != -1 && this.primeLen > var1_1) {
            throw new JSAFE_InputException("DSA prime size mismatch.");
        }
        if (this.primeLen >= 256 && this.primeLen <= 2048) ** GOTO lbl21
        throw new JSAFE_InputException("Invalid DSA prime size.");
lbl-1000:
        // 1 sources

        {
            --var7_7;
            ++var6_6;
lbl21:
            // 2 sources

            ** while (var5_5[var6_6] == 0)
        }
lbl22:
        // 1 sources

        this.subPrimeQ = new byte[var7_7];
        System.arraycopy(var5_5, var6_6, this.subPrimeQ, 0, var7_7);
        this.subPrimeLen = this.subPrimeQ.length * 8;
        var11_11 = this.subPrimeQ[0] & 255;
        var12_12 = var11_11 & 128;
        while (var12_12 == 0) {
            --this.subPrimeLen;
            var12_12 = (var11_11 <<= 1) & 128;
        }
        if (this.subPrimeLen >= 160 && this.subPrimeLen <= 160) ** GOTO lbl35
        throw new JSAFE_InputException("Invalid DSA subprime size.");
lbl-1000:
        // 1 sources

        {
            --var10_10;
            ++var9_9;
lbl35:
            // 2 sources

            ** while (var8_8[var9_9] == 0)
        }
lbl36:
        // 1 sources

        this.baseG = new byte[var10_10];
        System.arraycopy(var8_8, var9_9, this.baseG, 0, var10_10);
        if (this.baseG.length > this.primeP.length) {
            throw new JSAFE_InputException("Invalid DSA base size.");
        }
        if (this.baseG.length == this.primeP.length) {
            var13_13 = 0;
            while (var13_13 < this.baseG.length) {
                if ((this.baseG[var13_13] & 255) < (this.primeP[var13_13] & 255)) break;
                if ((this.baseG[var13_13] & 255) > (this.primeP[var13_13] & 255)) {
                    throw new JSAFE_InputException("Invalid DSA base size.");
                }
                ++var13_13;
            }
            if (var13_13 >= this.baseG.length) {
                throw new JSAFE_InputException("Invalid DSA base size.");
            }
        }
    }

    public byte[][] getParameterData(String string) throws JSAFE_UnimplementedException {
        if (this.primeP == null || this.subPrimeQ == null || this.baseG == null) {
            return new byte[0][];
        }
        if (string.compareTo("DSAParametersBER") == 0) {
            byte[] byArray = JA_DSAParametersBER.getDERAlgorithmID(null, this.primeP, this.subPrimeQ, this.baseG);
            byte[][] byArrayArray = new byte[][]{byArray};
            return byArrayArray;
        }
        if (string.compareTo("DSAParametersX957BER") == 0) {
            byte[] byArray = JA_DSAParametersBER.getDERAlgorithmID("DSAX957", this.primeP, this.subPrimeQ, this.baseG);
            byte[][] byArrayArray = new byte[][]{byArray};
            return byArrayArray;
        }
        if (string.compareTo("DSAParameters") == 0) {
            return this.getParameterData();
        }
        throw new JSAFE_UnimplementedException("Unimplemented DSA parameter format.");
    }

    public byte[][] getParameterData() {
        if (this.primeP == null || this.subPrimeQ == null || this.baseG == null) {
            return new byte[0][];
        }
        byte[] byArray = new byte[this.primeP.length];
        System.arraycopy(this.primeP, 0, byArray, 0, this.primeP.length);
        byte[] byArray2 = new byte[this.subPrimeQ.length];
        System.arraycopy(this.subPrimeQ, 0, byArray2, 0, this.subPrimeQ.length);
        byte[] byArray3 = new byte[this.baseG.length];
        System.arraycopy(this.baseG, 0, byArray3, 0, this.baseG.length);
        byte[][] byArrayArray = new byte[][]{byArray, byArray2, byArray3};
        return byArrayArray;
    }

    public void generateInit(int[] nArray, SecureRandom secureRandom) throws JSAFE_InvalidParameterException {
        this.generateInit(nArray, secureRandom, null);
    }

    public void generateInit(int[] nArray, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray) throws JSAFE_InvalidParameterException {
        this.isFIPSCompliant = false;
        this.commonGenerateInit(nArray, secureRandom);
    }

    public void generateFIPSInit(int[] nArray, SecureRandom secureRandom) throws JSAFE_InvalidParameterException {
        this.isFIPSCompliant = true;
        this.commonGenerateInit(nArray, secureRandom);
        int n = nArray[0];
        if (n < 512 || n > 1024 || n % 64 != 0) {
            throw new JSAFE_InvalidParameterException("Invalid DSA FIPS 186 prime size.Should be between 512 and 1024 and a multiple of 64 bits.");
        }
    }

    private void commonGenerateInit(int[] nArray, SecureRandom secureRandom) throws JSAFE_InvalidParameterException {
        this.clearSensitiveData();
        if (secureRandom != null) {
            this.random = secureRandom;
        }
        if (nArray == null || nArray.length != 1) {
            throw new JSAFE_InvalidParameterException("Incorrect number of DSA param gen parameters: expected 1 - primeSize.");
        }
        if (this.random == null) {
            throw new JSAFE_InvalidParameterException("DSA parameter generation needs a random number generating object.");
        }
        int n = nArray[0];
        if (n < 256 || n > 2048) {
            throw new JSAFE_InvalidParameterException("Invalid DSA prime size.Should be between 256 and 2048bits.");
        }
        this.primeLen = n;
        this.subPrimeLen = 160;
        if (secureRandom != null) {
            this.random = secureRandom;
        }
        this.objectState = 2;
    }

    public void generateReInit() throws JSAFE_InvalidUseException {
        if (this.objectState != 2) {
            throw new JSAFE_InvalidUseException("Cannot reinitialize, object not initialized.");
        }
        this.primeP = null;
        this.subPrimeQ = null;
        this.baseG = null;
    }

    public void generate() throws JSAFE_InvalidUseException {
        if (this.objectState != 2) {
            throw new JSAFE_InvalidUseException("Object not initialized.");
        }
        this.initializeArithmetic();
        int n = (this.primeLen + 7) / 8;
        this.primeP = new byte[n];
        int n2 = (this.subPrimeLen + 7) / 8;
        this.subPrimeQ = new byte[n2];
        this.baseG = new byte[n];
        if (this.isFIPSCompliant) {
            JA_PQGGen.generateFipsPQG(this.primeP, this.primeLen, this.subPrimeQ, this.subPrimeLen, this.baseG, this.random, this.arithmeticClass);
        } else {
            JA_PQGGen.generatePQG(this.primeP, this.primeLen, this.subPrimeQ, this.subPrimeLen, this.baseG, this.random, this.arithmeticClass);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JSAFE_SecureRandom jSAFE_SecureRandom = this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization(jSAFE_SecureRandom);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private JSAFE_SecureRandom prepareSerialization() {
        if (this.random == null) {
            return null;
        }
        if (!(this.random instanceof JSAFE_SecureRandom)) {
            return null;
        }
        JSAFE_SecureRandom jSAFE_SecureRandom = (JSAFE_SecureRandom)this.random;
        if (jSAFE_SecureRandom.getDevice().compareTo("Java") != 0) {
            return null;
        }
        this.randomAlgorithm = jSAFE_SecureRandom.getAlgorithm();
        this.randomSerialize = jSAFE_SecureRandom.serializeRandom();
        JSAFE_SecureRandom jSAFE_SecureRandom2 = (JSAFE_SecureRandom)this.random;
        this.random = null;
        return jSAFE_SecureRandom2;
    }

    private void restoreAfterSerialization(JSAFE_SecureRandom jSAFE_SecureRandom) {
        if (this.randomSerialize == null) {
            return;
        }
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
        this.random = jSAFE_SecureRandom;
    }

    private void restoreAfterDeserialization() {
        if (this.randomSerialize == null) {
            return;
        }
        this.random = JSAFE_SecureRandom.deserializeRandom(this.randomAlgorithm, this.randomSerialize);
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_DSAParameters jA_DSAParameters = new JA_DSAParameters();
        if (this.primeP != null) {
            jA_DSAParameters.primeP = (byte[])this.primeP.clone();
        }
        if (this.subPrimeQ != null) {
            jA_DSAParameters.subPrimeQ = (byte[])this.subPrimeQ.clone();
        }
        if (this.baseG != null) {
            jA_DSAParameters.baseG = (byte[])this.baseG.clone();
        }
        jA_DSAParameters.primeLen = this.primeLen;
        jA_DSAParameters.subPrimeLen = this.subPrimeLen;
        jA_DSAParameters.arithmeticClass = this.arithmeticClass;
        jA_DSAParameters.objectState = this.objectState;
        jA_DSAParameters.random = this.random;
        jA_DSAParameters.setJSAFELevelValues(this);
        return jA_DSAParameters;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.subPrimeLen = 0;
        this.primeLen = 0;
        this.baseG = null;
        this.subPrimeQ = null;
        this.primeP = null;
        this.objectState = 1;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

