/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.jsafe.JA_DSAParameters;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_UnimplementedException;

final class JA_DSAParametersBER
extends JSAFE_Object {
    JA_DSAParametersBER() {
    }

    static void setAlgorithmBER(JA_DSAParameters jA_DSAParameters, byte[] byArray, int n) throws JSAFE_UnimplementedException {
        IntegerContainer[] integerContainerArray;
        OIDContainer oIDContainer = null;
        OfContainer ofContainer = null;
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0);
            integerContainerArray = new EndContainer();
            oIDContainer = new OIDContainer(0, 4);
            ofContainer = new OfContainer(65536, 12288, new IntegerContainer(0));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, ofContainer, integerContainerArray};
            ASN1.berDecode(byArray, n, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Invalid DSA parameter BER encoding.(" + aSN_Exception.getMessage() + ")");
        }
        if (oIDContainer.transformation.compareTo("DSA") != 0) {
            throw new JSAFE_UnimplementedException("Invalid DSA parameter BER encoding.");
        }
        if (!ofContainer.dataPresent) {
            return;
        }
        int n2 = ofContainer.getContainerCount();
        if (n2 != 4 && n2 != 3) {
            throw new JSAFE_UnimplementedException("Could not read the DSA parameters BER.");
        }
        integerContainerArray = new IntegerContainer[n2];
        int n3 = -1;
        try {
            int n4 = 0;
            while (n4 < n2) {
                integerContainerArray[n4] = (IntegerContainer)ofContainer.containerAt(n4);
                ++n4;
            }
            if (n2 == 4) {
                n3 = integerContainerArray[0].getValueAsInt();
            }
            jA_DSAParameters.loadSystemParameters(n3, integerContainerArray[n2 -= 3].data, integerContainerArray[n2].dataOffset, integerContainerArray[n2].dataLen, integerContainerArray[n2 + 1].data, integerContainerArray[n2 + 1].dataOffset, integerContainerArray[n2 + 1].dataLen, integerContainerArray[n2 + 2].data, integerContainerArray[n2 + 2].dataOffset, integerContainerArray[n2 + 2].dataLen);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not read the DSA parameters BER. (" + aSN_Exception.getMessage() + ")");
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_UnimplementedException(jSAFE_Exception.getMessage());
        }
    }

    static byte[] getDERAlgorithmID(String string, byte[] byArray, byte[] byArray2, byte[] byArray3) throws JSAFE_UnimplementedException {
        ASN1Container[] aSN1ContainerArray;
        Object object;
        SequenceContainer sequenceContainer = null;
        OIDContainer oIDContainer = null;
        OfContainer ofContainer = null;
        try {
            IntegerContainer integerContainer;
            sequenceContainer = new SequenceContainer(0, true, 0);
            object = "DSA";
            if (string != null) {
                object = string;
            }
            oIDContainer = new OIDContainer(0, true, 0, (String)object, 4);
            ofContainer = new OfContainer(65536, true, 0, 12288, new IntegerContainer(0));
            if (string == null) {
                int n = byArray.length * 8;
                int n2 = byArray[0] & 0xFF;
                while ((n2 & 0x80) == 0) {
                    --n;
                    n2 <<= 1;
                }
                integerContainer = new IntegerContainer(0, true, 0, n);
                ofContainer.addContainer(integerContainer);
            }
            aSN1ContainerArray = new IntegerContainer(0, true, 0, byArray, 0, byArray.length, true);
            IntegerContainer integerContainer2 = new IntegerContainer(0, true, 0, byArray2, 0, byArray2.length, true);
            integerContainer = new IntegerContainer(0, true, 0, byArray3, 0, byArray3.length, true);
            ofContainer.addContainer((ASN1Container)aSN1ContainerArray);
            ofContainer.addContainer(integerContainer2);
            ofContainer.addContainer(integerContainer);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not compute the DSA parameters BER. (" + aSN_Exception.getMessage() + ")");
        }
        object = new EndContainer();
        aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, ofContainer, object};
        try {
            return ASN1.derEncode(aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Invalid DSA parameter BER encoding. (" + aSN_Exception.getMessage() + ")");
        }
    }
}

