/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_DSAPrivateKeyBER;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class JA_DSAPrivateKey
extends JSAFE_PrivateKey
implements JSAFE_Key,
Cloneable,
Serializable {
    private int primeLen;
    private int subPrimeLen;
    private byte[] primeP;
    private byte[] subPrimeQ;
    private byte[] baseG;
    private transient ObfuscatorItem privateOI;
    private byte[] privateValueX;

    public String getAlgorithm() {
        return "DSA";
    }

    public String[] getSupportedSetFormats() {
        String[] stringArray = new String[]{"DSAPrivateKey", "DSAPrivateValue", "DSAPrivateKeyBER", "DSAPrivateKeyX957BER"};
        return stringArray;
    }

    public String[] getSupportedGetFormats() {
        if (this.privateValueX == null) {
            return new String[0];
        }
        if (this.primeP == null || this.subPrimeQ == null || this.baseG == null) {
            String[] stringArray = new String[]{"DSAPrivateValue", "DSAPrivateKeyBER", "DSAPrivateKeyX957BER"};
            return stringArray;
        }
        String[] stringArray = new String[]{"DSAPrivateKey", "DSAPrivateValue", "DSAPrivateKeyBER", "DSAPrivateKeyX957BER"};
        return stringArray;
    }

    public void setKeyData(String string, byte[][] byArray) throws JSAFE_UnimplementedException, JSAFE_InvalidKeyException {
        if (string.compareTo("DSAPrivateKeyBER") == 0 || string.compareTo("DSAPrivateKeyX957BER") == 0) {
            this.clearKeys();
            if (byArray.length != 1) {
                throw new JSAFE_InvalidKeyException("Invalid BER DSA private key data.");
            }
            JA_DSAPrivateKeyBER.setKeyDataBER(this, byArray[0], 0);
            return;
        }
        if (string.compareTo("DSAPrivateKey") == 0) {
            this.setKeyData(byArray);
            return;
        }
        if (string.compareTo("DSAPrivateValue") == 0) {
            this.setKeyDataPrivateValue(byArray);
            return;
        }
        throw new JSAFE_UnimplementedException("Unknown DSA key data format.");
    }

    public void setKeyData(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.clearKeys();
        this.clearParameters();
        if (byArray == null || byArray.length != 4) {
            throw new JSAFE_InvalidKeyException("Invalid input for DSA key. Expects prime, subPrime, base, privateValue");
        }
        try {
            this.loadSystemParameters(-1, byArray[0], 0, byArray[0].length, byArray[1], 0, byArray[1].length, byArray[2], 0, byArray[2].length);
            this.loadPrivateValue(byArray[3], 0, byArray[3].length);
        }
        catch (NullPointerException nullPointerException) {
            throw new JSAFE_InvalidKeyException("Invalid input for DSA key.");
        }
    }

    private void setKeyDataPrivateValue(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.clearKeys();
        if (byArray == null || byArray.length != 1) {
            throw new JSAFE_InvalidKeyException("Invalid input for DSA key.");
        }
        if (byArray[0] == null) {
            throw new JSAFE_InvalidKeyException("Invalid input for DSA key.");
        }
        this.loadPrivateValue(byArray[0], 0, byArray[0].length);
    }

    void setKeyDataBER(byte[] byArray, int n) throws JSAFE_InvalidKeyException {
        this.clearKeys();
        JA_DSAPrivateKeyBER.setKeyDataBER(this, byArray, n);
    }

    /*
     * Unable to fully structure code
     */
    void loadSystemParameters(int var1_1, byte[] var2_2, int var3_3, int var4_4, byte[] var5_5, int var6_6, int var7_7, byte[] var8_8, int var9_9, int var10_10) throws JSAFE_InvalidKeyException {
        this.clearParameters();
        while (var2_2[var3_3] == 0) {
            --var4_4;
            ++var3_3;
        }
        this.primeP = new byte[var4_4];
        System.arraycopy(var2_2, var3_3, this.primeP, 0, var4_4);
        this.primeLen = this.primeP.length * 8;
        var11_11 = this.primeP[0] & 255;
        var12_12 = var11_11 & 128;
        while (var12_12 == 0) {
            --this.primeLen;
            var12_12 = (var11_11 <<= 1) & 128;
        }
        if (var1_1 != -1 && this.primeLen > var1_1) {
            throw new JSAFE_InvalidKeyException("DSA prime size mismatch.");
        }
        if (this.primeLen >= 256 && this.primeLen <= 2048) ** GOTO lbl21
        throw new JSAFE_InvalidKeyException("Invalid DSA prime size.");
lbl-1000:
        // 1 sources

        {
            --var7_7;
            ++var6_6;
lbl21:
            // 2 sources

            ** while (var5_5[var6_6] == 0)
        }
lbl22:
        // 1 sources

        this.subPrimeQ = new byte[var7_7];
        System.arraycopy(var5_5, var6_6, this.subPrimeQ, 0, var7_7);
        this.subPrimeLen = this.subPrimeQ.length * 8;
        var11_11 = this.subPrimeQ[0] & 255;
        var12_12 = var11_11 & 128;
        while (var12_12 == 0) {
            --this.subPrimeLen;
            var12_12 = (var11_11 <<= 1) & 128;
        }
        if (this.subPrimeLen >= 160 && this.subPrimeLen <= 160) ** GOTO lbl35
        throw new JSAFE_InvalidKeyException("Invalid DSA subprime size.");
lbl-1000:
        // 1 sources

        {
            --var10_10;
            ++var9_9;
lbl35:
            // 2 sources

            ** while (var8_8[var9_9] == 0)
        }
lbl36:
        // 1 sources

        this.baseG = new byte[var10_10];
        System.arraycopy(var8_8, var9_9, this.baseG, 0, var10_10);
        if (this.baseG.length > this.primeP.length) {
            throw new JSAFE_InvalidKeyException("Invalid DSA base size.");
        }
        if (this.baseG.length == this.primeP.length) {
            var13_13 = 0;
            while (var13_13 < this.baseG.length) {
                if ((this.baseG[var13_13] & 255) < (this.primeP[var13_13] & 255)) break;
                if ((this.baseG[var13_13] & 255) > (this.primeP[var13_13] & 255)) {
                    throw new JSAFE_InvalidKeyException("Invalid DSA base size.");
                }
                ++var13_13;
            }
            if (var13_13 >= this.baseG.length) {
                throw new JSAFE_InvalidKeyException("Invalid DSA base size.");
            }
        }
    }

    void loadPrivateValue(byte[] byArray, int n, int n2) throws JSAFE_InvalidKeyException {
        this.clearKeys();
        while (byArray[n] == 0) {
            --n2;
            ++n;
        }
        this.privateValueX = new byte[n2];
        System.arraycopy(byArray, n, this.privateValueX, 0, n2);
        if (this.primeP == null || this.subPrimeQ == null || this.baseG == null) {
            this.privateOI = JSAFE_Obfuscator.register(this.privateValueX);
            this.privateOI.obfuscate();
            return;
        }
        if (this.privateValueX.length > this.subPrimeQ.length) {
            throw new JSAFE_InvalidKeyException("DSA private value incompatible with previously stored parameters.");
        }
        if (this.privateValueX.length == this.subPrimeQ.length) {
            int n3 = 0;
            while (n3 < this.privateValueX.length) {
                if ((this.privateValueX[n3] & 0xFF) < (this.subPrimeQ[n3] & 0xFF)) break;
                if ((this.privateValueX[n3] & 0xFF) > (this.subPrimeQ[n3] & 0xFF)) {
                    throw new JSAFE_InvalidKeyException("DSA private value incompatible with previously stored parameters.");
                }
                ++n3;
            }
            if (n3 >= this.privateValueX.length) {
                throw new JSAFE_InvalidKeyException("DSA private value incompatible with previously stored parameters.");
            }
        }
        this.privateOI = JSAFE_Obfuscator.register(this.privateValueX);
        this.privateOI.obfuscate();
    }

    public int getMaximumKeyLength() {
        return 2048;
    }

    public int getMinimumKeyLength() {
        return 256;
    }

    public byte[][] getKeyData(String string) throws JSAFE_UnimplementedException {
        if (string.compareTo("DSAPrivateKeyBER") == 0) {
            return this.getKeyDataBER(null);
        }
        if (string.compareTo("DSAPrivateKeyX957BER") == 0) {
            return this.getKeyDataBER("DSAX957");
        }
        if (string.compareTo("DSAPrivateValue") == 0) {
            return this.getKeyDataPrivateValue();
        }
        if (string.compareTo("DSAPrivateKey") != 0) {
            throw new JSAFE_UnimplementedException("Unknown DSA key data format.");
        }
        return this.getKeyData();
    }

    public byte[][] getKeyData() {
        if (this.primeP == null || this.subPrimeQ == null || this.baseG == null || this.privateValueX == null) {
            return new byte[0][];
        }
        byte[] byArray = new byte[this.primeP.length];
        System.arraycopy(this.primeP, 0, byArray, 0, this.primeP.length);
        byte[] byArray2 = new byte[this.subPrimeQ.length];
        System.arraycopy(this.subPrimeQ, 0, byArray2, 0, this.subPrimeQ.length);
        byte[] byArray3 = new byte[this.baseG.length];
        System.arraycopy(this.baseG, 0, byArray3, 0, this.baseG.length);
        byte[] byArray4 = new byte[this.privateValueX.length];
        this.privateOI.deobfuscate();
        System.arraycopy(this.privateValueX, 0, byArray4, 0, this.privateValueX.length);
        this.privateOI.obfuscate();
        byte[][] byArrayArray = new byte[][]{byArray, byArray2, byArray3, byArray4};
        return byArrayArray;
    }

    private byte[][] getKeyDataPrivateValue() {
        if (this.privateValueX == null) {
            return new byte[0][];
        }
        byte[] byArray = new byte[this.privateValueX.length];
        this.privateOI.deobfuscate();
        System.arraycopy(this.privateValueX, 0, byArray, 0, this.privateValueX.length);
        this.privateOI.obfuscate();
        byte[][] byArrayArray = new byte[][]{byArray};
        return byArrayArray;
    }

    private byte[][] getKeyDataBER(String string) {
        if (this.privateValueX == null) {
            return new byte[0][];
        }
        this.privateOI.deobfuscate();
        try {
            try {
                byte[][] byArrayArray;
                byte[] byArray = JA_DSAPrivateKeyBER.getKeyDataBER(string, this.primeP, this.subPrimeQ, this.baseG, this.privateValueX);
                byte[][] byArrayArray2 = byArrayArray = new byte[][]{byArray};
                Object var6_7 = null;
                this.privateOI.obfuscate();
                return byArrayArray2;
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                byte[][] byArrayArray = new byte[][]{};
                Object var6_8 = null;
                this.privateOI.obfuscate();
                return byArrayArray;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.privateOI.obfuscate();
            throw throwable;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    protected void prepareSerialization() {
        if (this.privateOI != null) {
            this.privateOI.deobfuscate();
        }
    }

    protected void restoreAfterSerialization() {
        if (this.privateOI != null) {
            this.privateOI.obfuscate();
        }
    }

    protected void restoreAfterDeserialization() {
        if (this.privateValueX != null) {
            this.privateOI = JSAFE_Obfuscator.register(this.privateValueX);
            this.privateOI.obfuscate();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof JA_DSAPrivateKey)) {
            return false;
        }
        return this.dataEquals(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean dataEquals(Object object) {
        byte[][] byArray;
        block33: {
            int n;
            block34: {
                boolean bl;
                block32: {
                    boolean bl2;
                    block31: {
                        block30: {
                            boolean bl3;
                            block29: {
                                byArray = null;
                                try {
                                    try {
                                        JSAFE_PrivateKey jSAFE_PrivateKey = (JSAFE_PrivateKey)object;
                                        if (this.privateValueX == null) {
                                            if (jSAFE_PrivateKey.getAlgorithm().compareTo("DSA") != 0) {
                                                bl3 = false;
                                                Object var10_9 = null;
                                                if (byArray == null) return bl3;
                                                break block29;
                                            } else {
                                                String[] stringArray = jSAFE_PrivateKey.getSupportedGetFormats();
                                                int n2 = 0;
                                                while (true) {
                                                    if (n2 >= stringArray.length) break;
                                                    if (stringArray[n2].equals("DSAPrivateKey")) {
                                                        boolean bl4 = false;
                                                        Object var10_10 = null;
                                                        if (byArray == null) return bl4;
                                                        if (byArray.length == 1) {
                                                            this.overwrite(byArray[0]);
                                                            return bl4;
                                                        }
                                                        this.overwrite(byArray[3]);
                                                        return bl4;
                                                    }
                                                    ++n2;
                                                }
                                                boolean bl5 = true;
                                                Object var10_11 = null;
                                                if (byArray == null) return bl5;
                                                if (byArray.length == 1) {
                                                    this.overwrite(byArray[0]);
                                                    return bl5;
                                                }
                                                this.overwrite(byArray[3]);
                                                return bl5;
                                            }
                                        }
                                        if (this.primeP == null || this.subPrimeQ == null || this.baseG == null) {
                                            String[] stringArray = jSAFE_PrivateKey.getSupportedGetFormats();
                                            n = 0;
                                            while (n < stringArray.length && stringArray[n].compareTo("DSAPrivateValue") == 0) {
                                                n += 1;
                                            }
                                            if (n != stringArray.length) {
                                                boolean bl6 = false;
                                                Object var10_12 = null;
                                                if (byArray == null) return bl6;
                                                if (byArray.length == 1) {
                                                    this.overwrite(byArray[0]);
                                                    return bl6;
                                                }
                                                this.overwrite(byArray[3]);
                                                return bl6;
                                            }
                                            byArray = jSAFE_PrivateKey.getKeyData("DSAPrivateValue");
                                        } else {
                                            byArray = jSAFE_PrivateKey.getKeyData("DSAPrivateKey");
                                        }
                                        int n3 = 0;
                                        if (byArray.length > 1) {
                                            if (!this.compareKeyArrays(this.primeP, null, byArray[0], null)) {
                                                n = 0;
                                                break block30;
                                            }
                                            if (!this.compareKeyArrays(this.subPrimeQ, null, byArray[1], null)) {
                                                bl2 = false;
                                                break block31;
                                            }
                                            if (!this.compareKeyArrays(this.baseG, null, byArray[2], null)) {
                                                bl = false;
                                                break block32;
                                            }
                                            n3 = 3;
                                        }
                                        if (this.compareKeyArrays(this.privateValueX, this.privateOI, byArray[n3], null)) break block33;
                                        n = 0;
                                        break block34;
                                    }
                                    catch (Exception exception) {
                                        boolean bl7 = false;
                                        Object var10_18 = null;
                                        if (byArray == null) return bl7;
                                        if (byArray.length == 1) {
                                            this.overwrite((byte[])byArray[0]);
                                            return bl7;
                                        }
                                        this.overwrite((byte[])byArray[3]);
                                        return bl7;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var10_19 = null;
                                    if (byArray == null) throw throwable;
                                    if (byArray.length == 1) {
                                        this.overwrite((byte[])byArray[0]);
                                        throw throwable;
                                    }
                                    this.overwrite((byte[])byArray[3]);
                                    throw throwable;
                                }
                            }
                            if (byArray.length == 1) {
                                this.overwrite(byArray[0]);
                                return bl3;
                            }
                            this.overwrite(byArray[3]);
                            return bl3;
                        }
                        Object var10_13 = null;
                        if (byArray == null) return n;
                        if (byArray.length == 1) {
                            this.overwrite(byArray[0]);
                            return n;
                        }
                        this.overwrite(byArray[3]);
                        return n;
                    }
                    Object var10_14 = null;
                    if (byArray == null) return bl2;
                    if (byArray.length == 1) {
                        this.overwrite(byArray[0]);
                        return bl2;
                    }
                    this.overwrite(byArray[3]);
                    return bl2;
                }
                Object var10_15 = null;
                if (byArray == null) return bl;
                if (byArray.length == 1) {
                    this.overwrite(byArray[0]);
                    return bl;
                }
                this.overwrite(byArray[3]);
                return bl;
            }
            Object var10_16 = null;
            if (byArray == null) return n;
            if (byArray.length == 1) {
                this.overwrite(byArray[0]);
                return n;
            }
            this.overwrite(byArray[3]);
            return n;
        }
        Object var10_17 = null;
        if (byArray == null) return true;
        if (byArray.length == 1) {
            this.overwrite(byArray[0]);
            return true;
        }
        this.overwrite(byArray[3]);
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_DSAPrivateKey jA_DSAPrivateKey = new JA_DSAPrivateKey();
        this.copyContents(jA_DSAPrivateKey);
        return jA_DSAPrivateKey;
    }

    protected void copyContents(JA_DSAPrivateKey jA_DSAPrivateKey) throws CloneNotSupportedException {
        if (this.primeP != null) {
            jA_DSAPrivateKey.primeP = (byte[])this.primeP.clone();
        }
        if (this.subPrimeQ != null) {
            jA_DSAPrivateKey.subPrimeQ = (byte[])this.subPrimeQ.clone();
        }
        if (this.baseG != null) {
            jA_DSAPrivateKey.baseG = (byte[])this.baseG.clone();
        }
        if (this.privateValueX != null) {
            jA_DSAPrivateKey.privateValueX = (byte[])JSAFE_Obfuscator.copy(this.privateValueX, this.privateOI);
            jA_DSAPrivateKey.privateOI = JSAFE_Obfuscator.getObfuscatorItem(jA_DSAPrivateKey.privateValueX);
        }
        jA_DSAPrivateKey.primeLen = this.primeLen;
        jA_DSAPrivateKey.subPrimeLen = this.subPrimeLen;
        jA_DSAPrivateKey.setJSAFELevelValues(this);
    }

    private void clearKeys() {
        if (this.privateValueX == null) {
            return;
        }
        JSAFE_Obfuscator.deregister(this.privateValueX, this.privateOI);
        this.privateValueX = null;
        this.privateOI = null;
    }

    private void clearParameters() {
        this.baseG = null;
        this.subPrimeQ = null;
        this.primeP = null;
        this.subPrimeLen = 0;
        this.primeLen = 0;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.clearKeys();
        this.clearParameters();
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

