/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.jsafe.JA_DSAPrivateKey;
import com.rsa.jsafe.JA_PrivateKeyBER;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;

final class JA_DSAPrivateKeyBER
extends JSAFE_Object {
    JA_DSAPrivateKeyBER() {
    }

    static void setKeyDataBER(JA_DSAPrivateKey jA_DSAPrivateKey, byte[] byArray, int n) throws JSAFE_InvalidKeyException {
        OIDContainer oIDContainer = new OIDContainer(0, 3);
        EncodedContainer encodedContainer = new EncodedContainer(77824);
        OctetStringContainer octetStringContainer = new OctetStringContainer(0);
        JA_PrivateKeyBER.berDecodePrivateKeyInfo(byArray, n, oIDContainer, encodedContainer, octetStringContainer);
        if (oIDContainer.transformation.compareTo("DSA") != 0) {
            throw new JSAFE_InvalidKeyException("Invalid DSA private key BER encoding.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        IntegerContainer integerContainer = new IntegerContainer(0);
        ASN1Container[] aSN1ContainerArray = null;
        aSN1ContainerArray = octetStringContainer.data[octetStringContainer.dataOffset] == 2 ? new ASN1Container[]{integerContainer} : new ASN1Container[]{sequenceContainer, integerContainer, endContainer};
        try {
            ASN1.berDecode(octetStringContainer.data, octetStringContainer.dataOffset, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_InvalidKeyException("Could not decode DSA key from BER: " + aSN_Exception.getMessage());
        }
        if (encodedContainer.dataPresent) {
            OfContainer ofContainer = null;
            try {
                ofContainer = new OfContainer(0, 12288, new IntegerContainer(0));
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{ofContainer};
                ASN1.berDecode(encodedContainer.data, encodedContainer.dataOffset, aSN1ContainerArray2);
            }
            catch (ASN_Exception aSN_Exception) {
                throw new JSAFE_InvalidKeyException("Could not decode DSA key from BER: (" + aSN_Exception.getMessage() + ")");
            }
            int n2 = ofContainer.getContainerCount();
            if (n2 != 4 && n2 != 3) {
                throw new JSAFE_InvalidKeyException("Could not read the DSA parameters BER.");
            }
            IntegerContainer[] integerContainerArray = new IntegerContainer[n2];
            int n3 = -1;
            try {
                int n4 = 0;
                while (n4 < n2) {
                    integerContainerArray[n4] = (IntegerContainer)ofContainer.containerAt(n4);
                    ++n4;
                }
                if (n2 == 4) {
                    n3 = integerContainerArray[0].getValueAsInt();
                }
            }
            catch (ASN_Exception aSN_Exception) {
                throw new JSAFE_InvalidKeyException("Could not read the DSA parameters BER: (" + aSN_Exception.getMessage() + ")");
            }
            jA_DSAPrivateKey.loadSystemParameters(n3, integerContainerArray[n2 -= 3].data, integerContainerArray[n2].dataOffset, integerContainerArray[n2].dataLen, integerContainerArray[n2 + 1].data, integerContainerArray[n2 + 1].dataOffset, integerContainerArray[n2 + 1].dataLen, integerContainerArray[n2 + 2].data, integerContainerArray[n2 + 2].dataOffset, integerContainerArray[n2 + 2].dataLen);
        }
        jA_DSAPrivateKey.loadPrivateValue(integerContainer.data, integerContainer.dataOffset, integerContainer.dataLen);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static byte[] getKeyDataBER(String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws JSAFE_InvalidKeyException {
        ASN1Container[] aSN1ContainerArray;
        Object object;
        Object object2;
        IntegerContainer integerContainer;
        Object object3;
        byte[] byArray5 = null;
        if (byArray != null && byArray3 != null && byArray2 != null) {
            try {
                object3 = new OfContainer(65536, true, 0, 12288, new IntegerContainer(0));
                if (string == null) {
                    int n = byArray.length * 8;
                    int n2 = byArray[0] & 0xFF;
                    while ((n2 & 0x80) == 0) {
                        --n;
                        n2 <<= 1;
                    }
                    integerContainer = new IntegerContainer(0, true, 0, n);
                    ((OfContainer)object3).addContainer(integerContainer);
                }
                object2 = new IntegerContainer(0, true, 0, byArray, 0, byArray.length, true);
                object = new IntegerContainer(0, true, 0, byArray2, 0, byArray2.length, true);
                integerContainer = new IntegerContainer(0, true, 0, byArray3, 0, byArray3.length, true);
                ((OfContainer)object3).addContainer((ASN1Container)object2);
                ((OfContainer)object3).addContainer((ASN1Container)object);
                ((OfContainer)object3).addContainer(integerContainer);
                aSN1ContainerArray = new ASN1Container[]{object3};
                byArray5 = ASN1.derEncode(aSN1ContainerArray);
            }
            catch (ASN_Exception aSN_Exception) {
                throw new JSAFE_InvalidKeyException("Could not compute the DSA parameters BER: (" + aSN_Exception.getMessage() + ")");
            }
        }
        object3 = null;
        try {
            object2 = new SequenceContainer(0, true, 0);
            object = new EndContainer();
            integerContainer = new IntegerContainer(0, true, 0, byArray4, 0, byArray4.length, true);
            aSN1ContainerArray = null;
            aSN1ContainerArray = string != null ? new ASN1Container[]{integerContainer} : new ASN1Container[]{object2, integerContainer, object};
            object3 = ASN1.derEncode(aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_InvalidKeyException("Could not compute DSA private key BER: (" + aSN_Exception.getMessage() + ")");
        }
        object2 = "DSA";
        if (string != null) {
            object2 = string;
        }
        try {
            object = JA_PrivateKeyBER.derEncodePrivateKeyInfo((String)object2, byArray5, (byte[])object3);
            Object var12_15 = null;
            if (object3 == null) return object;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (object3 == null) throw throwable;
            JSAFE_Obfuscator.overwrite(object3);
            throw throwable;
        }
        JSAFE_Obfuscator.overwrite(object3);
        return object;
    }
}

