/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_DSAPublicKeyBER;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;

public class JA_DSAPublicKey
extends JSAFE_PublicKey
implements JSAFE_Key,
Cloneable,
Serializable {
    private int primeLen;
    private int subPrimeLen;
    private byte[] primeP;
    private byte[] subPrimeQ;
    private byte[] baseG;
    private byte[] publicValueY;

    public String getAlgorithm() {
        return "DSA";
    }

    public String[] getSupportedSetFormats() {
        String[] stringArray = new String[]{"DSAPublicKey", "DSAPublicValue", "DSAPublicKeyBER", "DSAPublicKeyX957BER"};
        return stringArray;
    }

    public String[] getSupportedGetFormats() {
        if (this.publicValueY == null) {
            return new String[0];
        }
        if (this.primeP == null || this.subPrimeQ == null || this.baseG == null) {
            String[] stringArray = new String[]{"DSAPublicValue", "DSAPublicKeyBER", "DSAPublicKeyX957BER"};
            return stringArray;
        }
        String[] stringArray = new String[]{"DSAPublicKey", "DSAPublicValue", "DSAPublicKeyBER", "DSAPublicKeyX957BER"};
        return stringArray;
    }

    public void setKeyData(String string, byte[][] byArray) throws JSAFE_UnimplementedException, JSAFE_InvalidKeyException {
        if (string.compareTo("DSAPublicKeyBER") == 0 || string.compareTo("DSAPublicKeyX957BER") == 0) {
            this.clearKeys();
            if (byArray == null || byArray.length != 1) {
                throw new JSAFE_UnimplementedException("Invalid BER DSA public key data.");
            }
            JA_DSAPublicKeyBER.setKeyDataBER(this, byArray[0], 0);
            return;
        }
        if (string.compareTo("DSAPublicKey") == 0) {
            this.setKeyData(byArray);
            return;
        }
        if (string.compareTo("DSAPublicValue") == 0) {
            this.setKeyDataPublicValue(byArray);
            return;
        }
        this.clearKeys();
        throw new JSAFE_UnimplementedException("Unknown DSA key data format.");
    }

    public void setKeyData(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.clearKeys();
        this.clearParameters();
        if (byArray == null || byArray.length != 4) {
            throw new JSAFE_InvalidKeyException("Invalid input for DSA key. Expects {prime, subPrime, base, privateValue}");
        }
        try {
            this.loadSystemParameters(-1, byArray[0], 0, byArray[0].length, byArray[1], 0, byArray[1].length, byArray[2], 0, byArray[2].length);
            this.loadPublicValue(byArray[3], 0, byArray[3].length);
        }
        catch (NullPointerException nullPointerException) {
            throw new JSAFE_InvalidKeyException("Invalid input for DSA key.");
        }
    }

    private void setKeyDataPublicValue(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.clearKeys();
        if (byArray == null || byArray.length != 1) {
            throw new JSAFE_InvalidKeyException("Invalid input for DSA key.");
        }
        if (byArray[0] == null) {
            throw new JSAFE_InvalidKeyException("Invalid input for DSA key.");
        }
        this.loadPublicValue(byArray[0], 0, byArray[0].length);
    }

    void setKeyDataBER(byte[] byArray, int n) throws JSAFE_InvalidKeyException {
        this.clearKeys();
        JA_DSAPublicKeyBER.setKeyDataBER(this, byArray, n);
    }

    /*
     * Unable to fully structure code
     */
    void loadSystemParameters(int var1_1, byte[] var2_2, int var3_3, int var4_4, byte[] var5_5, int var6_6, int var7_7, byte[] var8_8, int var9_9, int var10_10) throws JSAFE_InvalidKeyException {
        this.clearParameters();
        while (var2_2[var3_3] == 0) {
            --var4_4;
            ++var3_3;
        }
        this.primeP = new byte[var4_4];
        System.arraycopy(var2_2, var3_3, this.primeP, 0, var4_4);
        this.primeLen = this.primeP.length * 8;
        var11_11 = this.primeP[0] & 255;
        var12_12 = var11_11 & 128;
        while (var12_12 == 0) {
            --this.primeLen;
            var12_12 = (var11_11 <<= 1) & 128;
        }
        if (var1_1 != -1 && this.primeLen > var1_1) {
            throw new JSAFE_InvalidKeyException("DSA prime size mismatch.");
        }
        if (this.primeLen >= 256 && this.primeLen <= 2048) ** GOTO lbl21
        throw new JSAFE_InvalidKeyException("Invalid DSA prime size.");
lbl-1000:
        // 1 sources

        {
            --var7_7;
            ++var6_6;
lbl21:
            // 2 sources

            ** while (var5_5[var6_6] == 0)
        }
lbl22:
        // 1 sources

        this.subPrimeQ = new byte[var7_7];
        System.arraycopy(var5_5, var6_6, this.subPrimeQ, 0, var7_7);
        this.subPrimeLen = this.subPrimeQ.length * 8;
        var11_11 = this.subPrimeQ[0] & 255;
        var12_12 = var11_11 & 128;
        while (var12_12 == 0) {
            --this.subPrimeLen;
            var12_12 = (var11_11 <<= 1) & 128;
        }
        if (this.subPrimeLen >= 160 && this.subPrimeLen <= 160) ** GOTO lbl35
        throw new JSAFE_InvalidKeyException("Invalid DSA subprime size.");
lbl-1000:
        // 1 sources

        {
            --var10_10;
            ++var9_9;
lbl35:
            // 2 sources

            ** while (var8_8[var9_9] == 0)
        }
lbl36:
        // 1 sources

        this.baseG = new byte[var10_10];
        System.arraycopy(var8_8, var9_9, this.baseG, 0, var10_10);
        if (this.baseG.length > this.primeP.length) {
            throw new JSAFE_InvalidKeyException("Invalid DSA base size.");
        }
        if (this.baseG.length == this.primeP.length) {
            var13_13 = 0;
            while (var13_13 < this.baseG.length) {
                if ((this.baseG[var13_13] & 255) < (this.primeP[var13_13] & 255)) break;
                if ((this.baseG[var13_13] & 255) > (this.primeP[var13_13] & 255)) {
                    throw new JSAFE_InvalidKeyException("Invalid DSA base size.");
                }
                ++var13_13;
            }
            if (var13_13 >= this.baseG.length) {
                throw new JSAFE_InvalidKeyException("Invalid DSA base size.");
            }
        }
    }

    void loadPublicValue(byte[] byArray, int n, int n2) throws JSAFE_InvalidKeyException {
        this.clearKeys();
        while (byArray[n] == 0) {
            --n2;
            ++n;
        }
        this.publicValueY = new byte[n2];
        System.arraycopy(byArray, n, this.publicValueY, 0, n2);
        if (this.primeP == null || this.subPrimeQ == null || this.baseG == null) {
            return;
        }
        if (this.publicValueY.length > this.primeP.length) {
            throw new JSAFE_InvalidKeyException("DSA public value incompatible with previously stored parameters.");
        }
        if (this.publicValueY.length == this.primeP.length) {
            int n3 = 0;
            while (n3 < this.publicValueY.length) {
                if ((this.publicValueY[n3] & 0xFF) < (this.primeP[n3] & 0xFF)) break;
                if ((this.publicValueY[n3] & 0xFF) > (this.primeP[n3] & 0xFF)) {
                    throw new JSAFE_InvalidKeyException("DSA public value incompatible with previously stored parameters.");
                }
                ++n3;
            }
            if (n3 >= this.publicValueY.length) {
                throw new JSAFE_InvalidKeyException("DSA public value incompatible with previously stored parameters.");
            }
        }
    }

    public int getMaximumKeyLength() {
        return 2048;
    }

    public int getMinimumKeyLength() {
        return 256;
    }

    public byte[][] getKeyData(String string) throws JSAFE_UnimplementedException {
        if (string.compareTo("DSAPublicKeyBER") == 0) {
            return this.getKeyDataBER(null);
        }
        if (string.compareTo("DSAPublicKeyX957BER") == 0) {
            return this.getKeyDataBER("DSAX957");
        }
        if (string.compareTo("DSAPublicValue") == 0) {
            return this.getKeyDataPublicValue();
        }
        if (string.compareTo("DSAPublicKey") != 0) {
            throw new JSAFE_UnimplementedException("Unknown DSA key data format.");
        }
        return this.getKeyData();
    }

    public byte[][] getKeyData() {
        if (this.primeP == null || this.subPrimeQ == null || this.baseG == null || this.publicValueY == null) {
            return new byte[0][];
        }
        byte[] byArray = new byte[this.primeP.length];
        System.arraycopy(this.primeP, 0, byArray, 0, this.primeP.length);
        byte[] byArray2 = new byte[this.subPrimeQ.length];
        System.arraycopy(this.subPrimeQ, 0, byArray2, 0, this.subPrimeQ.length);
        byte[] byArray3 = new byte[this.baseG.length];
        System.arraycopy(this.baseG, 0, byArray3, 0, this.baseG.length);
        byte[] byArray4 = new byte[this.publicValueY.length];
        System.arraycopy(this.publicValueY, 0, byArray4, 0, this.publicValueY.length);
        byte[][] byArrayArray = new byte[][]{byArray, byArray2, byArray3, byArray4};
        return byArrayArray;
    }

    private byte[][] getKeyDataPublicValue() {
        if (this.publicValueY == null) {
            return new byte[0][];
        }
        byte[] byArray = new byte[this.publicValueY.length];
        System.arraycopy(this.publicValueY, 0, byArray, 0, this.publicValueY.length);
        byte[][] byArrayArray = new byte[][]{byArray};
        return byArrayArray;
    }

    private byte[][] getKeyDataBER(String string) {
        if (this.publicValueY == null) {
            return new byte[0][];
        }
        try {
            byte[] byArray = JA_DSAPublicKeyBER.getKeyDataBER(string, this.primeP, this.subPrimeQ, this.baseG, this.publicValueY);
            byte[][] byArrayArray = new byte[][]{byArray};
            return byArrayArray;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return new byte[0][];
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof JA_DSAPublicKey)) {
            return false;
        }
        return this.dataEquals(object);
    }

    public boolean dataEquals(Object object) {
        try {
            byte[][] byArray;
            JSAFE_PublicKey jSAFE_PublicKey = (JSAFE_PublicKey)object;
            if (this.publicValueY == null) {
                if (jSAFE_PublicKey.getAlgorithm().compareTo("DSA") != 0) {
                    return false;
                }
                String[] stringArray = jSAFE_PublicKey.getSupportedGetFormats();
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].equals("DSAPublicKey")) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            if (this.primeP == null || this.subPrimeQ == null || this.baseG == null) {
                String[] stringArray = jSAFE_PublicKey.getSupportedGetFormats();
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].compareTo("DSAPublicValue") != 0) break;
                    ++n;
                }
                if (n != stringArray.length) {
                    return false;
                }
                byArray = jSAFE_PublicKey.getKeyData("DSAPublicValue");
            } else {
                byArray = jSAFE_PublicKey.getKeyData("DSAPublicKey");
            }
            int n = 0;
            if (byArray.length > 1) {
                if (!this.compareKeyArrays(this.primeP, null, byArray[0], null)) {
                    return false;
                }
                if (!this.compareKeyArrays(this.subPrimeQ, null, byArray[1], null)) {
                    return false;
                }
                if (!this.compareKeyArrays(this.baseG, null, byArray[2], null)) {
                    return false;
                }
                n = 3;
            }
            if (!this.compareKeyArrays(this.publicValueY, null, byArray[n], null)) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_DSAPublicKey jA_DSAPublicKey = new JA_DSAPublicKey();
        this.copyContents(jA_DSAPublicKey);
        return jA_DSAPublicKey;
    }

    protected void copyContents(JA_DSAPublicKey jA_DSAPublicKey) throws CloneNotSupportedException {
        if (this.primeP != null) {
            jA_DSAPublicKey.primeP = (byte[])this.primeP.clone();
        }
        if (this.subPrimeQ != null) {
            jA_DSAPublicKey.subPrimeQ = (byte[])this.subPrimeQ.clone();
        }
        if (this.baseG != null) {
            jA_DSAPublicKey.baseG = (byte[])this.baseG.clone();
        }
        if (this.publicValueY != null) {
            jA_DSAPublicKey.publicValueY = (byte[])this.publicValueY.clone();
        }
        jA_DSAPublicKey.primeLen = this.primeLen;
        jA_DSAPublicKey.subPrimeLen = this.subPrimeLen;
        jA_DSAPublicKey.setJSAFELevelValues(this);
    }

    private void clearKeys() {
        this.publicValueY = null;
    }

    private void clearParameters() {
        this.baseG = null;
        this.subPrimeQ = null;
        this.primeP = null;
        this.subPrimeLen = 0;
        this.primeLen = 0;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.clearKeys();
        this.clearParameters();
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

