/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.CryptoJ;
import com.rsa.jsafe.JA_SHA1;
import com.rsa.jsafe.JCMPInt;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class JA_FIPS186DSAKeyGenPRNG
extends JSAFE_Object
implements Cloneable,
Serializable {
    private static final int BLOCK_SIZE = 20;
    protected JA_SHA1 digester;
    private byte[] padBuffer = new byte[44];
    private JCMPInt jcmpQ;
    private JCMPInt valueToReduce = null;
    private JCMPInt reducedValue = null;
    private byte[] XKEY = new byte[20];
    private transient ObfuscatorItem XKEY_OI = null;
    private static final byte[] theQ = new byte[]{-78, 13, -80, -79, 1, -33, 12, 102, 36, -4, 19, -110, -70, 85, -9, 125, 87, 116, -127, -27};
    private static final byte[] demoXKEY = new byte[]{-48, 25, -117, 0, -8, 25, -117, 0, -28, 25, -117, 0, 0, 0, 0, 0, -16, 88, 77, 0};
    private static final byte[] nistXKEY = new byte[]{18, 52, 86, 120, -112, 18, 52, 86, 120, -112, 18, 52, 86, 120, -112, 18, 52, 86, 120, -112};
    protected static final byte[] sampleXKEY = new byte[]{-67, 2, -101, -66, 127, 81, -106, 11, -49, -98, -37, 43, 97, -16, 111, 15, -21, 90, 56, -74};
    private boolean firstTime;
    private byte[] previousBlock;
    private transient ObfuscatorItem previousBlockOI;

    protected void commonInit() {
        this.firstTime = true;
        this.previousBlock = new byte[20];
        if (this.previousBlockOI == null) {
            this.previousBlockOI = JSAFE_Obfuscator.register(this.previousBlock);
        }
    }

    protected JA_FIPS186DSAKeyGenPRNG() {
        this.commonInit();
    }

    public JA_FIPS186DSAKeyGenPRNG(byte[] byArray) throws JSAFE_InvalidParameterException {
        this.commonInit();
        this.jcmpQ = new JCMPInt();
        this.jcmpQ.setValue(theQ, 0, theQ.length);
        this.valueToReduce = new JCMPInt();
        this.reducedValue = new JCMPInt();
        this.digester = this.initDigester();
        if (byArray != null) {
            if (byArray.length == 20) {
                System.arraycopy(byArray, 0, this.XKEY, 0, 20);
                this.XKEY_OI = JSAFE_Obfuscator.register(this.XKEY);
                return;
            }
            throw new JSAFE_InvalidParameterException("The seed should be precisely 20 bytes long.");
        }
    }

    protected JA_SHA1 initDigester() {
        return new JA_SHA1();
    }

    public String getAlgorithm() {
        return "JA_FIPS186DSAKeyGenPRNG";
    }

    void prngCheck(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            if (byArray[n + n4] != byArray2[n2 + n4]) {
                return;
            }
            ++n4;
        }
        CryptoJ.verified = 2;
        throw new RuntimeException("Continuous Random Number Generator check has failed. Crypto-J has entered a FAILED state and is inoperable");
    }

    private void doGenerateRandomBytes(byte[] byArray, int n, int n2) {
        this.deobfuscate();
        while (n2 > 0) {
            n2 -= this.generateBlock(n2, this.XKEY, byArray, n);
            n += 20;
        }
        this.digester.digestInit();
        this.obfuscate();
    }

    public void generateRandomBytes(byte[] byArray, int n, int n2) {
        if (this.firstTime) {
            this.generateFirstBlock();
        }
        this.doGenerateRandomBytes(byArray, n, n2);
    }

    protected void generateFirstBlock() {
        byte[] byArray = this.XKEY;
        byte[] byArray2 = this.modQGHash(byArray);
        System.arraycopy(byArray2, 0, this.previousBlock, 0, 20);
        this.firstTime = false;
        int n = 1;
        int n2 = 19;
        while (n2 >= 0) {
            this.XKEY[n2] = (byte)(n += (byArray2[n2] & 0xFF) + (this.XKEY[n2] & 0xFF));
            n >>>= 8;
            --n2;
        }
        System.arraycopy(this.padBuffer, 0, byArray2, 0, 20);
    }

    protected int generateBlock(int n, byte[] byArray, byte[] byArray2, int n2) {
        int n3 = n < 20 ? n : 20;
        byte[] byArray3 = byArray;
        byte[] byArray4 = this.modQGHash(byArray3);
        System.arraycopy(byArray4, 0, byArray2, n2, n3);
        this.prngCheck(this.previousBlock, 0, byArray4, 0, 20);
        System.arraycopy(byArray4, 0, this.previousBlock, 0, 20);
        int n4 = 1;
        int n5 = 19;
        while (n5 >= 0) {
            byArray[n5] = (byte)(n4 += (byArray4[n5] & 0xFF) + (byArray[n5] & 0xFF));
            n4 >>>= 8;
            --n5;
        }
        System.arraycopy(this.padBuffer, 0, byArray4, 0, 20);
        return n3;
    }

    protected byte[] modQGHash(byte[] byArray) {
        try {
            try {
                byte[] byArray2;
                this.digester.digestInit();
                this.digester.digestUpdate(byArray, 0, byArray.length);
                int n = 64 - byArray.length;
                this.digester.digestUpdate(this.padBuffer, 0, n);
                byte[] byArray3 = new byte[20];
                this.digester.getState(byArray3, 0);
                JCMPInt jCMPInt = new JCMPInt();
                jCMPInt.setValue(byArray3, 0, 20);
                JCMPInt jCMPInt2 = new JCMPInt();
                jCMPInt.modReduce(this.jcmpQ, jCMPInt2);
                System.arraycopy(this.padBuffer, 0, byArray3, 0, byArray3.length);
                byte[] byArray4 = byArray2 = jCMPInt2.toFixedLenOctetString(20);
                Object var9_10 = null;
                if (this.valueToReduce != null) {
                    this.valueToReduce.clearSensitiveData();
                }
                if (this.reducedValue != null) {
                    this.reducedValue.clearSensitiveData();
                }
                return byArray4;
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                byte[] byArray5 = new byte[20];
                Object var9_11 = null;
                if (this.valueToReduce != null) {
                    this.valueToReduce.clearSensitiveData();
                }
                if (this.reducedValue != null) {
                    this.reducedValue.clearSensitiveData();
                }
                return byArray5;
            }
        }
        catch (Throwable throwable) {
            block9: {
                Object var9_12 = null;
                if (this.valueToReduce != null) {
                    this.valueToReduce.clearSensitiveData();
                }
                if (this.reducedValue == null) break block9;
                this.reducedValue.clearSensitiveData();
            }
            throw throwable;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        this.restoreAfterDeserialization();
    }

    private void prepareSerialization() {
        if (this.XKEY_OI != null) {
            this.XKEY_OI.deobfuscate();
        }
        if (this.previousBlockOI != null) {
            this.previousBlockOI.deobfuscate();
        }
    }

    private void restoreAfterSerialization() {
        if (this.XKEY_OI != null) {
            this.XKEY_OI.obfuscate();
        }
        if (this.previousBlockOI != null) {
            this.previousBlockOI.obfuscate();
        }
    }

    private void restoreAfterDeserialization() {
        if (this.XKEY == null) {
            return;
        }
        this.XKEY_OI = JSAFE_Obfuscator.register(this.XKEY);
        this.XKEY_OI.obfuscate();
        this.previousBlockOI = JSAFE_Obfuscator.register(this.previousBlock);
        this.previousBlockOI.obfuscate();
    }

    private void obfuscate() {
        this.XKEY_OI.obfuscate();
    }

    private void deobfuscate() {
        this.XKEY_OI.deobfuscate();
    }

    public void clearSensitiveData() {
        if (this.digester != null) {
            this.digester.clearSensitiveData();
        }
        JSAFE_Obfuscator.overwrite(this.XKEY);
        JSAFE_Obfuscator.deregister(this.XKEY, this.XKEY_OI);
        JSAFE_Obfuscator.deregister(this.XKEY, this.XKEY_OI);
    }

    protected JA_FIPS186DSAKeyGenPRNG newEmptyObject() {
        return new JA_FIPS186DSAKeyGenPRNG();
    }

    public Object clone() throws CloneNotSupportedException {
        JA_FIPS186DSAKeyGenPRNG jA_FIPS186DSAKeyGenPRNG = this.newEmptyObject();
        if (this.digester != null) {
            jA_FIPS186DSAKeyGenPRNG.digester = (JA_SHA1)this.digester.clone();
        }
        jA_FIPS186DSAKeyGenPRNG.jcmpQ = this.jcmpQ;
        if (this.valueToReduce != null) {
            jA_FIPS186DSAKeyGenPRNG.valueToReduce = (JCMPInt)this.valueToReduce.clone();
        }
        if (this.reducedValue != null) {
            jA_FIPS186DSAKeyGenPRNG.reducedValue = (JCMPInt)this.reducedValue.clone();
        }
        if (this.XKEY_OI != null) {
            jA_FIPS186DSAKeyGenPRNG.XKEY = (byte[])JSAFE_Obfuscator.copy(this.XKEY, this.XKEY_OI);
            jA_FIPS186DSAKeyGenPRNG.XKEY_OI = JSAFE_Obfuscator.getObfuscatorItem(this.XKEY);
        }
        if (this.previousBlock != null) {
            jA_FIPS186DSAKeyGenPRNG.previousBlock = (byte[])JSAFE_Obfuscator.copy(this.previousBlock, this.previousBlockOI);
            jA_FIPS186DSAKeyGenPRNG.previousBlockOI = JSAFE_Obfuscator.getObfuscatorItem(jA_FIPS186DSAKeyGenPRNG.previousBlock);
        }
        return jA_FIPS186DSAKeyGenPRNG;
    }
}

