/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_AlgaeDigestMAC;
import com.rsa.jsafe.JA_HMACBER;
import com.rsa.jsafe.JA_HMACKey;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.SecureRandom;

final class JA_HMAC
extends JSAFE_Object
implements JA_AlgaeDigestMAC {
    private static final int BLOCK_SIZE = 64;
    private static final byte INNER_PAD = 54;
    private static final byte OUTER_PAD = 92;
    private static final int INNER_PADDING_START = 0;
    private static final int OUTER_PADDING_START = 64;
    private byte[] paddingBuffer;
    private transient ObfuscatorItem paddingBufferOI;
    private JA_AlgaeDigest digest;

    JA_HMAC() {
    }

    JA_HMAC(int[] nArray) throws JSAFE_InvalidParameterException {
    }

    public String getAlgorithm() {
        return "HMAC";
    }

    public void setAlgorithmBER(byte[] byArray, int n) {
    }

    public int getMACSize() {
        return this.digest.getDigestSize();
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Wrong Number of parameters: expected none");
        }
    }

    public int[] getInstantiationParameters() {
        return this.digest.getInstantiationParameters();
    }

    public byte[] getDERAlgorithmID(JA_AlgaeDigest jA_AlgaeDigest) throws JSAFE_UnimplementedException {
        return JA_HMACBER.getDERAlgorithmID(jA_AlgaeDigest);
    }

    public boolean isValidDigestAlgorithm(JA_AlgaeDigest jA_AlgaeDigest) {
        String string = jA_AlgaeDigest.getAlgorithm();
        return string.equals("MD5") || string.equals("SHA1");
    }

    public void macInit(JA_AlgaeDigest jA_AlgaeDigest, JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        if (this.digest != null) {
            this.digest.clearSensitiveData();
        }
        this.digest = jA_AlgaeDigest;
        if (jSAFE_SecretKey == null) {
            throw new JSAFE_InvalidKeyException("Invalid key");
        }
        if (!(jSAFE_SecretKey instanceof JA_HMACKey)) {
            throw new JSAFE_InvalidKeyException("Incorrect key type");
        }
        byte[] byArray = jSAFE_SecretKey.getSecretKeyData();
        int n = byArray.length;
        if (byArray.length > 64) {
            this.digest.digestInit();
            this.digest.digestUpdate(byArray, 0, byArray.length);
            n = this.digest.digestFinal(byArray, 0);
            this.digest.clearSensitiveData();
        }
        if (this.paddingBuffer == null) {
            this.paddingBuffer = new byte[128];
        }
        if (this.paddingBufferOI != null) {
            this.paddingBufferOI.overwrite();
        }
        System.arraycopy(byArray, 0, this.paddingBuffer, 0, n);
        System.arraycopy(byArray, 0, this.paddingBuffer, 64, n);
        JSAFE_Obfuscator.overwrite(byArray);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0 + n2;
            this.paddingBuffer[n3] = (byte)(this.paddingBuffer[n3] ^ 0x36);
            int n4 = 64 + n2;
            this.paddingBuffer[n4] = (byte)(this.paddingBuffer[n4] ^ 0x5C);
            ++n2;
        }
        while (n2 < 64) {
            this.paddingBuffer[0 + n2] = 54;
            this.paddingBuffer[64 + n2] = 92;
            ++n2;
        }
        this.digest.digestInit();
        this.digest.digestUpdate(this.paddingBuffer, 0, 64);
        if (this.paddingBufferOI == null) {
            this.paddingBufferOI = JSAFE_Obfuscator.register(this.paddingBuffer);
        }
        this.paddingBufferOI.obfuscate();
    }

    public void macReInit() throws JSAFE_InvalidUseException {
        this.deobfuscate();
        this.digest.digestInit();
        this.digest.digestUpdate(this.paddingBuffer, 0, 64);
        this.obfuscate();
    }

    public void macUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException {
        this.digest.digestUpdate(byArray, n, n2);
    }

    public int macFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException {
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        int n2 = this.digest.digestFinal(byArray2, 0);
        this.digest.digestInit();
        this.digest.digestUpdate(this.paddingBuffer, 64, 64);
        this.digest.digestUpdate(byArray2, 0, n2);
        int n3 = this.digest.digestFinal(byArray, n);
        int n4 = 0;
        while (n4 < n2) {
            byArray2[n4] = 0;
            ++n4;
        }
        return n3;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private void prepareSerialization() {
        if (this.paddingBufferOI != null) {
            this.paddingBufferOI.deobfuscate();
        }
    }

    private void restoreAfterSerialization() {
        if (this.paddingBufferOI != null) {
            this.paddingBufferOI.obfuscate();
        }
    }

    private void restoreAfterDeserialization() {
        if (this.paddingBuffer == null) {
            return;
        }
        this.paddingBufferOI = JSAFE_Obfuscator.register(this.paddingBuffer);
        this.paddingBufferOI.obfuscate();
    }

    public Object clone() throws CloneNotSupportedException {
        JA_HMAC jA_HMAC = new JA_HMAC();
        if (this.paddingBuffer != null) {
            jA_HMAC.paddingBuffer = (byte[])JSAFE_Obfuscator.copy(this.paddingBuffer, this.paddingBufferOI);
        }
        jA_HMAC.paddingBufferOI = JSAFE_Obfuscator.getObfuscatorItem(jA_HMAC.paddingBuffer);
        if (this.digest != null) {
            jA_HMAC.digest = (JA_AlgaeDigest)this.digest.clone();
        }
        return jA_HMAC;
    }

    public void obfuscate() {
        if (this.paddingBufferOI != null) {
            this.paddingBufferOI.obfuscate();
        }
    }

    public void deobfuscate() {
        if (this.paddingBufferOI != null) {
            this.paddingBufferOI.deobfuscate();
        }
    }

    public void clearSensitiveData() {
        if (this.digest != null) {
            this.digest.clearSensitiveData();
        }
        this.digest = null;
        JSAFE_Obfuscator.overwrite(this.paddingBuffer);
        this.paddingBufferOI = null;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

