/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Object;
import java.io.Serializable;

public class JA_MD2
extends JSAFE_Object
implements JA_AlgaeDigest,
Cloneable,
Serializable {
    private byte[] state = new byte[16];
    private byte[] checksum = new byte[16];
    private byte[] contextBuffer = new byte[16];
    private byte[] xArray = new byte[48];
    private int count;
    private static final byte[] ENCODE_PREFIX = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 2, 5, 0, 4, 16};
    private int objectState;
    private static final int NOT_INITIALIZED = 1;
    private static final int MD2_INITIALIZED = 2;
    private static final int MD2_FINALIZED = 3;
    private static final int MD2_OUTPUT_SIZE = 16;
    private static final int MD2_BLOCK_SIZE = 16;
    private static final int MD2_PAD_SIZE = 0;
    private static final byte[] MD2_PI_SUBST = new byte[]{41, 46, 67, -55, -94, -40, 124, 1, 61, 54, 84, -95, -20, -16, 6, 19, 98, -89, 5, -13, -64, -57, 115, -116, -104, -109, 43, -39, -68, 76, -126, -54, 30, -101, 87, 60, -3, -44, -32, 22, 103, 66, 111, 24, -118, 23, -27, 18, -66, 78, -60, -42, -38, -98, -34, 73, -96, -5, -11, -114, -69, 47, -18, 122, -87, 104, 121, -111, 21, -78, 7, 63, -108, -62, 16, -119, 11, 34, 95, 33, -128, 127, 93, -102, 90, -112, 50, 39, 53, 62, -52, -25, -65, -9, -105, 3, -1, 25, 48, -77, 72, -91, -75, -47, -41, 94, -110, 42, -84, 86, -86, -58, 79, -72, 56, -46, -106, -92, 125, -74, 118, -4, 107, -30, -100, 116, 4, -15, 69, -99, 112, 89, 100, 113, -121, 32, -122, 91, -49, 101, -26, 45, -88, 2, 27, 96, 37, -83, -82, -80, -71, -10, 28, 70, 97, 105, 52, 64, 126, 15, 85, 71, -93, 35, -35, 81, -81, 58, -61, 92, -7, -50, -70, -59, -22, 38, 44, 83, 13, 110, -123, 40, -124, 9, -45, -33, -51, -12, 65, -127, 77, 82, 106, -36, 55, -56, 108, -63, -85, -6, 36, -31, 123, 8, 12, -67, -79, 74, 120, -120, -107, -117, -29, 99, -24, 109, -23, -53, -43, -2, 59, 0, 29, 57, -14, -17, -73, 14, 102, 88, -48, -28, -90, 119, 114, -8, -21, 117, 75, 10, 49, 68, 80, -76, -113, -19, 31, 26, -37, -103, -115, 51, -97, 17, -125, 20};

    public JA_MD2() {
        try {
            this.setInstantiationParameters(null);
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            // empty catch block
        }
    }

    public JA_MD2(int[] nArray) throws JSAFE_InvalidParameterException {
        this.setInstantiationParameters(nArray);
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Wrong Number of parameters: expected none");
        }
        this.objectState = 1;
    }

    public int[] getInstantiationParameters() {
        return new int[0];
    }

    public String getAlgorithm() {
        return "MD2";
    }

    public void setAlgorithmBER(byte[] byArray, int n) {
    }

    public byte[] getDERAlgorithmID() {
        byte[] byArray = null;
        try {
            byArray = AlgorithmID.derEncodeAlgID("MD2", 10, null, 0, 0);
        }
        catch (ASN_Exception aSN_Exception) {
            byArray = null;
        }
        return byArray;
    }

    public int getBlockSize() {
        return 16;
    }

    public int getPadSize() {
        return 0;
    }

    public int getDigestSize() {
        return 16;
    }

    public int getEncodedDigestSize() {
        return ENCODE_PREFIX.length + 16;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_MD2 jA_MD2 = new JA_MD2();
        if (this.state != null) {
            jA_MD2.state = (byte[])this.state.clone();
        }
        if (this.checksum != null) {
            jA_MD2.checksum = (byte[])this.checksum.clone();
        }
        if (this.contextBuffer != null) {
            jA_MD2.contextBuffer = (byte[])this.contextBuffer.clone();
        }
        if (this.xArray != null) {
            jA_MD2.xArray = (byte[])this.xArray.clone();
        }
        jA_MD2.count = this.count;
        jA_MD2.objectState = this.objectState;
        return jA_MD2;
    }

    public void digestInit() {
        if (this.objectState == 1) {
            this.objectState = 2;
            return;
        }
        this.count = 0;
        int n = 0;
        while (n < this.state.length) {
            this.state[n] = 0;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.checksum.length) {
            this.checksum[n2] = 0;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.contextBuffer.length) {
            this.contextBuffer[n3] = 0;
            ++n3;
        }
        this.objectState = 2;
    }

    public void digestUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException {
        if (this.objectState != 2) {
            this.digestInit();
        }
        if (n2 <= 0) {
            return;
        }
        int n3 = this.count;
        this.count = n3 + n2 & 0xF;
        int n4 = 16 - n3;
        if (n2 >= n4) {
            if (n3 != 0) {
                while (n3 < 16) {
                    this.contextBuffer[n3] = byArray[n];
                    ++n3;
                    ++n;
                }
                this.MD2Transform(this.contextBuffer, 0);
                n2 -= n4;
                n3 = 0;
            }
            while (n2 >= 16) {
                this.MD2Transform(byArray, n);
                n2 -= 16;
                n += 16;
            }
        }
        while (n2 > 0) {
            this.contextBuffer[n3] = byArray[n];
            --n2;
            ++n3;
            ++n;
        }
    }

    public int digestFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException {
        if (this.objectState != 2) {
            this.digestInit();
        }
        int n2 = 16 - this.count;
        byte[] byArray2 = new byte[n2];
        byte by = (byte)n2;
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3] = by;
            ++n3;
        }
        this.digestUpdate(byArray2, 0, n2);
        this.digestUpdate(this.checksum, 0, this.checksum.length);
        int n4 = 0;
        while (n4 < this.state.length) {
            byArray[n] = this.state[n4];
            ++n4;
            ++n;
        }
        this.objectState = 3;
        return 16;
    }

    public int derEncode(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = ENCODE_PREFIX.length + 16;
        int n4 = 0;
        while (n4 < ENCODE_PREFIX.length) {
            byArray2[n2] = ENCODE_PREFIX[n4];
            ++n4;
            ++n2;
        }
        while (n4 < n3) {
            byArray2[n2] = byArray[n];
            ++n4;
            ++n2;
            ++n;
        }
        return n3;
    }

    private void MD2Transform(byte[] byArray, int n) {
        int n2;
        int n3 = n;
        int n4 = 0;
        while (n4 < 16) {
            this.xArray[n4] = this.state[n4];
            this.xArray[n4 + 16] = byArray[n];
            this.xArray[n4 + 32] = (byte)(this.state[n4] ^ byArray[n]);
            ++n4;
            ++n;
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < 18) {
            n2 = 0;
            while (n2 < this.xArray.length) {
                n5 = (this.xArray[n2] ^ MD2_PI_SUBST[n5]) & 0xFF;
                this.xArray[n2] = (byte)n5;
                ++n2;
            }
            n5 = n5 + n6 & 0xFF;
            ++n6;
        }
        n2 = 0;
        while (n2 < this.state.length) {
            this.state[n2] = this.xArray[n2];
            ++n2;
        }
        n5 = this.checksum[15] & 0xFF;
        int n7 = 0;
        while (n7 < this.checksum.length) {
            int n8 = (byArray[n3] ^ n5) & 0xFF;
            n5 = (this.checksum[n7] ^ MD2_PI_SUBST[n8]) & 0xFF;
            this.checksum[n7] = (byte)n5;
            ++n7;
            ++n3;
        }
    }

    public void clearSensitiveData() {
        this.count = 0;
        int n = 0;
        while (n < this.state.length) {
            this.state[n] = 0;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.checksum.length) {
            this.checksum[n2] = 0;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.contextBuffer.length) {
            this.contextBuffer[n3] = 0;
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.xArray.length) {
            this.xArray[n4] = 0;
            ++n4;
        }
        this.objectState = 1;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

