/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Object;
import java.io.Serializable;

public class JA_MD5
extends JSAFE_Object
implements JA_AlgaeDigest,
Cloneable,
Serializable {
    private int state1;
    private int state2;
    private int state3;
    private int state4;
    private int[] xArray = new int[16];
    private long count;
    private byte[] contextBuffer = new byte[64];
    private static final byte[] ENCODE_PREFIX = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};
    private int objectState;
    private static final int NOT_INITIALIZED = 1;
    private static final int MD5_INITIALIZED = 2;
    private static final int MD5_FINALIZED = 3;
    private static final int MD5_OUTPUT_SIZE = 16;
    private static final int MD5_BLOCK_SIZE = 64;
    private static final int MD5_PAD_SIZE = 8;
    private static final int S11 = 7;
    private static final int S12 = 12;
    private static final int S13 = 17;
    private static final int S14 = 22;
    private static final int S21 = 5;
    private static final int S22 = 9;
    private static final int S23 = 14;
    private static final int S24 = 20;
    private static final int S31 = 4;
    private static final int S32 = 11;
    private static final int S33 = 16;
    private static final int S34 = 23;
    private static final int S41 = 6;
    private static final int S42 = 10;
    private static final int S43 = 15;
    private static final int S44 = 21;

    public JA_MD5() {
    }

    public JA_MD5(int[] nArray) throws JSAFE_InvalidParameterException {
        this.setInstantiationParameters(nArray);
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Wrong Number of parameters: expected none.");
        }
    }

    public int[] getInstantiationParameters() {
        return new int[0];
    }

    public String getAlgorithm() {
        return "MD5";
    }

    public void setAlgorithmBER(byte[] byArray, int n) {
    }

    public byte[] getDERAlgorithmID() {
        byte[] byArray = null;
        try {
            byArray = AlgorithmID.derEncodeAlgID("MD5", 10, null, 0, 0);
        }
        catch (ASN_Exception aSN_Exception) {
            byArray = null;
        }
        return byArray;
    }

    public int getBlockSize() {
        return 64;
    }

    public int getPadSize() {
        return 8;
    }

    public int getDigestSize() {
        return 16;
    }

    public int getEncodedDigestSize() {
        return ENCODE_PREFIX.length + 16;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_MD5 jA_MD5 = new JA_MD5();
        jA_MD5.state1 = this.state1;
        jA_MD5.state2 = this.state2;
        jA_MD5.state3 = this.state3;
        jA_MD5.state4 = this.state4;
        if (this.xArray != null) {
            jA_MD5.xArray = (int[])this.xArray.clone();
        }
        jA_MD5.count = this.count;
        if (this.contextBuffer != null) {
            jA_MD5.contextBuffer = (byte[])this.contextBuffer.clone();
        }
        jA_MD5.objectState = this.objectState;
        return jA_MD5;
    }

    public void digestInit() {
        this.count = 0L;
        this.state1 = 1732584193;
        this.state2 = -271733879;
        this.state3 = -1732584194;
        this.state4 = 271733878;
    }

    public void digestUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException {
        if (n2 <= 0) {
            return;
        }
        int n3 = (int)this.count;
        n3 = n3 >> 3 & 0x3F;
        int n4 = 64 - n3;
        this.count += (long)n2 << 3;
        if (n2 >= n4) {
            if (n3 != 0) {
                System.arraycopy(byArray, n, this.contextBuffer, n3, n4);
                n3 += n4;
                n += n4;
                this.MD5Transform(this.contextBuffer, 0);
                n2 -= n4;
                n3 = 0;
            }
            while (n2 >= 64) {
                this.MD5Transform(byArray, n);
                n2 -= 64;
                n += 64;
            }
        }
        System.arraycopy(byArray, n, this.contextBuffer, n3, n2);
        n3 += n2;
        n += n2;
    }

    public int digestFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException {
        int n2 = (int)(this.count >> 3 & 0x3FL);
        int n3 = n2 < 56 ? 56 - n2 : 120 - n2;
        byte[] byArray2 = new byte[n3];
        byArray2[0] = -128;
        byte[] byArray3 = new byte[]{(byte)(this.count & 0xFFL), (byte)(this.count >> 8 & 0xFFL), (byte)(this.count >> 16 & 0xFFL), (byte)(this.count >> 24 & 0xFFL), (byte)(this.count >> 32 & 0xFFL), (byte)(this.count >> 40 & 0xFFL), (byte)(this.count >> 48 & 0xFFL), (byte)(this.count >> 56 & 0xFFL)};
        this.digestUpdate(byArray2, 0, n3);
        this.digestUpdate(byArray3, 0, 8);
        byArray[n] = (byte)(this.state1 & 0xFF);
        byArray[++n] = (byte)(this.state1 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.state1 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.state1 >> 24 & 0xFF);
        byArray[++n] = (byte)(this.state2 & 0xFF);
        byArray[++n] = (byte)(this.state2 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.state2 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.state2 >> 24 & 0xFF);
        byArray[++n] = (byte)(this.state3 & 0xFF);
        byArray[++n] = (byte)(this.state3 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.state3 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.state3 >> 24 & 0xFF);
        byArray[++n] = (byte)(this.state4 & 0xFF);
        byArray[++n] = (byte)(this.state4 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.state4 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.state4 >> 24 & 0xFF);
        ++n;
        return 16;
    }

    public int derEncode(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = ENCODE_PREFIX.length + 16;
        int n4 = 0;
        while (n4 < ENCODE_PREFIX.length) {
            byArray2[n2] = ENCODE_PREFIX[n4];
            ++n4;
            ++n2;
        }
        while (n4 < n3) {
            byArray2[n2] = byArray[n];
            ++n4;
            ++n2;
            ++n;
        }
        return n3;
    }

    private void MD5Transform(byte[] byArray, int n) {
        int n2 = this.state1;
        int n3 = this.state2;
        int n4 = this.state3;
        int n5 = this.state4;
        int n6 = 0;
        while (n6 < 16) {
            int n7 = byArray[n] & 0xFF;
            n7 |= (byArray[++n] & 0xFF) << 8;
            n7 |= (byArray[++n] & 0xFF) << 16;
            n7 |= (byArray[++n] & 0xFF) << 24;
            ++n;
            this.xArray[n6] = n7;
            ++n6;
        }
        n2 += (n3 & n4 | ~n3 & n5) + this.xArray[0] + -680876936;
        n2 = n2 << 7 | n2 >>> 25;
        n5 += ((n2 += n3) & n3 | ~n2 & n4) + this.xArray[1] + -389564586;
        n5 = n5 << 12 | n5 >>> 20;
        n4 += ((n5 += n2) & n2 | ~n5 & n3) + this.xArray[2] + 606105819;
        n4 = n4 << 17 | n4 >>> 15;
        n3 += ((n4 += n5) & n5 | ~n4 & n2) + this.xArray[3] + -1044525330;
        n3 = n3 << 22 | n3 >>> 10;
        n2 += ((n3 += n4) & n4 | ~n3 & n5) + this.xArray[4] + -176418897;
        n2 = n2 << 7 | n2 >>> 25;
        n5 += ((n2 += n3) & n3 | ~n2 & n4) + this.xArray[5] + 1200080426;
        n5 = n5 << 12 | n5 >>> 20;
        n4 += ((n5 += n2) & n2 | ~n5 & n3) + this.xArray[6] + -1473231341;
        n4 = n4 << 17 | n4 >>> 15;
        n3 += ((n4 += n5) & n5 | ~n4 & n2) + this.xArray[7] + -45705983;
        n3 = n3 << 22 | n3 >>> 10;
        n2 += ((n3 += n4) & n4 | ~n3 & n5) + this.xArray[8] + 1770035416;
        n2 = n2 << 7 | n2 >>> 25;
        n5 += ((n2 += n3) & n3 | ~n2 & n4) + this.xArray[9] + -1958414417;
        n5 = n5 << 12 | n5 >>> 20;
        n4 += ((n5 += n2) & n2 | ~n5 & n3) + this.xArray[10] + -42063;
        n4 = n4 << 17 | n4 >>> 15;
        n3 += ((n4 += n5) & n5 | ~n4 & n2) + this.xArray[11] + -1990404162;
        n3 = n3 << 22 | n3 >>> 10;
        n2 += ((n3 += n4) & n4 | ~n3 & n5) + this.xArray[12] + 1804603682;
        n2 = n2 << 7 | n2 >>> 25;
        n5 += ((n2 += n3) & n3 | ~n2 & n4) + this.xArray[13] + -40341101;
        n5 = n5 << 12 | n5 >>> 20;
        n4 += ((n5 += n2) & n2 | ~n5 & n3) + this.xArray[14] + -1502002290;
        n4 = n4 << 17 | n4 >>> 15;
        n3 += ((n4 += n5) & n5 | ~n4 & n2) + this.xArray[15] + 1236535329;
        n3 = n3 << 22 | n3 >>> 10;
        n2 += ((n3 += n4) & n5 | n4 & ~n5) + this.xArray[1] + -165796510;
        n2 = n2 << 5 | n2 >>> 27;
        n5 += ((n2 += n3) & n4 | n3 & ~n4) + this.xArray[6] + -1069501632;
        n5 = n5 << 9 | n5 >>> 23;
        n4 += ((n5 += n2) & n3 | n2 & ~n3) + this.xArray[11] + 643717713;
        n4 = n4 << 14 | n4 >>> 18;
        n3 += ((n4 += n5) & n2 | n5 & ~n2) + this.xArray[0] + -373897302;
        n3 = n3 << 20 | n3 >>> 12;
        n2 += ((n3 += n4) & n5 | n4 & ~n5) + this.xArray[5] + -701558691;
        n2 = n2 << 5 | n2 >>> 27;
        n5 += ((n2 += n3) & n4 | n3 & ~n4) + this.xArray[10] + 38016083;
        n5 = n5 << 9 | n5 >>> 23;
        n4 += ((n5 += n2) & n3 | n2 & ~n3) + this.xArray[15] + -660478335;
        n4 = n4 << 14 | n4 >>> 18;
        n3 += ((n4 += n5) & n2 | n5 & ~n2) + this.xArray[4] + -405537848;
        n3 = n3 << 20 | n3 >>> 12;
        n2 += ((n3 += n4) & n5 | n4 & ~n5) + this.xArray[9] + 568446438;
        n2 = n2 << 5 | n2 >>> 27;
        n5 += ((n2 += n3) & n4 | n3 & ~n4) + this.xArray[14] + -1019803690;
        n5 = n5 << 9 | n5 >>> 23;
        n4 += ((n5 += n2) & n3 | n2 & ~n3) + this.xArray[3] + -187363961;
        n4 = n4 << 14 | n4 >>> 18;
        n3 += ((n4 += n5) & n2 | n5 & ~n2) + this.xArray[8] + 1163531501;
        n3 = n3 << 20 | n3 >>> 12;
        n2 += ((n3 += n4) & n5 | n4 & ~n5) + this.xArray[13] + -1444681467;
        n2 = n2 << 5 | n2 >>> 27;
        n5 += ((n2 += n3) & n4 | n3 & ~n4) + this.xArray[2] + -51403784;
        n5 = n5 << 9 | n5 >>> 23;
        n4 += ((n5 += n2) & n3 | n2 & ~n3) + this.xArray[7] + 1735328473;
        n4 = n4 << 14 | n4 >>> 18;
        n3 += ((n4 += n5) & n2 | n5 & ~n2) + this.xArray[12] + -1926607734;
        n3 = n3 << 20 | n3 >>> 12;
        n2 += ((n3 += n4) ^ n4 ^ n5) + this.xArray[5] + -378558;
        n2 = n2 << 4 | n2 >>> 28;
        n5 += ((n2 += n3) ^ n3 ^ n4) + this.xArray[8] + -2022574463;
        n5 = n5 << 11 | n5 >>> 21;
        n4 += ((n5 += n2) ^ n2 ^ n3) + this.xArray[11] + 1839030562;
        n4 = n4 << 16 | n4 >>> 16;
        n3 += ((n4 += n5) ^ n5 ^ n2) + this.xArray[14] + -35309556;
        n3 = n3 << 23 | n3 >>> 9;
        n2 += ((n3 += n4) ^ n4 ^ n5) + this.xArray[1] + -1530992060;
        n2 = n2 << 4 | n2 >>> 28;
        n5 += ((n2 += n3) ^ n3 ^ n4) + this.xArray[4] + 1272893353;
        n5 = n5 << 11 | n5 >>> 21;
        n4 += ((n5 += n2) ^ n2 ^ n3) + this.xArray[7] + -155497632;
        n4 = n4 << 16 | n4 >>> 16;
        n3 += ((n4 += n5) ^ n5 ^ n2) + this.xArray[10] + -1094730640;
        n3 = n3 << 23 | n3 >>> 9;
        n2 += ((n3 += n4) ^ n4 ^ n5) + this.xArray[13] + 681279174;
        n2 = n2 << 4 | n2 >>> 28;
        n5 += ((n2 += n3) ^ n3 ^ n4) + this.xArray[0] + -358537222;
        n5 = n5 << 11 | n5 >>> 21;
        n4 += ((n5 += n2) ^ n2 ^ n3) + this.xArray[3] + -722521979;
        n4 = n4 << 16 | n4 >>> 16;
        n3 += ((n4 += n5) ^ n5 ^ n2) + this.xArray[6] + 76029189;
        n3 = n3 << 23 | n3 >>> 9;
        n2 += ((n3 += n4) ^ n4 ^ n5) + this.xArray[9] + -640364487;
        n2 = n2 << 4 | n2 >>> 28;
        n5 += ((n2 += n3) ^ n3 ^ n4) + this.xArray[12] + -421815835;
        n5 = n5 << 11 | n5 >>> 21;
        n4 += ((n5 += n2) ^ n2 ^ n3) + this.xArray[15] + 530742520;
        n4 = n4 << 16 | n4 >>> 16;
        n3 += ((n4 += n5) ^ n5 ^ n2) + this.xArray[2] + -995338651;
        n3 = n3 << 23 | n3 >>> 9;
        n2 += (n4 ^ ((n3 += n4) | ~n5)) + this.xArray[0] + -198630844;
        n2 = n2 << 6 | n2 >>> 26;
        n5 += (n3 ^ ((n2 += n3) | ~n4)) + this.xArray[7] + 1126891415;
        n5 = n5 << 10 | n5 >>> 22;
        n4 += (n2 ^ ((n5 += n2) | ~n3)) + this.xArray[14] + -1416354905;
        n4 = n4 << 15 | n4 >>> 17;
        n3 += (n5 ^ ((n4 += n5) | ~n2)) + this.xArray[5] + -57434055;
        n3 = n3 << 21 | n3 >>> 11;
        n2 += (n4 ^ ((n3 += n4) | ~n5)) + this.xArray[12] + 1700485571;
        n2 = n2 << 6 | n2 >>> 26;
        n5 += (n3 ^ ((n2 += n3) | ~n4)) + this.xArray[3] + -1894986606;
        n5 = n5 << 10 | n5 >>> 22;
        n4 += (n2 ^ ((n5 += n2) | ~n3)) + this.xArray[10] + -1051523;
        n4 = n4 << 15 | n4 >>> 17;
        n3 += (n5 ^ ((n4 += n5) | ~n2)) + this.xArray[1] + -2054922799;
        n3 = n3 << 21 | n3 >>> 11;
        n2 += (n4 ^ ((n3 += n4) | ~n5)) + this.xArray[8] + 1873313359;
        n2 = n2 << 6 | n2 >>> 26;
        n5 += (n3 ^ ((n2 += n3) | ~n4)) + this.xArray[15] + -30611744;
        n5 = n5 << 10 | n5 >>> 22;
        n4 += (n2 ^ ((n5 += n2) | ~n3)) + this.xArray[6] + -1560198380;
        n4 = n4 << 15 | n4 >>> 17;
        n3 += (n5 ^ ((n4 += n5) | ~n2)) + this.xArray[13] + 1309151649;
        n3 = n3 << 21 | n3 >>> 11;
        n2 += (n4 ^ ((n3 += n4) | ~n5)) + this.xArray[4] + -145523070;
        n2 = n2 << 6 | n2 >>> 26;
        n5 += (n3 ^ ((n2 += n3) | ~n4)) + this.xArray[11] + -1120210379;
        n5 = n5 << 10 | n5 >>> 22;
        n4 += (n2 ^ ((n5 += n2) | ~n3)) + this.xArray[2] + 718787259;
        n4 = n4 << 15 | n4 >>> 17;
        n3 += (n5 ^ ((n4 += n5) | ~n2)) + this.xArray[9] + -343485551;
        n3 = n3 << 21 | n3 >>> 11;
        this.state1 += n2;
        this.state2 += (n3 += n4);
        this.state3 += n4;
        this.state4 += n5;
    }

    public void clearSensitiveData() {
        int n = 0;
        while (n < this.contextBuffer.length) {
            this.contextBuffer[n] = 0;
            ++n;
        }
        this.state1 = 0;
        this.state2 = 0;
        this.state3 = 0;
        this.state4 = 0;
        n = 0;
        while (n < this.xArray.length) {
            this.xArray[n] = 0;
            ++n;
        }
        this.objectState = 1;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

