/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_MGFUnderlyingAlgorithm;
import com.rsa.jsafe.JA_MaskGeneratingFunction;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_PaddingException;
import java.io.Serializable;

final class JA_MGF1
extends JSAFE_Object
implements JA_MaskGeneratingFunction,
Cloneable,
Serializable {
    private JA_AlgaeDigest digester;
    private int hLen;
    private byte[] counter = new byte[4];
    private byte[] mask;

    JA_MGF1() {
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Incorrect number of parameters: expected none.");
        }
    }

    public int[] getInstantiationParameters() {
        return new int[0];
    }

    public void setUnderlyingAlgorithm(JA_MGFUnderlyingAlgorithm jA_MGFUnderlyingAlgorithm) throws JSAFE_InvalidParameterException {
        if (!(jA_MGFUnderlyingAlgorithm instanceof JA_AlgaeDigest)) {
            throw new JSAFE_InvalidParameterException("Invalid underlying algorithm for MGF1.");
        }
        this.digester = (JA_AlgaeDigest)((Object)jA_MGFUnderlyingAlgorithm);
        this.hLen = this.digester.getDigestSize();
        this.mask = new byte[this.hLen];
    }

    public String getAlgorithm() {
        return "MGF1";
    }

    public String getMGFAlg() {
        if (this.digester != null) {
            return this.digester.getAlgorithm();
        }
        return null;
    }

    public void generateMask(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws JSAFE_PaddingException {
        if (this.digester == null) {
            throw new JSAFE_PaddingException("Not yet implemented.");
        }
        try {
            block8: {
                try {
                    int n5;
                    while (n4 >= this.hLen) {
                        this.digester.digestInit();
                        this.digester.digestUpdate(byArray, n, n2);
                        this.digester.digestUpdate(this.counter, 0, this.counter.length);
                        this.digester.digestFinal(this.mask, 0);
                        n5 = 0;
                        while (n5 < this.hLen) {
                            byArray2[n3] = (byte)(byArray2[n3] ^ this.mask[n5]);
                            ++n5;
                            ++n3;
                        }
                        this.incrementCounter();
                        n4 -= this.hLen;
                    }
                    if (n4 <= 0) break block8;
                    this.digester.digestInit();
                    this.digester.digestUpdate(byArray, n, n2);
                    this.digester.digestUpdate(this.counter, 0, this.counter.length);
                    this.digester.digestFinal(this.mask, 0);
                    n5 = 0;
                    while (n4 > 0) {
                        byArray2[n3] = (byte)(byArray2[n3] ^ this.mask[n5]);
                        ++n5;
                        ++n3;
                        --n4;
                    }
                }
                catch (JSAFE_Exception jSAFE_Exception) {
                    throw new JSAFE_PaddingException("Digest error: " + jSAFE_Exception.getMessage());
                }
            }
            Object var9_9 = null;
            this.digester.clearSensitiveData();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.digester.clearSensitiveData();
            JSAFE_Obfuscator.overwrite(this.mask);
            this.resetCounter();
            throw throwable;
        }
        JSAFE_Obfuscator.overwrite(this.mask);
        this.resetCounter();
    }

    private void resetCounter() {
        this.counter[3] = 0;
    }

    private void incrementCounter() {
        this.counter[3] = (byte)(this.counter[3] + 1);
    }

    public Object clone() throws CloneNotSupportedException {
        JA_MGF1 jA_MGF1 = new JA_MGF1();
        if (this.digester != null) {
            jA_MGF1.digester = (JA_AlgaeDigest)this.digester.clone();
        }
        jA_MGF1.hLen = this.hLen;
        if (this.counter != null) {
            jA_MGF1.counter = (byte[])this.counter.clone();
        }
        if (this.mask != null) {
            jA_MGF1.mask = (byte[])this.mask.clone();
        }
        return jA_MGF1;
    }
}

