/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.jsafe.JA_AlgaeBlockCipher;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.security.SecureRandom;

final class JA_OFB
extends JA_FeedbackMode
implements Cloneable,
Serializable {
    private byte[] initializationVector;
    private byte[] cipherVector;
    private byte[] tempVector;
    private int ivLength;
    private int bitLength;

    JA_OFB() {
    }

    JA_OFB(int[] nArray) throws JSAFE_InvalidParameterException {
        this.setInstantiationParameters(nArray);
    }

    void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (nArray.length != 1) {
            throw new JSAFE_InvalidParameterException("Incorrect Number of Algorithm Parameters: " + nArray.length + " : expected one, bitLength.");
        }
        this.setBitLength(nArray[0]);
    }

    JA_OFB(byte[] byArray, int n, int n2, int n3) throws JSAFE_InvalidParameterException, JSAFE_IVException {
        this.setBitLength(n3);
        this.setIV(byArray, n, n2);
    }

    public String getFeedbackMode() {
        return "OFB";
    }

    public int getIVSize(int n) {
        return n;
    }

    public void setAlgorithmBER(byte[] byArray, int n, int n2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        try {
            OctetStringContainer octetStringContainer = new OctetStringContainer(0);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{octetStringContainer};
            ASN1.berDecode(byArray, n, aSN1ContainerArray);
            this.setBitLength(octetStringContainer.dataLen * 8);
            this.setIV(octetStringContainer.data, octetStringContainer.dataOffset, octetStringContainer.dataLen);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Invalid BER encoding. (" + aSN_Exception.getMessage() + ")");
        }
    }

    byte[] getParamsDER() throws JSAFE_UnimplementedException {
        if (this.initializationVector == null) {
            throw new JSAFE_UnimplementedException("Cannot DER encode CBC, IV not set.");
        }
        byte[] byArray = new byte[this.initializationVector.length + 2];
        byArray[0] = 4;
        byArray[1] = (byte)this.initializationVector.length;
        System.arraycopy(this.initializationVector, 0, byArray, 2, this.initializationVector.length);
        return byArray;
    }

    void setBitLength(int n) throws JSAFE_InvalidParameterException {
        this.bitLength = n;
        int n2 = this.bitLength / 8;
        if (n2 * 8 != this.bitLength) {
            throw new JSAFE_InvalidParameterException("OFB can only be used in bit lengths that are multiples of eight.");
        }
    }

    public void setIV(byte[] byArray, int n, int n2) throws JSAFE_IVException {
        if (this.ivLength != 0) {
            if (n2 != this.ivLength) {
                throw new JSAFE_IVException("Incorrect IV Length. Should be " + this.ivLength + ".");
            }
            if (n2 < this.bitLength >> 3) {
                throw new JSAFE_IVException("The bit length must be smaller than the block size.");
            }
            int n3 = 0;
            while (n3 < n2) {
                this.initializationVector[n3] = this.cipherVector[n3] = byArray[n];
                ++n3;
                ++n;
            }
            return;
        }
        if (this.bitLength == 0) {
            this.bitLength = n2 * 8;
        }
        if (n2 < this.bitLength >> 3) {
            throw new JSAFE_IVException("The bit length must be smaller than the block size.");
        }
        this.initializationVector = new byte[n2];
        this.cipherVector = new byte[n2];
        this.tempVector = new byte[n2];
        int n4 = 0;
        while (n4 < n2) {
            this.initializationVector[n4] = this.cipherVector[n4] = byArray[n];
            ++n4;
            ++n;
        }
        this.ivLength = n2;
    }

    public int getIVLength() {
        return this.ivLength;
    }

    public byte[] getIV() {
        if (this.ivLength == 0) {
            return null;
        }
        byte[] byArray = new byte[this.ivLength];
        System.arraycopy(this.initializationVector, 0, byArray, 0, this.ivLength);
        return byArray;
    }

    public int getBlockSize() {
        if (this.bitLength == 0) {
            return -1;
        }
        return this.bitLength / 8;
    }

    void encryptInit(JA_AlgaeBlockCipher jA_AlgaeBlockCipher, JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException, JSAFE_IVException {
        if (this.ivLength == 0) {
            throw new JSAFE_IVException("OFB initialization vector not set.");
        }
        jA_AlgaeBlockCipher.encryptInit(jSAFE_SecretKey, secureRandom);
    }

    void decryptInit(JA_AlgaeBlockCipher jA_AlgaeBlockCipher, JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException, JSAFE_IVException {
        if (this.ivLength == 0) {
            throw new JSAFE_IVException("OFB initialization vector not set.");
        }
        jA_AlgaeBlockCipher.encryptInit(jSAFE_SecretKey, secureRandom);
    }

    int encryptBlock(JA_AlgaeBlockCipher jA_AlgaeBlockCipher, byte[] byArray, int n, byte[] byArray2, int n2) {
        return this.updateBlock(jA_AlgaeBlockCipher, byArray, n, byArray2, n2);
    }

    int updateBlock(JA_AlgaeBlockCipher jA_AlgaeBlockCipher, byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.bitLength >> 3;
        jA_AlgaeBlockCipher.encryptBlock(this.cipherVector, 0, this.tempVector, 0);
        System.arraycopy(this.cipherVector, n3, this.cipherVector, 0, this.cipherVector.length - n3);
        System.arraycopy(this.tempVector, 0, this.cipherVector, this.cipherVector.length - n3, n3);
        int n4 = n2;
        int n5 = 0;
        while (n5 < n3) {
            byArray2[n5 + n4] = (byte)(byArray[n5 + n] ^ this.tempVector[n5]);
            ++n5;
        }
        return n3;
    }

    int decryptBlock(JA_AlgaeBlockCipher jA_AlgaeBlockCipher, byte[] byArray, int n, byte[] byArray2, int n2) {
        return this.updateBlock(jA_AlgaeBlockCipher, byArray, n, byArray2, n2);
    }

    public Object clone() throws CloneNotSupportedException {
        JA_OFB jA_OFB = new JA_OFB();
        if (this.initializationVector != null) {
            jA_OFB.initializationVector = (byte[])this.initializationVector.clone();
        }
        if (this.cipherVector != null) {
            jA_OFB.cipherVector = (byte[])this.cipherVector.clone();
        }
        if (this.tempVector != null) {
            jA_OFB.tempVector = (byte[])this.tempVector.clone();
        }
        jA_OFB.ivLength = this.ivLength;
        jA_OFB.bitLength = this.bitLength;
        return jA_OFB;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        if (this.initializationVector != null) {
            int n = 0;
            while (n < this.initializationVector.length) {
                this.initializationVector[n] = 0;
                ++n;
            }
        }
        this.initializationVector = null;
        if (this.cipherVector != null) {
            int n = 0;
            while (n < this.cipherVector.length) {
                this.cipherVector[n] = 0;
                ++n;
            }
        }
        this.cipherVector = null;
        if (this.tempVector != null) {
            int n = 0;
            while (n < this.tempVector.length) {
                this.tempVector[n] = 0;
                ++n;
            }
        }
        this.tempVector = null;
        this.ivLength = 0;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

