/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_AlgaeSymmetricCipher;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JA_PKCS12PBEBER;
import com.rsa.jsafe.JA_PasswordStandard;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;

final class JA_PKCS12V1PBE
extends JSAFE_Object
implements JA_PasswordStandard,
Cloneable,
Serializable {
    private int keySize = -1;
    private byte[] salt;
    private int iterationCount;
    private static final byte ID_ENCRYPT_KEY = 1;
    private static final byte ID_IV = 2;
    private static final byte ID_MAC_KEY = 3;

    JA_PKCS12V1PBE() {
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (nArray.length == 1) {
            this.iterationCount = nArray[0];
            if (this.iterationCount <= 0) {
                throw new JSAFE_InvalidParameterException("PKCS 12 PBE iteration count must be greater than 0.");
            }
            return;
        }
        if (nArray.length == 2) {
            this.iterationCount = nArray[0];
            if (this.iterationCount <= 0) {
                throw new JSAFE_InvalidParameterException("PKCS 12 PBE iteration count must be greater than 0.");
            }
            this.keySize = nArray[1];
            return;
        }
        throw new JSAFE_InvalidParameterException("Incorrect number of parameters: expected one or two.");
    }

    public int[] getInstantiationParameters() {
        if (this.keySize == -1) {
            int[] nArray = new int[]{this.iterationCount};
            return nArray;
        }
        int[] nArray = new int[]{this.iterationCount, this.keySize};
        return nArray;
    }

    public String getAlgorithm() {
        return "PKCS12V1PBE";
    }

    public String getFullAlgorithm() {
        return "PKCS12V1PBE-1-" + this.keySize;
    }

    public void setAlgorithmBER(JA_AlgaeSymmetricCipher jA_AlgaeSymmetricCipher, byte[] byArray, int n, int n2) throws JSAFE_UnimplementedException {
        JA_PKCS12PBEBER.setAlgorithmBER(this, jA_AlgaeSymmetricCipher, this.keySize, byArray, n, n2);
    }

    public byte[] getParamsDER(String string, String string2) throws JSAFE_UnimplementedException {
        return JA_PKCS12PBEBER.getParamsDER(this.iterationCount, this.salt);
    }

    public byte[] getParamsDER() throws JSAFE_UnimplementedException {
        return JA_PKCS12PBEBER.getParamsDER(this.iterationCount, this.salt);
    }

    public void setSalt(byte[] byArray, int n, int n2) {
        this.salt = new byte[n2];
        System.arraycopy(byArray, n, this.salt, 0, n2);
    }

    public byte[] getSalt() {
        if (this.salt == null) {
            return null;
        }
        byte[] byArray = new byte[this.salt.length];
        System.arraycopy(this.salt, 0, byArray, 0, this.salt.length);
        return byArray;
    }

    public boolean outsideIV() {
        return false;
    }

    public void generateKeyAndIV(JA_AlgaeDigest jA_AlgaeDigest, JA_FeedbackMode jA_FeedbackMode, int n, JSAFE_SecretKey jSAFE_SecretKey) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        int n2;
        if (this.iterationCount <= 0) {
            throw new JSAFE_InvalidUseException("PKCS 12 PBE iteration count must be greater than 0.");
        }
        int n3 = jSAFE_SecretKey.getKeyType();
        byte by = 1;
        if (n3 == 1) {
            by = 3;
        }
        char[] cArray = jSAFE_SecretKey.getPassword();
        byte[] byArray = null;
        if (cArray != null && cArray.length > 0) {
            n2 = 0;
            if (cArray[cArray.length - 1] != '\u0000') {
                n2 = 2;
            }
            byArray = new byte[cArray.length * 2 + n2];
            int n4 = 0;
            while (n4 < cArray.length) {
                byArray[n4 * 2] = (byte)(cArray[n4] >>> 8);
                byArray[n4 * 2 + 1] = (byte)cArray[n4];
                cArray[n4] = '\u0000';
                ++n4;
            }
        }
        n2 = jSAFE_SecretKey.getKeyBitLength(this.keySize);
        byte[] byArray2 = this.generateBytes(jA_AlgaeDigest, by, byArray, n2);
        jSAFE_SecretKey.setSecretKeyData(byArray2, 0, byArray2.length);
        JSAFE_Obfuscator.overwrite(byArray2);
        if (jA_FeedbackMode == null) {
            JSAFE_Obfuscator.overwrite(byArray);
            return;
        }
        int n5 = jA_FeedbackMode.getIVSize(n) * 8;
        if (n5 == 0) {
            JSAFE_Obfuscator.overwrite(byArray);
            return;
        }
        byte[] byArray3 = this.generateBytes(jA_AlgaeDigest, (byte)2, byArray, n5);
        JSAFE_Obfuscator.overwrite(byArray);
        try {
            jA_FeedbackMode.setIV(byArray3, 0, byArray3.length);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_InvalidUseException("Could not set the IV in PKCS 12 PBE.");
        }
    }

    private byte[] generateBytes(JA_AlgaeDigest jA_AlgaeDigest, byte by, byte[] byArray, int n) throws JSAFE_InvalidUseException {
        int n2;
        if (n <= 0) {
            return new byte[0];
        }
        int n3 = (n + 7) / 8;
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        int n5 = n3 * 8 - n;
        int n6 = jA_AlgaeDigest.getBlockSize();
        int n7 = n6 * 8;
        byte[] byArray3 = new byte[n6];
        int n8 = 0;
        while (n8 < byArray3.length) {
            byArray3[n8] = by;
            ++n8;
        }
        byte[] byArray4 = this.buildIBuffer(byArray, n7);
        byte[] byArray5 = new byte[jA_AlgaeDigest.getDigestSize()];
        while (true) {
            jA_AlgaeDigest.digestInit();
            jA_AlgaeDigest.digestUpdate(byArray3, 0, byArray3.length);
            jA_AlgaeDigest.digestUpdate(byArray4, 0, byArray4.length);
            jA_AlgaeDigest.digestFinal(byArray5, 0);
            n2 = this.iterationCount - 1;
            while (n2 > 0) {
                jA_AlgaeDigest.digestInit();
                jA_AlgaeDigest.digestUpdate(byArray5, 0, byArray5.length);
                jA_AlgaeDigest.digestFinal(byArray5, 0);
                --n2;
            }
            int n9 = byArray5.length;
            if (n3 < byArray5.length) {
                n9 = n3;
            }
            int n10 = 0;
            while (n10 < n9) {
                byArray2[n4] = byArray5[n10];
                ++n10;
                ++n4;
            }
            if ((n3 -= n9) <= 0) break;
            this.updateI(byArray4, byArray5, n6);
        }
        JSAFE_Obfuscator.overwrite(byArray4);
        JSAFE_Obfuscator.overwrite(byArray5);
        if (n5 > 0) {
            n2 = (byte)(255 >>> n5);
            byArray2[0] = (byte)(byArray2[0] & n2);
        }
        return byArray2;
    }

    private byte[] buildIBuffer(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4 = 0;
        if (this.salt != null && this.salt.length > 0) {
            n4 = (this.salt.length * 8 + (n - 1)) / n;
            n4 *= n;
            n4 /= 8;
        }
        int n5 = 0;
        if (byArray != null && byArray.length > 0) {
            n5 = (byArray.length * 8 + (n - 1)) / n;
            n5 *= n;
            n5 /= 8;
        }
        byte[] byArray2 = new byte[n4 + n5];
        int n6 = 0;
        while (n4 > 0) {
            n3 = this.salt.length;
            if (n4 < this.salt.length) {
                n3 = n4;
            }
            n2 = 0;
            while (n2 < n3) {
                byArray2[n6] = this.salt[n2];
                ++n2;
                ++n6;
            }
            n4 -= n3;
        }
        while (n5 > 0) {
            n3 = byArray.length;
            if (n5 < byArray.length) {
                n3 = n5;
            }
            n2 = 0;
            while (n2 < n3) {
                byArray2[n6] = byArray[n2];
                ++n2;
                ++n6;
            }
            n5 -= n3;
        }
        return byArray2;
    }

    private void updateI(byte[] byArray, byte[] byArray2, int n) {
        if (byArray == null) {
            return;
        }
        int n2 = n - 1;
        int n3 = n % byArray2.length - 1;
        if (n3 == -1) {
            n3 = byArray2.length - 1;
        }
        int n4 = 0;
        while (n2 < byArray.length) {
            int n5 = n3;
            int n6 = 1;
            int n7 = n2;
            while (n7 >= n4) {
                int n8 = (byArray[n7] & 0xFF) + (byArray2[n5] & 0xFF) + n6;
                n6 = n8 >>> 8;
                byArray[n7] = (byte)n8;
                if (n5 == 0) {
                    n5 = byArray2.length;
                }
                --n5;
                --n7;
            }
            n4 = n2 + 1;
            n2 += n;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JA_PKCS12V1PBE jA_PKCS12V1PBE = new JA_PKCS12V1PBE();
        jA_PKCS12V1PBE.iterationCount = this.iterationCount;
        jA_PKCS12V1PBE.keySize = this.keySize;
        if (this.salt != null) {
            jA_PKCS12V1PBE.salt = (byte[])this.salt.clone();
        }
        return jA_PKCS12V1PBE;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.keySize = -1;
        this.salt = null;
        this.iterationCount = 0;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

