/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AsymmetricPaddingScheme;
import com.rsa.jsafe.JA_PaddingScheme;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.security.SecureRandom;

final class JA_PKCS1Block02Pad
extends JA_PaddingScheme
implements JA_AsymmetricPaddingScheme,
Cloneable,
Serializable {
    JA_PKCS1Block02Pad() {
    }

    JA_PKCS1Block02Pad(int[] nArray) throws JSAFE_InvalidParameterException {
        this.setInstantiationParameters(nArray);
    }

    public String getPaddingScheme() {
        return "PKCS1Block02Pad";
    }

    public boolean needRandom() {
        return true;
    }

    public int getPadLength(int n, int n2) {
        if (n2 < 12 || n > n2 - 11) {
            return -1;
        }
        return n2 - n;
    }

    public int getMaxInputLen(int n) {
        if (n < 12) {
            return 0;
        }
        return n - 11;
    }

    public int performPadding(byte[] byArray, int n, int n2, int n3, Object object, SecureRandom secureRandom) throws JSAFE_PaddingException {
        if (n3 < 12 || n2 > n3 - 11) {
            throw new JSAFE_PaddingException("Cannot perform padding: not enough space");
        }
        int n4 = n3 - n2;
        --n2;
        int n5 = n3 - 1;
        while (n2 >= 0) {
            byArray[n5] = byArray[n + n2];
            --n5;
            --n2;
        }
        byArray[n5] = 0;
        byArray[n] = 0;
        byArray[n + 1] = 2;
        n += 2;
        while (n < n5) {
            byte by;
            while ((by = (byte)(secureRandom.nextInt() & 0xFF)) == 0) {
            }
            byArray[n] = by;
            ++n;
        }
        return n4;
    }

    public int performUnpadding(byte[] byArray, int n, int n2, Object object) throws JSAFE_PaddingException {
        try {
            if (byArray[n] != 0 || byArray[n + 1] != 2) {
                throw new JSAFE_PaddingException("Cannot perform unpadding: incorrect format");
            }
            n2 += n;
            int n3 = n + 2;
            while (n3 < n2) {
                if (byArray[n3] == 0) break;
                ++n3;
            }
            if (n3 == n2) {
                throw new JSAFE_PaddingException("Cannot perform unpadding: incorrect format");
            }
            int n4 = n2 - n3 - 1;
            ++n3;
            while (n3 < n2) {
                byArray[n] = byArray[n3];
                ++n3;
                ++n;
            }
            while (n < n2) {
                byArray[n] = 0;
                ++n;
            }
            return n4;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_PaddingException("Could not perform unpadding: invalid input");
        }
    }

    public byte[] getPaddingDER() throws JSAFE_UnimplementedException {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_PKCS1Block02Pad jA_PKCS1Block02Pad = new JA_PKCS1Block02Pad();
        return jA_PKCS1Block02Pad;
    }
}

