/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AsymmetricAlgID;
import com.rsa.jsafe.JA_MaskGeneratingFunction;
import com.rsa.jsafe.JA_OAEPDigest;
import com.rsa.jsafe.JA_OAEPPaddingScheme;
import com.rsa.jsafe.JA_OAEPParameterSource;
import com.rsa.jsafe.JA_PaddingScheme;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.security.SecureRandom;

final class JA_PKCS1V2OAEPPad
extends JA_PaddingScheme
implements JA_OAEPPaddingScheme,
Cloneable,
Serializable {
    private JA_OAEPDigest digester;
    private JA_MaskGeneratingFunction mgf;
    private JA_OAEPParameterSource paramSource;
    private int hLen;

    JA_PKCS1V2OAEPPad() {
    }

    JA_PKCS1V2OAEPPad(int[] nArray) throws JSAFE_InvalidParameterException {
        this.setInstantiationParameters(nArray);
    }

    public String getPaddingScheme() {
        return "PKCS1V2OAEPPad";
    }

    public boolean needRandom() {
        return true;
    }

    public void setOAEPComponents(JA_OAEPDigest jA_OAEPDigest, JA_MaskGeneratingFunction jA_MaskGeneratingFunction, JA_OAEPParameterSource jA_OAEPParameterSource) {
        this.digester = jA_OAEPDigest;
        this.mgf = jA_MaskGeneratingFunction;
        this.paramSource = jA_OAEPParameterSource;
        this.hLen = jA_OAEPDigest.getDigestSize();
    }

    public int getPadLength(int n, int n2) {
        int n3 = 2 * this.hLen + 2;
        if (n + n3 > n2) {
            return -1;
        }
        return n2 - n;
    }

    public int getMaxInputLen(int n) {
        int n2 = 2 * this.hLen + 2;
        return n - n2;
    }

    public String getDigest() {
        if (this.digester != null) {
            return this.digester.getAlgorithm();
        }
        return null;
    }

    public String getMGF() {
        if (this.mgf != null) {
            return this.mgf.getAlgorithm();
        }
        return null;
    }

    public String getMGFAlg() {
        if (this.mgf != null) {
            return this.mgf.getMGFAlg();
        }
        return null;
    }

    public String getParamSource() {
        if (this.paramSource != null) {
            return this.paramSource.getAlgorithm();
        }
        return null;
    }

    public void setOAEPParameters(byte[] byArray, int n, int n2) {
        if (this.paramSource != null) {
            this.paramSource.setOAEPParameters(byArray, n, n2);
        }
    }

    public byte[] getOAEPParameters() {
        if (this.paramSource != null) {
            return this.paramSource.getOAEPParameters();
        }
        return null;
    }

    public int performPadding(byte[] byArray, int n, int n2, int n3, Object object, SecureRandom secureRandom) throws JSAFE_PaddingException {
        if (n2 + (2 * this.hLen + 2) > n3) {
            throw new JSAFE_PaddingException("Cannot perform padding: not enough space");
        }
        int n4 = n3 - n2;
        int n5 = n + n3 - 1;
        --n2;
        while (n2 >= 0) {
            byArray[n5] = byArray[n + n2];
            --n5;
            --n2;
        }
        byArray[n5] = 1;
        int n6 = n + 2 * this.hLen + 1;
        while (n6 < n5) {
            byArray[n6] = 0;
            ++n6;
        }
        n6 = n + this.hLen + 1;
        this.paramSource.digestParams(this.digester, byArray, n6, byArray, n5 + 1, n2);
        byte[] byArray2 = new byte[this.hLen];
        secureRandom.nextBytes(byArray2);
        System.arraycopy(byArray2, 0, byArray, n + 1, this.hLen);
        JSAFE_Obfuscator.overwrite(byArray2);
        int n7 = n3 - this.hLen - 1;
        this.mgf.generateMask(byArray, n + 1, this.hLen, byArray, n6, n7);
        this.mgf.generateMask(byArray, n6, n7, byArray, n + 1, this.hLen);
        byArray[n] = 0;
        return n4;
    }

    public int performUnpadding(byte[] byArray, int n, int n2, Object object) throws JSAFE_PaddingException {
        if (byArray[n] != 0) {
            throw new JSAFE_PaddingException("Cannot perform unpadding: incorrect format.");
        }
        int n3 = n + 1 + this.hLen;
        this.mgf.generateMask(byArray, n3, n2 - 1 - this.hLen, byArray, n + 1, this.hLen);
        this.mgf.generateMask(byArray, n + 1, this.hLen, byArray, n3, n2 - 1 - this.hLen);
        n3 = n + 1 + 2 * this.hLen;
        while (n3 < n + n2) {
            if (byArray[n3] != 0) {
                if (byArray[n3] == 1) break;
                throw new JSAFE_PaddingException("Cannot perform unpadding: incorrect format.");
            }
            ++n3;
        }
        if (n3 >= n + n2) {
            throw new JSAFE_PaddingException("Cannot perform unpadding: incorrect format.");
        }
        int n4 = n3 + 1;
        int n5 = n2 - (n4 - n);
        if (!this.paramSource.digestParamsAndCompare(this.digester, byArray, n + 1 + this.hLen, byArray, n4, n5)) {
            throw new JSAFE_PaddingException("Cannot perform unpadding: incorrect format.");
        }
        int n6 = 0;
        while (n6 < n5) {
            byArray[n] = byArray[n4];
            ++n6;
            ++n4;
            ++n;
        }
        while (n6 < n2) {
            byArray[n] = 0;
            ++n6;
            ++n;
        }
        return n5;
    }

    public byte[] getPaddingDER() throws JSAFE_UnimplementedException {
        try {
            return JA_AsymmetricAlgID.getOAEPAlgIDParams(this.digester.getAlgorithm(), this.mgf.getAlgorithm(), this.mgf.getAlgorithm(), this.paramSource.getAlgorithm(), this.paramSource.getOAEPParameters());
        }
        catch (NullPointerException nullPointerException) {
            throw new JSAFE_UnimplementedException("Could not generate the DER of the OAEP AlgID parameters.");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JA_PKCS1V2OAEPPad jA_PKCS1V2OAEPPad = new JA_PKCS1V2OAEPPad();
        if (this.digester != null) {
            jA_PKCS1V2OAEPPad.digester = (JA_OAEPDigest)this.digester.clone();
        }
        if (this.mgf != null) {
            jA_PKCS1V2OAEPPad.mgf = (JA_MaskGeneratingFunction)this.mgf.clone();
        }
        if (this.paramSource != null) {
            jA_PKCS1V2OAEPPad.paramSource = (JA_OAEPParameterSource)this.paramSource.clone();
        }
        jA_PKCS1V2OAEPPad.hLen = this.hLen;
        return jA_PKCS1V2OAEPPad;
    }
}

