/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_MaskGeneratingFunction;
import com.rsa.jsafe.JA_PSSDigest;
import com.rsa.jsafe.JA_PSSPadding;
import com.rsa.jsafe.JA_PaddingScheme;
import com.rsa.jsafe.JA_SignatureAlgID;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.security.SecureRandom;

public final class JA_PKCS1V2PSS
extends JA_PaddingScheme
implements JA_PSSPadding,
Cloneable,
Serializable {
    private JA_AlgaeDigest digester;
    private JA_MaskGeneratingFunction mgf;
    private int tfOption;
    private static final byte[] padding1 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    JA_PKCS1V2PSS() {
    }

    JA_PKCS1V2PSS(int[] nArray) throws JSAFE_InvalidParameterException {
        this.setInstantiationParameters(nArray);
    }

    public String getPaddingScheme() {
        return "PKCS1V2PSS";
    }

    public boolean needRandom() {
        return true;
    }

    public void setPSSComponents(JA_AlgaeDigest jA_AlgaeDigest, JA_MaskGeneratingFunction jA_MaskGeneratingFunction) {
        this.digester = jA_AlgaeDigest;
        this.mgf = jA_MaskGeneratingFunction;
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (nArray.length == 1) {
            this.tfOption = nArray[0];
            if (this.tfOption != 1 && this.tfOption != 2) {
                throw new JSAFE_InvalidParameterException("PKCS1V2PSS tfOption must be either 1 or 2.");
            }
            return;
        }
        throw new JSAFE_InvalidParameterException("Incorrect number of parameters: expected one.");
    }

    public int getPadLength(int n, int n2) {
        int n3 = n2 * 8 - 1;
        if (8 * n + 8 * this.tfOption + 1 > n3) {
            return -1;
        }
        return n2 - n;
    }

    public String getDigest() {
        if (this.digester != null) {
            return this.digester.getAlgorithm();
        }
        return null;
    }

    public String getMGF() {
        if (this.mgf != null) {
            return this.mgf.getAlgorithm();
        }
        return null;
    }

    public String getMGFAlg() {
        if (this.mgf != null) {
            return this.mgf.getMGFAlg();
        }
        return null;
    }

    public int getMaxInputLen(int n) {
        return -1;
    }

    public int performPadding(byte[] byArray, int n, int n2, int n3, Object object, SecureRandom secureRandom) throws JSAFE_PaddingException {
        int n4 = n3 * 8 - 1;
        int n5 = (n4 + 7) / 8;
        int n6 = n2;
        if (8 * n2 + 8 * this.tfOption + 1 > n4) {
            throw new JSAFE_PaddingException("Cannot perform padding: not enough space");
        }
        int n7 = n3 - n2;
        if (8 * n2 + 8 * n6 + 8 * this.tfOption + 1 > n4) {
            n6 = 0;
        }
        byte[] byArray2 = new byte[n6];
        secureRandom.nextBytes(byArray2);
        byte[] byArray3 = new byte[n2];
        try {
            this.digester.digestInit();
            this.digester.digestUpdate(padding1, 0, padding1.length);
            this.digester.digestUpdate(byArray, n, n2);
            this.digester.digestUpdate(byArray2, 0, n6);
            this.digester.digestFinal(byArray3, 0);
        }
        catch (Exception exception) {
            throw new JSAFE_PaddingException("Cannot perform padding: not enough space");
        }
        int n8 = n5 - n6 - n2 - this.tfOption - 1;
        int n9 = n8 + 1 + n6;
        byte[] byArray4 = new byte[n9];
        int n10 = 0;
        while (n10 < n8) {
            byArray4[n10] = 0;
            ++n10;
        }
        byArray4[n10] = 1;
        System.arraycopy(byArray2, 0, byArray4, n10 + 1, n6);
        this.mgf.generateMask(byArray3, 0, n2, byArray4, 0, n9);
        byArray4[0] = (byte)(byArray4[0] & 255 >> 8 * n5 - n4);
        System.arraycopy(byArray4, 0, byArray, 0, n9);
        System.arraycopy(byArray3, 0, byArray, n9, n2);
        if (this.tfOption == 1) {
            byArray[n5 - 1] = -68;
        } else if (this.tfOption == 2) {
            byArray[n5 - 2] = 51;
            byArray[n5 - 1] = -52;
        }
        return n7;
    }

    public int performUnpadding(byte[] byArray, int n, int n2, Object object) throws JSAFE_PaddingException {
        int n3;
        int n4 = n2 * 8 - 1;
        int n5 = (n4 + 7) / 8;
        int n6 = this.digester.getDigestSize();
        if (this.tfOption == 1) {
            if (byArray[n5 - 1] != -68) {
                throw new JSAFE_PaddingException("Cannot perform unpadding: incorrect format");
            }
            if (this.tfOption == 2 && (byArray[n5 - 2] != 51 || byArray[n5 - 1] != -52)) {
                throw new JSAFE_PaddingException("Cannot perform unpadding: incorrect format");
            }
        }
        if (8 * n6 + 8 * (n3 = n6) + 8 * this.tfOption + 1 > n4) {
            n3 = 0;
        }
        int n7 = n5 - n6 - this.tfOption;
        byte[] byArray2 = new byte[n7];
        System.arraycopy(byArray, n, byArray2, 0, n7);
        this.mgf.generateMask(byArray, n + n7, n6, byArray2, 0, n7);
        byArray2[0] = (byte)(byArray2[0] & 255 >> 8 * n5 - n4);
        int n8 = 0;
        while (n8 < n5 - n6 - n3 - this.tfOption - 1) {
            if (byArray2[n8] != 0) {
                throw new JSAFE_PaddingException("Cannot perform unpadding: incorrect format");
            }
            ++n8;
        }
        if (byArray2[n5 - n6 - n3 - this.tfOption - 1] != 1) {
            throw new JSAFE_PaddingException("Cannot perform unpadding: incorrect format");
        }
        System.arraycopy(byArray2, 0, byArray, 0, n7);
        return n5 - n7 - this.tfOption;
    }

    public int postProcessing(byte[] byArray, int n, byte[] byArray2, int n2, Object object) throws JSAFE_PaddingException {
        int n3;
        byte[] byArray3 = null;
        int n4 = n * 8 - 1;
        if (object == null) {
            return -1;
        }
        try {
            JA_AlgaeDigest jA_AlgaeDigest = (JA_AlgaeDigest)object;
            n3 = jA_AlgaeDigest.getDigestSize();
            byArray3 = new byte[n3];
            int n5 = n3;
            if (2 * (8 * n3) + 8 * this.tfOption + 1 > n4) {
                n5 = 0;
            }
            jA_AlgaeDigest.digestInit();
            jA_AlgaeDigest.digestUpdate(padding1, 0, padding1.length);
            jA_AlgaeDigest.digestUpdate(byArray2, 0, n2);
            jA_AlgaeDigest.digestUpdate(byArray, n - n5 - n3 - this.tfOption, n5);
            jA_AlgaeDigest.digestFinal(byArray3, 0);
        }
        catch (Exception exception) {
            throw new JSAFE_PaddingException("Cannot perform unpadding");
        }
        System.arraycopy(byArray, n - this.tfOption - n3, byArray2, 0, n3);
        System.arraycopy(byArray3, 0, byArray, 0, n3);
        return n3;
    }

    public byte[] getPaddingDER() throws JSAFE_UnimplementedException {
        try {
            return JA_SignatureAlgID.getPSSAlgIDParams(this.digester.getAlgorithm(), this.mgf.getAlgorithm(), this.mgf.getAlgorithm(), this.tfOption);
        }
        catch (NullPointerException nullPointerException) {
            throw new JSAFE_UnimplementedException("Could not generate the DER of the PSS AlgID parameters.");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JA_PKCS1V2PSS jA_PKCS1V2PSS = new JA_PKCS1V2PSS();
        if (this.digester != null) {
            jA_PKCS1V2PSS.digester = (JA_PSSDigest)this.digester.clone();
        }
        if (this.mgf != null) {
            jA_PKCS1V2PSS.mgf = (JA_MaskGeneratingFunction)this.mgf.clone();
        }
        jA_PKCS1V2PSS.tfOption = this.tfOption;
        return jA_PKCS1V2PSS;
    }
}

