/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_AlgaeSymmetricCipher;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JA_PKCS5PBEBER;
import com.rsa.jsafe.JA_PasswordStandard;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;

final class JA_PKCS5PBE
extends JSAFE_Object
implements JA_PasswordStandard,
Cloneable,
Serializable {
    private int iterationCount;
    private int keySize = -1;
    private byte[] salt;

    JA_PKCS5PBE() {
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (nArray.length == 1) {
            this.iterationCount = nArray[0];
            if (this.iterationCount <= 0) {
                throw new JSAFE_InvalidParameterException("PKCS 5 PBE iteration count must be greater than 0.");
            }
            return;
        }
        if (nArray.length == 2) {
            this.iterationCount = nArray[0];
            if (this.iterationCount <= 0) {
                throw new JSAFE_InvalidParameterException("PKCS 5 PBE iteration count must be greater than 0.");
            }
            this.keySize = nArray[1];
            return;
        }
        throw new JSAFE_InvalidParameterException("Incorrect number of parameters: expected one (iteration count) or two (iteration cound, keySize)");
    }

    public int[] getInstantiationParameters() {
        if (this.keySize == -1) {
            int[] nArray = new int[]{this.iterationCount};
            return nArray;
        }
        int[] nArray = new int[]{this.iterationCount, this.keySize};
        return nArray;
    }

    public String getAlgorithm() {
        return "PKCS5PBE";
    }

    public String getFullAlgorithm() {
        return "PKCS5PBE";
    }

    public void setAlgorithmBER(JA_AlgaeSymmetricCipher jA_AlgaeSymmetricCipher, byte[] byArray, int n, int n2) throws JSAFE_UnimplementedException {
        JA_PKCS5PBEBER.setAlgorithmBER(this, jA_AlgaeSymmetricCipher, byArray, n, n2);
    }

    public byte[] getParamsDER(String string, String string2) throws JSAFE_UnimplementedException {
        return JA_PKCS5PBEBER.getParamsDER(this.iterationCount, this.salt);
    }

    public byte[] getParamsDER() throws JSAFE_UnimplementedException {
        return JA_PKCS5PBEBER.getParamsDER(this.iterationCount, this.salt);
    }

    public void setSalt(byte[] byArray, int n, int n2) {
        this.salt = new byte[n2];
        System.arraycopy(byArray, n, this.salt, 0, n2);
    }

    public byte[] getSalt() {
        if (this.salt == null) {
            return null;
        }
        byte[] byArray = new byte[this.salt.length];
        System.arraycopy(this.salt, 0, byArray, 0, this.salt.length);
        return byArray;
    }

    public boolean outsideIV() {
        return false;
    }

    public void generateKeyAndIV(JA_AlgaeDigest jA_AlgaeDigest, JA_FeedbackMode jA_FeedbackMode, int n, JSAFE_SecretKey jSAFE_SecretKey) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        int n2;
        if (this.iterationCount <= 0) {
            throw new JSAFE_InvalidUseException("PKCS 5 PBE iteration count must be greater than 0.");
        }
        int n3 = jSAFE_SecretKey.getKeyBitLength(this.keySize);
        int n4 = (n3 + 7) / 8;
        int n5 = 0;
        if (jA_FeedbackMode != null) {
            n5 = jA_FeedbackMode.getIVSize(n);
        }
        if ((n2 = jA_AlgaeDigest.getDigestSize()) < n4 + n5) {
            throw new JSAFE_InvalidUseException(jA_AlgaeDigest.getAlgorithm() + " will not generate enough bytes for the given key size" + " using PKCS #5 PBE.");
        }
        jA_AlgaeDigest.digestInit();
        char[] cArray = jSAFE_SecretKey.getPassword();
        byte[] byArray = new byte[cArray.length];
        int n6 = cArray.length;
        if (cArray[cArray.length - 1] == '\u0000') {
            --n6;
        }
        int n7 = 0;
        while (n7 < cArray.length) {
            byArray[n7] = (byte)cArray[n7];
            cArray[n7] = '\u0000';
            ++n7;
        }
        jA_AlgaeDigest.digestUpdate(byArray, 0, n6);
        JSAFE_Obfuscator.overwrite(byArray);
        jA_AlgaeDigest.digestUpdate(this.salt, 0, this.salt.length);
        byte[] byArray2 = new byte[n2];
        jA_AlgaeDigest.digestFinal(byArray2, 0);
        int n8 = this.iterationCount - 1;
        while (n8 > 0) {
            jA_AlgaeDigest.digestInit();
            jA_AlgaeDigest.digestUpdate(byArray2, 0, byArray2.length);
            jA_AlgaeDigest.digestFinal(byArray2, 0);
            --n8;
        }
        int n9 = n4 * 8 - n3;
        if (n9 > 0) {
            byte by = (byte)(255 >>> n9);
            byArray2[0] = (byte)(byArray2[0] & by);
        }
        jSAFE_SecretKey.setSecretKeyData(byArray2, 0, n4);
        try {
            if (n5 > 0) {
                jA_FeedbackMode.setIV(byArray2, n4, n5);
            }
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_InvalidUseException("Could not set the IV in PKCS 5 PBE.");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JA_PKCS5PBE jA_PKCS5PBE = new JA_PKCS5PBE();
        jA_PKCS5PBE.iterationCount = this.iterationCount;
        jA_PKCS5PBE.keySize = this.keySize;
        if (this.salt != null) {
            jA_PKCS5PBE.salt = (byte[])this.salt.clone();
        }
        return jA_PKCS5PBE;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.keySize = -1;
        this.salt = null;
        this.iterationCount = 0;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

