/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.jsafe.JA_AlgaeSymmetricCipher;
import com.rsa.jsafe.JA_PasswordStandard;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_UnimplementedException;

public final class JA_PKCS5PBEBER
extends JSAFE_Object {
    public static void setAlgorithmBER(JA_PasswordStandard jA_PasswordStandard, JA_AlgaeSymmetricCipher jA_AlgaeSymmetricCipher, byte[] byArray, int n, int n2) throws JSAFE_UnimplementedException {
        if (byArray == null || byArray.length == 0) {
            throw new JSAFE_UnimplementedException("Invalid PKCS5 BER encoding.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        OctetStringContainer octetStringContainer = new OctetStringContainer(0);
        IntegerContainer integerContainer = new IntegerContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, octetStringContainer, integerContainer, endContainer};
        int n3 = 0;
        try {
            ASN1.berDecode(byArray, n, aSN1ContainerArray);
            n3 = integerContainer.getValueAsInt();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Invalid PKCS5 BER encoding. (" + aSN_Exception.getMessage() + ")");
        }
        int[] nArray = new int[]{n3};
        try {
            jA_PasswordStandard.setInstantiationParameters(nArray);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_UnimplementedException("Invalid PKCS5 BER encoding.");
        }
        jA_PasswordStandard.setSalt(octetStringContainer.data, octetStringContainer.dataOffset, octetStringContainer.dataLen);
        jA_AlgaeSymmetricCipher.pbeKeySize(64);
    }

    public static byte[] getParamsDER(int n, byte[] byArray) throws JSAFE_UnimplementedException {
        if (n < 1) {
            throw new JSAFE_UnimplementedException("Cannot DER encode PKCS #5 PBE, no iteration count.");
        }
        if (byArray == null || byArray.length < 8) {
            throw new JSAFE_UnimplementedException("Cannot DER encode PKCS #5 PBE, invalid salt.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            OctetStringContainer octetStringContainer = new OctetStringContainer(0, true, 0, byArray, 0, byArray.length);
            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, n);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, octetStringContainer, integerContainer, endContainer};
            return ASN1.derEncode(aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            return null;
        }
    }
}

