/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_PaddingScheme;
import com.rsa.jsafe.JA_SymmetricPaddingScheme;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.security.SecureRandom;

final class JA_PKCS5Padding
extends JA_PaddingScheme
implements JA_SymmetricPaddingScheme {
    JA_PKCS5Padding() {
    }

    JA_PKCS5Padding(int[] nArray) throws JSAFE_InvalidParameterException {
        this.setInstantiationParameters(nArray);
    }

    public String getPaddingScheme() {
        return "PKCS5Padding";
    }

    public boolean needRandom() {
        return false;
    }

    public void setAlgorithmBER(byte[] byArray, int n, int n2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
    }

    public int getPadLength(int n, int n2) {
        if (n < 0) {
            return -1;
        }
        if (n2 == 1) {
            return 0;
        }
        return n2 - n % n2;
    }

    public int performPadding(byte[] byArray, int n, int n2, int n3, Object object, SecureRandom secureRandom) throws JSAFE_PaddingException {
        if (n2 < 0) {
            throw new JSAFE_PaddingException("Negative input length to padding");
        }
        if (n3 == 1) {
            return 0;
        }
        int n4 = n3 - n2 % n3;
        int n5 = n2 + n;
        while (n5 < n2 + n + n4) {
            byArray[n5] = (byte)n4;
            ++n5;
        }
        return n4;
    }

    public int performUnpadding(byte[] byArray, int n, int n2, Object object) throws JSAFE_PaddingException {
        int n3 = 0;
        if (n2 == 1) {
            return 0;
        }
        if (n + n2 - 1 >= byArray.length) {
            throw new JSAFE_PaddingException("Could not perform unpadding: invalid input.");
        }
        n3 = byArray[n + n2 - 1] & 0xFF;
        if (n3 < 1 || n3 > n2) {
            throw new JSAFE_PaddingException("Could not perform unpadding: invalid pad byte.");
        }
        int n4 = n + (n2 - n3);
        while (n4 < n + n2) {
            if ((byArray[n4] & 0xFF) != n3) {
                throw new JSAFE_PaddingException("Could not perform unpadding: invalid pad byte.");
            }
            ++n4;
        }
        return n2 - n3;
    }
}

