/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_AlgaeDigestMAC;
import com.rsa.jsafe.JA_AlgaeSymmetricCipher;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JA_HMAC;
import com.rsa.jsafe.JA_HMACKey;
import com.rsa.jsafe.JA_PasswordStandard;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;

final class JA_PKCS5V2PBE
extends JSAFE_Object
implements JA_PasswordStandard,
Cloneable,
Serializable {
    private int iterationCount;
    private int keySize = -1;
    private byte[] salt;
    private JA_AlgaeDigestMAC algaeMAC;

    JA_PKCS5V2PBE() {
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        this.iterationCount = nArray[0];
        if (this.iterationCount <= 0) {
            throw new JSAFE_InvalidParameterException("PKCS 5 V2 PBE iteration count must be greater than 0.");
        }
        if (nArray.length == 1) {
            return;
        }
        this.keySize = nArray[1];
        if (nArray.length == 2) {
            return;
        }
        throw new JSAFE_InvalidParameterException("Incorrect number of parameters: expected one or two. (iterationCount) or (iterationCount, keySize)");
    }

    public int[] getInstantiationParameters() {
        if (this.keySize == -1) {
            int[] nArray = new int[]{this.iterationCount};
            return nArray;
        }
        int[] nArray = new int[]{this.iterationCount, this.keySize};
        return nArray;
    }

    public String getAlgorithm() {
        return "PKCSV25PBE";
    }

    public String getFullAlgorithm() {
        return "PKCSV25PBE";
    }

    public void setAlgorithmBER(JA_AlgaeSymmetricCipher jA_AlgaeSymmetricCipher, byte[] byArray, int n, int n2) throws JSAFE_UnimplementedException {
        throw new JSAFE_UnimplementedException("Not yet implemented.");
    }

    public byte[] getParamsDER(String string, String string2) throws JSAFE_UnimplementedException {
        throw new JSAFE_UnimplementedException("Not yet implemented.");
    }

    public byte[] getParamsDER() throws JSAFE_UnimplementedException {
        throw new JSAFE_UnimplementedException("Not yet implemented.");
    }

    public void setSalt(byte[] byArray, int n, int n2) {
        this.salt = new byte[n2];
        System.arraycopy(byArray, n, this.salt, 0, n2);
    }

    public byte[] getSalt() {
        if (this.salt == null) {
            return null;
        }
        byte[] byArray = new byte[this.salt.length];
        System.arraycopy(this.salt, 0, byArray, 0, this.salt.length);
        return byArray;
    }

    public boolean outsideIV() {
        return true;
    }

    public void generateKeyAndIV(JA_AlgaeDigest jA_AlgaeDigest, JA_FeedbackMode jA_FeedbackMode, int n, JSAFE_SecretKey jSAFE_SecretKey) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        int n2;
        int n3;
        if (this.iterationCount <= 0) {
            throw new JSAFE_InvalidUseException("PKCS 5 V2 PBE iteration count must be greater than 0.");
        }
        if (this.algaeMAC == null) {
            this.algaeMAC = new JA_HMAC();
        }
        if (!this.algaeMAC.isValidDigestAlgorithm(jA_AlgaeDigest)) {
            throw new JSAFE_InvalidUseException("Invalid digest algorithm for use with PKCS #5 V2 PBE.");
        }
        char[] cArray = jSAFE_SecretKey.getPassword();
        int n4 = cArray.length;
        while (cArray[n4 - 1] == '\u0000') {
            --n4;
        }
        byte[] byArray = new byte[n4];
        int n5 = 0;
        while (n5 < n4) {
            byArray[n5] = (byte)cArray[n5];
            cArray[n5] = '\u0000';
            ++n5;
        }
        JA_HMACKey jA_HMACKey = new JA_HMACKey();
        jA_HMACKey.setSecretKeyData(byArray, 0, byArray.length);
        JSAFE_Obfuscator.overwrite(byArray);
        this.algaeMAC.macInit(jA_AlgaeDigest, jA_HMACKey, null);
        int n6 = jSAFE_SecretKey.getKeyBitLength(this.keySize);
        int n7 = (n6 + 7) / 8;
        byte[] byArray2 = new byte[n7];
        int n8 = 0;
        int n9 = this.algaeMAC.getMACSize();
        byte[] byArray3 = new byte[n9];
        byte[] byArray4 = new byte[n9];
        int n10 = (n7 + n9 - 1) / n9;
        byte[] byArray5 = new byte[4];
        int n11 = 1;
        while (n11 <= n10) {
            this.algaeMAC.macInit(jA_AlgaeDigest, jA_HMACKey, null);
            this.algaeMAC.macUpdate(this.salt, 0, this.salt.length);
            this.incrementCount(byArray5);
            this.algaeMAC.macUpdate(byArray5, 0, 4);
            this.algaeMAC.macFinal(byArray4, 0);
            System.arraycopy(byArray4, 0, byArray3, 0, byArray4.length);
            n3 = 1;
            while (n3 < this.iterationCount) {
                this.algaeMAC.macInit(jA_AlgaeDigest, jA_HMACKey, null);
                this.algaeMAC.macUpdate(byArray4, 0, byArray4.length);
                this.algaeMAC.macFinal(byArray4, 0);
                n2 = 0;
                while (n2 < byArray3.length) {
                    byArray3[n2] = (byte)(byArray3[n2] ^ byArray4[n2]);
                    ++n2;
                }
                ++n3;
            }
            n2 = n7;
            if (n7 > n9) {
                n2 = n9;
            }
            System.arraycopy(byArray3, 0, byArray2, n8, n2);
            n8 += n2;
            n7 -= n2;
            ++n11;
        }
        JSAFE_Obfuscator.overwrite(byArray4);
        JSAFE_Obfuscator.overwrite(byArray3);
        jA_HMACKey.clearSensitiveData();
        n3 = n7 * 8 - n6;
        if (n3 > 0) {
            n2 = 255 >>> n3;
            byArray2[0] = (byte)(byArray2[0] & n2);
        }
        jSAFE_SecretKey.setSecretKeyData(byArray2, 0, byArray2.length);
    }

    private void incrementCount(byte[] byArray) {
        int n = 3;
        while (n >= 0) {
            int n2 = byArray[n] + 1 & 0xFF;
            byArray[n] = (byte)n2;
            if (n2 != 0) break;
            --n;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JA_PKCS5V2PBE jA_PKCS5V2PBE = new JA_PKCS5V2PBE();
        jA_PKCS5V2PBE.iterationCount = this.iterationCount;
        jA_PKCS5V2PBE.keySize = this.keySize;
        if (this.salt != null) {
            jA_PKCS5V2PBE.salt = (byte[])this.salt.clone();
        }
        return jA_PKCS5V2PBE;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.keySize = -1;
        this.salt = null;
        this.iterationCount = 0;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

