/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_AlgaeSymmetricCipher;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JA_PKIXPBEBER;
import com.rsa.jsafe.JA_PasswordStandard;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;

final class JA_PKIXPBE
extends JSAFE_Object
implements JA_PasswordStandard,
Cloneable,
Serializable {
    private byte[] salt;
    private int iterationCount;
    private static final byte ID_ENCRYPT_KEY = 1;
    private static final byte ID_IV = 2;
    private static final byte ID_MAC_KEY = 3;

    JA_PKIXPBE() {
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray == null) {
            throw new JSAFE_InvalidParameterException("Incorrect number of parameters: expected one parameter.");
        }
        if (nArray.length == 1) {
            this.iterationCount = nArray[0];
            if (this.iterationCount <= 0) {
                throw new JSAFE_InvalidParameterException("PKIX PBE iteration count must be greater than 0.");
            }
            return;
        }
        throw new JSAFE_InvalidParameterException("Incorrect number of parameters: expected one parameter.");
    }

    public int[] getInstantiationParameters() {
        int[] nArray = new int[]{this.iterationCount};
        return nArray;
    }

    public String getAlgorithm() {
        return "PKIXPBE";
    }

    public String getFullAlgorithm() {
        return "PKIXPBE";
    }

    public boolean outsideIV() {
        return false;
    }

    public void setAlgorithmBER(JA_AlgaeSymmetricCipher jA_AlgaeSymmetricCipher, byte[] byArray, int n, int n2) throws JSAFE_UnimplementedException {
        JA_PKIXPBEBER.setAlgorithmBER(this, jA_AlgaeSymmetricCipher, -1, byArray, n, n2);
    }

    public byte[] getParamsDER() throws JSAFE_UnimplementedException {
        return JA_PKIXPBEBER.getParamsDER(this.iterationCount, this.salt);
    }

    public byte[] getParamsDER(String string, String string2) throws JSAFE_UnimplementedException {
        return JA_PKIXPBEBER.getParamsDER(string, string2, this.iterationCount, this.salt);
    }

    public void setSalt(byte[] byArray, int n, int n2) {
        this.salt = new byte[n2];
        System.arraycopy(byArray, n, this.salt, 0, n2);
    }

    public byte[] getSalt() {
        if (this.salt == null) {
            return null;
        }
        byte[] byArray = new byte[this.salt.length];
        System.arraycopy(this.salt, 0, byArray, 0, this.salt.length);
        return byArray;
    }

    protected byte[] buildBuffer(byte[] byArray) {
        byte[] byArray2 = new byte[this.salt.length + byArray.length];
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byArray2[n2] = byArray[n2];
            ++n2;
        }
        int n3 = n;
        n = this.salt.length;
        int n4 = 0;
        while (n4 < n) {
            byArray2[n3] = this.salt[n4];
            ++n4;
            ++n3;
        }
        return byArray2;
    }

    public void generateKeyAndIV(JA_AlgaeDigest jA_AlgaeDigest, JA_FeedbackMode jA_FeedbackMode, int n, JSAFE_SecretKey jSAFE_SecretKey) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        if (this.iterationCount <= 0) {
            throw new JSAFE_InvalidUseException("PKIX PBE iteration count must be greater than 0.");
        }
        char[] cArray = jSAFE_SecretKey.getPassword();
        byte[] byArray = null;
        if (cArray != null && cArray.length > 0) {
            byArray = new byte[cArray.length];
            int n2 = 0;
            while (n2 < cArray.length) {
                byArray[n2] = (byte)cArray[n2];
                ++n2;
            }
        }
        byte[] byArray2 = this.generateBytes(jA_AlgaeDigest, byArray);
        jSAFE_SecretKey.setSecretKeyData(byArray2, 0, byArray2.length);
        JSAFE_Obfuscator.overwrite(byArray2);
        if (jA_FeedbackMode == null) {
            JSAFE_Obfuscator.overwrite(byArray);
            return;
        }
        byte[] byArray3 = this.generateBytes(jA_AlgaeDigest, byArray);
        JSAFE_Obfuscator.overwrite(byArray);
        try {
            jA_FeedbackMode.setIV(byArray3, 0, byArray3.length);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_InvalidUseException("Could not set the IV in PKIX PBE.");
        }
    }

    private byte[] generateBytes(JA_AlgaeDigest jA_AlgaeDigest, byte[] byArray) throws JSAFE_InvalidUseException {
        byte[] byArray2 = this.buildBuffer(byArray);
        byte[] byArray3 = new byte[jA_AlgaeDigest.getDigestSize()];
        jA_AlgaeDigest.digestInit();
        jA_AlgaeDigest.digestUpdate(byArray2, 0, byArray2.length);
        jA_AlgaeDigest.digestFinal(byArray3, 0);
        int n = this.iterationCount - 1;
        while (n > 0) {
            jA_AlgaeDigest.digestInit();
            jA_AlgaeDigest.digestUpdate(byArray3, 0, byArray3.length);
            jA_AlgaeDigest.digestFinal(byArray3, 0);
            --n;
        }
        JSAFE_Obfuscator.overwrite(byArray2);
        return byArray3;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_PKIXPBE jA_PKIXPBE = new JA_PKIXPBE();
        jA_PKIXPBE.iterationCount = this.iterationCount;
        if (this.salt != null) {
            jA_PKIXPBE.salt = (byte[])this.salt.clone();
        }
        return jA_PKIXPBE;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.salt = null;
        this.iterationCount = 0;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

