/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_Prime;
import com.rsa.jsafe.JA_SHA1;
import com.rsa.jsafe.JCMPInt;
import com.rsa.jsafe.JCMPInteger;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import java.security.SecureRandom;

public final class JA_PQGGen {
    static final int SHA1_OUTPUT_SIZE = 20;
    private static int requiredIterationsForQ = JA_PQGGen.requiredRoundsForRabin(160);

    JA_PQGGen() {
    }

    static void generatePQG(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, SecureRandom secureRandom, Class clazz) throws JSAFE_InvalidUseException {
        boolean bl = false;
        JCMPInteger jCMPInteger = null;
        JCMPInteger jCMPInteger2 = null;
        JCMPInteger jCMPInteger3 = null;
        JCMPInteger jCMPInteger4 = null;
        JCMPInteger jCMPInteger5 = null;
        JCMPInteger jCMPInteger6 = null;
        try {
            try {
                byte[] byArray4;
                if (n <= n2) {
                    throw new JSAFE_InvalidUseException("Cannot generate p, q, g with a p smaller than q");
                }
                jCMPInteger2 = (JCMPInteger)clazz.newInstance();
                jCMPInteger = (JCMPInteger)clazz.newInstance();
                while (!bl) {
                    int n3;
                    if (!jCMPInteger2.generatePrime(n2, null, 0, false, secureRandom) || !JA_PQGGen.findPrimeP(jCMPInteger2, n, n2, secureRandom, clazz, jCMPInteger) || (n3 = jCMPInteger.getBitLength()) != n) continue;
                    byArray4 = new byte[(n + 7) / 8];
                    secureRandom.nextBytes(byArray4);
                    jCMPInteger3 = (JCMPInteger)clazz.newInstance();
                    jCMPInteger4 = (JCMPInteger)clazz.newInstance();
                    jCMPInteger3.setValue(byArray4, 0, byArray4.length);
                    int n4 = 0;
                    while (n4 < byArray4.length) {
                        byArray4[n4] = 0;
                        ++n4;
                    }
                    jCMPInteger3.modReduce(jCMPInteger, jCMPInteger4);
                    jCMPInteger5 = (JCMPInteger)clazz.newInstance();
                    jCMPInteger6 = (JCMPInteger)clazz.newInstance();
                    jCMPInteger.divide(jCMPInteger2, jCMPInteger5, jCMPInteger6);
                    jCMPInteger4.modExp(jCMPInteger5, jCMPInteger, jCMPInteger3);
                    jCMPInteger5.setValue(jCMPInteger3);
                    jCMPInteger3.modMultiply(jCMPInteger5, jCMPInteger, jCMPInteger6);
                    if (jCMPInteger3.compareTo(jCMPInteger6) == 0) continue;
                    bl = true;
                }
                byte[] byArray5 = jCMPInteger.toFixedLenOctetString(byArray.length);
                byArray4 = jCMPInteger2.toFixedLenOctetString(byArray2.length);
                byte[] byArray6 = jCMPInteger3.toFixedLenOctetString(byArray3.length);
                System.arraycopy(byArray5, 0, byArray, 0, byArray5.length);
                JSAFE_Obfuscator.overwrite(byArray5);
                System.arraycopy(byArray4, 0, byArray2, 0, byArray4.length);
                JSAFE_Obfuscator.overwrite(byArray4);
                System.arraycopy(byArray6, 0, byArray3, 0, byArray6.length);
                JSAFE_Obfuscator.overwrite(byArray6);
            }
            catch (InstantiationException instantiationException) {
                throw new JSAFE_InvalidUseException("Bad arithmetic class.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JSAFE_InvalidUseException("Bad arithmetic class.");
            }
            catch (JSAFE_InputException jSAFE_InputException) {
                throw new JSAFE_InvalidUseException("Could not generate a prime with the given parameters.");
            }
            Object var18_22 = null;
            if (jCMPInteger2 != null) {
                jCMPInteger2.clearSensitiveData();
            }
            if (jCMPInteger != null) {
                jCMPInteger.clearSensitiveData();
            }
            if (jCMPInteger3 != null) {
                jCMPInteger3.clearSensitiveData();
            }
            if (jCMPInteger4 != null) {
                jCMPInteger4.clearSensitiveData();
            }
            if (jCMPInteger5 != null) {
                jCMPInteger5.clearSensitiveData();
            }
            if (jCMPInteger6 != null) {
                jCMPInteger6.clearSensitiveData();
            }
        }
        catch (Throwable throwable) {
            Object var18_23 = null;
            if (jCMPInteger2 != null) {
                jCMPInteger2.clearSensitiveData();
            }
            if (jCMPInteger != null) {
                jCMPInteger.clearSensitiveData();
            }
            if (jCMPInteger3 != null) {
                jCMPInteger3.clearSensitiveData();
            }
            if (jCMPInteger4 != null) {
                jCMPInteger4.clearSensitiveData();
            }
            if (jCMPInteger5 != null) {
                jCMPInteger5.clearSensitiveData();
            }
            if (jCMPInteger6 != null) {
                jCMPInteger6.clearSensitiveData();
            }
            throw throwable;
        }
    }

    private static boolean findPrimeP(JCMPInteger jCMPInteger, int n, int n2, SecureRandom secureRandom, Class clazz, JCMPInteger jCMPInteger2) throws JSAFE_InvalidUseException {
        if (n <= n2) {
            throw new JSAFE_InvalidUseException("JSAFE cannot generate P, Q, G if Q's length >= P's length.");
        }
        JCMPInteger jCMPInteger3 = null;
        JCMPInteger jCMPInteger4 = null;
        JCMPInteger jCMPInteger5 = null;
        JCMPInteger jCMPInteger6 = null;
        boolean bl = false;
        try {
            try {
                jCMPInteger3 = (JCMPInteger)clazz.newInstance();
                jCMPInteger.add(jCMPInteger, jCMPInteger3);
                int n3 = (n + 7) / 8;
                byte[] byArray = new byte[n3];
                secureRandom.nextBytes(byArray);
                n3 = n % 8;
                if (n3 != 0) {
                    n3 = 8 - n3;
                }
                byArray[0] = (byte)(byArray[0] | 0xC0);
                byArray[0] = (byte)((byArray[0] & 0xFF) >>> n3);
                if (n3 == 7) {
                    byArray[1] = (byte)(byArray[1] | 0x80);
                }
                jCMPInteger2.setValue(byArray, 0, byArray.length);
                secureRandom.nextBytes(byArray);
                jCMPInteger4 = (JCMPInteger)clazz.newInstance();
                jCMPInteger5 = (JCMPInteger)clazz.newInstance();
                jCMPInteger6 = (JCMPInteger)clazz.newInstance();
                jCMPInteger2.divide(jCMPInteger, jCMPInteger4, jCMPInteger5);
                jCMPInteger2.subtractInPlace(jCMPInteger5);
                if (jCMPInteger2.getBit(0) == 1) {
                    jCMPInteger2.addInPlace(jCMPInteger);
                }
                jCMPInteger2.addInPlace(1);
                int n4 = jCMPInteger2.getBitLength();
                int[] nArray = new int[2];
                while (n4 == n) {
                    boolean bl2 = false;
                    nArray[1] = 0;
                    nArray[0] = 0;
                    JA_Prime.getNextSmallPrime(nArray);
                    do {
                        jCMPInteger4.setValue(nArray[0]);
                        jCMPInteger2.modReduce(jCMPInteger4, jCMPInteger5);
                        if (jCMPInteger5.getBitLength() == 1 && jCMPInteger5.getBit(0) == 0) {
                            bl2 = true;
                        }
                        JA_Prime.getNextSmallPrime(nArray);
                    } while (!bl2 && nArray[1] < 53);
                    if (!bl2 && JA_Prime.fermatTest(jCMPInteger2, jCMPInteger4, jCMPInteger5)) {
                        bl = JA_Prime.rabinTest(jCMPInteger2, jCMPInteger4, jCMPInteger5, jCMPInteger6, secureRandom);
                    }
                    if (bl) break;
                    jCMPInteger2.addInPlace(jCMPInteger3);
                    n4 = jCMPInteger2.getBitLength();
                }
            }
            catch (InstantiationException instantiationException) {
                throw new JSAFE_InvalidUseException("Bad arithmetic class.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JSAFE_InvalidUseException("Bad arithmetic class.");
            }
            catch (JSAFE_InputException jSAFE_InputException) {
                throw new JSAFE_InvalidUseException("Could not generate a prime with the given parameters.");
            }
            Object var17_19 = null;
            if (jCMPInteger3 != null) {
                jCMPInteger3.clearSensitiveData();
            }
            if (jCMPInteger4 != null) {
                jCMPInteger4.clearSensitiveData();
            }
            if (jCMPInteger5 != null) {
                jCMPInteger5.clearSensitiveData();
            }
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            if (jCMPInteger3 != null) {
                jCMPInteger3.clearSensitiveData();
            }
            if (jCMPInteger4 != null) {
                jCMPInteger4.clearSensitiveData();
            }
            if (jCMPInteger5 != null) {
                jCMPInteger5.clearSensitiveData();
            }
            throw throwable;
        }
        return bl;
    }

    public static void generateFipsPQG(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, SecureRandom secureRandom, Class clazz) throws JSAFE_InvalidUseException {
        if (n2 != 160) {
            throw new JSAFE_InvalidUseException("primeQ must be exactly 160 bit long to comply with Fips 186");
        }
        if (n < 512 || n > 1024 || n % 64 != 0) {
            throw new JSAFE_InvalidUseException("FIPS 186-2 primeP should be a multiple of 64 and between 512 and 1024");
        }
        byte[] byArray4 = new byte[20];
        int[] nArray = new int[]{0};
        JCMPInteger jCMPInteger = null;
        JCMPInteger jCMPInteger2 = null;
        JCMPInteger jCMPInteger3 = null;
        JCMPInteger jCMPInteger4 = null;
        try {
            try {
                jCMPInteger = (JCMPInteger)clazz.newInstance();
                jCMPInteger2 = (JCMPInteger)clazz.newInstance();
                jCMPInteger3 = (JCMPInteger)clazz.newInstance();
                jCMPInteger4 = (JCMPInteger)clazz.newInstance();
                jCMPInteger4.setValue(2);
                try {
                    boolean bl = false;
                    do {
                        secureRandom.nextBytes(byArray4);
                    } while (!(bl = JA_PQGGen.computeFipsPQGFromHash(byArray4, n, secureRandom, jCMPInteger, jCMPInteger2, jCMPInteger3, jCMPInteger4, nArray, clazz)));
                }
                catch (JSAFE_InputException jSAFE_InputException) {
                    Throwable throwable = jSAFE_InputException.fillInStackTrace();
                    throw new RuntimeException("Internal error: " + throwable.getMessage());
                }
                byte[] byArray5 = jCMPInteger.toFixedLenOctetString(byArray.length);
                byte[] byArray6 = jCMPInteger2.toFixedLenOctetString(byArray2.length);
                byte[] byArray7 = jCMPInteger3.toFixedLenOctetString(byArray3.length);
                System.arraycopy(byArray5, 0, byArray, 0, byArray5.length);
                System.arraycopy(byArray6, 0, byArray2, 0, byArray6.length);
                System.arraycopy(byArray7, 0, byArray3, 0, byArray7.length);
            }
            catch (InstantiationException instantiationException) {
                throw new JSAFE_InvalidUseException("Bad arithmetic class.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JSAFE_InvalidUseException("Bad arithmetic class.");
            }
            catch (JSAFE_InputException jSAFE_InputException) {
                throw new JSAFE_InvalidUseException("Could not generate a prime with the given parameters. " + jSAFE_InputException.getMessage());
            }
            Object var17_22 = null;
            if (jCMPInteger != null) {
                jCMPInteger.clearSensitiveData();
            }
            if (jCMPInteger2 != null) {
                jCMPInteger.clearSensitiveData();
            }
            if (jCMPInteger3 != null) {
                jCMPInteger.clearSensitiveData();
            }
            if (jCMPInteger4 != null) {
                jCMPInteger.clearSensitiveData();
            }
        }
        catch (Throwable throwable) {
            Object var17_23 = null;
            if (jCMPInteger != null) {
                jCMPInteger.clearSensitiveData();
            }
            if (jCMPInteger2 != null) {
                jCMPInteger.clearSensitiveData();
            }
            if (jCMPInteger3 != null) {
                jCMPInteger.clearSensitiveData();
            }
            if (jCMPInteger4 != null) {
                jCMPInteger.clearSensitiveData();
            }
            throw throwable;
        }
    }

    private static int requiredRoundsForRabin(int n) {
        return JA_Prime.requiredIterationsForRabin(n);
    }

    public static boolean computeFipsPQGFromHash(byte[] byArray, int n, SecureRandom secureRandom, JCMPInteger jCMPInteger, JCMPInteger jCMPInteger2, JCMPInteger jCMPInteger3, JCMPInteger jCMPInteger4, int[] nArray, Class clazz) throws JSAFE_InputException, JSAFE_InvalidUseException {
        int n2 = byArray.length * 8;
        if (!JA_PQGGen.computeFipsPrimeQ(byArray, n2, secureRandom, jCMPInteger2, clazz)) {
            return false;
        }
        if (!JA_PQGGen.computeFipsPrimeP(byArray, jCMPInteger2, secureRandom, jCMPInteger, n, nArray, clazz)) {
            return false;
        }
        JCMPInt jCMPInt = null;
        JCMPInt jCMPInt2 = null;
        try {
            try {
                jCMPInt = (JCMPInt)clazz.newInstance();
                jCMPInt2 = (JCMPInt)clazz.newInstance();
                jCMPInteger.divide(jCMPInteger2, jCMPInt, jCMPInt2);
                jCMPInteger4.modExp(jCMPInt, jCMPInteger, jCMPInteger3);
                boolean bl = true;
                Object var15_14 = null;
                if (jCMPInt != null) {
                    jCMPInt.clearSensitiveData();
                }
                if (jCMPInt2 != null) {
                    jCMPInt2.clearSensitiveData();
                }
                return bl;
            }
            catch (InstantiationException instantiationException) {
                throw new JSAFE_InvalidUseException("Bad arithmetic class.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JSAFE_InvalidUseException("Bad arithmetic class.");
            }
        }
        catch (Throwable throwable) {
            block10: {
                Object var15_15 = null;
                if (jCMPInt != null) {
                    jCMPInt.clearSensitiveData();
                }
                if (jCMPInt2 == null) break block10;
                jCMPInt2.clearSensitiveData();
            }
            throw throwable;
        }
    }

    private static boolean computeFipsPrimeP(byte[] byArray, JCMPInteger jCMPInteger, SecureRandom secureRandom, JCMPInteger jCMPInteger2, int n, int[] nArray, Class clazz) throws JSAFE_InputException, JSAFE_InvalidUseException {
        boolean bl = false;
        int n2 = n;
        int n3 = (n2 - 1) / 160;
        int n4 = (n2 - 1) % 160;
        int n5 = byArray.length * 8;
        JCMPInteger jCMPInteger3 = null;
        JCMPInteger jCMPInteger4 = null;
        JCMPInteger jCMPInteger5 = null;
        JCMPInteger jCMPInteger6 = null;
        JCMPInteger jCMPInteger7 = null;
        JCMPInteger jCMPInteger8 = null;
        try {
            try {
                jCMPInteger3 = (JCMPInteger)clazz.newInstance();
                jCMPInteger3.setValue(jCMPInteger);
                jCMPInteger3.shiftLeftByBits(1);
                jCMPInteger4 = (JCMPInteger)clazz.newInstance();
                jCMPInteger4.setPowerOfTwo(n2 - 1);
                jCMPInteger7 = (JCMPInteger)clazz.newInstance();
                jCMPInteger5 = (JCMPInteger)clazz.newInstance();
                jCMPInteger6 = (JCMPInteger)clazz.newInstance();
                jCMPInteger8 = (JCMPInteger)clazz.newInstance();
                JA_SHA1 jA_SHA1 = new JA_SHA1();
                int n6 = 2;
                int n7 = 0;
                do {
                    int n8;
                    boolean bl2;
                    JA_PQGGen.computeFipsVariableW(byArray, n5, n3, n4, n6, jCMPInteger5, jCMPInteger6, jA_SHA1, jCMPInteger8);
                    jCMPInteger8.setBit(n2 - 1, 1);
                    jCMPInteger8.modReduce(jCMPInteger3, jCMPInteger7);
                    jCMPInteger8.subtractInPlace(jCMPInteger7);
                    jCMPInteger8.addInPlace(1);
                    if (jCMPInteger8.compareTo(jCMPInteger4) >= 0 && JA_Prime.fermatTest(jCMPInteger8, jCMPInteger5, jCMPInteger6) && (bl2 = JA_Prime.RTWithIterationCount(jCMPInteger8, jCMPInteger5, jCMPInteger6, jCMPInteger7, secureRandom, n8 = JA_Prime.requiredIterationsForRabin(n)))) {
                        jCMPInteger2.setValue(jCMPInteger8);
                        nArray[0] = n7;
                        bl = true;
                        break;
                    }
                    n6 += n3 + 1;
                } while (++n7 < 4096);
            }
            catch (InstantiationException instantiationException) {
                throw new JSAFE_InvalidUseException("Bad arithmetic class.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JSAFE_InvalidUseException("Bad arithmetic class.");
            }
            catch (JSAFE_InputException jSAFE_InputException) {
                throw new JSAFE_InvalidUseException(jSAFE_InputException.getMessage());
            }
            Object var24_26 = null;
            if (jCMPInteger8 != null) {
                jCMPInteger8.clearSensitiveData();
            }
            if (jCMPInteger3 != null) {
                jCMPInteger3.clearSensitiveData();
            }
            if (jCMPInteger7 != null) {
                jCMPInteger7.clearSensitiveData();
            }
            if (jCMPInteger4 != null) {
                jCMPInteger4.clearSensitiveData();
            }
            if (jCMPInteger5 != null) {
                jCMPInteger5.clearSensitiveData();
            }
            if (jCMPInteger6 != null) {
                jCMPInteger6.clearSensitiveData();
            }
        }
        catch (Throwable throwable) {
            Object var24_27 = null;
            if (jCMPInteger8 != null) {
                jCMPInteger8.clearSensitiveData();
            }
            if (jCMPInteger3 != null) {
                jCMPInteger3.clearSensitiveData();
            }
            if (jCMPInteger7 != null) {
                jCMPInteger7.clearSensitiveData();
            }
            if (jCMPInteger4 != null) {
                jCMPInteger4.clearSensitiveData();
            }
            if (jCMPInteger5 != null) {
                jCMPInteger5.clearSensitiveData();
            }
            if (jCMPInteger6 != null) {
                jCMPInteger6.clearSensitiveData();
            }
            throw throwable;
        }
        return bl;
    }

    private static void computeFipsVariableW(byte[] byArray, int n, int n2, int n3, int n4, JCMPInteger jCMPInteger, JCMPInteger jCMPInteger2, JA_SHA1 jA_SHA1, JCMPInteger jCMPInteger3) throws JSAFE_InputException {
        byte[] byArray2 = new byte[20];
        jCMPInteger3.setValue(0);
        int n5 = 0;
        while (n5 <= n2) {
            JA_PQGGen.HashSeedPlusNumber(byArray, n, n5, n4, jCMPInteger, jA_SHA1, true, byArray2);
            jCMPInteger2.setValue(byArray2, 0, 20);
            if (n5 == n2) {
                int n6 = n3;
                while (n6 < 160) {
                    jCMPInteger2.setBit(n6, 0);
                    ++n6;
                }
            }
            jCMPInteger2.shiftLeftByBits(n5 * 160);
            jCMPInteger3.addInPlace(jCMPInteger2);
            ++n5;
        }
    }

    private static boolean computeFipsPrimeQ(byte[] byArray, int n, SecureRandom secureRandom, JCMPInteger jCMPInteger, Class clazz) throws JSAFE_InputException, JSAFE_InvalidUseException {
        boolean bl = false;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        JCMPInteger jCMPInteger2 = null;
        JCMPInteger jCMPInteger3 = null;
        JCMPInteger jCMPInteger4 = null;
        JA_SHA1 jA_SHA1 = new JA_SHA1();
        try {
            try {
                jCMPInteger2 = (JCMPInteger)clazz.newInstance();
                jCMPInteger3 = (JCMPInteger)clazz.newInstance();
                jCMPInteger4 = (JCMPInteger)clazz.newInstance();
                byArray2 = new byte[20];
                byArray3 = new byte[20];
                JA_PQGGen.HashSeedPlusNumber(byArray, n, 0, 0, jCMPInteger2, jA_SHA1, false, byArray2);
                JA_PQGGen.HashSeedPlusNumber(byArray, n, 1, 0, jCMPInteger2, jA_SHA1, true, byArray3);
                int n2 = 0;
                while (n2 < 20) {
                    int n3 = n2;
                    byArray2[n3] = (byte)(byArray2[n3] ^ byArray3[n2]);
                    ++n2;
                }
                byArray2[0] = (byte)(byArray2[0] | 0x80);
                byArray2[19] = (byte)(byArray2[19] | 1);
                jCMPInteger.setValue(byArray2, 0, 20);
                if (JA_Prime.fermatTest(jCMPInteger, jCMPInteger2, jCMPInteger3)) {
                    bl = JA_Prime.RTWithIterationCount(jCMPInteger, jCMPInteger2, jCMPInteger3, jCMPInteger4, secureRandom, requiredIterationsForQ);
                }
                boolean bl2 = bl;
                Object var17_16 = null;
                if (jCMPInteger2 != null) {
                    jCMPInteger2.clearSensitiveData();
                }
                if (jCMPInteger3 != null) {
                    jCMPInteger3.clearSensitiveData();
                }
                if (jCMPInteger4 != null) {
                    jCMPInteger4.clearSensitiveData();
                }
                return bl2;
            }
            catch (InstantiationException instantiationException) {
                throw new JSAFE_InvalidUseException("Bad arithmetic class.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JSAFE_InvalidUseException("Bad arithmetic class.");
            }
            catch (JSAFE_InputException jSAFE_InputException) {
                throw new JSAFE_InvalidUseException(jSAFE_InputException.getMessage());
            }
        }
        catch (Throwable throwable) {
            block13: {
                Object var17_17 = null;
                if (jCMPInteger2 != null) {
                    jCMPInteger2.clearSensitiveData();
                }
                if (jCMPInteger3 != null) {
                    jCMPInteger3.clearSensitiveData();
                }
                if (jCMPInteger4 == null) break block13;
                jCMPInteger4.clearSensitiveData();
            }
            throw throwable;
        }
    }

    private static void HashSeedPlusNumber(byte[] byArray, int n, int n2, int n3, JCMPInteger jCMPInteger, JA_SHA1 jA_SHA1, boolean bl, byte[] byArray2) throws JSAFE_InputException {
        int n4 = byArray.length;
        jCMPInteger.setValue(byArray, 0, n4);
        try {
            jCMPInteger.addInPlace(n3 + n2);
            if (bl) {
                jCMPInteger.setBit(n, 0);
            }
            byte[] byArray3 = jCMPInteger.toFixedLenOctetString(n4);
            jA_SHA1.digestInit();
            jA_SHA1.digestUpdate(byArray3, 0, n4);
            jA_SHA1.digestFinal(byArray2, 0);
        }
        catch (JSAFE_InputException jSAFE_InputException) {
            throw new JSAFE_InputException("Could not generate prime.");
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new JSAFE_InputException("Could not generate prime.");
        }
    }
}

