/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_Object;

final class JA_PublicKeyBER
extends JSAFE_Object {
    JA_PublicKeyBER() {
    }

    static int berDecodePublicKeyInfo(byte[] byArray, int n, OIDContainer oIDContainer, EncodedContainer encodedContainer, BitStringContainer bitStringContainer) throws JSAFE_InvalidKeyException {
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        SequenceContainer sequenceContainer2 = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        if (oIDContainer == null) {
            oIDContainer = new OIDContainer(0, 3);
        }
        if (encodedContainer == null) {
            encodedContainer = new EncodedContainer(77824);
        }
        if (bitStringContainer == null) {
            bitStringContainer = new BitStringContainer(0);
        }
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, sequenceContainer2, oIDContainer, encodedContainer, endContainer, bitStringContainer, endContainer};
        try {
            return ASN1.berDecode(byArray, n, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_InvalidKeyException("Could not decode public key from BER. (" + aSN_Exception.getMessage() + ")");
        }
    }

    static byte[] derEncodePublicKeyInfo(String string, byte[] byArray, byte[] byArray2) throws JSAFE_InvalidKeyException {
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            SequenceContainer sequenceContainer2 = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            OIDContainer oIDContainer = new OIDContainer(0, true, 0, string, 3);
            int n = 0;
            boolean bl = true;
            if (byArray == null) {
                bl = false;
            } else {
                n = byArray.length;
            }
            EncodedContainer encodedContainer = new EncodedContainer(77824, bl, 5, byArray, 0, n);
            BitStringContainer bitStringContainer = new BitStringContainer(0, true, 0, byArray2, 0, byArray2.length, byArray2.length * 8, false);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, sequenceContainer2, oIDContainer, encodedContainer, endContainer, bitStringContainer, endContainer};
            return ASN1.derEncode(aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_InvalidKeyException("Could not DER encode the public key. (" + aSN_Exception.getMessage() + ")");
        }
    }
}

