/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeBlockCipher;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JA_PI_SUBST;
import com.rsa.jsafe.JA_RC2BER;
import com.rsa.jsafe.JA_RC2Key;
import com.rsa.jsafe.JA_SymmetricPaddingScheme;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

final class JA_RC2
extends JSAFE_Object
implements JA_AlgaeBlockCipher,
Cloneable,
Serializable {
    private int[] keyTable = new int[64];
    private transient ObfuscatorItem tableOI;
    private int effectiveKeyBits;
    private static final int RC2_BLOCK_SIZE = 8;

    JA_RC2() {
        this.effectiveKeyBits = 128;
    }

    JA_RC2(int[] nArray) throws JSAFE_InvalidParameterException {
        this.setInstantiationParameters(nArray);
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        int n;
        if (nArray == null || nArray.length == 0) {
            n = 128;
        } else {
            if (nArray.length != 1) {
                throw new JSAFE_InvalidParameterException("Incorrect number of algorithm parameters:expected 1, effectiveKeyBits.");
            }
            n = nArray[0];
        }
        if (n < 1 || n > 1024) {
            throw new JSAFE_InvalidParameterException("Effective key bits should be between 1 and 1024.");
        }
        this.effectiveKeyBits = n;
    }

    public int[] getInstantiationParameters() {
        int[] nArray = new int[]{this.effectiveKeyBits};
        return nArray;
    }

    public void setAlgorithmBER(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        JA_RC2BER.setAlgorithmBER(this, byArray, n, n2, jA_FeedbackMode, jA_SymmetricPaddingScheme);
    }

    public byte[] getParamsDER(byte[] byArray) {
        return JA_RC2BER.getParamsDER(this.effectiveKeyBits, byArray);
    }

    public String getAlgorithm() {
        return "RC2";
    }

    public int getBlockSize() {
        return 8;
    }

    public boolean canWrapKey(boolean bl) {
        return false;
    }

    public void pbeKeySize(int n) {
        if (n < 1 || n > 1024) {
            this.effectiveKeyBits = 128;
        }
        this.effectiveKeyBits = n;
    }

    public byte[] wrapKey(JSAFE_Key jSAFE_Key, boolean bl, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot wrap key.");
    }

    public JSAFE_PrivateKey unwrapPrivateKey(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    public JSAFE_PublicKey unwrapPublicKey(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    public JSAFE_SecretKey unwrapSecretKey(byte[] byArray, int n, int n2, boolean bl, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private void prepareSerialization() {
        if (this.tableOI != null) {
            this.tableOI.deobfuscate();
        }
    }

    private void restoreAfterSerialization() {
        if (this.tableOI != null) {
            this.tableOI.obfuscate();
        }
    }

    private void restoreAfterDeserialization() {
        if (this.keyTable == null) {
            return;
        }
        this.tableOI = JSAFE_Obfuscator.register(this.keyTable);
        this.tableOI.obfuscate();
    }

    public Object clone() throws CloneNotSupportedException {
        JA_RC2 jA_RC2 = new JA_RC2();
        jA_RC2.keyTable = (int[])JSAFE_Obfuscator.copy(this.keyTable, this.tableOI);
        jA_RC2.tableOI = JSAFE_Obfuscator.getObfuscatorItem(jA_RC2.keyTable);
        jA_RC2.effectiveKeyBits = this.effectiveKeyBits;
        return jA_RC2;
    }

    public void encryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        this.init(jSAFE_SecretKey, secureRandom);
    }

    public void decryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        this.init(jSAFE_SecretKey, secureRandom);
    }

    private void init(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        byte[] byArray = null;
        try {
            byArray = ((JA_RC2Key)jSAFE_SecretKey).getSecretKeyData("Clear");
        }
        catch (ClassCastException classCastException) {
            throw new JSAFE_InvalidKeyException("Invalid key type");
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_InvalidKeyException("Invalid key type");
        }
        int n = 0;
        byte[] byArray2 = new byte[128];
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        n = byArray.length;
        while (n < 128) {
            int n2 = byArray2[n - 1] + byArray2[n - byArray.length] & 0xFF;
            byArray2[n] = JA_PI_SUBST.table[n2];
            ++n;
        }
        int n3 = (this.effectiveKeyBits + 7) / 8;
        int n4 = 255 >>> 7 - (this.effectiveKeyBits + 7) % 8;
        byArray2[128 - n3] = JA_PI_SUBST.table[byArray2[128 - n3] & n4];
        n = 127 - n3;
        while (n >= 0) {
            byArray2[n] = JA_PI_SUBST.table[(byArray2[n + 1] ^ byArray2[n + n3]) & 0xFF];
            --n;
        }
        if (this.tableOI != null) {
            this.tableOI.overwrite();
        }
        n = 0;
        while (n < 64) {
            int n5 = byArray2[2 * n + 1] << 8 & 0xFFFF;
            this.keyTable[n] = n5 + (byArray2[n * 2] & 0xFF);
            ++n;
        }
        if (this.tableOI == null) {
            this.tableOI = JSAFE_Obfuscator.register(this.keyTable);
        }
        this.tableOI.obfuscate();
        n = 0;
        while (n < byArray.length) {
            byArray[n] = 0;
            ++n;
        }
        n = 0;
        while (n < byArray2.length) {
            byArray2[n] = 0;
            ++n;
        }
    }

    public int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = byArray[n] & 0xFF;
        n3 += (byArray[++n] & 0xFF) << 8;
        int n4 = byArray[++n] & 0xFF;
        n4 += (byArray[++n] & 0xFF) << 8;
        int n5 = byArray[++n] & 0xFF;
        n5 += (byArray[++n] & 0xFF) << 8;
        int n6 = byArray[++n] & 0xFF;
        int n7 = this.keyTable[0];
        n7 += n3;
        n3 = ((n6 += (byArray[++n] & 0xFF) << 8) & n5) + (~n6 & n4);
        n3 += n7;
        n3 = n3 << 1 | (n3 & 0xFFFF) >>> 15;
        n7 = this.keyTable[1];
        n7 += n4;
        n4 = (n3 & n6) + (~n3 & n5);
        n4 += n7;
        n4 = n4 << 2 | (n4 & 0xFFFF) >>> 14;
        n7 = this.keyTable[2];
        n7 += n5;
        n5 = (n4 & n3) + (~n4 & n6);
        n5 += n7;
        n5 = n5 << 3 | (n5 & 0xFFFF) >>> 13;
        n7 = this.keyTable[3];
        n7 += n6;
        n6 = (n5 & n4) + (~n5 & n3);
        n6 += n7;
        n6 = n6 << 5 | (n6 & 0xFFFF) >>> 11;
        n7 = this.keyTable[4];
        n7 += n3;
        n3 = (n6 & n5) + (~n6 & n4);
        n3 += n7;
        n3 = n3 << 1 | (n3 & 0xFFFF) >>> 15;
        n7 = this.keyTable[5];
        n7 += n4;
        n4 = (n3 & n6) + (~n3 & n5);
        n4 += n7;
        n4 = n4 << 2 | (n4 & 0xFFFF) >>> 14;
        n7 = this.keyTable[6];
        n7 += n5;
        n5 = (n4 & n3) + (~n4 & n6);
        n5 += n7;
        n5 = n5 << 3 | (n5 & 0xFFFF) >>> 13;
        n7 = this.keyTable[7];
        n7 += n6;
        n6 = (n5 & n4) + (~n5 & n3);
        n6 += n7;
        n6 = n6 << 5 | (n6 & 0xFFFF) >>> 11;
        n7 = this.keyTable[8];
        n7 += n3;
        n3 = (n6 & n5) + (~n6 & n4);
        n3 += n7;
        n3 = n3 << 1 | (n3 & 0xFFFF) >>> 15;
        n7 = this.keyTable[9];
        n7 += n4;
        n4 = (n3 & n6) + (~n3 & n5);
        n4 += n7;
        n4 = n4 << 2 | (n4 & 0xFFFF) >>> 14;
        n7 = this.keyTable[10];
        n7 += n5;
        n5 = (n4 & n3) + (~n4 & n6);
        n5 += n7;
        n5 = n5 << 3 | (n5 & 0xFFFF) >>> 13;
        n7 = this.keyTable[11];
        n7 += n6;
        n6 = (n5 & n4) + (~n5 & n3);
        n6 += n7;
        n6 = n6 << 5 | (n6 & 0xFFFF) >>> 11;
        n7 = this.keyTable[12];
        n7 += n3;
        n3 = (n6 & n5) + (~n6 & n4);
        n3 += n7;
        n3 = n3 << 1 | (n3 & 0xFFFF) >>> 15;
        n7 = this.keyTable[13];
        n7 += n4;
        n4 = (n3 & n6) + (~n3 & n5);
        n4 += n7;
        n4 = n4 << 2 | (n4 & 0xFFFF) >>> 14;
        n7 = this.keyTable[14];
        n7 += n5;
        n5 = (n4 & n3) + (~n4 & n6);
        n5 += n7;
        n5 = n5 << 3 | (n5 & 0xFFFF) >>> 13;
        n7 = this.keyTable[15];
        n7 += n6;
        n6 = (n5 & n4) + (~n5 & n3);
        n6 += n7;
        n6 = n6 << 5 | (n6 & 0xFFFF) >>> 11;
        n7 = this.keyTable[16];
        n7 += n3;
        n3 = (n6 & n5) + (~n6 & n4);
        n3 += n7;
        n3 = n3 << 1 | (n3 & 0xFFFF) >>> 15;
        n7 = this.keyTable[17];
        n7 += n4;
        n4 = (n3 & n6) + (~n3 & n5);
        n4 += n7;
        n4 = n4 << 2 | (n4 & 0xFFFF) >>> 14;
        n7 = this.keyTable[18];
        n7 += n5;
        n5 = (n4 & n3) + (~n4 & n6);
        n5 += n7;
        n5 = n5 << 3 | (n5 & 0xFFFF) >>> 13;
        n7 = this.keyTable[19];
        n7 += n6;
        n6 = (n5 & n4) + (~n5 & n3);
        n6 += n7;
        n6 = n6 << 5 | (n6 & 0xFFFF) >>> 11;
        n5 += this.keyTable[(n4 += this.keyTable[(n3 += this.keyTable[n6 & 0x3F]) & 0x3F]) & 0x3F];
        n7 = this.keyTable[20];
        n7 += n3;
        n3 = ((n6 += this.keyTable[n5 & 0x3F]) & n5) + (~n6 & n4);
        n3 += n7;
        n3 = n3 << 1 | (n3 & 0xFFFF) >>> 15;
        n7 = this.keyTable[21];
        n7 += n4;
        n4 = (n3 & n6) + (~n3 & n5);
        n4 += n7;
        n4 = n4 << 2 | (n4 & 0xFFFF) >>> 14;
        n7 = this.keyTable[22];
        n7 += n5;
        n5 = (n4 & n3) + (~n4 & n6);
        n5 += n7;
        n5 = n5 << 3 | (n5 & 0xFFFF) >>> 13;
        n7 = this.keyTable[23];
        n7 += n6;
        n6 = (n5 & n4) + (~n5 & n3);
        n6 += n7;
        n6 = n6 << 5 | (n6 & 0xFFFF) >>> 11;
        n7 = this.keyTable[24];
        n7 += n3;
        n3 = (n6 & n5) + (~n6 & n4);
        n3 += n7;
        n3 = n3 << 1 | (n3 & 0xFFFF) >>> 15;
        n7 = this.keyTable[25];
        n7 += n4;
        n4 = (n3 & n6) + (~n3 & n5);
        n4 += n7;
        n4 = n4 << 2 | (n4 & 0xFFFF) >>> 14;
        n7 = this.keyTable[26];
        n7 += n5;
        n5 = (n4 & n3) + (~n4 & n6);
        n5 += n7;
        n5 = n5 << 3 | (n5 & 0xFFFF) >>> 13;
        n7 = this.keyTable[27];
        n7 += n6;
        n6 = (n5 & n4) + (~n5 & n3);
        n6 += n7;
        n6 = n6 << 5 | (n6 & 0xFFFF) >>> 11;
        n7 = this.keyTable[28];
        n7 += n3;
        n3 = (n6 & n5) + (~n6 & n4);
        n3 += n7;
        n3 = n3 << 1 | (n3 & 0xFFFF) >>> 15;
        n7 = this.keyTable[29];
        n7 += n4;
        n4 = (n3 & n6) + (~n3 & n5);
        n4 += n7;
        n4 = n4 << 2 | (n4 & 0xFFFF) >>> 14;
        n7 = this.keyTable[30];
        n7 += n5;
        n5 = (n4 & n3) + (~n4 & n6);
        n5 += n7;
        n5 = n5 << 3 | (n5 & 0xFFFF) >>> 13;
        n7 = this.keyTable[31];
        n7 += n6;
        n6 = (n5 & n4) + (~n5 & n3);
        n6 += n7;
        n6 = n6 << 5 | (n6 & 0xFFFF) >>> 11;
        n7 = this.keyTable[32];
        n7 += n3;
        n3 = (n6 & n5) + (~n6 & n4);
        n3 += n7;
        n3 = n3 << 1 | (n3 & 0xFFFF) >>> 15;
        n7 = this.keyTable[33];
        n7 += n4;
        n4 = (n3 & n6) + (~n3 & n5);
        n4 += n7;
        n4 = n4 << 2 | (n4 & 0xFFFF) >>> 14;
        n7 = this.keyTable[34];
        n7 += n5;
        n5 = (n4 & n3) + (~n4 & n6);
        n5 += n7;
        n5 = n5 << 3 | (n5 & 0xFFFF) >>> 13;
        n7 = this.keyTable[35];
        n7 += n6;
        n6 = (n5 & n4) + (~n5 & n3);
        n6 += n7;
        n6 = n6 << 5 | (n6 & 0xFFFF) >>> 11;
        n7 = this.keyTable[36];
        n7 += n3;
        n3 = (n6 & n5) + (~n6 & n4);
        n3 += n7;
        n3 = n3 << 1 | (n3 & 0xFFFF) >>> 15;
        n7 = this.keyTable[37];
        n7 += n4;
        n4 = (n3 & n6) + (~n3 & n5);
        n4 += n7;
        n4 = n4 << 2 | (n4 & 0xFFFF) >>> 14;
        n7 = this.keyTable[38];
        n7 += n5;
        n5 = (n4 & n3) + (~n4 & n6);
        n5 += n7;
        n5 = n5 << 3 | (n5 & 0xFFFF) >>> 13;
        n7 = this.keyTable[39];
        n7 += n6;
        n6 = (n5 & n4) + (~n5 & n3);
        n6 += n7;
        n6 = n6 << 5 | (n6 & 0xFFFF) >>> 11;
        n7 = this.keyTable[40];
        n7 += n3;
        n3 = (n6 & n5) + (~n6 & n4);
        n3 += n7;
        n3 = n3 << 1 | (n3 & 0xFFFF) >>> 15;
        n7 = this.keyTable[41];
        n7 += n4;
        n4 = (n3 & n6) + (~n3 & n5);
        n4 += n7;
        n4 = n4 << 2 | (n4 & 0xFFFF) >>> 14;
        n7 = this.keyTable[42];
        n7 += n5;
        n5 = (n4 & n3) + (~n4 & n6);
        n5 += n7;
        n5 = n5 << 3 | (n5 & 0xFFFF) >>> 13;
        n7 = this.keyTable[43];
        n7 += n6;
        n6 = (n5 & n4) + (~n5 & n3);
        n6 += n7;
        n6 = n6 << 5 | (n6 & 0xFFFF) >>> 11;
        n5 += this.keyTable[(n4 += this.keyTable[(n3 += this.keyTable[n6 & 0x3F]) & 0x3F]) & 0x3F];
        n7 = this.keyTable[44];
        n7 += n3;
        n3 = ((n6 += this.keyTable[n5 & 0x3F]) & n5) + (~n6 & n4);
        n3 += n7;
        n3 = n3 << 1 | (n3 & 0xFFFF) >>> 15;
        n7 = this.keyTable[45];
        n7 += n4;
        n4 = (n3 & n6) + (~n3 & n5);
        n4 += n7;
        n4 = n4 << 2 | (n4 & 0xFFFF) >>> 14;
        n7 = this.keyTable[46];
        n7 += n5;
        n5 = (n4 & n3) + (~n4 & n6);
        n5 += n7;
        n5 = n5 << 3 | (n5 & 0xFFFF) >>> 13;
        n7 = this.keyTable[47];
        n7 += n6;
        n6 = (n5 & n4) + (~n5 & n3);
        n6 += n7;
        n6 = n6 << 5 | (n6 & 0xFFFF) >>> 11;
        n7 = this.keyTable[48];
        n7 += n3;
        n3 = (n6 & n5) + (~n6 & n4);
        n3 += n7;
        n3 = n3 << 1 | (n3 & 0xFFFF) >>> 15;
        n7 = this.keyTable[49];
        n7 += n4;
        n4 = (n3 & n6) + (~n3 & n5);
        n4 += n7;
        n4 = n4 << 2 | (n4 & 0xFFFF) >>> 14;
        n7 = this.keyTable[50];
        n7 += n5;
        n5 = (n4 & n3) + (~n4 & n6);
        n5 += n7;
        n5 = n5 << 3 | (n5 & 0xFFFF) >>> 13;
        n7 = this.keyTable[51];
        n7 += n6;
        n6 = (n5 & n4) + (~n5 & n3);
        n6 += n7;
        n6 = n6 << 5 | (n6 & 0xFFFF) >>> 11;
        n7 = this.keyTable[52];
        n7 += n3;
        n3 = (n6 & n5) + (~n6 & n4);
        n3 += n7;
        n3 = n3 << 1 | (n3 & 0xFFFF) >>> 15;
        n7 = this.keyTable[53];
        n7 += n4;
        n4 = (n3 & n6) + (~n3 & n5);
        n4 += n7;
        n4 = n4 << 2 | (n4 & 0xFFFF) >>> 14;
        n7 = this.keyTable[54];
        n7 += n5;
        n5 = (n4 & n3) + (~n4 & n6);
        n5 += n7;
        n5 = n5 << 3 | (n5 & 0xFFFF) >>> 13;
        n7 = this.keyTable[55];
        n7 += n6;
        n6 = (n5 & n4) + (~n5 & n3);
        n6 += n7;
        n6 = n6 << 5 | (n6 & 0xFFFF) >>> 11;
        n7 = this.keyTable[56];
        n7 += n3;
        n3 = (n6 & n5) + (~n6 & n4);
        n3 += n7;
        n3 = n3 << 1 | (n3 & 0xFFFF) >>> 15;
        n7 = this.keyTable[57];
        n7 += n4;
        n4 = (n3 & n6) + (~n3 & n5);
        n4 += n7;
        n4 = n4 << 2 | (n4 & 0xFFFF) >>> 14;
        n7 = this.keyTable[58];
        n7 += n5;
        n5 = (n4 & n3) + (~n4 & n6);
        n5 += n7;
        n5 = n5 << 3 | (n5 & 0xFFFF) >>> 13;
        n7 = this.keyTable[59];
        n7 += n6;
        n6 = (n5 & n4) + (~n5 & n3);
        n6 += n7;
        n6 = n6 << 5 | (n6 & 0xFFFF) >>> 11;
        n7 = this.keyTable[60];
        n7 += n3;
        n3 = (n6 & n5) + (~n6 & n4);
        n3 += n7;
        n3 = n3 << 1 | (n3 & 0xFFFF) >>> 15;
        n7 = this.keyTable[61];
        n7 += n4;
        n4 = (n3 & n6) + (~n3 & n5);
        n4 += n7;
        n4 = n4 << 2 | (n4 & 0xFFFF) >>> 14;
        n7 = this.keyTable[62];
        n7 += n5;
        n5 = (n4 & n3) + (~n4 & n6);
        n5 += n7;
        n5 = n5 << 3 | (n5 & 0xFFFF) >>> 13;
        n7 = this.keyTable[63];
        n7 += n6;
        n6 = (n5 & n4) + (~n5 & n3);
        n6 += n7;
        n6 = n6 << 5 | (n6 & 0xFFFF) >>> 11;
        n7 = n2;
        byArray2[n7] = (byte)(n3 & 0xFF);
        byArray2[++n7] = (byte)((n3 & 0xFF00) >>> 8);
        byArray2[++n7] = (byte)(n4 & 0xFF);
        byArray2[++n7] = (byte)((n4 & 0xFF00) >>> 8);
        byArray2[++n7] = (byte)(n5 & 0xFF);
        byArray2[++n7] = (byte)((n5 & 0xFF00) >>> 8);
        byArray2[++n7] = (byte)(n6 & 0xFF);
        byArray2[++n7] = (byte)((n6 & 0xFF00) >>> 8);
        return 8;
    }

    public int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = byArray[n] & 0xFF;
        n3 += (byArray[++n] & 0xFF) << 8;
        int n4 = byArray[++n] & 0xFF;
        n4 += (byArray[++n] & 0xFF) << 8;
        int n5 = byArray[++n] & 0xFF;
        n5 += (byArray[++n] & 0xFF) << 8;
        int n6 = byArray[++n] & 0xFF;
        n6 += (byArray[++n] & 0xFF) << 8;
        n6 = (n6 & 0xFFFF) >>> 5 | n6 << 11;
        n6 -= this.keyTable[63] + (n5 & n4) + (~n5 & n3);
        n5 = (n5 & 0xFFFF) >>> 3 | n5 << 13;
        n5 -= this.keyTable[62] + (n4 & n3) + (~n4 & n6);
        n4 = (n4 & 0xFFFF) >>> 2 | n4 << 14;
        n4 -= this.keyTable[61] + (n3 & n6) + (~n3 & n5);
        n3 = (n3 & 0xFFFF) >>> 1 | n3 << 15;
        n3 -= this.keyTable[60] + (n6 & n5) + (~n6 & n4);
        n6 = (n6 & 0xFFFF) >>> 5 | n6 << 11;
        n6 -= this.keyTable[59] + (n5 & n4) + (~n5 & n3);
        n5 = (n5 & 0xFFFF) >>> 3 | n5 << 13;
        n5 -= this.keyTable[58] + (n4 & n3) + (~n4 & n6);
        n4 = (n4 & 0xFFFF) >>> 2 | n4 << 14;
        n4 -= this.keyTable[57] + (n3 & n6) + (~n3 & n5);
        n3 = (n3 & 0xFFFF) >>> 1 | n3 << 15;
        n3 -= this.keyTable[56] + (n6 & n5) + (~n6 & n4);
        n6 = (n6 & 0xFFFF) >>> 5 | n6 << 11;
        n6 -= this.keyTable[55] + (n5 & n4) + (~n5 & n3);
        n5 = (n5 & 0xFFFF) >>> 3 | n5 << 13;
        n5 -= this.keyTable[54] + (n4 & n3) + (~n4 & n6);
        n4 = (n4 & 0xFFFF) >>> 2 | n4 << 14;
        n4 -= this.keyTable[53] + (n3 & n6) + (~n3 & n5);
        n3 = (n3 & 0xFFFF) >>> 1 | n3 << 15;
        n3 -= this.keyTable[52] + (n6 & n5) + (~n6 & n4);
        n6 = (n6 & 0xFFFF) >>> 5 | n6 << 11;
        n6 -= this.keyTable[51] + (n5 & n4) + (~n5 & n3);
        n5 = (n5 & 0xFFFF) >>> 3 | n5 << 13;
        n5 -= this.keyTable[50] + (n4 & n3) + (~n4 & n6);
        n4 = (n4 & 0xFFFF) >>> 2 | n4 << 14;
        n4 -= this.keyTable[49] + (n3 & n6) + (~n3 & n5);
        n3 = (n3 & 0xFFFF) >>> 1 | n3 << 15;
        n3 -= this.keyTable[48] + (n6 & n5) + (~n6 & n4);
        n6 = (n6 & 0xFFFF) >>> 5 | n6 << 11;
        n6 -= this.keyTable[47] + (n5 & n4) + (~n5 & n3);
        n5 = (n5 & 0xFFFF) >>> 3 | n5 << 13;
        n5 -= this.keyTable[46] + (n4 & n3) + (~n4 & n6);
        n4 = (n4 & 0xFFFF) >>> 2 | n4 << 14;
        n4 -= this.keyTable[45] + (n3 & n6) + (~n3 & n5);
        n3 = (n3 & 0xFFFF) >>> 1 | n3 << 15;
        n3 -= this.keyTable[44] + (n6 & n5) + (~n6 & n4);
        n6 -= this.keyTable[n5 & 0x3F];
        n5 -= this.keyTable[n4 & 0x3F];
        n4 -= this.keyTable[n3 & 0x3F];
        n3 -= this.keyTable[n6 & 0x3F];
        n6 = (n6 & 0xFFFF) >>> 5 | n6 << 11;
        n6 -= this.keyTable[43] + (n5 & n4) + (~n5 & n3);
        n5 = (n5 & 0xFFFF) >>> 3 | n5 << 13;
        n5 -= this.keyTable[42] + (n4 & n3) + (~n4 & n6);
        n4 = (n4 & 0xFFFF) >>> 2 | n4 << 14;
        n4 -= this.keyTable[41] + (n3 & n6) + (~n3 & n5);
        n3 = (n3 & 0xFFFF) >>> 1 | n3 << 15;
        n3 -= this.keyTable[40] + (n6 & n5) + (~n6 & n4);
        n6 = (n6 & 0xFFFF) >>> 5 | n6 << 11;
        n6 -= this.keyTable[39] + (n5 & n4) + (~n5 & n3);
        n5 = (n5 & 0xFFFF) >>> 3 | n5 << 13;
        n5 -= this.keyTable[38] + (n4 & n3) + (~n4 & n6);
        n4 = (n4 & 0xFFFF) >>> 2 | n4 << 14;
        n4 -= this.keyTable[37] + (n3 & n6) + (~n3 & n5);
        n3 = (n3 & 0xFFFF) >>> 1 | n3 << 15;
        n3 -= this.keyTable[36] + (n6 & n5) + (~n6 & n4);
        n6 = (n6 & 0xFFFF) >>> 5 | n6 << 11;
        n6 -= this.keyTable[35] + (n5 & n4) + (~n5 & n3);
        n5 = (n5 & 0xFFFF) >>> 3 | n5 << 13;
        n5 -= this.keyTable[34] + (n4 & n3) + (~n4 & n6);
        n4 = (n4 & 0xFFFF) >>> 2 | n4 << 14;
        n4 -= this.keyTable[33] + (n3 & n6) + (~n3 & n5);
        n3 = (n3 & 0xFFFF) >>> 1 | n3 << 15;
        n3 -= this.keyTable[32] + (n6 & n5) + (~n6 & n4);
        n6 = (n6 & 0xFFFF) >>> 5 | n6 << 11;
        n6 -= this.keyTable[31] + (n5 & n4) + (~n5 & n3);
        n5 = (n5 & 0xFFFF) >>> 3 | n5 << 13;
        n5 -= this.keyTable[30] + (n4 & n3) + (~n4 & n6);
        n4 = (n4 & 0xFFFF) >>> 2 | n4 << 14;
        n4 -= this.keyTable[29] + (n3 & n6) + (~n3 & n5);
        n3 = (n3 & 0xFFFF) >>> 1 | n3 << 15;
        n3 -= this.keyTable[28] + (n6 & n5) + (~n6 & n4);
        n6 = (n6 & 0xFFFF) >>> 5 | n6 << 11;
        n6 -= this.keyTable[27] + (n5 & n4) + (~n5 & n3);
        n5 = (n5 & 0xFFFF) >>> 3 | n5 << 13;
        n5 -= this.keyTable[26] + (n4 & n3) + (~n4 & n6);
        n4 = (n4 & 0xFFFF) >>> 2 | n4 << 14;
        n4 -= this.keyTable[25] + (n3 & n6) + (~n3 & n5);
        n3 = (n3 & 0xFFFF) >>> 1 | n3 << 15;
        n3 -= this.keyTable[24] + (n6 & n5) + (~n6 & n4);
        n6 = (n6 & 0xFFFF) >>> 5 | n6 << 11;
        n6 -= this.keyTable[23] + (n5 & n4) + (~n5 & n3);
        n5 = (n5 & 0xFFFF) >>> 3 | n5 << 13;
        n5 -= this.keyTable[22] + (n4 & n3) + (~n4 & n6);
        n4 = (n4 & 0xFFFF) >>> 2 | n4 << 14;
        n4 -= this.keyTable[21] + (n3 & n6) + (~n3 & n5);
        n3 = (n3 & 0xFFFF) >>> 1 | n3 << 15;
        n3 -= this.keyTable[20] + (n6 & n5) + (~n6 & n4);
        n6 -= this.keyTable[n5 & 0x3F];
        n5 -= this.keyTable[n4 & 0x3F];
        n4 -= this.keyTable[n3 & 0x3F];
        n3 -= this.keyTable[n6 & 0x3F];
        n6 = (n6 & 0xFFFF) >>> 5 | n6 << 11;
        n6 -= this.keyTable[19] + (n5 & n4) + (~n5 & n3);
        n5 = (n5 & 0xFFFF) >>> 3 | n5 << 13;
        n5 -= this.keyTable[18] + (n4 & n3) + (~n4 & n6);
        n4 = (n4 & 0xFFFF) >>> 2 | n4 << 14;
        n4 -= this.keyTable[17] + (n3 & n6) + (~n3 & n5);
        n3 = (n3 & 0xFFFF) >>> 1 | n3 << 15;
        n3 -= this.keyTable[16] + (n6 & n5) + (~n6 & n4);
        n6 = (n6 & 0xFFFF) >>> 5 | n6 << 11;
        n6 -= this.keyTable[15] + (n5 & n4) + (~n5 & n3);
        n5 = (n5 & 0xFFFF) >>> 3 | n5 << 13;
        n5 -= this.keyTable[14] + (n4 & n3) + (~n4 & n6);
        n4 = (n4 & 0xFFFF) >>> 2 | n4 << 14;
        n4 -= this.keyTable[13] + (n3 & n6) + (~n3 & n5);
        n3 = (n3 & 0xFFFF) >>> 1 | n3 << 15;
        n3 -= this.keyTable[12] + (n6 & n5) + (~n6 & n4);
        n6 = (n6 & 0xFFFF) >>> 5 | n6 << 11;
        n6 -= this.keyTable[11] + (n5 & n4) + (~n5 & n3);
        n5 = (n5 & 0xFFFF) >>> 3 | n5 << 13;
        n5 -= this.keyTable[10] + (n4 & n3) + (~n4 & n6);
        n4 = (n4 & 0xFFFF) >>> 2 | n4 << 14;
        n4 -= this.keyTable[9] + (n3 & n6) + (~n3 & n5);
        n3 = (n3 & 0xFFFF) >>> 1 | n3 << 15;
        n3 -= this.keyTable[8] + (n6 & n5) + (~n6 & n4);
        n6 = (n6 & 0xFFFF) >>> 5 | n6 << 11;
        n6 -= this.keyTable[7] + (n5 & n4) + (~n5 & n3);
        n5 = (n5 & 0xFFFF) >>> 3 | n5 << 13;
        n5 -= this.keyTable[6] + (n4 & n3) + (~n4 & n6);
        n4 = (n4 & 0xFFFF) >>> 2 | n4 << 14;
        n4 -= this.keyTable[5] + (n3 & n6) + (~n3 & n5);
        n3 = (n3 & 0xFFFF) >>> 1 | n3 << 15;
        n3 -= this.keyTable[4] + (n6 & n5) + (~n6 & n4);
        n6 = (n6 & 0xFFFF) >>> 5 | n6 << 11;
        n6 -= this.keyTable[3] + (n5 & n4) + (~n5 & n3);
        n5 = (n5 & 0xFFFF) >>> 3 | n5 << 13;
        n5 -= this.keyTable[2] + (n4 & n3) + (~n4 & n6);
        n4 = (n4 & 0xFFFF) >>> 2 | n4 << 14;
        n4 -= this.keyTable[1] + (n3 & n6) + (~n3 & n5);
        n3 = (n3 & 0xFFFF) >>> 1 | n3 << 15;
        int n7 = n2;
        byArray2[n7] = (byte)((n3 -= this.keyTable[0] + (n6 & n5) + (~n6 & n4)) & 0xFF);
        byArray2[++n7] = (byte)((n3 & 0xFF00) >>> 8);
        byArray2[++n7] = (byte)(n4 & 0xFF);
        byArray2[++n7] = (byte)((n4 & 0xFF00) >>> 8);
        byArray2[++n7] = (byte)(n5 & 0xFF);
        byArray2[++n7] = (byte)((n5 & 0xFF00) >>> 8);
        byArray2[++n7] = (byte)(n6 & 0xFF);
        byArray2[++n7] = (byte)((n6 & 0xFF00) >>> 8);
        return 8;
    }

    public void obfuscate() {
        if (this.tableOI != null) {
            this.tableOI.obfuscate();
        }
    }

    public void deobfuscate() {
        if (this.tableOI != null) {
            this.tableOI.deobfuscate();
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        JSAFE_Obfuscator.deregister(this.keyTable, this.tableOI);
        this.tableOI = null;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

