/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.jsafe.JA_AlgaeSymmetricCipher;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JA_PI_SUBST;
import com.rsa.jsafe.JA_SymmetricPaddingScheme;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_UnimplementedException;

public final class JA_RC2BER
extends JSAFE_Object {
    public static void setAlgorithmBER(JA_AlgaeSymmetricCipher jA_AlgaeSymmetricCipher, byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        Object object;
        int n3 = 32;
        int n4 = byArray[n] & 0xFF;
        if (n4 != 48) {
            jA_FeedbackMode.setAlgorithmBER(byArray, n, n2);
        } else {
            object = new SequenceContainer(0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0);
            EncodedContainer encodedContainer = new EncodedContainer(130816);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{object, integerContainer, encodedContainer, endContainer};
            try {
                ASN1.berDecode(byArray, n, aSN1ContainerArray);
                n3 = integerContainer.getValueAsInt();
            }
            catch (ASN_Exception aSN_Exception) {
                throw new JSAFE_UnimplementedException("Invalid RC2 BER encoding. (" + aSN_Exception.getMessage() + ")");
            }
            if (n3 < 256) {
                int n5 = 0;
                while (n5 < 256) {
                    if (JA_PI_SUBST.rc2VersionTable[n5] == (byte)n3) {
                        n3 = n5;
                        break;
                    }
                    ++n5;
                }
            }
            jA_FeedbackMode.setAlgorithmBER(encodedContainer.data, encodedContainer.dataOffset, encodedContainer.dataLen);
        }
        object = new int[]{n3};
        try {
            jA_AlgaeSymmetricCipher.setInstantiationParameters((int[])object);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_UnimplementedException("Invalid RC2 BER encoding.");
        }
    }

    public static byte[] getParamsDER(int n, byte[] byArray) {
        if (n == 32) {
            return byArray;
        }
        Object var2_2 = null;
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            int n2 = n >= 256 ? n : JA_PI_SUBST.rc2VersionTable[n] & 0xFF;
            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, n2);
            boolean bl = false;
            int n3 = 0;
            if (byArray != null) {
                bl = true;
                n3 = byArray.length;
            }
            EncodedContainer encodedContainer = new EncodedContainer(130816, bl, 5, byArray, 0, n3);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, endContainer};
            return ASN1.derEncode(aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            return null;
        }
    }
}

