/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeStreamCipher;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JA_RC4Key;
import com.rsa.jsafe.JA_SymmetricPaddingScheme;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public class JA_RC4
extends JSAFE_Object
implements JA_AlgaeStreamCipher,
Cloneable,
Serializable {
    private int[] table = new int[256];
    private transient ObfuscatorItem tableOI;
    private int ti;
    private int tj;
    private int i;
    private int j;

    public JA_RC4() {
    }

    public JA_RC4(int[] nArray) throws JSAFE_InvalidParameterException {
        this.setInstantiationParameters(nArray);
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Incorrect number of parameters: expected none.");
        }
    }

    public int[] getInstantiationParameters() {
        return new int[0];
    }

    public void setAlgorithmBER(byte[] byArray, int n, int n2) {
    }

    public byte[] getParamsDER() {
        return null;
    }

    public String getAlgorithm() {
        return "RC4";
    }

    public int getOutputBufferSize(int n) {
        return n;
    }

    public boolean canWrapKey(boolean bl) {
        return false;
    }

    public void pbeKeySize(int n) {
    }

    public byte[] wrapKey(JSAFE_Key jSAFE_Key, boolean bl, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot wrap key.");
    }

    public JSAFE_PrivateKey unwrapPrivateKey(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    public JSAFE_PublicKey unwrapPublicKey(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    public JSAFE_SecretKey unwrapSecretKey(byte[] byArray, int n, int n2, boolean bl, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private void prepareSerialization() {
        if (this.tableOI != null) {
            this.tableOI.deobfuscate();
        }
    }

    private void restoreAfterSerialization() {
        if (this.tableOI != null) {
            this.tableOI.obfuscate();
        }
    }

    private void restoreAfterDeserialization() {
        if (this.table == null) {
            return;
        }
        this.tableOI = JSAFE_Obfuscator.register(this.table);
        this.tableOI.obfuscate();
    }

    public Object clone() throws CloneNotSupportedException {
        JA_RC4 jA_RC4 = new JA_RC4();
        jA_RC4.table = (int[])JSAFE_Obfuscator.copy(this.table, this.tableOI);
        jA_RC4.tableOI = JSAFE_Obfuscator.getObfuscatorItem(jA_RC4.table);
        jA_RC4.ti = this.ti;
        jA_RC4.tj = this.tj;
        jA_RC4.i = this.i;
        jA_RC4.j = this.j;
        return jA_RC4;
    }

    public void encryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        this.init(jSAFE_SecretKey, secureRandom);
    }

    public void decryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        this.init(jSAFE_SecretKey, secureRandom);
    }

    public void init(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        byte[] byArray = null;
        try {
            byArray = ((JA_RC4Key)jSAFE_SecretKey).getSecretKeyData("Clear");
        }
        catch (ClassCastException classCastException) {
            throw new JSAFE_InvalidKeyException("Invalid key type");
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_InvalidKeyException("Invalid key type");
        }
        if (byArray == null) {
            return;
        }
        if (this.tableOI != null) {
            this.tableOI.overwrite();
        }
        int n = 0;
        while (n <= 255) {
            this.table[n] = n;
            ++n;
        }
        this.i = 0;
        this.j = 0;
        n = 0;
        while (this.i < 256) {
            this.ti = this.table[this.i];
            byte by = byArray[n];
            this.j += by;
            this.j += this.ti;
            this.j &= 0xFF;
            this.tj = this.table[this.j];
            ++this.i;
            this.table[this.i - 1] = this.tj;
            this.table[this.j] = this.ti;
            if (++n != byArray.length) continue;
            n = 0;
        }
        if (this.tableOI == null) {
            this.tableOI = JSAFE_Obfuscator.register(this.table);
        }
        this.tableOI.obfuscate();
        JSAFE_Obfuscator.overwrite(byArray);
        this.i = 0;
        this.j = 0;
    }

    public int encryptUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n2 <= 0) {
            return 0;
        }
        this.RC4Update(byArray, n, n2, byArray2, n3);
        return n2;
    }

    public int encryptFinal(byte[] byArray, int n) {
        return 0;
    }

    public int decryptUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n2 <= 0) {
            return 0;
        }
        this.RC4Update(byArray, n, n2, byArray2, n3);
        return n2;
    }

    public int decryptFinal(byte[] byArray, int n) {
        return 0;
    }

    private void RC4Update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        n2 += n;
        while (n < n2) {
            ++this.i;
            this.i &= 0xFF;
            this.ti = this.table[this.i];
            this.j = this.j + this.ti & 0xFF;
            this.table[this.i] = this.tj = this.table[this.j];
            this.table[this.j] = this.ti;
            this.tj = this.table[this.tj + this.ti & 0xFF];
            byArray2[n3] = (byte)(byArray[n] ^ this.tj);
            ++n;
            ++n3;
        }
    }

    public void obfuscate() {
        this.tableOI.obfuscate();
    }

    public void deobfuscate() {
        this.tableOI.deobfuscate();
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        JSAFE_Obfuscator.deregister(this.table, this.tableOI);
        this.tableOI = null;
        this.i = 0;
        this.j = 0;
        this.ti = 0;
        this.tj = 0;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

