/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeBlockCipher;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JA_RC5BER;
import com.rsa.jsafe.JA_RC5Key;
import com.rsa.jsafe.JA_RC5Operations32;
import com.rsa.jsafe.JA_RC5Operations64;
import com.rsa.jsafe.JA_RCOperations;
import com.rsa.jsafe.JA_SymmetricPaddingScheme;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.security.SecureRandom;

class JA_RC5
extends JSAFE_Object
implements JA_AlgaeBlockCipher,
Cloneable,
Serializable {
    protected int version;
    protected int rounds;
    protected int wordSizeInBits;
    protected int blockSize;
    protected JA_RCOperations rcOperations;

    JA_RC5() {
        try {
            this.setInstantiationParameters(JA_RC5.getDEFAULT_VERSION(), JA_RC5.getDEFAULT_WORD_SIZE(), JA_RC5.getDEFAULT_ROUNDS());
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            // empty catch block
        }
    }

    JA_RC5(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray == null || nArray.length == 0) {
            this.setInstantiationParameters(JA_RC5.getDEFAULT_VERSION(), JA_RC5.getDEFAULT_WORD_SIZE(), JA_RC5.getDEFAULT_ROUNDS());
        } else {
            this.setInstantiationParameters(nArray);
        }
    }

    protected JA_RC5 cloneEmptyObject() {
        JA_RC5 jA_RC5 = new JA_RC5();
        return jA_RC5;
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (nArray.length != 3) {
            throw new JSAFE_InvalidParameterException("Incorrect number of RC5 parameters: expected 3: version, wordSizeInBits, rounds)");
        }
        this.setInstantiationParameters(nArray[0], nArray[1], nArray[2]);
    }

    void setInstantiationParameters(int n, int n2, int n3) throws JSAFE_InvalidParameterException {
        if (n != JA_RC5.getDEFAULT_VERSION()) {
            throw new JSAFE_InvalidParameterException("Only Version " + JA_RC5.getDEFAULT_VERSION() + " of " + this.getAlgorithm() + " is currently implemented");
        }
        if (n3 < JA_RC5.getMIN_ROUNDS() || n3 > JA_RC5.getMAX_ROUNDS()) {
            throw new JSAFE_InvalidParameterException("Number of Rounds for " + this.getAlgorithm() + " should be between " + JA_RC5.getMIN_ROUNDS() + " and " + JA_RC5.getMAX_ROUNDS());
        }
        JA_RCOperations jA_RCOperations = this.NewOperationsObject(n2, n3);
        this.version = n;
        this.wordSizeInBits = n2;
        this.rounds = n3;
        this.blockSize = this.getBlockSizeFirstTime();
        this.rcOperations = jA_RCOperations;
    }

    protected JA_RCOperations NewOperationsObject(int n, int n2) throws JSAFE_InvalidParameterException {
        switch (n) {
            case 32: {
                return new JA_RC5Operations32(n2);
            }
            case 64: {
                return new JA_RC5Operations64(n2);
            }
        }
        throw new JSAFE_InvalidParameterException("Invalid word size for " + this.getAlgorithm() + " only 32 and 64 are supported");
    }

    public int[] getInstantiationParameters() {
        int[] nArray = new int[]{this.version, this.wordSizeInBits, this.rounds};
        return nArray;
    }

    public void setAlgorithmBER(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        JA_RC5BER.setAlgorithmBER(this, byArray, n, n2, jA_FeedbackMode, jA_SymmetricPaddingScheme);
    }

    public byte[] getParamsDER(byte[] byArray) {
        return JA_RC5BER.getParamsDER(this.version, this.wordSizeInBits, this.rounds, byArray);
    }

    public String getAlgorithm() {
        return "RC5";
    }

    protected JA_RCOperations getRCOperations() {
        return this.rcOperations;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    protected static int getDEFAULT_WORD_SIZE() {
        return 32;
    }

    protected static int getDEFAULT_VERSION() {
        return 16;
    }

    protected static int getMIN_ROUNDS() {
        return 0;
    }

    protected static int getMAX_ROUNDS() {
        return 255;
    }

    protected int getBlockSizeFirstTime() {
        return 2 * (this.wordSizeInBits / 8);
    }

    protected static int getDEFAULT_ROUNDS() {
        return 12;
    }

    public boolean canWrapKey(boolean bl) {
        return false;
    }

    public void pbeKeySize(int n) {
    }

    public byte[] wrapKey(JSAFE_Key jSAFE_Key, boolean bl, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot wrap key.");
    }

    public JSAFE_PrivateKey unwrapPrivateKey(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    public JSAFE_PublicKey unwrapPublicKey(byte[] byArray, int n, int n2, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    public JSAFE_SecretKey unwrapSecretKey(byte[] byArray, int n, int n2, boolean bl, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    public Object clone() throws CloneNotSupportedException {
        JA_RC5 jA_RC5 = this.cloneEmptyObject();
        jA_RC5.version = this.version;
        jA_RC5.rounds = this.rounds;
        jA_RC5.wordSizeInBits = this.wordSizeInBits;
        jA_RC5.blockSize = this.blockSize;
        JA_RCOperations jA_RCOperations = this.getRCOperations();
        if (jA_RCOperations != null) {
            jA_RC5.rcOperations = (JA_RCOperations)jA_RCOperations.clone();
        }
        return jA_RC5;
    }

    public void encryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        this.init(jSAFE_SecretKey, secureRandom);
    }

    public void decryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        this.init(jSAFE_SecretKey, secureRandom);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException {
        int n;
        byte[] byArray = null;
        try {
            try {
                byArray = ((JA_RC5Key)jSAFE_SecretKey).getSecretKeyData("Clear");
                if (byArray != null) {
                    this.getRCOperations().RCInit(byArray, 0, byArray.length);
                }
            }
            catch (ClassCastException classCastException) {
                throw new JSAFE_InvalidKeyException("Invalid key type");
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new JSAFE_InvalidKeyException("Invalid Key Type");
            }
            Object var7_4 = null;
            if (byArray == null) return;
            int n2 = 0;
            while (n2 < byArray.length) {
                byArray[n2] = 0;
                ++n2;
            }
            return;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (byArray == null) throw throwable;
            n = 0;
        }
        while (true) {
            if (n >= byArray.length) {
                throw throwable;
            }
            byArray[n] = 0;
            ++n;
        }
    }

    public int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.getRCOperations().RCEncrypt(byArray, n, byArray2, n2);
        return this.blockSize;
    }

    public int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.getRCOperations().RCDecrypt(byArray, n, byArray2, n2);
        return this.blockSize;
    }

    public void obfuscate() {
        this.getRCOperations().obfuscate();
    }

    public void deobfuscate() {
        this.getRCOperations().deobfuscate();
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        JA_RCOperations jA_RCOperations = this.getRCOperations();
        if (jA_RCOperations != null) {
            jA_RCOperations.clearSensitiveData();
        }
    }
}

