/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_RCOperations;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

final class JA_RC5Operations32
extends JA_RCOperations
implements Cloneable,
Serializable {
    private int[] keyTable;
    private transient ObfuscatorItem tableOI;
    private int keyTableSize;
    private static final int MAGIC_P32 = -1209970333;
    private static final int MAGIC_Q32 = -1640531527;
    private int A;
    private int B;

    JA_RC5Operations32(int n) {
        int n2 = 2 * n + 2;
        int[] nArray = new int[n2];
        this.keyTable = nArray;
        this.keyTableSize = n2;
    }

    private JA_RC5Operations32() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private void prepareSerialization() {
        if (this.tableOI != null) {
            this.tableOI.deobfuscate();
        }
    }

    private void restoreAfterSerialization() {
        if (this.tableOI != null) {
            this.tableOI.obfuscate();
        }
    }

    private void restoreAfterDeserialization() {
        if (this.keyTable == null) {
            return;
        }
        this.tableOI = JSAFE_Obfuscator.register(this.keyTable);
        this.tableOI.obfuscate();
    }

    public Object clone() throws CloneNotSupportedException {
        JA_RC5Operations32 jA_RC5Operations32 = new JA_RC5Operations32();
        jA_RC5Operations32.keyTable = null;
        if (this.keyTable != null) {
            jA_RC5Operations32.keyTable = (int[])JSAFE_Obfuscator.copy(this.keyTable, this.tableOI);
        }
        jA_RC5Operations32.tableOI = JSAFE_Obfuscator.getObfuscatorItem(jA_RC5Operations32.keyTable);
        jA_RC5Operations32.A = this.A;
        jA_RC5Operations32.B = this.B;
        jA_RC5Operations32.keyTableSize = this.keyTableSize;
        return jA_RC5Operations32;
    }

    void RCInit(byte[] byArray, int n, int n2) {
        int n3;
        if (this.tableOI != null) {
            this.tableOI.overwrite();
        }
        int n4 = n2 == 0 ? 1 : (n2 + 3) / 4;
        int[] nArray = new int[n4];
        int n5 = 0;
        while (n2 >= 4) {
            int n6 = n5;
            nArray[n6] = nArray[n6] + (byArray[n] & 0xFF);
            int n7 = n5;
            nArray[n7] = nArray[n7] + ((byArray[++n] & 0xFF) << 8);
            int n8 = n5;
            nArray[n8] = nArray[n8] + ((byArray[++n] & 0xFF) << 16);
            int n9 = n5++;
            nArray[n9] = nArray[n9] + ((byArray[++n] & 0xFF) << 24);
            ++n;
            n2 -= 4;
        }
        int n10 = 0;
        while (n2 > 0) {
            int n11 = n5;
            nArray[n11] = nArray[n11] + ((byArray[n] & 0xFF) << n10);
            --n2;
            ++n;
            n10 += 8;
        }
        this.keyTable[0] = -1209970333;
        int n12 = 1;
        while (n12 < this.keyTableSize) {
            this.keyTable[n12] = this.keyTable[n12 - 1] + -1640531527;
            ++n12;
        }
        n12 = 0;
        n5 = 0;
        this.A = 0;
        this.B = 0;
        int n13 = n4 > this.keyTableSize ? 3 * n4 : 3 * this.keyTableSize;
        while (n13 > 0) {
            this.A = this.A + this.B + this.keyTable[n12];
            this.keyTable[n12] = this.A = this.A << 3 | this.A >>> 29;
            n3 = this.A + this.B;
            this.B = nArray[n5] + n3;
            nArray[n5] = this.B = this.B << (n3 &= 0x1F) | this.B >>> 32 - n3;
            if (++n12 >= this.keyTableSize) {
                n12 = 0;
            }
            if (++n5 >= n4) {
                n5 = 0;
            }
            --n13;
        }
        if (this.tableOI == null) {
            this.tableOI = JSAFE_Obfuscator.register(this.keyTable);
        }
        this.tableOI.obfuscate();
        n3 = 0;
        JSAFE_Obfuscator.overwrite(nArray);
    }

    void RCEncrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.A = byArray[n] & 0xFF;
        this.A += (byArray[++n] & 0xFF) << 8;
        this.A += (byArray[++n] & 0xFF) << 16;
        this.A += (byArray[++n] & 0xFF) << 24;
        this.B = byArray[++n] & 0xFF;
        this.B += (byArray[++n] & 0xFF) << 8;
        this.B += (byArray[++n] & 0xFF) << 16;
        this.B += (byArray[++n] & 0xFF) << 24;
        this.A += this.keyTable[0];
        this.B += this.keyTable[1];
        int n3 = 2;
        while (n3 < this.keyTableSize) {
            this.A ^= this.B;
            int n4 = this.B & 0x1F;
            this.A = this.A << n4 | this.A >>> 32 - n4;
            this.A += this.keyTable[n3];
            this.B ^= this.A;
            n4 = this.A & 0x1F;
            this.B = this.B << n4 | this.B >>> 32 - n4;
            this.B += this.keyTable[n3 + 1];
            n3 += 2;
        }
        byArray2[n2] = (byte)(this.A & 0xFF);
        byArray2[++n2] = (byte)(this.A >>> 8 & 0xFF);
        byArray2[++n2] = (byte)(this.A >>> 16 & 0xFF);
        byArray2[++n2] = (byte)(this.A >>> 24 & 0xFF);
        byArray2[++n2] = (byte)(this.B & 0xFF);
        byArray2[++n2] = (byte)(this.B >>> 8 & 0xFF);
        byArray2[++n2] = (byte)(this.B >>> 16 & 0xFF);
        byArray2[++n2] = (byte)(this.B >>> 24 & 0xFF);
    }

    void RCDecrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.A = byArray[n] & 0xFF;
        this.A += (byArray[++n] & 0xFF) << 8;
        this.A += (byArray[++n] & 0xFF) << 16;
        this.A += (byArray[++n] & 0xFF) << 24;
        this.B = byArray[++n] & 0xFF;
        this.B += (byArray[++n] & 0xFF) << 8;
        this.B += (byArray[++n] & 0xFF) << 16;
        this.B += (byArray[++n] & 0xFF) << 24;
        int n3 = this.keyTableSize - 1;
        while (n3 > 2) {
            this.B -= this.keyTable[n3];
            int n4 = this.A & 0x1F;
            this.B = this.B >>> n4 | this.B << 32 - n4;
            this.B ^= this.A;
            this.A -= this.keyTable[n3 - 1];
            n4 = this.B & 0x1F;
            this.A = this.A >>> n4 | this.A << 32 - n4;
            this.A ^= this.B;
            n3 -= 2;
        }
        this.B -= this.keyTable[1];
        this.A -= this.keyTable[0];
        byArray2[n2] = (byte)(this.A & 0xFF);
        byArray2[++n2] = (byte)(this.A >>> 8 & 0xFF);
        byArray2[++n2] = (byte)(this.A >>> 16 & 0xFF);
        byArray2[++n2] = (byte)(this.A >>> 24 & 0xFF);
        byArray2[++n2] = (byte)(this.B & 0xFF);
        byArray2[++n2] = (byte)(this.B >>> 8 & 0xFF);
        byArray2[++n2] = (byte)(this.B >>> 16 & 0xFF);
        byArray2[++n2] = (byte)(this.B >>> 24 & 0xFF);
    }

    void obfuscate() {
        if (this.tableOI != null) {
            this.tableOI.obfuscate();
        }
    }

    void deobfuscate() {
        if (this.tableOI != null) {
            this.tableOI.deobfuscate();
        }
    }

    void clearSensitiveData() {
        JSAFE_Obfuscator.deregister(this.keyTable, this.tableOI);
        this.tableOI = null;
        this.A = 0;
        this.B = 0;
    }
}

