/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_RCOperations;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

final class JA_RC5Operations64
extends JA_RCOperations
implements Cloneable,
Serializable {
    private long[] keyTable;
    private transient ObfuscatorItem tableOI;
    private int keyTableSize;
    private static final long MAGIC_P64 = -5196783011329398165L;
    private static final long MAGIC_Q64 = -7046029254386353131L;
    private long A;
    private long B;

    JA_RC5Operations64(int n) {
        int n2 = 2 * n + 2;
        long[] lArray = new long[n2];
        this.keyTable = lArray;
        this.keyTableSize = n2;
    }

    private JA_RC5Operations64() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private void prepareSerialization() {
        if (this.tableOI != null) {
            this.tableOI.deobfuscate();
        }
    }

    private void restoreAfterSerialization() {
        if (this.tableOI != null) {
            this.tableOI.obfuscate();
        }
    }

    private void restoreAfterDeserialization() {
        if (this.keyTable == null) {
            return;
        }
        this.tableOI = JSAFE_Obfuscator.register(this.keyTable);
        this.tableOI.obfuscate();
    }

    public Object clone() throws CloneNotSupportedException {
        JA_RC5Operations64 jA_RC5Operations64 = new JA_RC5Operations64();
        jA_RC5Operations64.keyTable = null;
        if (this.keyTable != null) {
            jA_RC5Operations64.keyTable = (long[])JSAFE_Obfuscator.copy(this.keyTable, this.tableOI);
        }
        jA_RC5Operations64.tableOI = JSAFE_Obfuscator.getObfuscatorItem(jA_RC5Operations64.keyTable);
        jA_RC5Operations64.A = this.A;
        jA_RC5Operations64.B = this.B;
        jA_RC5Operations64.keyTableSize = this.keyTableSize;
        return jA_RC5Operations64;
    }

    void RCInit(byte[] byArray, int n, int n2) {
        long l;
        if (this.tableOI != null) {
            this.tableOI.overwrite();
        }
        int n3 = n2 == 0 ? 1 : (n2 + 7) / 8;
        long[] lArray = new long[n3];
        int n4 = 0;
        while (n2 >= 8) {
            int n5 = n4;
            lArray[n5] = lArray[n5] + ((long)byArray[n] & 0xFFL);
            int n6 = n4;
            lArray[n6] = lArray[n6] + (((long)byArray[n + 1] & 0xFFL) << 8);
            int n7 = n4;
            lArray[n7] = lArray[n7] + (((long)byArray[n + 2] & 0xFFL) << 16);
            int n8 = n4;
            lArray[n8] = lArray[n8] + (((long)byArray[n + 3] & 0xFFL) << 24);
            int n9 = n4;
            lArray[n9] = lArray[n9] + (((long)byArray[n + 4] & 0xFFL) << 32);
            int n10 = n4;
            lArray[n10] = lArray[n10] + (((long)byArray[n + 5] & 0xFFL) << 40);
            int n11 = n4;
            lArray[n11] = lArray[n11] + (((long)byArray[n + 6] & 0xFFL) << 48);
            int n12 = n4++;
            lArray[n12] = lArray[n12] + (((long)byArray[n + 7] & 0xFFL) << 56);
            n += 8;
            n2 -= 8;
        }
        int n13 = 0;
        while (n2 > 0) {
            int n14 = n4;
            lArray[n14] = lArray[n14] + (((long)byArray[n] & 0xFFL) << n13);
            --n2;
            ++n;
            n13 += 8;
        }
        this.keyTable[0] = -5196783011329398165L;
        int n15 = 1;
        while (n15 < this.keyTableSize) {
            this.keyTable[n15] = this.keyTable[n15 - 1] + -7046029254386353131L;
            ++n15;
        }
        n15 = 0;
        n4 = 0;
        this.A = 0L;
        this.B = 0L;
        int n16 = n3 > this.keyTableSize ? 3 * n3 : 3 * this.keyTableSize;
        while (n16 > 0) {
            this.A = this.A + this.B + this.keyTable[n15];
            this.keyTable[n15] = this.A = this.A << 3 | this.A >>> 61;
            l = this.A + this.B;
            this.B = lArray[n4] + l;
            lArray[n4] = this.B = this.B << (int)(l &= 0x3FL) | this.B >>> (int)(64L - l);
            if (++n15 >= this.keyTableSize) {
                n15 = 0;
            }
            if (++n4 >= n3) {
                n4 = 0;
            }
            --n16;
        }
        if (this.tableOI == null) {
            this.tableOI = JSAFE_Obfuscator.register(this.keyTable);
        }
        this.tableOI.obfuscate();
        l = 0L;
        JSAFE_Obfuscator.overwrite(lArray);
    }

    void RCEncrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.A = (long)byArray[n] & 0xFFL;
        this.A += ((long)byArray[n + 1] & 0xFFL) << 8;
        this.A += ((long)byArray[n + 2] & 0xFFL) << 16;
        this.A += ((long)byArray[n + 3] & 0xFFL) << 24;
        this.A += ((long)byArray[n + 4] & 0xFFL) << 32;
        this.A += ((long)byArray[n + 5] & 0xFFL) << 40;
        this.A += ((long)byArray[n + 6] & 0xFFL) << 48;
        this.A += ((long)byArray[n + 7] & 0xFFL) << 56;
        this.B = (long)byArray[n + 8] & 0xFFL;
        this.B += ((long)byArray[n + 9] & 0xFFL) << 8;
        this.B += ((long)byArray[n + 10] & 0xFFL) << 16;
        this.B += ((long)byArray[n + 11] & 0xFFL) << 24;
        this.B += ((long)byArray[n + 12] & 0xFFL) << 32;
        this.B += ((long)byArray[n + 13] & 0xFFL) << 40;
        this.B += ((long)byArray[n + 14] & 0xFFL) << 48;
        this.B += ((long)byArray[n + 15] & 0xFFL) << 56;
        this.A += this.keyTable[0];
        this.B += this.keyTable[1];
        int n3 = 2;
        while (n3 < this.keyTableSize) {
            this.A ^= this.B;
            long l = this.B & 0x3FL;
            this.A = this.A << (int)l | this.A >>> (int)(64L - l);
            this.A += this.keyTable[n3];
            this.B ^= this.A;
            l = this.A & 0x3FL;
            this.B = this.B << (int)l | this.B >>> (int)(64L - l);
            this.B += this.keyTable[n3 + 1];
            n3 += 2;
        }
        byArray2[n2] = (byte)(this.A & 0xFFL);
        byArray2[n2 + 1] = (byte)(this.A >>> 8 & 0xFFL);
        byArray2[n2 + 2] = (byte)(this.A >>> 16 & 0xFFL);
        byArray2[n2 + 3] = (byte)(this.A >>> 24 & 0xFFL);
        byArray2[n2 + 4] = (byte)(this.A >>> 32 & 0xFFL);
        byArray2[n2 + 5] = (byte)(this.A >>> 40 & 0xFFL);
        byArray2[n2 + 6] = (byte)(this.A >>> 48 & 0xFFL);
        byArray2[n2 + 7] = (byte)(this.A >>> 56 & 0xFFL);
        byArray2[n2 + 8] = (byte)(this.B & 0xFFL);
        byArray2[n2 + 9] = (byte)(this.B >>> 8 & 0xFFL);
        byArray2[n2 + 10] = (byte)(this.B >>> 16 & 0xFFL);
        byArray2[n2 + 11] = (byte)(this.B >>> 24 & 0xFFL);
        byArray2[n2 + 12] = (byte)(this.B >>> 32 & 0xFFL);
        byArray2[n2 + 13] = (byte)(this.B >>> 40 & 0xFFL);
        byArray2[n2 + 14] = (byte)(this.B >>> 48 & 0xFFL);
        byArray2[n2 + 15] = (byte)(this.B >>> 56 & 0xFFL);
    }

    void RCDecrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.A = (long)byArray[n] & 0xFFL;
        this.A += ((long)byArray[n + 1] & 0xFFL) << 8;
        this.A += ((long)byArray[n + 2] & 0xFFL) << 16;
        this.A += ((long)byArray[n + 3] & 0xFFL) << 24;
        this.A += ((long)byArray[n + 4] & 0xFFL) << 32;
        this.A += ((long)byArray[n + 5] & 0xFFL) << 40;
        this.A += ((long)byArray[n + 6] & 0xFFL) << 48;
        this.A += ((long)byArray[n + 7] & 0xFFL) << 56;
        this.B = (long)byArray[n + 8] & 0xFFL;
        this.B += ((long)byArray[n + 9] & 0xFFL) << 8;
        this.B += ((long)byArray[n + 10] & 0xFFL) << 16;
        this.B += ((long)byArray[n + 11] & 0xFFL) << 24;
        this.B += ((long)byArray[n + 12] & 0xFFL) << 32;
        this.B += ((long)byArray[n + 13] & 0xFFL) << 40;
        this.B += ((long)byArray[n + 14] & 0xFFL) << 48;
        this.B += ((long)byArray[n + 15] & 0xFFL) << 56;
        int n3 = this.keyTableSize - 1;
        while (n3 > 2) {
            this.B -= this.keyTable[n3];
            long l = this.A & 0x3FL;
            this.B = this.B >>> (int)l | this.B << (int)(64L - l);
            this.B ^= this.A;
            this.A -= this.keyTable[n3 - 1];
            l = this.B & 0x3FL;
            this.A = this.A >>> (int)l | this.A << (int)(64L - l);
            this.A ^= this.B;
            n3 -= 2;
        }
        this.B -= this.keyTable[1];
        this.A -= this.keyTable[0];
        byArray2[n2] = (byte)(this.A & 0xFFL);
        byArray2[n2 + 1] = (byte)(this.A >>> 8 & 0xFFL);
        byArray2[n2 + 2] = (byte)(this.A >>> 16 & 0xFFL);
        byArray2[n2 + 3] = (byte)(this.A >>> 24 & 0xFFL);
        byArray2[n2 + 4] = (byte)(this.A >>> 32 & 0xFFL);
        byArray2[n2 + 5] = (byte)(this.A >>> 40 & 0xFFL);
        byArray2[n2 + 6] = (byte)(this.A >>> 48 & 0xFFL);
        byArray2[n2 + 7] = (byte)(this.A >>> 56 & 0xFFL);
        byArray2[n2 + 8] = (byte)(this.B & 0xFFL);
        byArray2[n2 + 9] = (byte)(this.B >>> 8 & 0xFFL);
        byArray2[n2 + 10] = (byte)(this.B >>> 16 & 0xFFL);
        byArray2[n2 + 11] = (byte)(this.B >>> 24 & 0xFFL);
        byArray2[n2 + 12] = (byte)(this.B >>> 32 & 0xFFL);
        byArray2[n2 + 13] = (byte)(this.B >>> 40 & 0xFFL);
        byArray2[n2 + 14] = (byte)(this.B >>> 48 & 0xFFL);
        byArray2[n2 + 15] = (byte)(this.B >>> 56 & 0xFFL);
    }

    void obfuscate() {
        if (this.tableOI != null) {
            this.tableOI.obfuscate();
        }
    }

    void deobfuscate() {
        if (this.tableOI != null) {
            this.tableOI.deobfuscate();
        }
    }

    void clearSensitiveData() {
        super.clearSensitiveData();
        JSAFE_Obfuscator.deregister(this.keyTable, this.tableOI);
        this.tableOI = null;
        this.A = 0L;
        this.B = 0L;
    }
}

