/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_MGFUnderlyingAlgorithm;
import com.rsa.jsafe.JA_OAEPDigest;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Object;
import java.io.Serializable;

public class JA_RIPEMD160
extends JSAFE_Object
implements JA_AlgaeDigest,
JA_OAEPDigest,
JA_MGFUnderlyingAlgorithm,
Cloneable,
Serializable {
    protected int h0;
    protected int h1;
    protected int h2;
    protected int h3;
    protected int h4;
    private final int H0INIT = 1732584193;
    private final int H1INIT = -271733879;
    private final int H2INIT = -1732584194;
    private final int H3INIT = 271733878;
    private final int H4INIT = -1009589776;
    protected long bytes_processed;
    protected int part_buffer_size;
    private int a;
    private int b;
    private int c;
    private int d;
    private int e;
    private int[] W;
    private static final int NOT_INITIALIZED = 1;
    private static final int RIPEMD160_INITIALIZED = 2;
    private static final int RIPEMD160_FINALIZED = 3;
    private static final int RIPEMD160_OUTPUT_SIZE = 20;
    private static final int RIPEMD160_BLOCK_SIZE = 64;
    private static final int RIPEMD160_PAD_SIZE = 8;
    private static final int RIPEMD160_NUM_ROUNDS = 64;
    private static final int RIPEMD160_NUM_MS_ROUNDS = 64;
    private static final int W_ARRAY_SIZE = 64;
    private byte[] buffer = new byte[64];
    private int objectState;
    private static final byte[] ENCODE_PREFIX = new byte[]{48, 33, 48, 9, 6, 5, 43, 36, 3, 2, 1, 5, 0, 4, 20};
    private final short[] rsrpsp = new short[]{0, 11, 5, 8, 1, 14, 14, 9, 2, 15, 7, 9, 3, 12, 0, 11, 4, 5, 9, 13, 5, 8, 2, 15, 6, 7, 11, 15, 7, 9, 4, 5, 8, 11, 13, 7, 9, 13, 6, 7, 10, 14, 15, 8, 11, 15, 8, 11, 12, 6, 1, 14, 13, 7, 10, 14, 14, 9, 3, 12, 15, 8, 12, 6, 7, 7, 6, 9, 4, 6, 11, 13, 13, 8, 3, 15, 1, 13, 7, 7, 10, 11, 0, 12, 6, 9, 13, 8, 15, 7, 5, 9, 3, 15, 10, 11, 12, 7, 14, 7, 0, 12, 15, 7, 9, 15, 8, 12, 5, 9, 12, 7, 2, 11, 4, 6, 14, 7, 9, 15, 11, 13, 1, 13, 8, 12, 2, 11, 3, 11, 15, 9, 10, 13, 5, 7, 14, 6, 1, 15, 4, 7, 3, 11, 9, 14, 7, 8, 15, 9, 14, 6, 8, 13, 6, 6, 1, 15, 9, 14, 2, 14, 11, 12, 7, 8, 8, 13, 0, 13, 12, 5, 6, 6, 2, 14, 13, 5, 10, 13, 11, 12, 0, 13, 5, 7, 4, 7, 12, 5, 13, 5, 1, 11, 8, 15, 9, 12, 6, 5, 11, 14, 4, 8, 10, 15, 1, 11, 0, 14, 3, 14, 8, 15, 11, 14, 12, 9, 15, 6, 4, 8, 0, 14, 13, 9, 5, 6, 3, 14, 12, 9, 7, 5, 2, 12, 15, 6, 13, 9, 14, 8, 9, 12, 5, 6, 7, 5, 6, 5, 10, 15, 2, 12, 14, 8, 4, 9, 12, 8, 0, 15, 15, 5, 5, 5, 10, 12, 9, 11, 4, 9, 7, 6, 1, 12, 12, 8, 5, 5, 2, 13, 8, 14, 10, 12, 7, 6, 14, 5, 6, 8, 1, 12, 2, 13, 3, 13, 13, 6, 8, 14, 14, 5, 11, 11, 0, 15, 6, 8, 3, 13, 15, 5, 9, 11, 13, 6, 11, 11};

    public JA_RIPEMD160() {
    }

    public JA_RIPEMD160(int[] nArray) throws JSAFE_InvalidParameterException {
        this.setInstantiationParameters(nArray);
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Wrong Number of parameters: expected none.");
        }
    }

    public int[] getInstantiationParameters() {
        return new int[0];
    }

    public String getAlgorithm() {
        return "RIPEMD160";
    }

    public void setAlgorithmBER(byte[] byArray, int n) {
    }

    public byte[] getDERAlgorithmID() {
        byte[] byArray = null;
        try {
            byArray = AlgorithmID.derEncodeAlgID("RIPEMD160", 10, null, 0, 0);
        }
        catch (ASN_Exception aSN_Exception) {
            byArray = null;
        }
        return byArray;
    }

    public int getBlockSize() {
        return 64;
    }

    public int getPadSize() {
        return 8;
    }

    public int getDigestSize() {
        return 20;
    }

    public int getEncodedDigestSize() {
        return ENCODE_PREFIX.length + 20;
    }

    protected JA_RIPEMD160 newEmptyObject() {
        return new JA_RIPEMD160();
    }

    public Object clone() throws CloneNotSupportedException {
        JA_RIPEMD160 jA_RIPEMD160 = this.newEmptyObject();
        jA_RIPEMD160.h0 = this.h0;
        jA_RIPEMD160.h1 = this.h1;
        jA_RIPEMD160.h2 = this.h2;
        jA_RIPEMD160.h3 = this.h3;
        jA_RIPEMD160.h4 = this.h4;
        jA_RIPEMD160.part_buffer_size = this.part_buffer_size;
        jA_RIPEMD160.buffer = new byte[64];
        jA_RIPEMD160.bytes_processed = this.bytes_processed;
        if (this.buffer != null) {
            jA_RIPEMD160.buffer = (byte[])this.buffer.clone();
        }
        jA_RIPEMD160.objectState = this.objectState;
        return jA_RIPEMD160;
    }

    protected long getCount() {
        return this.bytes_processed;
    }

    public void digestInit() {
        this.bytes_processed = 0L;
        this.part_buffer_size = 0;
        this.h0 = 1732584193;
        this.h1 = -271733879;
        this.h2 = -1732584194;
        this.h3 = 271733878;
        this.h4 = -1009589776;
        this.objectState = 2;
    }

    public void digestUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException {
        int n3 = this.part_buffer_size & 0x3F;
        int n4 = n2;
        if (byArray == null) {
            throw new JSAFE_InvalidUseException("partIn is Null");
        }
        if (n > byArray.length) {
            throw new JSAFE_InvalidUseException("offset exceeds partInLength");
        }
        if (n4 <= 64 - n3) {
            System.arraycopy(byArray, n, this.buffer, n3, n4);
            this.part_buffer_size += n4;
            if ((this.part_buffer_size & 0x3F) == 0) {
                this.RIPEMD160Transform(this.buffer, 0);
                this.bytes_processed += 64L;
                this.part_buffer_size = 0;
            }
        } else {
            System.arraycopy(byArray, n, this.buffer, n3, 64 - n3);
            n += 64 - n3;
            this.RIPEMD160Transform(this.buffer, 0);
            this.bytes_processed += 64L;
            n4 -= 64 - n3;
            while (n4 >= 64) {
                System.arraycopy(byArray, n, this.buffer, 0, 64);
                this.RIPEMD160Transform(this.buffer, 0);
                this.bytes_processed += 64L;
                n4 -= 64;
                n += 64;
            }
            if (n4 > 0) {
                System.arraycopy(byArray, n, this.buffer, 0, n4);
                this.part_buffer_size = n4;
            }
        }
    }

    public int digestFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException {
        if (byArray == null) {
            throw new JSAFE_InvalidUseException("hash output array is null");
        }
        if (byArray.length < n) {
            throw new JSAFE_InvalidUseException("offset exceeds length of array");
        }
        if (this.objectState == 1) {
            throw new JSAFE_InvalidUseException("digest Not Initialized\n");
        }
        byte[] byArray2 = new byte[144];
        int n2 = 64 - (this.part_buffer_size & 0x3F);
        if (n2 <= 8) {
            n2 += 64;
        }
        byArray2[0] = -128;
        int n3 = 1;
        while (n3 < n2 - 7) {
            byArray2[n3] = 0;
            ++n3;
        }
        this.bytes_processed += (long)this.part_buffer_size;
        long l = this.bytes_processed << 3;
        byArray2[n2 - 1] = (byte)((l & 0xFF00000000000000L) >>> 56);
        byArray2[n2 - 2] = (byte)((l & 0xFF000000000000L) >>> 48);
        byArray2[n2 - 3] = (byte)((l & 0xFF0000000000L) >>> 40);
        byArray2[n2 - 4] = (byte)((l & 0xFF00000000L) >>> 32);
        byArray2[n2 - 5] = (byte)((l & 0xFF000000L) >>> 24);
        byArray2[n2 - 6] = (byte)((l & 0xFF0000L) >>> 16);
        byArray2[n2 - 7] = (byte)((l & 0xFF00L) >>> 8);
        byArray2[n2 - 8] = (byte)(l & 0xFFL);
        this.digestUpdate(byArray2, 0, n2);
        this.getState(byArray, n);
        return 20;
    }

    public int derEncode(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = ENCODE_PREFIX.length + 20;
        System.arraycopy(ENCODE_PREFIX, 0, byArray2, n2, ENCODE_PREFIX.length);
        System.arraycopy(byArray, n, byArray2, n2 += ENCODE_PREFIX.length, byArray.length);
        return n3;
    }

    private void RIPEMD160Transform(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int[] nArray = new int[16];
        int n10 = 0;
        int n11 = 0;
        while (n11 < 16) {
            nArray[n11] = byArray[n10] & 0xFF | (byArray[n10 + 1] & 0xFF) << 8 | (byArray[n10 + 2] & 0xFF) << 16 | (byArray[n10 + 3] & 0xFF) << 24;
            ++n11;
            n10 += 4;
        }
        int n12 = n9 = this.h0;
        int n13 = n8 = this.h1;
        int n14 = n7 = this.h2;
        int n15 = n6 = this.h3;
        int n16 = n5 = this.h4;
        n11 = 0;
        while (n11 < 16) {
            n4 = n11 << 2;
            n3 = n12 + (n13 ^ n14 ^ n15) + nArray[this.rsrpsp[n4]] + 0;
            n2 = (n3 << this.rsrpsp[n4 + 1] | n3 >>> 32 - this.rsrpsp[n4 + 1]) + n16;
            n12 = n16;
            n16 = n15;
            n15 = n14 << 10 | n14 >>> 22;
            n14 = n13;
            n13 = n2;
            n3 = n9 + (n8 ^ (n7 | ~n6)) + nArray[this.rsrpsp[n4 + 2]] + 1352829926;
            n2 = (n3 << this.rsrpsp[n4 + 3] | n3 >>> 32 - this.rsrpsp[n4 + 3]) + n5;
            n9 = n5;
            n5 = n6;
            n6 = n7 << 10 | n7 >>> 22;
            n7 = n8;
            n8 = n2;
            ++n11;
        }
        n11 = 16;
        while (n11 < 32) {
            n4 = n11 << 2;
            n3 = n12 + (n13 & n14 | ~n13 & n15) + nArray[this.rsrpsp[n4]] + 1518500249;
            n2 = (n3 << this.rsrpsp[n4 + 1] | n3 >>> 32 - this.rsrpsp[n4 + 1]) + n16;
            n12 = n16;
            n16 = n15;
            n15 = n14 << 10 | n14 >>> 22;
            n14 = n13;
            n13 = n2;
            n3 = n9 + (n8 & n6 | n7 & ~n6) + nArray[this.rsrpsp[n4 + 2]] + 1548603684;
            n2 = (n3 << this.rsrpsp[n4 + 3] | n3 >>> 32 - this.rsrpsp[n4 + 3]) + n5;
            n9 = n5;
            n5 = n6;
            n6 = n7 << 10 | n7 >>> 22;
            n7 = n8;
            n8 = n2;
            ++n11;
        }
        n11 = 32;
        while (n11 < 48) {
            n4 = n11 << 2;
            n3 = n12 + ((n13 | ~n14) ^ n15) + nArray[this.rsrpsp[n4]] + 1859775393;
            n2 = (n3 << this.rsrpsp[n4 + 1] | n3 >>> 32 - this.rsrpsp[n4 + 1]) + n16;
            n12 = n16;
            n16 = n15;
            n15 = n14 << 10 | n14 >>> 22;
            n14 = n13;
            n13 = n2;
            n3 = n9 + ((n8 | ~n7) ^ n6) + nArray[this.rsrpsp[n4 + 2]] + 1836072691;
            n2 = (n3 << this.rsrpsp[n4 + 3] | n3 >>> 32 - this.rsrpsp[n4 + 3]) + n5;
            n9 = n5;
            n5 = n6;
            n6 = n7 << 10 | n7 >>> 22;
            n7 = n8;
            n8 = n2;
            ++n11;
        }
        n11 = 48;
        while (n11 < 64) {
            n4 = n11 << 2;
            n3 = n12 + (n13 & n15 | n14 & ~n15) + nArray[this.rsrpsp[n4]] + -1894007588;
            n2 = (n3 << this.rsrpsp[n4 + 1] | n3 >>> 32 - this.rsrpsp[n4 + 1]) + n16;
            n12 = n16;
            n16 = n15;
            n15 = n14 << 10 | n14 >>> 22;
            n14 = n13;
            n13 = n2;
            n3 = n9 + (n8 & n7 | ~n8 & n6) + nArray[this.rsrpsp[n4 + 2]] + 2053994217;
            n2 = (n3 << this.rsrpsp[n4 + 3] | n3 >>> 32 - this.rsrpsp[n4 + 3]) + n5;
            n9 = n5;
            n5 = n6;
            n6 = n7 << 10 | n7 >>> 22;
            n7 = n8;
            n8 = n2;
            ++n11;
        }
        n11 = 64;
        while (n11 < 80) {
            n4 = n11 << 2;
            n3 = n12 + (n13 ^ (n14 | ~n15)) + nArray[this.rsrpsp[n4]] + -1454113458;
            n2 = (n3 << this.rsrpsp[n4 + 1] | n3 >>> 32 - this.rsrpsp[n4 + 1]) + n16;
            n12 = n16;
            n16 = n15;
            n15 = n14 << 10 | n14 >>> 22;
            n14 = n13;
            n13 = n2;
            n3 = n9 + (n8 ^ n7 ^ n6) + nArray[this.rsrpsp[n4 + 2]] + 0;
            n2 = (n3 << this.rsrpsp[n4 + 3] | n3 >>> 32 - this.rsrpsp[n4 + 3]) + n5;
            n9 = n5;
            n5 = n6;
            n6 = n7 << 10 | n7 >>> 22;
            n7 = n8;
            n8 = n2;
            ++n11;
        }
        n2 = this.h1 + n14 + n6;
        this.h1 = this.h2 + n15 + n5;
        this.h2 = this.h3 + n16 + n9;
        this.h3 = this.h4 + n12 + n8;
        this.h4 = this.h0 + n13 + n7;
        this.h0 = n2;
    }

    void getState(byte[] byArray, int n) {
        byArray[n] = (byte)(this.h0 & 0xFF);
        byArray[++n] = (byte)(this.h0 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.h0 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.h0 >>> 24 & 0xFF);
        byArray[++n] = (byte)(this.h1 & 0xFF);
        byArray[++n] = (byte)(this.h1 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.h1 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.h1 >>> 24 & 0xFF);
        byArray[++n] = (byte)(this.h2 & 0xFF);
        byArray[++n] = (byte)(this.h2 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.h2 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.h2 >>> 24 & 0xFF);
        byArray[++n] = (byte)(this.h3 & 0xFF);
        byArray[++n] = (byte)(this.h3 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.h3 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.h3 >>> 24 & 0xFF);
        byArray[++n] = (byte)(this.h4 & 0xFF);
        byArray[++n] = (byte)(this.h4 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.h4 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.h4 >>> 24 & 0xFF);
        ++n;
    }

    public void clearSensitiveData() {
        int n = 0;
        while (n < this.buffer.length) {
            this.buffer[n] = 0;
            ++n;
        }
        this.h0 = 0;
        this.h1 = 0;
        this.h2 = 0;
        this.h3 = 0;
        this.h4 = 0;
        this.objectState = 1;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

