/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeAsymmetricCipher;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_AlgaeSignature;
import com.rsa.jsafe.JA_AllPaddingSchemes;
import com.rsa.jsafe.JA_AlternateArithmetic;
import com.rsa.jsafe.JA_AsymmetricPaddingScheme;
import com.rsa.jsafe.JA_KeyData;
import com.rsa.jsafe.JA_RSABER;
import com.rsa.jsafe.JA_SignaturePaddingScheme;
import com.rsa.jsafe.JCMPArithmeticClass;
import com.rsa.jsafe.JCMPInteger;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidArithmeticException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_Parameters;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.SecureRandom;

public class JA_RSA
extends JSAFE_Object
implements JA_AlgaeAsymmetricCipher,
JA_AlgaeSignature,
JA_AlternateArithmetic {
    protected Class arithmeticClass;
    protected SecureRandom random;
    protected byte[] randomSerialize;
    protected String randomAlgorithm;
    protected int blockSize = -1;
    protected int maxInputLen = 0;
    protected int numberOfPrimes;
    protected JCMPInteger[] allKeyData;

    protected JA_RSA() {
    }

    JA_RSA(int[] nArray) throws JSAFE_InvalidParameterException {
        this();
        this.setInstantiationParameters(nArray);
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Incorrect number of parameters: expected none");
        }
    }

    public int[] getInstantiationParameters() {
        return new int[0];
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getDefaultCipherPaddingName() {
        return "PKCS1Block02Pad";
    }

    public String getDefaultSignaturePaddingName() {
        return "PKCS1Block01Pad";
    }

    public void setAlgorithmBER(byte[] byArray, int n) {
    }

    public byte[] getDERAlgorithmID(JA_AsymmetricPaddingScheme jA_AsymmetricPaddingScheme) throws JSAFE_UnimplementedException {
        return JA_RSABER.getDERAlgorithmID(this, jA_AsymmetricPaddingScheme);
    }

    public byte[] getDERAlgorithmID(JA_AlgaeDigest jA_AlgaeDigest, JA_SignaturePaddingScheme jA_SignaturePaddingScheme, String string, boolean bl) throws JSAFE_UnimplementedException {
        return JA_RSABER.getDERAlgorithmID(this, jA_AlgaeDigest, jA_SignaturePaddingScheme, string, bl);
    }

    public int getEncryptInputBlockSize() {
        return this.blockSize;
    }

    public int getEncryptOutputBlockSize() {
        return this.blockSize;
    }

    public int getDecryptInputBlockSize() {
        return this.blockSize;
    }

    public int getDecryptOutputBlockSize() {
        return this.blockSize;
    }

    public int getInputBlockSize() {
        return this.blockSize;
    }

    public boolean doesSignUpdate() {
        return false;
    }

    public int getMaxInputLen() {
        return this.maxInputLen;
    }

    public int getMaxInputLen(JA_AsymmetricPaddingScheme jA_AsymmetricPaddingScheme) {
        return jA_AsymmetricPaddingScheme.getMaxInputLen(this.blockSize);
    }

    public int getSignatureBlockSize() {
        return this.blockSize;
    }

    public boolean isValidDigestAlgorithm(JA_AlgaeDigest jA_AlgaeDigest) {
        return true;
    }

    public boolean isValidPaddingScheme(JA_SignaturePaddingScheme jA_SignaturePaddingScheme) {
        return true;
    }

    protected void initializeArithmetic() {
        if (this.arithmeticClass == null) {
            this.arithmeticClass = JCMPArithmeticClass.getDefaultClass();
        }
    }

    public void setArithmetic(Class clazz) throws JSAFE_InvalidArithmeticException {
        try {
            JCMPInteger jCMPInteger = (JCMPInteger)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        this.arithmeticClass = clazz;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidInputBlock(byte[] byArray, int n) {
        boolean bl;
        JCMPInteger jCMPInteger = null;
        try {
            try {
                this.initializeArithmetic();
                jCMPInteger = (JCMPInteger)this.arithmeticClass.newInstance();
                jCMPInteger.setValue(byArray, n, this.blockSize);
                int n2 = jCMPInteger.compareTo(this.allKeyData[0]);
                if (n2 < 0) {
                    boolean bl2 = true;
                    Object var9_9 = null;
                    if (jCMPInteger == null) return bl2;
                    jCMPInteger.clearSensitiveData();
                    return bl2;
                }
                bl = false;
            }
            catch (InstantiationException instantiationException) {
                boolean bl3 = false;
                Object var9_11 = null;
                if (jCMPInteger == null) return bl3;
                jCMPInteger.clearSensitiveData();
                return bl3;
            }
            catch (IllegalAccessException illegalAccessException) {
                boolean bl4 = false;
                Object var9_12 = null;
                if (jCMPInteger == null) return bl4;
                jCMPInteger.clearSensitiveData();
                return bl4;
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                boolean bl5 = false;
                Object var9_13 = null;
                if (jCMPInteger == null) return bl5;
                jCMPInteger.clearSensitiveData();
                return bl5;
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (jCMPInteger == null) throw throwable;
            jCMPInteger.clearSensitiveData();
            throw throwable;
        }
        Object var9_10 = null;
        if (jCMPInteger == null) return bl;
        jCMPInteger.clearSensitiveData();
        return bl;
    }

    public boolean needRandom() {
        return false;
    }

    public boolean canWrapKey(boolean bl) {
        return false;
    }

    public byte[] wrapSecretKey(JSAFE_SecretKey jSAFE_SecretKey, boolean bl, JA_AsymmetricPaddingScheme jA_AsymmetricPaddingScheme) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot wrap key.");
    }

    public JSAFE_SecretKey unwrapSecretKey(byte[] byArray, int n, int n2, boolean bl, JA_AsymmetricPaddingScheme jA_AsymmetricPaddingScheme, String string) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot unwrap key.");
    }

    public String encryptInit(JSAFE_PublicKey jSAFE_PublicKey, JA_AsymmetricPaddingScheme jA_AsymmetricPaddingScheme, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray) {
        return this.generalEncryptInit(jSAFE_PublicKey, null, jA_AsymmetricPaddingScheme, secureRandom, jSAFE_SessionArray, false);
    }

    protected String generalEncryptInit(JSAFE_PublicKey jSAFE_PublicKey, JA_AlgaeDigest jA_AlgaeDigest, JA_AllPaddingSchemes jA_AllPaddingSchemes, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray, boolean bl) {
        if (secureRandom != null) {
            this.random = secureRandom;
        }
        byte[][] byArray = null;
        byArray = JA_KeyData.getKeyData(jSAFE_PublicKey, "RSAPublicKey");
        if (byArray == null || byArray.length < 2) {
            return "Key not set to RSA public.";
        }
        this.initializeArithmetic();
        this.clearKeys();
        try {
            this.allKeyData = new JCMPInteger[2];
            int n = 0;
            while (n < 2) {
                this.allKeyData[n] = (JCMPInteger)this.arithmeticClass.newInstance();
                this.allKeyData[n].setValue(byArray[n], 0, byArray[n].length);
                ++n;
            }
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return "Improper RSA key.";
        }
        catch (InstantiationException instantiationException) {
            return "Invalid arithmetic class.";
        }
        catch (IllegalAccessException illegalAccessException) {
            return "Invalid arithmetic class.";
        }
        this.blockSize = byArray[0].length;
        this.numberOfPrimes = -2;
        return null;
    }

    public String decryptInit(JSAFE_PrivateKey jSAFE_PrivateKey, JA_AsymmetricPaddingScheme jA_AsymmetricPaddingScheme, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray) {
        return this.generalDecryptInit(jSAFE_PrivateKey, null, jA_AsymmetricPaddingScheme, secureRandom, jSAFE_SessionArray, false);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String generalDecryptInit(JSAFE_PrivateKey var1_1, JA_AlgaeDigest var2_2, JA_AllPaddingSchemes var3_3, SecureRandom var4_4, JSAFE_Session[] var5_5, boolean var6_6) {
        block26: {
            if (var4_4 != null) {
                this.random = var4_4;
            }
            var7_7 = null;
            try {
                try {
                    block28: {
                        block27: {
                            var7_7 = JA_KeyData.getKeyData(var1_1, "RSAMultiPrimePrivateKeyCRT");
                            var8_8 = 0;
                            if (var7_7 != null && var7_7.length != 0) break block27;
                            var7_7 = JA_KeyData.getKeyData(var1_1, "RSAPrivateKeyCRT");
                            var8_8 = 1;
                            if (var7_7 != null && var7_7.length != 0) break block27;
                            var7_7 = JA_KeyData.getKeyData(var1_1, "RSAPrivateKey");
                            var8_8 = 2;
                            if (var7_7 != null && var7_7.length != 0) break block27;
                            var9_10 = "Key not set to RSA private.";
                            var13_14 = null;
                            if (var7_7 == null) return var9_10;
                            var14_20 = 1;
                            if (true) ** GOTO lbl78
                        }
                        this.initializeArithmetic();
                        this.clearKeys();
                        if (var8_8 == 0) {
                            this.numberOfPrimes = var7_7[3][0] & 255;
                        }
                        if (var8_8 == 1) {
                            this.numberOfPrimes = 2;
                        }
                        if (var8_8 == 2) break block28;
                        this.allKeyData = new JCMPInteger[this.numberOfPrimes * 3];
                        var9_11 = 4;
                        if (var8_8 == 1) {
                            var9_11 = 3;
                        }
                        var10_26 = 0;
                        var11_29 = 0;
                        if (true) ** GOTO lbl86
                    }
                    this.allKeyData = new JCMPInteger[2];
                    var9_11 = 0;
                    while (true) {
                        if (var9_11 >= 2) {
                            this.numberOfPrimes = -1;
                            break block26;
                        }
                        this.allKeyData[var9_11] = (JCMPInteger)this.arithmeticClass.newInstance();
                        this.allKeyData[var9_11].setValue(var7_7[var9_11], 0, var7_7[var9_11].length);
                        ++var9_11;
                    }
                }
                catch (JSAFE_Exception var8_9) {
                    var9_12 = "Improper RSA key.";
                    var13_16 = null;
                    if (var7_7 == null) return var9_12;
                    var14_22 = 1;
                    if (true) ** GOTO lbl103
                }
                catch (InstantiationException var9_13) {
                    var10_27 = "Invalid arithmetic class.";
                    var13_17 = null;
                    if (var7_7 == null) return var10_27;
                    var14_23 = 1;
                    if (true) ** GOTO lbl109
                }
                catch (IllegalAccessException var10_28) {
                    var11_30 = "Invalid arithmetic class.";
                    var13_18 = null;
                    if (var7_7 == null) return var11_30;
                    var14_24 = 1;
                    if (true) ** GOTO lbl115
                }
            }
            catch (Throwable var12_31) {
                var13_19 = null;
                if (var7_7 == null) throw var12_31;
                var14_25 = 1;
                if (true) ** GOTO lbl121
            }
            do {
                if (var7_7[var14_20] != null) {
                    this.overwrite(var7_7[var14_20]);
                }
                ++var14_20;
lbl78:
                // 2 sources

            } while (var14_20 < var7_7.length);
            return var9_10;
            do {
                if (var10_26 <= 0 || var10_26 >= var9_11) {
                    this.allKeyData[var11_29] = (JCMPInteger)this.arithmeticClass.newInstance();
                    this.allKeyData[var11_29].setValue(var7_7[var10_26], 0, var7_7[var10_26].length);
                    ++var11_29;
                }
                ++var10_26;
lbl86:
                // 2 sources

            } while (var10_26 < var7_7.length);
        }
        this.blockSize = var7_7[0].length;
        var13_15 = null;
        if (var7_7 == null) return null;
        var14_21 = 1;
        while (var14_21 < var7_7.length) {
            if (var7_7[var14_21] != null) {
                this.overwrite(var7_7[var14_21]);
            }
            ++var14_21;
        }
        return null;
        do {
            if (var7_7[var14_22] != null) {
                this.overwrite(var7_7[var14_22]);
            }
            ++var14_22;
lbl103:
            // 2 sources

        } while (var14_22 < var7_7.length);
        return var9_12;
        do {
            if (var7_7[var14_23] != null) {
                this.overwrite(var7_7[var14_23]);
            }
            ++var14_23;
lbl109:
            // 2 sources

        } while (var14_23 < var7_7.length);
        return var10_27;
        do {
            if (var7_7[var14_24] != null) {
                this.overwrite(var7_7[var14_24]);
            }
            ++var14_24;
lbl115:
            // 2 sources

        } while (var14_24 < var7_7.length);
        return var11_30;
        do {
            if (var7_7[var14_25] != null) {
                this.overwrite(var7_7[var14_25]);
            }
            ++var14_25;
lbl121:
            // 2 sources

        } while (var14_25 < var7_7.length);
        throw var12_31;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        byte[] byArray3;
        JCMPInteger jCMPInteger;
        JCMPInteger jCMPInteger2;
        block22: {
            int n3;
            block20: {
                block21: {
                    jCMPInteger2 = null;
                    jCMPInteger = null;
                    byArray3 = null;
                    try {
                        try {
                            jCMPInteger2 = (JCMPInteger)this.arithmeticClass.newInstance();
                            jCMPInteger = (JCMPInteger)this.arithmeticClass.newInstance();
                            jCMPInteger2.setValue(byArray, n, this.blockSize);
                            jCMPInteger2.modExp(this.allKeyData[1], this.allKeyData[0], jCMPInteger);
                            byArray3 = jCMPInteger.toFixedLenOctetString(this.blockSize);
                            if (byArray3 == null || byArray3.length == 0) {
                                n3 = 0;
                                Object var13_10 = null;
                                if (byArray3 == null) break block20;
                                break block21;
                            }
                            int n4 = 0;
                            while (n4 < byArray3.length) {
                                byArray2[n4 + n2] = byArray3[n4];
                                ++n4;
                            }
                            break block22;
                        }
                        catch (InstantiationException instantiationException) {
                            int n5 = 0;
                            Object var13_12 = null;
                            if (byArray3 != null) {
                                JSAFE_Obfuscator.overwrite(byArray3);
                            }
                            if (jCMPInteger2 != null) {
                                jCMPInteger2.clearSensitiveData();
                            }
                            if (jCMPInteger == null) return n5;
                            jCMPInteger.clearSensitiveData();
                            return n5;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            int n6 = 0;
                            Object var13_13 = null;
                            if (byArray3 != null) {
                                JSAFE_Obfuscator.overwrite(byArray3);
                            }
                            if (jCMPInteger2 != null) {
                                jCMPInteger2.clearSensitiveData();
                            }
                            if (jCMPInteger == null) return n6;
                            jCMPInteger.clearSensitiveData();
                            return n6;
                        }
                        catch (JSAFE_Exception jSAFE_Exception) {
                            int n7 = 0;
                            Object var13_14 = null;
                            if (byArray3 != null) {
                                JSAFE_Obfuscator.overwrite(byArray3);
                            }
                            if (jCMPInteger2 != null) {
                                jCMPInteger2.clearSensitiveData();
                            }
                            if (jCMPInteger == null) return n7;
                            jCMPInteger.clearSensitiveData();
                            return n7;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_15 = null;
                        if (byArray3 != null) {
                            JSAFE_Obfuscator.overwrite(byArray3);
                        }
                        if (jCMPInteger2 != null) {
                            jCMPInteger2.clearSensitiveData();
                        }
                        if (jCMPInteger == null) throw throwable;
                        jCMPInteger.clearSensitiveData();
                        throw throwable;
                    }
                }
                JSAFE_Obfuscator.overwrite(byArray3);
            }
            if (jCMPInteger2 != null) {
                jCMPInteger2.clearSensitiveData();
            }
            if (jCMPInteger == null) return n3;
            jCMPInteger.clearSensitiveData();
            return n3;
        }
        Object var13_11 = null;
        if (byArray3 != null) {
            JSAFE_Obfuscator.overwrite(byArray3);
        }
        if (jCMPInteger2 != null) {
            jCMPInteger2.clearSensitiveData();
        }
        if (jCMPInteger == null) return this.blockSize;
        jCMPInteger.clearSensitiveData();
        return this.blockSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        byte[] byArray3;
        JCMPInteger jCMPInteger;
        JCMPInteger jCMPInteger2;
        block24: {
            int n3;
            block22: {
                block23: {
                    jCMPInteger2 = null;
                    jCMPInteger = null;
                    byArray3 = null;
                    try {
                        try {
                            jCMPInteger = (JCMPInteger)this.arithmeticClass.newInstance();
                            jCMPInteger2 = (JCMPInteger)this.arithmeticClass.newInstance();
                            jCMPInteger.setValue(byArray, n, this.blockSize);
                            if (this.numberOfPrimes == -1) {
                                jCMPInteger.modExp(this.allKeyData[1], this.allKeyData[0], jCMPInteger2);
                            } else {
                                jCMPInteger.modExpCRT(this.numberOfPrimes, this.allKeyData, jCMPInteger2);
                            }
                            byArray3 = jCMPInteger2.toFixedLenOctetString(this.blockSize);
                            if (byArray3 == null || byArray3.length == 0) {
                                n3 = 0;
                                Object var13_10 = null;
                                if (byArray3 == null) break block22;
                                break block23;
                            }
                            int n4 = 0;
                            while (n4 < byArray3.length) {
                                byArray2[n4 + n2] = byArray3[n4];
                                ++n4;
                            }
                            break block24;
                        }
                        catch (InstantiationException instantiationException) {
                            int n5 = 0;
                            Object var13_12 = null;
                            if (byArray3 != null) {
                                JSAFE_Obfuscator.overwrite(byArray3);
                            }
                            if (jCMPInteger2 != null) {
                                jCMPInteger2.clearSensitiveData();
                            }
                            if (jCMPInteger == null) return n5;
                            jCMPInteger.clearSensitiveData();
                            return n5;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            int n6 = 0;
                            Object var13_13 = null;
                            if (byArray3 != null) {
                                JSAFE_Obfuscator.overwrite(byArray3);
                            }
                            if (jCMPInteger2 != null) {
                                jCMPInteger2.clearSensitiveData();
                            }
                            if (jCMPInteger == null) return n6;
                            jCMPInteger.clearSensitiveData();
                            return n6;
                        }
                        catch (JSAFE_Exception jSAFE_Exception) {
                            int n7 = 0;
                            Object var13_14 = null;
                            if (byArray3 != null) {
                                JSAFE_Obfuscator.overwrite(byArray3);
                            }
                            if (jCMPInteger2 != null) {
                                jCMPInteger2.clearSensitiveData();
                            }
                            if (jCMPInteger == null) return n7;
                            jCMPInteger.clearSensitiveData();
                            return n7;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_15 = null;
                        if (byArray3 != null) {
                            JSAFE_Obfuscator.overwrite(byArray3);
                        }
                        if (jCMPInteger2 != null) {
                            jCMPInteger2.clearSensitiveData();
                        }
                        if (jCMPInteger == null) throw throwable;
                        jCMPInteger.clearSensitiveData();
                        throw throwable;
                    }
                }
                JSAFE_Obfuscator.overwrite(byArray3);
            }
            if (jCMPInteger2 != null) {
                jCMPInteger2.clearSensitiveData();
            }
            if (jCMPInteger == null) return n3;
            jCMPInteger.clearSensitiveData();
            return n3;
        }
        Object var13_11 = null;
        if (byArray3 != null) {
            JSAFE_Obfuscator.overwrite(byArray3);
        }
        if (jCMPInteger2 != null) {
            jCMPInteger2.clearSensitiveData();
        }
        if (jCMPInteger == null) return this.blockSize;
        jCMPInteger.clearSensitiveData();
        return this.blockSize;
    }

    public String setSignatureParameters(JSAFE_Parameters jSAFE_Parameters) {
        if (jSAFE_Parameters != null) {
            return "RSA signatures expect no system parameters.";
        }
        return null;
    }

    public String signInit(JSAFE_PrivateKey jSAFE_PrivateKey, JA_AlgaeDigest jA_AlgaeDigest, JA_SignaturePaddingScheme jA_SignaturePaddingScheme, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray) {
        String string = this.generalDecryptInit(jSAFE_PrivateKey, jA_AlgaeDigest, jA_SignaturePaddingScheme, secureRandom, jSAFE_SessionArray, true);
        if (string != null) {
            return string;
        }
        if (jA_AlgaeDigest.getAlgorithm().compareTo("NoDigest") == 0) {
            this.maxInputLen = jA_SignaturePaddingScheme.getMaxInputLen(this.blockSize);
        } else {
            this.maxInputLen = -1;
            int n = jA_AlgaeDigest.getEncodedDigestSize();
            if ((n = jA_SignaturePaddingScheme.getPadLength(n, this.blockSize)) == -1) {
                return "Key too small for RSA signatures.";
            }
        }
        return null;
    }

    public void signReInit() throws JSAFE_InvalidUseException {
    }

    public String verifyInit(JSAFE_PublicKey jSAFE_PublicKey, JA_AlgaeDigest jA_AlgaeDigest, JA_SignaturePaddingScheme jA_SignaturePaddingScheme, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray) {
        String string = this.generalEncryptInit(jSAFE_PublicKey, jA_AlgaeDigest, jA_SignaturePaddingScheme, secureRandom, jSAFE_SessionArray, true);
        if (string != null) {
            return string;
        }
        if (jA_AlgaeDigest.getAlgorithm().compareTo("NoDigest") == 0) {
            this.maxInputLen = jA_SignaturePaddingScheme.getMaxInputLen(this.blockSize);
        } else {
            this.maxInputLen = -1;
            int n = jA_AlgaeDigest.getEncodedDigestSize();
            if ((n = jA_SignaturePaddingScheme.getPadLength(n, this.blockSize)) == -1) {
                return "Key too small for RSA signatures.";
            }
        }
        return null;
    }

    public void verifyReInit() throws JSAFE_InvalidUseException {
    }

    public void signUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException, JSAFE_InputException {
        throw new JSAFE_InvalidUseException("Improper call to signUpdate.");
    }

    public int sign(byte[] byArray, int n, int n2, JA_AlgaeDigest jA_AlgaeDigest, JA_SignaturePaddingScheme jA_SignaturePaddingScheme, byte[] byArray2, int n3) {
        return this.decryptBlock(byArray, n, byArray2, n3);
    }

    public void verifyUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException, JSAFE_InputException {
        throw new JSAFE_InvalidUseException("Improper call to verifyUpdate.");
    }

    public boolean verify(byte[] byArray, int n, int n2, JA_AlgaeDigest jA_AlgaeDigest, JA_SignaturePaddingScheme jA_SignaturePaddingScheme, byte[] byArray2, int n3, int n4) {
        if (n4 != this.blockSize) {
            return false;
        }
        byte[] byArray3 = new byte[this.blockSize];
        int n5 = -1;
        this.encryptBlock(byArray2, n3, byArray3, 0);
        try {
            n5 = jA_SignaturePaddingScheme.performUnpadding(byArray3, 0, this.blockSize, jA_AlgaeDigest);
        }
        catch (JSAFE_PaddingException jSAFE_PaddingException) {
            return false;
        }
        try {
            n2 = jA_SignaturePaddingScheme.postProcessing(byArray3, this.blockSize, byArray, n2, jA_AlgaeDigest);
        }
        catch (JSAFE_PaddingException jSAFE_PaddingException) {
            return false;
        }
        if (n5 != n2) {
            return false;
        }
        int n6 = 0;
        while (n6 < n2) {
            if (byArray3[n6] != byArray[n + n6]) {
                return false;
            }
            ++n6;
        }
        return true;
    }

    public void obfuscate() {
        if (this.allKeyData == null || this.allKeyData.length < 2 || this.numberOfPrimes == -2) {
            return;
        }
        int n = 1;
        while (n < this.allKeyData.length) {
            if (this.allKeyData[n] != null) {
                this.allKeyData[n].obfuscate();
            }
            ++n;
        }
    }

    public void deobfuscate() {
        if (this.allKeyData == null || this.allKeyData.length < 2 || this.numberOfPrimes == -2) {
            return;
        }
        int n = 1;
        while (n < this.allKeyData.length) {
            if (this.allKeyData[n] != null) {
                this.allKeyData[n].deobfuscate();
            }
            ++n;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JSAFE_SecureRandom jSAFE_SecureRandom = this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization(jSAFE_SecureRandom);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private JSAFE_SecureRandom prepareSerialization() {
        this.deobfuscate();
        if (this.random == null) {
            return null;
        }
        if (!(this.random instanceof JSAFE_SecureRandom)) {
            return null;
        }
        JSAFE_SecureRandom jSAFE_SecureRandom = (JSAFE_SecureRandom)this.random;
        if (jSAFE_SecureRandom.getDevice().compareTo("Java") != 0) {
            return null;
        }
        this.randomAlgorithm = jSAFE_SecureRandom.getAlgorithm();
        this.randomSerialize = jSAFE_SecureRandom.serializeRandom();
        JSAFE_SecureRandom jSAFE_SecureRandom2 = (JSAFE_SecureRandom)this.random;
        this.random = null;
        return jSAFE_SecureRandom2;
    }

    private void restoreAfterSerialization(JSAFE_SecureRandom jSAFE_SecureRandom) {
        this.obfuscate();
        if (this.randomSerialize == null) {
            return;
        }
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
        this.random = jSAFE_SecureRandom;
    }

    private void restoreAfterDeserialization() {
        this.obfuscate();
        if (this.randomSerialize == null) {
            return;
        }
        this.random = JSAFE_SecureRandom.deserializeRandom(this.randomAlgorithm, this.randomSerialize);
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_RSA jA_RSA = new JA_RSA();
        this.copyObjects(jA_RSA);
        return jA_RSA;
    }

    protected void copyObjects(JA_RSA jA_RSA) throws CloneNotSupportedException {
        jA_RSA.arithmeticClass = this.arithmeticClass;
        jA_RSA.random = this.random;
        jA_RSA.randomAlgorithm = this.randomAlgorithm;
        jA_RSA.blockSize = this.blockSize;
        jA_RSA.maxInputLen = this.maxInputLen;
        jA_RSA.numberOfPrimes = this.numberOfPrimes;
        if (this.allKeyData != null) {
            this.deobfuscate();
            jA_RSA.allKeyData = new JCMPInteger[this.allKeyData.length];
            int n = 0;
            while (n < this.allKeyData.length) {
                if (this.allKeyData[n] != null) {
                    jA_RSA.allKeyData[n] = (JCMPInteger)this.allKeyData[n].clone();
                }
                ++n;
            }
            this.obfuscate();
            jA_RSA.obfuscate();
        }
    }

    protected void clearKeys() {
        if (this.allKeyData != null) {
            int n = 0;
            while (n < this.allKeyData.length) {
                if (this.allKeyData[n] != null) {
                    this.allKeyData[n].clearSensitiveData();
                    this.allKeyData[n] = null;
                }
                ++n;
            }
            this.allKeyData = null;
        }
        this.numberOfPrimes = 0;
        this.blockSize = -1;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
    }

    protected void doClearSensitiveData() {
        this.clearKeys();
        this.arithmeticClass = null;
        this.random = null;
        this.randomSerialize = null;
        this.randomAlgorithm = null;
        this.blockSize = -1;
        this.maxInputLen = 0;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

