/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.CryptoJ;
import com.rsa.jsafe.JA_AlternateArithmetic;
import com.rsa.jsafe.JA_MultiPrimeCount;
import com.rsa.jsafe.JA_RSAPrivateKey;
import com.rsa.jsafe.JA_RSAPublicKey;
import com.rsa.jsafe.JCMPArithmeticClass;
import com.rsa.jsafe.JCMPInteger;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidArithmeticException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_KeyPair;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_Parameters;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.KATRSASignVerify;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public class JA_RSAKeyPair
extends JSAFE_KeyPair
implements JA_AlternateArithmetic,
Cloneable,
Serializable {
    protected Class arithmeticClass;
    protected int modulusLen;
    protected int numberOfPrimes;
    protected int publicExponent;
    protected SecureRandom random;
    protected byte[] randomSerialize;
    protected String randomAlgorithm;
    protected int objectStateGen = 1;
    protected boolean strongFlag;
    protected static final int NOT_INITIALIZED = 1;
    protected static final int INITIALIZED = 2;

    public String getAlgorithm() {
        return "RSA";
    }

    protected void initializeArithmetic() {
        if (this.arithmeticClass == null) {
            this.arithmeticClass = JCMPArithmeticClass.getDefaultClass();
        }
    }

    public void setArithmetic(Class clazz) throws JSAFE_InvalidArithmeticException {
        try {
            JCMPInteger jCMPInteger = (JCMPInteger)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        this.arithmeticClass = clazz;
    }

    protected boolean setKeyPair(JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) {
        if (!(jSAFE_PublicKey instanceof JA_RSAPublicKey) || !(jSAFE_PrivateKey instanceof JA_RSAPrivateKey)) {
            return false;
        }
        return super.setKeyPair(jSAFE_PublicKey, jSAFE_PrivateKey);
    }

    public void generateStrongInit(JSAFE_Parameters jSAFE_Parameters, int[] nArray, SecureRandom secureRandom) throws JSAFE_InvalidParameterException, JSAFE_InvalidUseException {
        JSAFE_Object.checkIntegrity();
        this.generateInit(jSAFE_Parameters, nArray, secureRandom, null);
        if (this.modulusLen < 1024 || this.modulusLen % 256 != 0) {
            throw new JSAFE_InvalidParameterException("Strong RSA key pair gen requires bit length >= 1024 and multiple of 256.");
        }
        try {
            int[] nArray2;
            JSAFE_SecureRandom jSAFE_SecureRandom = (JSAFE_SecureRandom)this.random;
            String string = jSAFE_SecureRandom.getAlgorithm();
            if (!(string.compareTo("X931Random") == 0 ? (nArray2 = jSAFE_SecureRandom.getAlgorithmParameters()).length < 1 || nArray2[0] != 6 : string.compareTo("HWRandom") != 0)) {
                this.strongFlag = true;
                return;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw new JSAFE_InvalidParameterException("Strong RSA key pair gen requires HWRandom or 6 stream X931Random.");
    }

    protected boolean genInit(JSAFE_Parameters jSAFE_Parameters, int[] nArray, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray) {
        JSAFE_Object.checkIntegrity();
        this.clearKeys();
        if (jSAFE_Parameters != null) {
            return false;
        }
        if (nArray == null || nArray.length < 1 || nArray.length > 3) {
            return false;
        }
        if (nArray[0] < 256 || nArray[0] > 4096) {
            return false;
        }
        this.modulusLen = nArray[0];
        this.numberOfPrimes = 2;
        this.publicExponent = 17;
        if (nArray.length == 3) {
            this.numberOfPrimes = nArray[1];
            this.publicExponent = nArray[2];
        }
        if (nArray.length == 2) {
            this.publicExponent = nArray[1];
        }
        if (!JA_MultiPrimeCount.isValidPrimeCount(this.numberOfPrimes, this.modulusLen)) {
            return false;
        }
        if (this.publicExponent < 0 || (this.publicExponent & 1) == 0) {
            return false;
        }
        if (secureRandom != null) {
            this.random = secureRandom;
        }
        if (this.random == null) {
            return false;
        }
        this.strongFlag = false;
        this.objectStateGen = 2;
        return true;
    }

    protected void genReInit() throws JSAFE_InvalidUseException {
        JSAFE_Object.checkIntegrity();
        this.clearKeys();
        if (this.objectStateGen != 2) {
            throw new JSAFE_InvalidUseException("Cannot reInit, object not initialized.");
        }
    }

    void pairwiseConsistencyCheck(JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) {
        JSAFE_PublicKey jSAFE_PublicKey2 = null;
        JSAFE_PrivateKey jSAFE_PrivateKey2 = null;
        try {
            jSAFE_PublicKey2 = this.getPublicKey();
            jSAFE_PrivateKey2 = this.getPrivateKey();
            KATRSASignVerify kATRSASignVerify = new KATRSASignVerify();
            if (!kATRSASignVerify.testKeyPair(jSAFE_PublicKey2, jSAFE_PrivateKey2)) {
                CryptoJ.verified = 2;
                this.clearSensitiveData();
                this.objectStateGen = 1;
                throw new RuntimeException("Crypto-J has entered a failed state and is inoperable.An internal pairwise consistency check failed");
            }
            Object var7_6 = null;
            if (jSAFE_PublicKey2 != null) {
                jSAFE_PublicKey2.clearSensitiveData();
            }
            if (jSAFE_PrivateKey2 != null) {
                jSAFE_PrivateKey2.clearSensitiveData();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (jSAFE_PublicKey2 != null) {
                jSAFE_PublicKey2.clearSensitiveData();
            }
            if (jSAFE_PrivateKey2 != null) {
                jSAFE_PrivateKey2.clearSensitiveData();
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void generateKeyPair() throws JSAFE_InvalidUseException {
        block57: {
            block58: {
                block56: {
                    if (this.objectStateGen != 2) {
                        throw new JSAFE_InvalidUseException("Cannot generate, object not initialized.");
                    }
                    this.initializeArithmetic();
                    var1_1 = null;
                    var2_2 = null;
                    var3_3 = null;
                    var4_4 = new JCMPInteger[this.numberOfPrimes];
                    var5_5 = null;
                    var6_6 = null;
                    var7_7 = new JCMPInteger[this.numberOfPrimes];
                    var8_8 = null;
                    var9_9 = null;
                    var10_10 = null;
                    var11_11 = null;
                    var12_12 = new byte[this.numberOfPrimes * 3 + 3][];
                    var13_13 = new byte[2][];
                    var12_12[3] = new byte[1];
                    var12_12[3][0] = (byte)this.numberOfPrimes;
                    try {
                        block55: {
                            var1_1 = JSAFE_PublicKey.getInstance("RSA", this.getDevice());
                            var2_2 = JSAFE_PrivateKey.getInstance("RSA", this.getDevice());
                            var3_3 = (JCMPInteger)this.arithmeticClass.newInstance();
                            var14_14 = 0;
                            while (var14_14 < this.numberOfPrimes) {
                                var4_4[var14_14] = (JCMPInteger)this.arithmeticClass.newInstance();
                                var7_7[var14_14] = (JCMPInteger)this.arithmeticClass.newInstance();
                                ++var14_14;
                            }
                            var5_5 = (JCMPInteger)this.arithmeticClass.newInstance();
                            var6_6 = (JCMPInteger)this.arithmeticClass.newInstance();
                            var8_8 = (JCMPInteger)this.arithmeticClass.newInstance();
                            var9_9 = (JCMPInteger)this.arithmeticClass.newInstance();
                            var10_10 = (JCMPInteger)this.arithmeticClass.newInstance();
                            var11_11 = (JCMPInteger)this.arithmeticClass.newInstance();
                            var3_3.setValue(this.publicExponent);
                            var10_10.setValue(0);
                            var11_11.setValue(1);
                            var15_16 = new int[this.numberOfPrimes];
                            var16_18 = this.modulusLen / this.numberOfPrimes;
                            var17_20 = this.modulusLen % this.numberOfPrimes;
                            var18_21 = 0;
                            while (var18_21 < this.numberOfPrimes) {
                                var15_16[var18_21] = var16_18;
                                if (var17_20 > 0) {
                                    v0 = var18_21;
                                    var15_16[v0] = var15_16[v0] + 1;
                                    --var17_20;
                                }
                                ++var18_21;
                            }
                            var17_20 = this.modulusLen % this.numberOfPrimes;
                            var19_22 = 1;
                            var20_23 = new byte[1];
                            while (true) {
                                var21_24 = 3;
                                var22_25 = 1;
                                var23_26 = 0;
                                while (var23_26 < this.numberOfPrimes) {
                                    if (this.strongFlag) {
                                        var19_22 = (var19_22 = this.setStream(var19_22, var22_25, var20_23)) == 1 ? 4 : 1;
                                        if (!var4_4[var23_26].generatePrime(var15_16[var23_26], var3_3, var21_24, this.strongFlag, this.random)) {
                                            continue;
                                        }
                                    } else if (this.numberOfPrimes == 2) {
                                        if (!var4_4[var23_26].generatePrime(var15_16[var23_26], var3_3, var21_24, this.strongFlag, this.random)) {
                                            continue;
                                        }
                                    } else {
                                        this.createStartingPoint(var4_4[var23_26], var16_18, var17_20, this.random);
                                        if (!var4_4[var23_26].buildPrime(var3_3, this.random)) continue;
                                    }
                                    var4_4[var23_26].subtract(var11_11, var7_7[var23_26]);
                                    var7_7[var23_26].modReduce(var3_3, var8_8);
                                    if (!this.relativelyPrimeTest(var8_8)) continue;
                                    var22_25 = 4;
                                    ++var23_26;
                                    var21_24 = 7;
                                }
                                if (!this.orderPrimes(var4_4, var7_7)) continue;
                                var7_7[0].multiply(var7_7[1], var5_5);
                                var24_27 = 2;
                                while (var24_27 < this.numberOfPrimes) {
                                    var7_7[var24_27].multiply(var5_5, var8_8);
                                    var5_5.setValue(var8_8);
                                    ++var24_27;
                                }
                                if (!var3_3.modInvert(var5_5, var9_9) || var9_9.compareTo(var10_10) == 0) continue;
                                var4_4[0].multiply(var4_4[1], var6_6);
                                var25_29 = 2;
                                while (var25_29 < this.numberOfPrimes) {
                                    var4_4[var25_29].multiply(var6_6, var8_8);
                                    var6_6.setValue(var8_8);
                                    ++var25_29;
                                }
                                if (this.testCandidatePair(var3_3, var9_9, var6_6)) break;
                            }
                            var12_12[0] = var6_6.toOctetString();
                            var12_12[1] = var3_3.toOctetString();
                            var12_12[2] = var9_9.toOctetString();
                            var21_24 = 4;
                            var22_25 = 0;
                            while (var22_25 < this.numberOfPrimes) {
                                var12_12[var21_24] = var4_4[var22_25].toOctetString();
                                ++var22_25;
                                ++var21_24;
                            }
                            var23_26 = 0;
                            while (var23_26 < this.numberOfPrimes) {
                                var9_9.modReduce(var7_7[var23_26], var8_8);
                                var12_12[var21_24] = var8_8.toOctetString();
                                ++var23_26;
                                ++var21_24;
                            }
                            var24_28 = var4_4[1];
                            var4_4[1] = var4_4[0];
                            var4_4[0] = var24_28;
                            var6_6.setValue(1);
                            var25_29 = 1;
                            while (var25_29 < this.numberOfPrimes) {
                                var6_6.multiply(var4_4[var25_29 - 1], var8_8);
                                var6_6.setValue(var8_8);
                                var6_6.modReduce(var4_4[var25_29], var8_8);
                                var8_8.modInvert(var4_4[var25_29], var9_9);
                                var12_12[var21_24] = var9_9.toOctetString();
                                ++var25_29;
                                ++var21_24;
                            }
                            var24_28 = var4_4[1];
                            var4_4[1] = var4_4[0];
                            var4_4[0] = var24_28;
                            var2_2.setKeyData("RSAMultiPrimePrivateKeyCRT", var12_12);
                            var13_13[0] = var12_12[0];
                            var13_13[1] = var12_12[1];
                            var1_1.setKeyData("RSAPublicKey", var13_13);
                            this.setKeys(var1_1, var2_2);
                            if (!JSAFE_Object.fipsIsRequired()) break block55;
                            this.pairwiseConsistencyCheck(var1_1, var2_2);
                        }
                        var27_30 = null;
                        if (var2_2 != null) {
                            var2_2.clearSensitiveData();
                        }
                        if (var1_1 != null) {
                            var1_1.clearSensitiveData();
                        }
                        if (var4_4 == null) break block56;
                        var28_32 = 0;
                        ** while (var28_32 < this.numberOfPrimes)
                    }
                    catch (Throwable var26_34) {
                        var27_31 = null;
                        if (var2_2 != null) {
                            var2_2.clearSensitiveData();
                        }
                        if (var1_1 != null) {
                            var1_1.clearSensitiveData();
                        }
                        if (var4_4 == null) break block58;
                        var28_33 = 0;
                        ** while (var28_33 < this.numberOfPrimes)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (var4_4[var28_32] != null) {
                            var4_4[var28_32].clearSensitiveData();
                        }
                        ++var28_32;
                        continue;
                    }
                }
                if (var7_7 != null) {
                    var28_32 = 0;
                    while (var28_32 < this.numberOfPrimes) {
                        if (var7_7[var28_32] != null) {
                            var7_7[var28_32].clearSensitiveData();
                        }
                        ++var28_32;
                    }
                }
                if (var8_8 != null) {
                    var8_8.clearSensitiveData();
                }
                if (var9_9 != null) {
                    var9_9.clearSensitiveData();
                }
                if (var5_5 != null) {
                    var5_5.clearSensitiveData();
                }
                if (var3_3 != null) {
                    var3_3.clearSensitiveData();
                }
                if (var6_6 != null) {
                    var6_6.clearSensitiveData();
                }
                if (var10_10 != null) {
                    var10_10.clearSensitiveData();
                }
                if (var11_11 != null) {
                    var11_11.clearSensitiveData();
                }
                var28_32 = 2;
                while (var28_32 < var12_12.length) {
                    if (var12_12[var28_32] != null) {
                        JSAFE_Obfuscator.overwrite(var12_12[var28_32]);
                    }
                    ++var28_32;
                }
                {
                    break block57;
                    catch (JSAFE_Exception var14_15) {
                        throw new JSAFE_InvalidUseException("Could not generate the key pair, try reseeding.");
                    }
                    catch (InstantiationException var15_17) {
                        throw new JSAFE_InvalidUseException("Bad arithmetic class.");
                    }
                    catch (IllegalAccessException var16_19) {
                        throw new JSAFE_InvalidUseException("Bad arithmetic class.");
                    }
                }
lbl-1000:
                // 1 sources

                {
                    if (var4_4[var28_33] != null) {
                        var4_4[var28_33].clearSensitiveData();
                    }
                    ++var28_33;
                    continue;
                }
            }
            if (var7_7 != null) {
                var28_33 = 0;
                while (var28_33 < this.numberOfPrimes) {
                    if (var7_7[var28_33] != null) {
                        var7_7[var28_33].clearSensitiveData();
                    }
                    ++var28_33;
                }
            }
            if (var8_8 != null) {
                var8_8.clearSensitiveData();
            }
            if (var9_9 != null) {
                var9_9.clearSensitiveData();
            }
            if (var5_5 != null) {
                var5_5.clearSensitiveData();
            }
            if (var3_3 != null) {
                var3_3.clearSensitiveData();
            }
            if (var6_6 != null) {
                var6_6.clearSensitiveData();
            }
            if (var10_10 != null) {
                var10_10.clearSensitiveData();
            }
            if (var11_11 != null) {
                var11_11.clearSensitiveData();
            }
            var28_33 = 2;
            while (var28_33 < var12_12.length) {
                if (var12_12[var28_33] != null) {
                    JSAFE_Obfuscator.overwrite(var12_12[var28_33]);
                }
                ++var28_33;
            }
            throw var26_34;
        }
    }

    private void createStartingPoint(JCMPInteger jCMPInteger, int n, int n2, SecureRandom secureRandom) throws JSAFE_InvalidUseException {
        byte[] byArray = new byte[(n + 7) / 8];
        secureRandom.nextBytes(byArray);
        try {
            try {
                int n3 = byArray.length * 8 - n;
                byArray[0] = (byte)((byArray[0] & 0xFF) >> n3);
                jCMPInteger.setValue(byArray, 0, byArray.length);
                JCMPInteger jCMPInteger2 = (JCMPInteger)this.arithmeticClass.newInstance();
                JCMPInteger jCMPInteger3 = (JCMPInteger)this.arithmeticClass.newInstance();
                JCMPInteger jCMPInteger4 = (JCMPInteger)this.arithmeticClass.newInstance();
                switch (n2) {
                    case 2: {
                        byte[] byArray2 = new byte[]{80, -94, -117, -25};
                        byte[] byArray3 = new byte[]{20, -11, 110, -82};
                        jCMPInteger2.setValue(byArray2, 0, byArray2.length);
                        jCMPInteger3.setValue(byArray3, 0, byArray3.length);
                        break;
                    }
                    case 1: {
                        byte[] byArray4 = new byte[]{64, 0, 0, 0};
                        byte[] byArray5 = new byte[]{16, -94, -117, -25};
                        jCMPInteger2.setValue(byArray4, 0, byArray4.length);
                        jCMPInteger3.setValue(byArray5, 0, byArray5.length);
                        break;
                    }
                    default: {
                        byte[] byArray6 = new byte[]{50, -53, -3, 75};
                        byte[] byArray7 = new byte[]{13, 52, 2, -75};
                        jCMPInteger2.setValue(byArray6, 0, byArray6.length);
                        jCMPInteger3.setValue(byArray7, 0, byArray7.length);
                    }
                }
                jCMPInteger2.shiftLeftByBits(n);
                jCMPInteger.multiply(jCMPInteger3, jCMPInteger4);
                jCMPInteger4.add(jCMPInteger2, jCMPInteger);
                jCMPInteger.shiftRightByBits(30);
                jCMPInteger.setBit(0, 1);
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new JSAFE_InvalidUseException("Invalid generate input.");
            }
            catch (InstantiationException instantiationException) {
                throw new JSAFE_InvalidUseException("Bad arithmetic class.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JSAFE_InvalidUseException("Bad arithmetic class.");
            }
            Object var17_19 = null;
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            JSAFE_Obfuscator.overwrite(byArray);
            throw throwable;
        }
        JSAFE_Obfuscator.overwrite(byArray);
    }

    private boolean orderPrimes(JCMPInteger[] jCMPIntegerArray, JCMPInteger[] jCMPIntegerArray2) {
        try {
            int n = 0;
            while (n < jCMPIntegerArray.length - 1) {
                int n2 = n;
                int n3 = n + 1;
                while (n3 < jCMPIntegerArray.length) {
                    int n4 = jCMPIntegerArray[n2].compareTo(jCMPIntegerArray[n3]);
                    if (n4 == 0) {
                        return false;
                    }
                    if (n4 < 0) {
                        n2 = n3;
                    }
                    ++n3;
                }
                if (n2 != n) {
                    JCMPInteger jCMPInteger = jCMPIntegerArray[n];
                    jCMPIntegerArray[n] = jCMPIntegerArray[n2];
                    jCMPIntegerArray[n2] = jCMPInteger;
                    jCMPInteger = jCMPIntegerArray2[n];
                    jCMPIntegerArray2[n] = jCMPIntegerArray2[n2];
                    jCMPIntegerArray2[n2] = jCMPInteger;
                }
                ++n;
            }
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return false;
        }
        return true;
    }

    private int setStream(int n, int n2, byte[] byArray) {
        if (n == n2) {
            return n2;
        }
        int n3 = n;
        while (n3 <= 6) {
            this.random.nextBytes(byArray);
            ++n3;
        }
        int n4 = 1;
        while (n4 < n2) {
            this.random.nextBytes(byArray);
            ++n4;
        }
        return n2;
    }

    public boolean testCandidatePair(JCMPInteger jCMPInteger, JCMPInteger jCMPInteger2, JCMPInteger jCMPInteger3) {
        boolean bl;
        block22: {
            JCMPInteger jCMPInteger4 = null;
            JCMPInteger jCMPInteger5 = null;
            JCMPInteger jCMPInteger6 = null;
            bl = false;
            try {
                block21: {
                    try {
                        jCMPInteger4 = (JCMPInteger)this.arithmeticClass.newInstance();
                        jCMPInteger5 = (JCMPInteger)this.arithmeticClass.newInstance();
                        jCMPInteger6 = (JCMPInteger)this.arithmeticClass.newInstance();
                        jCMPInteger4.setValue(127);
                        jCMPInteger4.modExp(jCMPInteger, jCMPInteger3, jCMPInteger5);
                        jCMPInteger5.modExp(jCMPInteger2, jCMPInteger3, jCMPInteger6);
                        if (jCMPInteger6.compareTo(jCMPInteger4) != 0) break block21;
                        bl = true;
                    }
                    catch (InstantiationException instantiationException) {
                        bl = false;
                        Object var12_9 = null;
                        if (jCMPInteger4 != null) {
                            jCMPInteger4.clearSensitiveData();
                        }
                        if (jCMPInteger5 != null) {
                            jCMPInteger5.clearSensitiveData();
                        }
                        if (jCMPInteger6 != null) {
                            jCMPInteger6.clearSensitiveData();
                        }
                        break block22;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        bl = false;
                        Object var12_10 = null;
                        if (jCMPInteger4 != null) {
                            jCMPInteger4.clearSensitiveData();
                        }
                        if (jCMPInteger5 != null) {
                            jCMPInteger5.clearSensitiveData();
                        }
                        if (jCMPInteger6 != null) {
                            jCMPInteger6.clearSensitiveData();
                        }
                        break block22;
                    }
                    catch (JSAFE_InputException jSAFE_InputException) {
                        bl = false;
                        Object var12_11 = null;
                        if (jCMPInteger4 != null) {
                            jCMPInteger4.clearSensitiveData();
                        }
                        if (jCMPInteger5 != null) {
                            jCMPInteger5.clearSensitiveData();
                        }
                        if (jCMPInteger6 != null) {
                            jCMPInteger6.clearSensitiveData();
                        }
                    }
                }
                Object var12_8 = null;
                if (jCMPInteger4 != null) {
                    jCMPInteger4.clearSensitiveData();
                }
                if (jCMPInteger5 != null) {
                    jCMPInteger5.clearSensitiveData();
                }
                if (jCMPInteger6 != null) {
                    jCMPInteger6.clearSensitiveData();
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (jCMPInteger4 != null) {
                    jCMPInteger4.clearSensitiveData();
                }
                if (jCMPInteger5 != null) {
                    jCMPInteger5.clearSensitiveData();
                }
                if (jCMPInteger6 != null) {
                    jCMPInteger6.clearSensitiveData();
                }
                throw throwable;
            }
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JSAFE_SecureRandom jSAFE_SecureRandom = this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization(jSAFE_SecureRandom);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private JSAFE_SecureRandom prepareSerialization() {
        if (this.random == null) {
            return null;
        }
        if (!(this.random instanceof JSAFE_SecureRandom)) {
            return null;
        }
        JSAFE_SecureRandom jSAFE_SecureRandom = (JSAFE_SecureRandom)this.random;
        if (jSAFE_SecureRandom.getDevice().compareTo("Java") != 0) {
            return null;
        }
        this.randomAlgorithm = jSAFE_SecureRandom.getAlgorithm();
        this.randomSerialize = jSAFE_SecureRandom.serializeRandom();
        JSAFE_SecureRandom jSAFE_SecureRandom2 = (JSAFE_SecureRandom)this.random;
        this.random = null;
        return jSAFE_SecureRandom2;
    }

    private void restoreAfterSerialization(JSAFE_SecureRandom jSAFE_SecureRandom) {
        if (this.randomSerialize == null) {
            return;
        }
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
        this.random = jSAFE_SecureRandom;
    }

    private void restoreAfterDeserialization() {
        if (this.randomSerialize == null) {
            return;
        }
        this.random = JSAFE_SecureRandom.deserializeRandom(this.randomAlgorithm, this.randomSerialize);
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
    }

    protected JSAFE_KeyPair createClone() throws CloneNotSupportedException {
        JA_RSAKeyPair jA_RSAKeyPair = new JA_RSAKeyPair();
        jA_RSAKeyPair.arithmeticClass = this.arithmeticClass;
        jA_RSAKeyPair.modulusLen = this.modulusLen;
        jA_RSAKeyPair.numberOfPrimes = this.numberOfPrimes;
        jA_RSAKeyPair.publicExponent = this.publicExponent;
        jA_RSAKeyPair.random = this.random;
        jA_RSAKeyPair.objectStateGen = this.objectStateGen;
        jA_RSAKeyPair.setJSAFELevelValues(this);
        return jA_RSAKeyPair;
    }

    private boolean relativelyPrimeTest(JCMPInteger jCMPInteger) {
        try {
            byte[] byArray = jCMPInteger.toOctetString();
            int n = this.publicExponent;
            int n2 = 0;
            int n3 = 0;
            while (n3 < byArray.length) {
                n2 <<= 8;
                n2 += byArray[n3] & 0xFF;
                ++n3;
            }
            while (n2 > 0) {
                int n4 = n % n2;
                n = n2;
                n2 = n4;
            }
            return n == 1;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return false;
        }
    }

    protected void clearKeys() {
        super.clearKeys();
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
    }

    protected void doClearSensitiveData() {
        this.clearKeys();
        this.modulusLen = 0;
        this.numberOfPrimes = 0;
        this.publicExponent = 0;
        this.objectStateGen = 1;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

