/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_MultiPrimeCount;
import com.rsa.jsafe.JA_RSAPrivateKeyBER;
import com.rsa.jsafe.JA_SSLCKeyEncode;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class JA_RSAPrivateKey
extends JSAFE_PrivateKey
implements Cloneable,
Serializable {
    private int numberOfPrimes;
    private byte[][] allKeyData;
    private transient ObfuscatorItem[] allOI;

    public String getAlgorithm() {
        return "RSA";
    }

    public String[] getSupportedSetFormats() {
        String[] stringArray = new String[]{"RSAPrivateKeyCRT", "RSAMultiPrimePrivateKeyCRT", "RSAPrivateKey", "RSAPrivateKeyBER", "SSLCPKCS1RSAPrivateKeyBER", "SSLCPKCS1RSAPrivateKeyPEM"};
        return stringArray;
    }

    public String[] getSupportedGetFormats() {
        if (this.allKeyData == null || this.allKeyData.length < 2) {
            return new String[0];
        }
        if (this.allKeyData[0] == null || this.allKeyData[1] == null) {
            return new String[0];
        }
        if (this.numberOfPrimes == 0) {
            String[] stringArray = new String[]{"RSAPrivateKey", "SSLCPKCS1RSAPrivateKeyBER", "SSLCPKCS1RSAPrivateKeyPEM"};
            return stringArray;
        }
        if (this.numberOfPrimes > 2) {
            String[] stringArray = new String[]{"RSAMultiPrimePrivateKeyCRT", "RSAPrivateKey", "RSAPrivateKeyBER"};
            return stringArray;
        }
        String[] stringArray = new String[]{"RSAMultiPrimePrivateKeyCRT", "RSAPrivateKeyCRT", "RSAPrivateKey", "RSAPrivateKeyBER", "SSLCPKCS1RSAPrivateKeyBER", "SSLCPKCS1RSAPrivateKeyPEM"};
        return stringArray;
    }

    public void setKeyData(String string, byte[][] byArray) throws JSAFE_UnimplementedException, JSAFE_InvalidKeyException {
        if (string.compareTo("RSAPrivateKeyCRT") == 0) {
            this.setKeyData(byArray);
            return;
        }
        if (string.compareTo("RSAMultiPrimePrivateKeyCRT") == 0) {
            this.setKeyDataMultiPrime(byArray);
            return;
        }
        if (string.compareTo("RSAPrivateKey") == 0) {
            this.setAbbreviatedKeyData(byArray);
            return;
        }
        if (string.compareTo("RSAPrivateKeyBER") == 0) {
            if (byArray.length != 1) {
                this.clearKeyData();
                throw new JSAFE_InvalidKeyException("Invalid BER RSA private key data.");
            }
            this.setKeyDataBER(byArray[0], 0);
            return;
        }
        if (string.equals("SSLCPKCS1RSAPrivateKeyBER") || string.equals("SSLCPKCS1RSAPrivateKeyPEM")) {
            byte[] byArray2;
            if (byArray.length != 1) {
                throw new JSAFE_InvalidKeyException("Invalid SSLC RSA private key data.");
            }
            Object var3_3 = null;
            String[] stringArray = new String[1];
            byte[] byArray3 = new byte[8];
            byte[] byArray4 = byArray[0];
            if (string.compareTo("SSLCPKCS1RSAPrivateKeyPEM") == 0) {
                byArray2 = JA_SSLCKeyEncode.pemDecodeNotEncrypted(byArray[0]);
                byArray4 = JA_SSLCKeyEncode.base64Decode(byArray2);
            }
            byArray2 = JA_SSLCKeyEncode.convertPKCS1ToPKCS8(byArray4);
            this.setKeyDataBER(byArray2, 0);
            return;
        }
        this.clearKeyData();
        throw new JSAFE_UnimplementedException("Unimplemented RSA Private Key Format.");
    }

    public void setKeyData(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.clearKeyData();
        if (byArray.length != 8) {
            throw new JSAFE_InvalidKeyException("Invalid RSA Private Key data format");
        }
        this.numberOfPrimes = 2;
        this.allKeyData = new byte[8][];
        this.allOI = new ObfuscatorItem[6];
        boolean bl = false;
        int n = 0;
        int n2 = -2;
        while (n < 8) {
            bl = this.loadData(byArray[n], 0, byArray[n].length, n, n2);
            if (!bl) break;
            ++n;
            ++n2;
        }
        if (!bl) {
            throw new JSAFE_InvalidKeyException("Invalid RSA Private Key data format");
        }
    }

    public void setKeyDataMultiPrime(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.clearKeyData();
        if (byArray == null || byArray.length < 4) {
            throw new JSAFE_InvalidKeyException("Invalid RSA Private Key data format");
        }
        if (byArray[3] == null || byArray[3].length != 1) {
            throw new JSAFE_InvalidKeyException("Invalid RSA Private Key data format");
        }
        this.numberOfPrimes = byArray[3][0] & 0xFF;
        int n = this.numberOfPrimes * 3 + 2;
        if (byArray.length != n + 1) {
            throw new JSAFE_InvalidKeyException("Invalid RSA Private Key data format");
        }
        this.allKeyData = new byte[n][];
        this.allOI = new ObfuscatorItem[n - 2];
        boolean bl = false;
        int n2 = 0;
        int n3 = -2;
        int n4 = 0;
        while (n2 < n + 1) {
            if (n2 != 3) {
                bl = this.loadData(byArray[n2], 0, byArray[n2].length, n4, n3);
                ++n4;
                if (!bl) break;
                ++n3;
            }
            ++n2;
        }
        if (!bl) {
            throw new JSAFE_InvalidKeyException("Invalid RSA Private Key data format");
        }
    }

    private void setAbbreviatedKeyData(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.clearKeyData();
        if (byArray.length != 2) {
            throw new JSAFE_InvalidKeyException("Invalid RSA Private Key Data Format.");
        }
        this.allKeyData = new byte[2][];
        this.allOI = new ObfuscatorItem[1];
        boolean bl = false;
        int n = 0;
        int n2 = -1;
        while (n < 2) {
            bl = this.loadData(byArray[n], 0, byArray[n].length, n, n2);
            if (!bl) break;
            ++n;
            ++n2;
        }
        if (!bl) {
            throw new JSAFE_InvalidKeyException("Invalid RSA Private Key data format");
        }
    }

    void setKeyDataBER(byte[] byArray, int n) throws JSAFE_InvalidKeyException {
        this.clearKeyData();
        JA_RSAPrivateKeyBER.setKeyDataBER(this, byArray, n);
    }

    int createDataArrays(int n) {
        int n2 = n * 3 + 2;
        this.allKeyData = new byte[n2][];
        this.allOI = new ObfuscatorItem[n2 - 2];
        this.numberOfPrimes = n;
        return n2;
    }

    void prepareForBERData(int n) {
        this.clearKeyData();
        this.numberOfPrimes = n;
        this.allKeyData = new byte[n * 3 + 2][];
        this.allOI = new ObfuscatorItem[n * 3];
    }

    boolean loadData(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = n;
        while (n5 < n + n2) {
            if (n >= byArray.length) {
                return false;
            }
            if (byArray[n] != 0) break;
            ++n;
            --n2;
            ++n5;
        }
        this.allKeyData[n3] = new byte[n2];
        System.arraycopy(byArray, n, this.allKeyData[n3], 0, n2);
        if (n4 < 0) {
            return true;
        }
        this.allOI[n4] = JSAFE_Obfuscator.register(this.allKeyData[n3]);
        this.allOI[n4].obfuscate();
        return true;
    }

    private boolean checkPrimeCount(int n) {
        if (this.allKeyData == null || this.allKeyData[0] == null) {
            return false;
        }
        int n2 = this.allKeyData[0].length * 8;
        int n3 = this.allKeyData[0][0] & 0xFF;
        int n4 = 0;
        while (n3 == 0) {
            if (++n4 >= this.allKeyData[0].length) {
                return false;
            }
            n3 = this.allKeyData[0][n4];
        }
        while ((n3 & 0x80) == 0) {
            --n2;
            n3 <<= 1;
        }
        return JA_MultiPrimeCount.isValidPrimeCount(n, n2);
    }

    public byte[][] getKeyData(String string) throws JSAFE_UnimplementedException {
        if (string.compareTo("RSAPrivateKeyCRT") == 0) {
            return this.getKeyData();
        }
        if (string.compareTo("RSAMultiPrimePrivateKeyCRT") == 0) {
            return this.getKeyDataMultiPrime();
        }
        if (string.compareTo("RSAPrivateKeyBER") == 0) {
            return this.getKeyDataBER();
        }
        if (string.compareTo("RSAPrivateKey") == 0) {
            return this.getAbbreviatedKeyData();
        }
        if (string.equals("SSLCPKCS1RSAPrivateKeyBER") || string.equals("SSLCPKCS1RSAPrivateKeyPEM")) {
            byte[] byArray;
            byte[][] byArrayArray = new byte[][]{null};
            byte[][] byArray2 = this.getKeyDataBER();
            try {
                byArray = JA_SSLCKeyEncode.convertPKCS8ToPKCS1(byArray2[0]);
                byArrayArray[0] = byArray;
            }
            catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
                throw new JSAFE_UnimplementedException(jSAFE_InvalidKeyException.getMessage());
            }
            if (string.compareTo("SSLCPKCS1RSAPrivateKeyPEM") != 0) {
                return byArrayArray;
            }
            byArray = null;
            byte[] byArray3 = byArrayArray[0];
            try {
                byArray = JA_SSLCKeyEncode.base64Encode(byArray3);
            }
            catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
                throw new JSAFE_UnimplementedException(jSAFE_InvalidKeyException.getMessage());
            }
            byte[] byArray4 = new byte[8];
            byte[] byArray5 = JA_SSLCKeyEncode.pemEncode(byArray, "CLEAR", byArray4);
            byte[][] byArrayArray2 = new byte[][]{byArray5};
            return byArrayArray2;
        }
        throw new JSAFE_UnimplementedException("Unimplemented Key Data Format");
    }

    public byte[][] getKeyData() {
        if (this.numberOfPrimes != 2) {
            return new byte[0][];
        }
        byte[][] byArrayArray = new byte[8][];
        int n = 0;
        while (n < 8) {
            if (n > 1) {
                this.allOI[n - 2].deobfuscate();
                byArrayArray[n] = (byte[])this.allKeyData[n].clone();
                this.allOI[n - 2].obfuscate();
            } else {
                byArrayArray[n] = (byte[])this.allKeyData[n].clone();
            }
            ++n;
        }
        return byArrayArray;
    }

    public byte[][] getKeyDataMultiPrime() {
        if (this.numberOfPrimes < 2) {
            return new byte[0][];
        }
        int n = this.numberOfPrimes * 3 + 3;
        byte[][] byArrayArray = new byte[n][];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            if (n2 == 3) {
                byArrayArray[n2] = new byte[1];
                byArrayArray[n2][0] = (byte)this.numberOfPrimes;
            } else {
                if (n3 > 1) {
                    this.allOI[n3 - 2].deobfuscate();
                    byArrayArray[n2] = (byte[])this.allKeyData[n3].clone();
                    this.allOI[n3 - 2].obfuscate();
                } else {
                    byArrayArray[n2] = (byte[])this.allKeyData[n3].clone();
                }
                ++n3;
            }
            ++n2;
        }
        return byArrayArray;
    }

    private byte[][] getAbbreviatedKeyData() {
        if (this.allKeyData == null) {
            return new byte[0][];
        }
        int n = 0;
        int n2 = 1;
        if (this.numberOfPrimes > 0) {
            n2 = 2;
        }
        if (this.allKeyData.length < n2 + 1 || this.allKeyData[n] == null || this.allKeyData[n2] == null) {
            return new byte[0][];
        }
        this.allOI[0].deobfuscate();
        byte[][] byArrayArray = new byte[][]{(byte[])this.allKeyData[n].clone(), (byte[])this.allKeyData[n2].clone()};
        this.allOI[0].deobfuscate();
        return byArrayArray;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[][] getKeyDataBER() {
        if (this.numberOfPrimes == 0) {
            return new byte[0][];
        }
        var1_1 = 0;
        while (var1_1 < this.allOI.length) {
            this.allOI[var1_1].deobfuscate();
            ++var1_1;
        }
        try {
            try {
                var2_2 = JA_RSAPrivateKeyBER.getKeyDataBER(this.numberOfPrimes, this.allKeyData);
                var4_6 = var3_4 = new byte[][]{var2_2};
                var6_7 = null;
                var1_1 = 0;
                if (true) ** GOTO lbl30
            }
            catch (JSAFE_Exception var2_3) {
                var3_5 = new byte[][]{};
                var6_8 = null;
                var1_1 = 0;
                if (true) ** GOTO lbl35
            }
        }
        catch (Throwable var5_10) {
            var6_9 = null;
            var1_1 = 0;
            if (true) ** GOTO lbl40
        }
        do {
            this.allOI[var1_1].obfuscate();
            ++var1_1;
lbl30:
            // 2 sources

        } while (var1_1 < this.allOI.length);
        return var4_6;
        do {
            this.allOI[var1_1].obfuscate();
            ++var1_1;
lbl35:
            // 2 sources

        } while (var1_1 < this.allOI.length);
        return var3_5;
        do {
            this.allOI[var1_1].obfuscate();
            ++var1_1;
lbl40:
            // 2 sources

        } while (var1_1 < this.allOI.length);
        throw var5_10;
    }

    public int getMaximumKeyLength() {
        return 4096;
    }

    public int getMinimumKeyLength() {
        return 256;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JA_RSAPrivateKey)) {
            return false;
        }
        return this.dataEquals(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean dataEquals(Object object) {
        byte[][] byArray;
        block14: {
            boolean bl;
            block15: {
                boolean bl2;
                block13: {
                    boolean bl3;
                    block12: {
                        byArray = null;
                        try {
                            try {
                                JSAFE_PrivateKey jSAFE_PrivateKey = (JSAFE_PrivateKey)object;
                                if (this.allKeyData == null || this.allKeyData.length < 2) {
                                    if (jSAFE_PrivateKey.getAlgorithm().compareTo("RSA") != 0) {
                                        bl3 = false;
                                        Object var10_8 = null;
                                        if (byArray == null) return bl3;
                                        break block12;
                                    } else {
                                        String[] stringArray = jSAFE_PrivateKey.getSupportedGetFormats();
                                        int n = 0;
                                        while (true) {
                                            if (n >= stringArray.length) break;
                                            if (stringArray[n].equals("RSAPrivateKey")) {
                                                boolean bl4 = false;
                                                Object var10_9 = null;
                                                if (byArray == null) return bl4;
                                                if (byArray.length < 2) return bl4;
                                                this.overwrite(byArray[1]);
                                                return bl4;
                                            }
                                            ++n;
                                        }
                                        boolean bl5 = true;
                                        Object var10_10 = null;
                                        if (byArray == null) return bl5;
                                        if (byArray.length < 2) return bl5;
                                        this.overwrite(byArray[1]);
                                        return bl5;
                                    }
                                }
                                byArray = jSAFE_PrivateKey.getKeyData("RSAPrivateKey");
                                if (!this.compareKeyArrays(this.allKeyData[0], null, byArray[0], null)) {
                                    bl2 = false;
                                    break block13;
                                }
                                int n = 1;
                                if (this.allKeyData.length > 2) {
                                    n = 2;
                                }
                                if (this.compareKeyArrays(this.allKeyData[n], this.allOI[0], byArray[1], null)) break block14;
                                bl = false;
                                break block15;
                            }
                            catch (Exception exception) {
                                boolean bl6 = false;
                                Object var10_14 = null;
                                if (byArray == null) return bl6;
                                if (byArray.length < 2) return bl6;
                                this.overwrite(byArray[1]);
                                return bl6;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_15 = null;
                            if (byArray == null) throw throwable;
                            if (byArray.length < 2) throw throwable;
                            this.overwrite((byte[])byArray[1]);
                            throw throwable;
                        }
                    }
                    if (byArray.length < 2) return bl3;
                    this.overwrite(byArray[1]);
                    return bl3;
                }
                Object var10_11 = null;
                if (byArray == null) return bl2;
                if (byArray.length < 2) return bl2;
                this.overwrite(byArray[1]);
                return bl2;
            }
            Object var10_12 = null;
            if (byArray == null) return bl;
            if (byArray.length < 2) return bl;
            this.overwrite(byArray[1]);
            return bl;
        }
        Object var10_13 = null;
        if (byArray == null) return true;
        if (byArray.length < 2) return true;
        this.overwrite(byArray[1]);
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    protected void prepareSerialization() {
        if (this.allOI == null) {
            return;
        }
        int n = 0;
        while (n < this.allOI.length) {
            if (this.allOI[n] != null) {
                this.allOI[n].deobfuscate();
            }
            ++n;
        }
    }

    protected void restoreAfterSerialization() {
        if (this.allOI == null) {
            return;
        }
        int n = 0;
        while (n < this.allOI.length) {
            if (this.allOI[n] != null) {
                this.allOI[n].obfuscate();
            }
            ++n;
        }
    }

    protected void restoreAfterDeserialization() {
        if (this.allKeyData == null) {
            return;
        }
        if (this.numberOfPrimes == 0) {
            if (this.allKeyData.length < 2) {
                return;
            }
            if (this.allKeyData[1] == null) {
                return;
            }
            this.allOI = new ObfuscatorItem[1];
            this.allOI[0] = JSAFE_Obfuscator.register(this.allKeyData[1]);
            this.allOI[0].obfuscate();
            return;
        }
        this.allOI = new ObfuscatorItem[this.numberOfPrimes * 3];
        int n = 2;
        while (n < this.allKeyData.length) {
            if (this.allKeyData[1] == null) {
                return;
            }
            this.allOI[n - 2] = JSAFE_Obfuscator.register(this.allKeyData[n]);
            this.allOI[0].obfuscate();
            ++n;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JA_RSAPrivateKey jA_RSAPrivateKey = new JA_RSAPrivateKey();
        this.copyContents(jA_RSAPrivateKey);
        return jA_RSAPrivateKey;
    }

    protected void copyContents(JA_RSAPrivateKey jA_RSAPrivateKey) throws CloneNotSupportedException {
        jA_RSAPrivateKey.numberOfPrimes = this.numberOfPrimes;
        jA_RSAPrivateKey.setJSAFELevelValues(this);
        if (this.allKeyData == null) {
            return;
        }
        jA_RSAPrivateKey.allKeyData = new byte[this.allKeyData.length][];
        jA_RSAPrivateKey.allOI = new ObfuscatorItem[this.allOI.length];
        int n = -1;
        if (this.numberOfPrimes != 0) {
            n = -2;
        }
        int n2 = 0;
        while (n2 < this.allKeyData.length) {
            if (this.allKeyData[n2] != null) {
                if (n < 0) {
                    jA_RSAPrivateKey.allKeyData[n2] = (byte[])this.allKeyData[n2].clone();
                } else {
                    jA_RSAPrivateKey.allKeyData[n2] = (byte[])JSAFE_Obfuscator.copy(this.allKeyData[n2], this.allOI[n]);
                    jA_RSAPrivateKey.allOI[n] = JSAFE_Obfuscator.getObfuscatorItem(jA_RSAPrivateKey.allKeyData[n2]);
                }
            }
            ++n2;
            ++n;
        }
    }

    protected void clearKeyData() {
        if (this.allKeyData == null || this.allOI == null) {
            this.resetVariables();
            return;
        }
        if (this.numberOfPrimes == 0) {
            if (this.allKeyData.length == 2 && this.allOI.length == 1) {
                JSAFE_Obfuscator.deregister(this.allKeyData[1], this.allOI[0]);
            }
            this.resetVariables();
            return;
        }
        int n = this.numberOfPrimes * 3;
        if (this.allKeyData.length == n + 2 && this.allOI.length == n) {
            int n2 = 0;
            while (n2 < this.allOI.length) {
                JSAFE_Obfuscator.deregister(this.allKeyData[n2 + 2], this.allOI[n2]);
                ++n2;
            }
        }
        this.resetVariables();
    }

    private void resetVariables() {
        this.numberOfPrimes = 0;
        this.allKeyData = null;
        this.allOI = null;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.clearKeyData();
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

