/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_RSAPublicKeyBER;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;

public class JA_RSAPublicKey
extends JSAFE_PublicKey
implements Cloneable,
Serializable {
    private byte[] modulus;
    private byte[] publicExponent;

    public String getAlgorithm() {
        return "RSA";
    }

    public String[] getSupportedSetFormats() {
        String[] stringArray = new String[]{"RSAPublicKey", "RSAPublicKeyBER"};
        return stringArray;
    }

    public String[] getSupportedGetFormats() {
        if (this.modulus == null || this.publicExponent == null) {
            return new String[0];
        }
        String[] stringArray = new String[]{"RSAPublicKey", "RSAPublicKeyBER"};
        return stringArray;
    }

    public void setKeyData(String string, byte[][] byArray) throws JSAFE_InvalidKeyException, JSAFE_UnimplementedException {
        if (string.compareTo("RSAPublicKeyBER") == 0) {
            if (byArray == null || byArray.length != 1) {
                this.clearKeyData();
                throw new JSAFE_InvalidKeyException("Invalid key data format.");
            }
            this.setKeyDataBER(byArray[0], 0);
            return;
        }
        if (string.compareTo("RSAPublicKey") != 0) {
            this.clearKeyData();
            throw new JSAFE_InvalidKeyException("Unknown key data format.");
        }
        this.setKeyData(byArray);
    }

    public void setKeyData(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.clearKeyData();
        if (byArray == null || byArray.length != 2) {
            throw new JSAFE_InvalidKeyException("Invalid input for RSA public key, expected { modulus, publicExponent }");
        }
        this.loadKeyData(byArray[0], 0, byArray[0].length, byArray[1], 0, byArray[1].length);
    }

    void setKeyDataBER(byte[] byArray, int n) throws JSAFE_InvalidKeyException {
        this.clearKeyData();
        JA_RSAPublicKeyBER.setKeyDataBER(this, byArray, n);
    }

    /*
     * Unable to fully structure code
     */
    void loadKeyData(byte[] var1_1, int var2_2, int var3_3, byte[] var4_4, int var5_5, int var6_6) throws JSAFE_InvalidKeyException {
        this.clearKeyData();
        while (var1_1[var2_2] == 0) {
            --var3_3;
            ++var2_2;
        }
        this.modulus = new byte[var3_3];
        System.arraycopy(var1_1, var2_2, this.modulus, 0, var3_3);
        var7_7 = this.modulus.length * 8;
        var8_8 = this.modulus[0] & 255;
        var9_9 = var8_8 & 128;
        while (var9_9 == 0) {
            --var7_7;
            var9_9 = var8_8 << 1 & 255;
        }
        if (var7_7 >= 256 && var7_7 <= 4096) ** GOTO lbl19
        throw new JSAFE_InvalidKeyException("Invalid RSA modulus size. Expected a value from 256 to 4096 bits long.");
lbl-1000:
        // 1 sources

        {
            --var6_6;
            ++var5_5;
lbl19:
            // 2 sources

            ** while (var4_4[var5_5] == 0)
        }
lbl20:
        // 1 sources

        this.publicExponent = new byte[var6_6];
        System.arraycopy(var4_4, var5_5, this.publicExponent, 0, var6_6);
    }

    public int getMaximumKeyLength() {
        return 4096;
    }

    public int getMinimumKeyLength() {
        return 256;
    }

    public byte[][] getKeyData(String string) throws JSAFE_UnimplementedException {
        if (string.compareTo("RSAPublicKeyBER") == 0) {
            return this.getKeyDataBER();
        }
        if (string.compareTo("RSAPublicKey") != 0) {
            throw new JSAFE_UnimplementedException("Unknown key data format.");
        }
        return this.getKeyData();
    }

    public byte[][] getKeyData() {
        if (this.modulus == null || this.publicExponent == null) {
            return new byte[0][];
        }
        byte[] byArray = (byte[])this.modulus.clone();
        byte[] byArray2 = (byte[])this.publicExponent.clone();
        byte[][] byArrayArray = new byte[][]{byArray, byArray2};
        return byArrayArray;
    }

    private byte[][] getKeyDataBER() {
        if (this.modulus == null || this.publicExponent == null) {
            return new byte[0][];
        }
        try {
            byte[] byArray = JA_RSAPublicKeyBER.getKeyDataBER(this.modulus, this.publicExponent);
            byte[][] byArrayArray = new byte[][]{byArray};
            return byArrayArray;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return new byte[0][];
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof JA_RSAPublicKey)) {
            return false;
        }
        return this.dataEquals(object);
    }

    public boolean dataEquals(Object object) {
        try {
            JSAFE_PublicKey jSAFE_PublicKey = (JSAFE_PublicKey)object;
            if (this.modulus == null || this.publicExponent == null) {
                if (jSAFE_PublicKey.getAlgorithm().compareTo("RSA") != 0) {
                    return false;
                }
                String[] stringArray = jSAFE_PublicKey.getSupportedGetFormats();
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].equals("RSAPublicKey")) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            byte[][] byArray = jSAFE_PublicKey.getKeyData("RSAPublicKey");
            if (!this.compareKeyArrays(this.modulus, null, byArray[0], null)) {
                return false;
            }
            return this.compareKeyArrays(this.publicExponent, null, byArray[1], null);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JA_RSAPublicKey jA_RSAPublicKey = new JA_RSAPublicKey();
        this.copyContents(jA_RSAPublicKey);
        return jA_RSAPublicKey;
    }

    protected void copyContents(JA_RSAPublicKey jA_RSAPublicKey) throws CloneNotSupportedException {
        if (this.modulus != null) {
            jA_RSAPublicKey.modulus = (byte[])this.modulus.clone();
        }
        if (this.publicExponent != null) {
            jA_RSAPublicKey.publicExponent = (byte[])this.publicExponent.clone();
        }
        jA_RSAPublicKey.setJSAFELevelValues(this);
    }

    protected void clearKeyData() {
        this.publicExponent = null;
        this.modulus = null;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.clearKeyData();
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

